/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class DeleteSourceManipulationChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;

    public DeleteSourceManipulationChange(ISourceManipulation iSourceManipulation, boolean bl) {
        Assert.isNotNull((Object)iSourceManipulation);
        this.fHandle = DeleteSourceManipulationChange.getJavaElement(iSourceManipulation).getHandleIdentifier();
        this.fIsExecuteChange = bl;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteSourceManipulationChange_0, this.getElementName());
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        ISourceManipulation iSourceManipulation = this.getSourceManipulation();
        if (this.fIsExecuteChange) {
            if (iSourceManipulation instanceof ICompilationUnit) {
                return super.isValid(iProgressMonitor, 0);
            }
            return super.isValid(iProgressMonitor, 2);
        }
        return super.isValid(iProgressMonitor, 3);
    }

    private String getElementName() {
        IJavaElement iJavaElement = DeleteSourceManipulationChange.getJavaElement(this.getSourceManipulation());
        if (JavaElementUtil.isDefaultPackage(iJavaElement)) {
            return RefactoringCoreMessages.DeleteSourceManipulationChange_1;
        }
        return iJavaElement.getElementName();
    }

    public Object getModifiedElement() {
        return JavaCore.create((String)this.fHandle);
    }

    protected Change doDelete(IProgressMonitor iProgressMonitor) throws CoreException {
        ISourceManipulation iSourceManipulation = this.getSourceManipulation();
        if (iSourceManipulation instanceof ICompilationUnit) {
            iProgressMonitor.beginTask("", 2);
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iSourceManipulation;
            DeleteSourceManipulationChange.saveCUnitIfNeeded(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IResource iResource = iCompilationUnit.getResource();
            ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)iResource);
            iSourceManipulation.delete(false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            resourceDescription.recordStateFromHistory(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            return new UndoDeleteResourceChange(resourceDescription);
        }
        if (iSourceManipulation instanceof IPackageFragment) {
            ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)iSourceManipulation).getCompilationUnits();
            iProgressMonitor.beginTask("", iCompilationUnitArray.length + 1);
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                DeleteSourceManipulationChange.saveCUnitIfNeeded(iCompilationUnitArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                ++n;
            }
            iSourceManipulation.delete(false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            return new NullChange();
        }
        iSourceManipulation.delete(false, iProgressMonitor);
        return null;
    }

    private ISourceManipulation getSourceManipulation() {
        return (ISourceManipulation)this.getModifiedElement();
    }

    private static IJavaElement getJavaElement(ISourceManipulation iSourceManipulation) {
        return (IJavaElement)iSourceManipulation;
    }

    private static void saveCUnitIfNeeded(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException {
        DeleteSourceManipulationChange.saveFileIfNeeded((IFile)iCompilationUnit.getResource(), iProgressMonitor);
    }
}

