/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameResourceChange
extends JDTChange {
    private final String fComment;
    private final RefactoringDescriptor fDescriptor;
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;

    public static IPath renamedResourcePath(IPath iPath, String string) {
        return iPath.removeLastSegments(1).append(string);
    }

    private RenameResourceChange(RefactoringDescriptor refactoringDescriptor, IPath iPath, String string, String string2, long l) {
        this.fDescriptor = refactoringDescriptor;
        this.fResourcePath = iPath;
        this.fNewName = string;
        this.fComment = string2;
        this.fStampToRestore = l;
    }

    public RenameResourceChange(RefactoringDescriptor refactoringDescriptor, IResource iResource, String string, String string2) {
        this(refactoringDescriptor, iResource.getFullPath(), string, string2, -1L);
    }

    public ChangeDescriptor getDescriptor() {
        if (this.fDescriptor != null) {
            return new RefactoringChangeDescriptor(this.fDescriptor);
        }
        return null;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameResourceChange_name, new String[]{this.fResourcePath.toString(), this.fNewName});
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        IResource iResource = this.getResource();
        if (iResource == null || !iResource.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameResourceChange_does_not_exist, this.fResourcePath.toString()));
        }
        return super.isValid(iProgressMonitor, 2);
    }

    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        RenameResourceChange renameResourceChange;
        try {
            String string;
            iProgressMonitor.beginTask(RefactoringCoreMessages.RenameResourceChange_rename_resource, 1);
            IResource iResource = this.getResource();
            long l = iResource.getModificationStamp();
            IPath iPath = RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            iResource.move(iPath, 32, iProgressMonitor);
            if (this.fStampToRestore != -1L) {
                string = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
                string.revertModificationStamp(this.fStampToRestore);
            }
            string = this.fResourcePath.lastSegment();
            renameResourceChange = new RenameResourceChange(null, iPath, string, this.fComment, l);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return renameResourceChange;
    }
}

