/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameSourceFolderChange
extends AbstractJavaElementRenameChange {
    private static RefactoringStatus checkIfModifiable(IPackageFragmentRoot iPackageFragmentRoot, IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        RenameSourceFolderChange.checkExistence(refactoringStatus, iPackageFragmentRoot);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (iPackageFragmentRoot.isArchive()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_archive, iPackageFragmentRoot.getElementName()));
            return refactoringStatus;
        }
        if (iPackageFragmentRoot.isExternal()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_external, iPackageFragmentRoot.getElementName()));
            return refactoringStatus;
        }
        RenameSourceFolderChange.checkExistence(refactoringStatus, iPackageFragmentRoot.getCorrespondingResource());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (iPackageFragmentRoot.getCorrespondingResource().isLinked()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_linked, iPackageFragmentRoot.getElementName()));
            return refactoringStatus;
        }
        return refactoringStatus;
    }

    public RenameSourceFolderChange(IPackageFragmentRoot iPackageFragmentRoot, String string) {
        this(iPackageFragmentRoot.getPath(), iPackageFragmentRoot.getElementName(), string, -1L);
        Assert.isTrue((!iPackageFragmentRoot.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
        Assert.isTrue((!iPackageFragmentRoot.isArchive() ? 1 : 0) != 0, (String)"should not be an archive");
    }

    private RenameSourceFolderChange(IPath iPath, String string, String string2, long l) {
        super(iPath, string, string2);
    }

    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long l) {
        return new RenameSourceFolderChange(this.createNewPath(), this.getNewName(), this.getOldName(), l);
    }

    protected void doRename(IProgressMonitor iProgressMonitor) throws CoreException {
        IPackageFragmentRoot iPackageFragmentRoot = this.getSourceFolder();
        if (iPackageFragmentRoot != null) {
            iPackageFragmentRoot.move(this.getNewPath(), this.getCoreMoveFlags(), this.getJavaModelUpdateFlags(), null, iProgressMonitor);
        }
    }

    private int getCoreMoveFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    private int getJavaModelUpdateFlags() {
        return 30;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename, new String[]{this.getOldName(), this.getNewName()});
    }

    private IPath getNewPath() {
        return this.getResource().getFullPath().removeLastSegments(1).append(this.getNewName());
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getModifiedElement();
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        iProgressMonitor.beginTask("", 2);
        refactoringStatus.merge(this.isValid((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), 2));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        IPackageFragmentRoot iPackageFragmentRoot = this.getSourceFolder();
        refactoringStatus.merge(RenameSourceFolderChange.checkIfModifiable(iPackageFragmentRoot, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        return refactoringStatus;
    }
}

