/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.OperatorPrecedence;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CallInliner {
    private ICompilationUnit fCUnit;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ITextFileBuffer fBuffer;
    private SourceProvider fSourceProvider;
    private TypeEnvironment fTypeEnvironment;
    private BodyDeclaration fBodyDeclaration;
    private CodeScopeBuilder.Scope fRootScope;
    private int fNumberOfLocals;
    private ASTNode fInvocation;
    private int fInsertionIndex;
    private ListRewrite fListRewrite;
    private boolean fNeedsStatement;
    private ASTNode fTargetNode;
    private FlowContext fFlowContext;
    private FlowInfo fFlowInfo;
    private CodeScopeBuilder.Scope fInvocationScope;
    private boolean fFieldInitializer;
    private List fLocals;
    private CallContext fContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CallInliner(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, SourceProvider sourceProvider) throws CoreException {
        this.fCUnit = iCompilationUnit;
        this.fBuffer = RefactoringFileBuffers.acquire(this.fCUnit);
        this.fSourceProvider = sourceProvider;
        this.fImportRewrite = StubUtility.createImportRewrite(compilationUnit, true);
        this.fLocals = new ArrayList(3);
        this.fRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
        this.fRewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
        this.fTypeEnvironment = new TypeEnvironment();
    }

    public void dispose() {
        try {
            RefactoringFileBuffers.release(this.fCUnit);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }

    public ImportRewrite getImportEdit() {
        return this.fImportRewrite;
    }

    public ASTNode getTargetNode() {
        return this.fTargetNode;
    }

    public void initialize(BodyDeclaration bodyDeclaration) {
        this.fBodyDeclaration = bodyDeclaration;
        this.fRootScope = CodeScopeBuilder.perform(bodyDeclaration, (IBinding)this.fSourceProvider.getDeclaration().resolveBinding());
        this.fNumberOfLocals = 0;
        switch (bodyDeclaration.getNodeType()) {
            case 28: 
            case 31: {
                this.fNumberOfLocals = LocalVariableIndex.perform(bodyDeclaration);
            }
        }
    }

    public RefactoringStatus initialize(ASTNode aSTNode, int n) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fInvocation = aSTNode;
        this.fLocals = new ArrayList(3);
        this.checkMethodDeclaration(refactoringStatus, n);
        if (refactoringStatus.getSeverity() >= n) {
            return refactoringStatus;
        }
        this.initializeRewriteState();
        this.initializeTargetNode();
        this.flowAnalysis();
        this.fContext = new CallContext(this.fInvocation, this.fInvocationScope, this.fTargetNode.getNodeType(), this.fImportRewrite);
        try {
            this.computeRealArguments();
            this.computeReceiver();
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        this.checkInvocationContext(refactoringStatus, n);
        return refactoringStatus;
    }

    private void initializeRewriteState() {
        if (ASTNodes.getParent(this.fInvocation, 23) != null) {
            this.fFieldInitializer = true;
        }
    }

    private void initializeTargetNode() {
        ASTNode aSTNode = this.fInvocation.getParent();
        int n = aSTNode.getNodeType();
        this.fTargetNode = n == 21 || n == 41 ? aSTNode : this.fInvocation;
    }

    private void checkMethodDeclaration(RefactoringStatus refactoringStatus, int n) {
        Expression expression;
        MethodDeclaration methodDeclaration = this.fSourceProvider.getDeclaration();
        if (this.fInvocation.getNodeType() != 17 && methodDeclaration.isConstructor()) {
            refactoringStatus.addEntry(new RefactoringStatusEntry(n, RefactoringCoreMessages.CallInliner_constructors, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.fInvocation)));
        }
        if (this.fSourceProvider.hasSuperMethodInvocation() && this.fInvocation.getNodeType() == 32 && (expression = ((MethodInvocation)this.fInvocation).getExpression()) instanceof ThisExpression) {
            refactoringStatus.addEntry(new RefactoringStatusEntry(n, RefactoringCoreMessages.CallInliner_super_into_this_expression, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.fInvocation)));
        }
    }

    private void checkInvocationContext(RefactoringStatus refactoringStatus, int n) {
        Expression expression;
        if (this.fInvocation.getNodeType() == 32 && (expression = ((MethodInvocation)this.fInvocation).getExpression()) != null && expression.resolveTypeBinding() == null) {
            this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_receiver_type, 258, n);
            return;
        }
        int n2 = this.fTargetNode.getNodeType();
        if (n2 == 21) {
            if (this.fSourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_execution_flow, 260, n);
                return;
            }
        } else if (n2 == 32) {
            boolean bl;
            ASTNode aSTNode = this.fTargetNode.getParent();
            if (CallInliner.isReturnStatement(aSTNode)) {
                return;
            }
            if (this.fSourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_execution_flow, 260, n);
                return;
            }
            if (CallInliner.isAssignment(aSTNode) || CallInliner.isSingleDeclaration(aSTNode)) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.FieldDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            boolean bl2 = bl = ASTNodes.getParent(this.fInvocation, clazz) != null;
            if (!this.fSourceProvider.isSimpleFunction()) {
                if (CallInliner.isMultiDeclarationFragment(aSTNode)) {
                    this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_multiDeclaration, 261, n);
                } else if (bl) {
                    this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_field_initializer_simple, 256, n);
                } else {
                    this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_simple_functions, 259, n);
                }
                return;
            }
            if (bl) {
                int n3 = this.fContext.arguments.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParameterData parameterData = this.fSourceProvider.getParameterData(n4);
                    if (parameterData.isWrite()) {
                        this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_field_initialize_write_parameter, 256, n);
                        return;
                    }
                    ++n4;
                }
                if (this.fLocals.size() > 0) {
                    this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_field_initialize_new_local, 256, n);
                    return;
                }
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)ASTNodes.getParent(this.fInvocation, 59);
                if (this.fSourceProvider.isVariableReferenced(variableDeclarationFragment.resolveBinding())) {
                    this.addEntry(refactoringStatus, RefactoringCoreMessages.CallInliner_field_initialize_self_reference, 256, n);
                    return;
                }
            }
        }
    }

    private static boolean isAssignment(ASTNode aSTNode) {
        return aSTNode instanceof Assignment;
    }

    private static boolean isReturnStatement(ASTNode aSTNode) {
        return aSTNode instanceof ReturnStatement;
    }

    private static boolean isSingleDeclaration(ASTNode aSTNode) {
        int n = aSTNode.getNodeType();
        if (n == 44) {
            return true;
        }
        if (n == 59 && (aSTNode = aSTNode.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
            return variableDeclarationStatement.fragments().size() == 1;
        }
        return false;
    }

    private static boolean isMultiDeclarationFragment(ASTNode aSTNode) {
        int n = aSTNode.getNodeType();
        if (n == 59 && (aSTNode = aSTNode.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
            return variableDeclarationStatement.fragments().size() > 1;
        }
        return false;
    }

    private void addEntry(RefactoringStatus refactoringStatus, String string, int n, int n2) {
        refactoringStatus.addEntry(new RefactoringStatusEntry(n2, string, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.fInvocation), Corext.getPluginId(), n, null));
    }

    private void flowAnalysis() {
        this.fInvocationScope = this.fRootScope.findScope(this.fTargetNode.getStartPosition(), this.fTargetNode.getLength());
        this.fInvocationScope.setCursor(this.fTargetNode.getStartPosition());
        this.fFlowContext = new FlowContext(0, this.fNumberOfLocals + 1);
        this.fFlowContext.setConsiderAccessMode(true);
        this.fFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        Selection selection = Selection.createFromStartLength(this.fInvocation.getStartPosition(), this.fInvocation.getLength());
        switch (this.fBodyDeclaration.getNodeType()) {
            case 23: 
            case 28: 
            case 31: {
                this.fFlowInfo = new InputFlowAnalyzer(this.fFlowContext, selection, true).perform(this.fBodyDeclaration);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"Should not happen");
            }
        }
    }

    public RefactoringStatus perform(TextEditGroup textEditGroup) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        String[] stringArray = this.fSourceProvider.getCodeBlocks(this.fContext);
        if (!this.fFieldInitializer) {
            this.initializeInsertionPoint(this.fSourceProvider.getNumberOfStatements() + this.fLocals.size());
        }
        this.addNewLocals(textEditGroup);
        this.replaceCall(refactoringStatus, stringArray, textEditGroup);
        return refactoringStatus;
    }

    public TextEdit getModifications() {
        return this.fRewrite.rewriteAST(this.fBuffer.getDocument(), this.fCUnit.getJavaProject().getOptions(true));
    }

    private void computeRealArguments() throws BadLocationException {
        String string;
        ParameterData parameterData;
        Object object;
        List list = Invocations.getArguments(this.fInvocation);
        Set set = this.crossCheckArguments(list);
        boolean bl = this.needsVarargBoxing(list);
        int n = this.fSourceProvider.getVarargIndex();
        String[] stringArray = new String[bl ? n + 1 : list.size()];
        int n2 = 0;
        while (n2 < (bl ? n : list.size())) {
            object = (Expression)list.get(n2);
            if (this.canInline((Expression)object, parameterData = this.fSourceProvider.getParameterData(n2)) && !set.contains(object)) {
                stringArray[n2] = this.getContent((ASTNode)object);
                if (this.argumentNeedsParenthesis((Expression)object, parameterData)) {
                    stringArray[n2] = "(" + stringArray[n2] + ")";
                }
            } else {
                stringArray[n2] = string = this.fInvocationScope.createName(parameterData.getName(), true);
                this.fLocals.add(this.createLocalDeclaration(parameterData.getTypeBinding(), string, (Expression)this.fRewrite.createCopyTarget((ASTNode)object)));
            }
            ++n2;
        }
        if (bl) {
            ParameterData parameterData2 = this.fSourceProvider.getParameterData(n);
            object = this.fInvocationScope.createName(parameterData2.getName(), true);
            stringArray[n] = object;
            parameterData = this.fInvocation.getAST();
            string = this.fImportRewrite.addImport(parameterData2.getTypeBinding(), (AST)parameterData);
            VariableDeclarationFragment variableDeclarationFragment = parameterData.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(parameterData.newSimpleName((String)object));
            ArrayInitializer arrayInitializer = parameterData.newArrayInitializer();
            int n3 = n;
            while (n3 < list.size()) {
                arrayInitializer.expressions().add(this.fRewrite.createCopyTarget((ASTNode)list.get(n3)));
                ++n3;
            }
            variableDeclarationFragment.setInitializer((Expression)arrayInitializer);
            VariableDeclarationStatement variableDeclarationStatement = parameterData.newVariableDeclarationStatement(variableDeclarationFragment);
            variableDeclarationStatement.setType((Type)string);
            this.fLocals.add(variableDeclarationStatement);
        }
        this.fContext.arguments = stringArray;
    }

    private boolean needsVarargBoxing(List list) {
        if (!this.fSourceProvider.isVarargs()) {
            return false;
        }
        int n = this.fSourceProvider.getVarargIndex();
        if (n >= list.size()) {
            return true;
        }
        if (n == list.size() - 1) {
            ITypeBinding iTypeBinding = ((Expression)list.get(n)).resolveTypeBinding();
            if (iTypeBinding == null) {
                return false;
            }
            ITypeBinding iTypeBinding2 = this.fSourceProvider.getParameterData(n).getTypeBinding();
            return !this.fTypeEnvironment.create(iTypeBinding).canAssignTo(this.fTypeEnvironment.create(iTypeBinding2));
        }
        return true;
    }

    private boolean argumentNeedsParenthesis(Expression expression, ParameterData parameterData) {
        if (expression instanceof CastExpression || expression instanceof ArrayCreation) {
            return true;
        }
        int n = OperatorPrecedence.getValue(expression);
        int n2 = parameterData.getOperatorPrecedence();
        if (n != -1 && n2 != -1) {
            return n < n2;
        }
        return false;
    }

    private void computeReceiver() throws BadLocationException {
        Expression expression = Invocations.getExpression(this.fInvocation);
        if (expression == null) {
            return;
        }
        boolean bl = expression instanceof Name;
        if (bl) {
            this.fContext.receiverIsStatic = ((Name)expression).resolveBinding() instanceof ITypeBinding;
        }
        if (ASTNodes.isLiteral(expression) || bl || expression instanceof ThisExpression) {
            this.fContext.receiver = this.fBuffer.getDocument().get(expression.getStartPosition(), expression.getLength());
            return;
        }
        switch (this.fSourceProvider.getReceiversToBeUpdated()) {
            case 0: {
                this.fLocals.add(this.createLocalDeclaration(expression.resolveTypeBinding(), this.fInvocationScope.createName("r", true), (Expression)this.fRewrite.createCopyTarget((ASTNode)expression)));
                return;
            }
            case 1: {
                this.fContext.receiver = this.fBuffer.getDocument().get(expression.getStartPosition(), expression.getLength());
                return;
            }
        }
        String string = this.fInvocationScope.createName("r", true);
        this.fLocals.add(this.createLocalDeclaration(expression.resolveTypeBinding(), string, (Expression)this.fRewrite.createCopyTarget((ASTNode)expression)));
        this.fContext.receiver = string;
    }

    private void addNewLocals(TextEditGroup textEditGroup) {
        if (this.fLocals.isEmpty()) {
            return;
        }
        Iterator iterator = this.fLocals.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            this.fListRewrite.insertAt(aSTNode, this.fInsertionIndex++, textEditGroup);
        }
    }

    private void replaceCall(RefactoringStatus refactoringStatus, String[] stringArray, TextEditGroup textEditGroup) {
        if (stringArray.length == 0) {
            if (this.fNeedsStatement) {
                this.fRewrite.replace(this.fTargetNode, (ASTNode)this.fTargetNode.getAST().newEmptyStatement(), textEditGroup);
            } else {
                this.fRewrite.remove(this.fTargetNode, textEditGroup);
            }
        } else {
            ASTNode aSTNode = null;
            int n = 0;
            while (n < stringArray.length - 1) {
                aSTNode = this.fRewrite.createStringPlaceholder(stringArray[n], 41);
                this.fListRewrite.insertAt(aSTNode, this.fInsertionIndex++, textEditGroup);
                ++n;
            }
            String string = stringArray[stringArray.length - 1];
            if (this.fContext.callMode == 21 && this.fSourceProvider.hasReturnValue()) {
                if (this.fSourceProvider.mustEvaluateReturnedExpression()) {
                    if (this.fSourceProvider.returnValueNeedsLocalVariable()) {
                        IMethodBinding iMethodBinding = Invocations.resolveBinding(this.fInvocation);
                        aSTNode = this.createLocalDeclaration(iMethodBinding.getReturnType(), this.fInvocationScope.createName(this.fSourceProvider.getMethodName(), true), (Expression)this.fRewrite.createStringPlaceholder(string, 32));
                    } else {
                        aSTNode = this.fTargetNode.getAST().newExpressionStatement((Expression)this.fRewrite.createStringPlaceholder(string, 32));
                    }
                } else {
                    aSTNode = null;
                }
            } else if (this.fTargetNode instanceof Expression) {
                AST aST;
                aSTNode = this.fRewrite.createStringPlaceholder(string, 32);
                if (this.needsExplicitCast(refactoringStatus)) {
                    aST = aSTNode.getAST();
                    CastExpression castExpression = aST.newCastExpression();
                    Type type = this.fImportRewrite.addImport(this.fSourceProvider.getReturnType(), aST);
                    castExpression.setType(type);
                    castExpression.setExpression((Expression)aSTNode);
                    aSTNode = castExpression;
                }
                if (this.needsParenthesis()) {
                    aST = this.fTargetNode.getAST().newParenthesizedExpression();
                    aST.setExpression((Expression)aSTNode);
                    aSTNode = aST;
                }
            } else {
                aSTNode = this.fRewrite.createStringPlaceholder(string, 41);
            }
            if (aSTNode != null) {
                if (this.fTargetNode == null) {
                    this.fListRewrite.insertAt(aSTNode, this.fInsertionIndex++, textEditGroup);
                } else {
                    this.fRewrite.replace(this.fTargetNode, aSTNode, textEditGroup);
                }
            } else if (this.fTargetNode != null) {
                this.fRewrite.remove(this.fTargetNode, textEditGroup);
            }
        }
    }

    private boolean needsExplicitCast(RefactoringStatus refactoringStatus) {
        if (this.fSourceProvider.returnTypeMatchesReturnExpressions()) {
            return false;
        }
        ASTNode aSTNode = this.fTargetNode.getParent();
        int n = aSTNode.getNodeType();
        if (n == 32) {
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            if (methodInvocation.getExpression() == this.fTargetNode) {
                return false;
            }
            IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
            if (iMethodBinding == null) {
                refactoringStatus.addError(RefactoringCoreMessages.CallInliner_cast_analysis_error, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)methodInvocation));
                return false;
            }
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            int n2 = methodInvocation.arguments().indexOf(this.fInvocation);
            List list = this.fSourceProvider.getReturnExpressions();
            if (list.size() != 1) {
                return false;
            }
            iTypeBindingArray[n2] = ((Expression)list.get(0)).resolveTypeBinding();
            ITypeBinding iTypeBinding = ASTNodes.getReceiverTypeBinding(methodInvocation);
            AmbiguousMethodAnalyzer ambiguousMethodAnalyzer = new AmbiguousMethodAnalyzer(this.fTypeEnvironment, iMethodBinding, this.fTypeEnvironment.create(iTypeBindingArray));
            if (!ambiguousMethodAnalyzer.visit(iTypeBinding)) {
                return true;
            }
            if (iTypeBinding.isInterface()) {
                return !Bindings.visitInterfaces(iTypeBinding, ambiguousMethodAnalyzer);
            }
            if (Modifier.isAbstract((int)iTypeBinding.getModifiers())) {
                return !Bindings.visitHierarchy(iTypeBinding, ambiguousMethodAnalyzer);
            }
            return !Bindings.visitSuperclasses(iTypeBinding, ambiguousMethodAnalyzer);
        }
        return false;
    }

    private boolean needsParenthesis() {
        if (!this.fSourceProvider.needsReturnedExpressionParenthesis()) {
            return false;
        }
        ASTNode aSTNode = this.fTargetNode.getParent();
        int n = aSTNode.getNodeType();
        return n == 32 || aSTNode instanceof Expression && n != 7 || this.fSourceProvider.returnsConditionalExpression() && n == 59 && ((VariableDeclarationFragment)aSTNode).getInitializer() == this.fTargetNode;
    }

    private VariableDeclarationStatement createLocalDeclaration(ITypeBinding iTypeBinding, String string, Expression expression) {
        String string2 = this.fImportRewrite.addImport(iTypeBinding);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)ASTNodeFactory.newStatement(this.fInvocation.getAST(), String.valueOf(string2) + " " + string + ";");
        ((VariableDeclarationFragment)variableDeclarationStatement.fragments().get(0)).setInitializer(expression);
        return variableDeclarationStatement;
    }

    private Set crossCheckArguments(List list) {
        Expression expression;
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept(new ASTVisitor(){

                public boolean visit(Assignment assignment) {
                    IBinding iBinding;
                    Expression expression2 = assignment.getLeftHandSide();
                    if (expression2 instanceof Name && (iBinding = ((Name)expression2).resolveBinding()) instanceof IVariableBinding) {
                        hashSet.add(iBinding);
                        hashSet2.add(expression);
                    }
                    return true;
                }
            });
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            if (hashSet2.contains(expression)) continue;
            expression.accept((ASTVisitor)new HierarchicalASTVisitor(){

                public boolean visit(Name name) {
                    IBinding iBinding = name.resolveBinding();
                    if (iBinding != null && hashSet.contains(iBinding)) {
                        hashSet2.add(expression);
                    }
                    return false;
                }
            });
        }
        return hashSet2;
    }

    private boolean canInline(Expression expression, ParameterData parameterData) {
        InlineEvaluator inlineEvaluator = new InlineEvaluator(parameterData);
        expression.accept((ASTVisitor)inlineEvaluator);
        return inlineEvaluator.getResult();
    }

    private void initializeInsertionPoint(int n) {
        ASTNode aSTNode;
        this.fInsertionIndex = -1;
        this.fNeedsStatement = false;
        if (this.fInvocation instanceof Statement) {
            aSTNode = this.fInvocation;
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Statement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            aSTNode = ASTNodes.getParent(this.fInvocation, clazz);
        }
        ASTNode aSTNode2 = aSTNode;
        ASTNode aSTNode3 = aSTNode2.getParent();
        int n2 = aSTNode3.getNodeType();
        if (n2 == 8) {
            Block block = (Block)aSTNode3;
            this.fListRewrite = this.fRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            this.fInsertionIndex = this.fListRewrite.getRewrittenList().indexOf(aSTNode2);
        } else if (n2 == 50) {
            SwitchStatement switchStatement = (SwitchStatement)aSTNode3;
            this.fListRewrite = this.fRewrite.getListRewrite((ASTNode)switchStatement, SwitchStatement.STATEMENTS_PROPERTY);
            this.fInsertionIndex = this.fListRewrite.getRewrittenList().indexOf(aSTNode2);
        } else if (this.isControlStatement(aSTNode3) || n2 == 30) {
            this.fNeedsStatement = true;
            if (n > 1 || this.needsBlockAroundDanglingIf()) {
                Block block = this.fInvocation.getAST().newBlock();
                this.fInsertionIndex = 0;
                Statement statement = null;
                switch (n2) {
                    case 30: {
                        statement = ((LabeledStatement)aSTNode3).getBody();
                        break;
                    }
                    case 24: {
                        statement = ((ForStatement)aSTNode3).getBody();
                        break;
                    }
                    case 83: {
                        statement = ((ForInStatement)aSTNode3).getBody();
                        break;
                    }
                    case 70: {
                        statement = ((EnhancedForStatement)aSTNode3).getBody();
                        break;
                    }
                    case 61: {
                        statement = ((WhileStatement)aSTNode3).getBody();
                        break;
                    }
                    case 90: {
                        statement = ((WithStatement)aSTNode3).getBody();
                        break;
                    }
                    case 19: {
                        statement = ((DoStatement)aSTNode3).getBody();
                        break;
                    }
                    case 25: {
                        IfStatement ifStatement = (IfStatement)aSTNode3;
                        Statement statement2 = ifStatement.getThenStatement();
                        statement = this.fTargetNode == statement2 || ASTNodes.isParent(this.fTargetNode, (ASTNode)statement2) ? statement2 : ifStatement.getElseStatement();
                    }
                }
                Assert.isNotNull(statement);
                this.fRewrite.replace((ASTNode)statement, (ASTNode)block, null);
                this.fListRewrite = this.fRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                if (statement != this.fTargetNode) {
                    this.fListRewrite.insertLast(this.fRewrite.createCopyTarget((ASTNode)statement), null);
                } else {
                    this.fTargetNode = null;
                }
            }
        }
    }

    private boolean needsBlockAroundDanglingIf() {
        return this.fTargetNode.getLocationInParent() == IfStatement.THEN_STATEMENT_PROPERTY && this.fTargetNode.getParent().getStructuralProperty((StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY) != null && this.fSourceProvider.isDangligIf();
    }

    private String getContent(ASTNode aSTNode) throws BadLocationException {
        return this.fBuffer.getDocument().get(aSTNode.getStartPosition(), aSTNode.getLength());
    }

    private boolean isControlStatement(ASTNode aSTNode) {
        int n = aSTNode.getNodeType();
        return n == 25 || n == 24 || n == 70 || n == 61 || n == 19;
    }

    private static class AmbiguousMethodAnalyzer
    implements TypeBindingVisitor {
        private TypeEnvironment fTypeEnvironment;
        private TType[] fTypes;
        private IMethodBinding fOriginal;

        public AmbiguousMethodAnalyzer(TypeEnvironment typeEnvironment, IMethodBinding iMethodBinding, TType[] tTypeArray) {
            this.fTypeEnvironment = typeEnvironment;
            this.fOriginal = iMethodBinding;
            this.fTypes = tTypeArray;
        }

        public boolean visit(ITypeBinding iTypeBinding) {
            IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
            int n = 0;
            while (n < iMethodBindingArray.length) {
                IMethodBinding iMethodBinding = iMethodBindingArray[n];
                if (iMethodBinding != this.fOriginal && this.fOriginal.getName().equals(iMethodBinding.getName()) && this.canImplicitlyCall(iMethodBinding)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private boolean canImplicitlyCall(IMethodBinding iMethodBinding) {
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            if (iTypeBindingArray.length != this.fTypes.length) {
                return false;
            }
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (!this.fTypes[n].canAssignTo(this.fTypeEnvironment.create(iTypeBindingArray[n]))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    private class InlineEvaluator
    extends HierarchicalASTVisitor {
        private ParameterData fFormalArgument;
        private boolean fResult;

        public InlineEvaluator(ParameterData parameterData) {
            this.fFormalArgument = parameterData;
        }

        public boolean getResult() {
            return this.fResult;
        }

        private boolean setResult(boolean bl) {
            this.fResult = bl;
            return false;
        }

        public boolean visit(Expression expression) {
            int n = this.fFormalArgument.getSimplifiedAccessMode();
            if (n == 8) {
                return this.setResult(false);
            }
            if (n == 1) {
                return this.setResult(true);
            }
            if (ASTNodes.isLiteral(expression)) {
                return this.setResult(true);
            }
            return this.setResult(this.fFormalArgument.getNumberOfAccesses() <= 1);
        }

        public boolean visit(SimpleName simpleName) {
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding instanceof IVariableBinding) {
                int n = this.fFormalArgument.getSimplifiedAccessMode();
                if (n == 2 || n == 1) {
                    return this.setResult(true);
                }
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                if (iVariableBinding.isField()) {
                    return this.setResult(false);
                }
                return this.setResult(CallInliner.this.fFlowInfo.hasAccessMode(CallInliner.this.fFlowContext, iVariableBinding, 9));
            }
            return this.setResult(false);
        }

        public boolean visit(FieldAccess fieldAccess) {
            return this.visit(fieldAccess.getName());
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            return this.visit(superFieldAccess.getName());
        }

        public boolean visit(ThisExpression thisExpression) {
            int n = this.fFormalArgument.getSimplifiedAccessMode();
            if (n == 2 || n == 1) {
                return this.setResult(true);
            }
            return this.setResult(false);
        }
    }
}

