/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;

class ConstantChecks {
    ConstantChecks() {
    }

    public static boolean isStaticFinalConstant(IExpressionFragment iExpressionFragment) {
        return new StaticFinalConstantChecker(iExpressionFragment).check();
    }

    public static boolean isLoadTimeConstant(IExpressionFragment iExpressionFragment) {
        return new LoadTimeConstantChecker(iExpressionFragment).check();
    }

    private static abstract class ExpressionChecker
    extends ASTVisitor {
        private final IExpressionFragment fExpression;
        protected boolean fResult = true;

        public ExpressionChecker(IExpressionFragment iExpressionFragment) {
            this.fExpression = iExpressionFragment;
        }

        public boolean check() {
            this.fResult = true;
            this.fExpression.getAssociatedNode().accept((ASTVisitor)this);
            return this.fResult;
        }
    }

    private static class LoadTimeConstantChecker
    extends ExpressionChecker {
        public LoadTimeConstantChecker(IExpressionFragment iExpressionFragment) {
            super(iExpressionFragment);
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            this.fResult = false;
            return false;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            this.fResult = false;
            return false;
        }

        public boolean visit(ThisExpression thisExpression) {
            this.fResult = false;
            return false;
        }

        public boolean visit(FieldAccess fieldAccess) {
            this.fResult = new LoadTimeConstantChecker((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)fieldAccess.getExpression())).check();
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (methodInvocation.getExpression() == null) {
                this.visitName((Name)methodInvocation.getName());
            } else {
                this.fResult = new LoadTimeConstantChecker((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)methodInvocation.getExpression())).check();
            }
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            return this.visitName((Name)qualifiedName);
        }

        public boolean visit(SimpleName simpleName) {
            return this.visitName((Name)simpleName);
        }

        private boolean visitName(Name name) {
            this.fResult = this.checkName(name);
            return false;
        }

        private boolean checkName(Name name) {
            IBinding iBinding = name.resolveBinding();
            if (iBinding == null) {
                return true;
            }
            if (iBinding instanceof IVariableBinding || iBinding instanceof IMethodBinding) {
                return this.isMemberReferenceValidInClassInitialization(name);
            }
            if (iBinding instanceof ITypeBinding) {
                return !((ITypeBinding)iBinding).isTypeVariable();
            }
            Assert.isTrue((boolean)false);
            return true;
        }

        private boolean isMemberReferenceValidInClassInitialization(Name name) {
            IBinding iBinding = name.resolveBinding();
            Assert.isTrue((iBinding instanceof IVariableBinding || iBinding instanceof IMethodBinding ? 1 : 0) != 0);
            if (name instanceof SimpleName) {
                return Modifier.isStatic((int)iBinding.getModifiers());
            }
            Assert.isTrue((boolean)(name instanceof QualifiedName));
            return this.checkName(((QualifiedName)name).getQualifier());
        }
    }

    private static class StaticFinalConstantChecker
    extends ExpressionChecker {
        public StaticFinalConstantChecker(IExpressionFragment iExpressionFragment) {
            super(iExpressionFragment);
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            this.fResult = false;
            return false;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            this.fResult = false;
            return false;
        }

        public boolean visit(ThisExpression thisExpression) {
            this.fResult = false;
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            return this.visitName((Name)qualifiedName);
        }

        public boolean visit(SimpleName simpleName) {
            return this.visitName((Name)simpleName);
        }

        private boolean visitName(Name name) {
            IBinding iBinding = name.resolveBinding();
            if (iBinding == null) {
                return true;
            }
            int n = iBinding.getModifiers();
            if (iBinding instanceof IVariableBinding) {
                if (!Modifier.isStatic((int)n) || !Modifier.isFinal((int)n)) {
                    this.fResult = false;
                    return false;
                }
            } else if (iBinding instanceof IMethodBinding) {
                if (!Modifier.isStatic((int)n)) {
                    this.fResult = false;
                    return false;
                }
            } else {
                if (iBinding instanceof ITypeBinding) {
                    return false;
                }
                Assert.isTrue((boolean)false);
                return false;
            }
            return true;
        }
    }
}

