/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ConvertAnonymousToNestedRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_STATIC = "static";
    private static final String KEY_TYPE_NAME = "type_name";
    private static final String KEY_PARAM_NAME_EXT = "param_name_ext";
    private static final String KEY_PARAM_NAME_CONST = "param_name_const";
    private static final String KEY_FIELD_NAME_EXT = "field_name_ext";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private int fVisibility;
    private boolean fDeclareFinal = true;
    private boolean fDeclareStatic;
    private String fClassName = "";
    private CompilationUnit fCompilationUnitNode;
    private AnonymousClassDeclaration fAnonymousInnerClassNode;
    private Set fClassNamesUsed;
    private boolean fSelfInitializing = false;
    private LinkedProposalModel fLinkedProposalModel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConvertAnonymousToNestedRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((iCompilationUnit == null || iCompilationUnit.exists() ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = iCompilationUnit;
        this.fAnonymousInnerClassNode = null;
        this.fCompilationUnitNode = null;
    }

    public ConvertAnonymousToNestedRefactoring(AnonymousClassDeclaration anonymousClassDeclaration) {
        Assert.isTrue((anonymousClassDeclaration != null ? 1 : 0) != 0);
        ASTNode aSTNode = anonymousClassDeclaration.getRoot();
        Assert.isTrue((boolean)(aSTNode instanceof CompilationUnit));
        this.fCompilationUnitNode = (CompilationUnit)aSTNode;
        IJavaElement iJavaElement = this.fCompilationUnitNode.getJavaElement();
        Assert.isTrue((boolean)(iJavaElement instanceof ICompilationUnit));
        this.fCu = (ICompilationUnit)iJavaElement;
        this.fSelectionStart = anonymousClassDeclaration.getStartPosition();
        this.fSelectionLength = anonymousClassDeclaration.getLength();
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public int[] getAvailableVisibilities() {
        if (this.isLocalInnerType()) {
            return new int[1];
        }
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public boolean isLocalInnerType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent(ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz), 1) != null;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int n) {
        Assert.isTrue((n == 2 || n == 0 || n == 4 || n == 1 ? 1 : 0) != 0);
        this.fVisibility = n;
    }

    public void setClassName(String string) {
        Assert.isNotNull((Object)string);
        this.fClassName = string;
    }

    public boolean canEnableSettingFinal() {
        return true;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public void setDeclareFinal(boolean bl) {
        this.fDeclareFinal = bl;
    }

    public void setDeclareStatic(boolean bl) {
        this.fDeclareStatic = bl;
    }

    public String getName() {
        return RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name;
    }

    private boolean useThisForFieldAccess() {
        return StubUtility.useThisForFieldAccess(this.fCu.getJavaProject());
    }

    private boolean doAddComments() {
        return StubUtility.doAddComments(this.fCu.getJavaProject());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.initAST(iProgressMonitor);
        if (this.fAnonymousInnerClassNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_place_caret);
        }
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        if (this.getSuperConstructorBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.getSuperTypeBinding().isLocal()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_extends_local_class);
        }
        return new RefactoringStatus();
    }

    private void initializeDefaults() {
        this.fVisibility = this.isLocalInnerType() ? 0 : 2;
        this.fDeclareStatic = this.mustInnerClassBeStatic();
    }

    private void initAST(IProgressMonitor iProgressMonitor) {
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, iProgressMonitor);
        }
        if (this.fAnonymousInnerClassNode == null) {
            this.fAnonymousInnerClassNode = ConvertAnonymousToNestedRefactoring.getAnonymousInnerClass(NodeFinder.perform((ASTNode)this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength));
        }
        if (this.fAnonymousInnerClassNode != null) {
            AbstractTypeDeclaration abstractTypeDeclaration;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz)) instanceof TypeDeclaration) {
                TypeDeclaration[] typeDeclarationArray = ((TypeDeclaration)abstractTypeDeclaration).getTypes();
                this.fClassNamesUsed = new HashSet(typeDeclarationArray.length);
                int n = 0;
                while (n < typeDeclarationArray.length) {
                    this.fClassNamesUsed.add(typeDeclarationArray[n].getName().getIdentifier());
                    ++n;
                }
            } else {
                this.fClassNamesUsed = Collections.EMPTY_SET;
            }
        }
    }

    private static AnonymousClassDeclaration getAnonymousInnerClass(ASTNode aSTNode) {
        AnonymousClassDeclaration anonymousClassDeclaration;
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return (AnonymousClassDeclaration)aSTNode;
        }
        if (aSTNode instanceof ClassInstanceCreation && (anonymousClassDeclaration = ((ClassInstanceCreation)aSTNode).getAnonymousClassDeclaration()) != null) {
            return anonymousClassDeclaration;
        }
        if ((aSTNode = ASTNodes.getNormalizedNode(aSTNode)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY && (anonymousClassDeclaration = ((ClassInstanceCreation)aSTNode.getParent()).getAnonymousClassDeclaration()) != null) {
            return anonymousClassDeclaration;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AnonymousClassDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus refactoringStatus = Checks.checkTypeName(this.fClassName);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (this.fClassNamesUsed.contains(this.fClassName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_type_exists);
        }
        IMethodBinding iMethodBinding = this.getSuperConstructorBinding();
        if (iMethodBinding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.fClassName.equals(iMethodBinding.getDeclaringClass().getName())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_another_name);
        }
        if (this.classNameHidesEnclosingType()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name_hides);
        }
        return refactoringStatus;
    }

    private boolean accessesAnonymousFields() {
        List list = this.getAllEnclosingAnonymousTypesField();
        List list2 = this.getAllAccessedFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IVariableBinding iVariableBinding = (IVariableBinding)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                IVariableBinding iVariableBinding2 = (IVariableBinding)iterator2.next();
                if (!Bindings.equals((IBinding)iVariableBinding, (IBinding)iVariableBinding2)) continue;
                return true;
            }
        }
        return false;
    }

    private List getAllAccessedFields() {
        final ArrayList arrayList = new ArrayList();
        ASTVisitor aSTVisitor = new ASTVisitor(){

            public boolean visit(FieldAccess fieldAccess) {
                IVariableBinding iVariableBinding = fieldAccess.resolveFieldBinding();
                if (iVariableBinding != null && !iVariableBinding.isEnumConstant()) {
                    arrayList.add(iVariableBinding);
                }
                return super.visit(fieldAccess);
            }

            public boolean visit(QualifiedName qualifiedName) {
                IVariableBinding iVariableBinding;
                IBinding iBinding = qualifiedName.resolveBinding();
                if (iBinding != null && iBinding instanceof IVariableBinding && !(iVariableBinding = (IVariableBinding)iBinding).isEnumConstant() && iVariableBinding.isField()) {
                    arrayList.add(iBinding);
                }
                return super.visit(qualifiedName);
            }

            public boolean visit(SimpleName simpleName) {
                IVariableBinding iVariableBinding;
                IBinding iBinding = simpleName.resolveBinding();
                if (iBinding != null && iBinding instanceof IVariableBinding && !(iVariableBinding = (IVariableBinding)iBinding).isEnumConstant() && iVariableBinding.isField()) {
                    arrayList.add(iBinding);
                }
                return super.visit(simpleName);
            }

            public boolean visit(SuperFieldAccess superFieldAccess) {
                IVariableBinding iVariableBinding = superFieldAccess.resolveFieldBinding();
                if (iVariableBinding != null && !iVariableBinding.isEnumConstant()) {
                    arrayList.add(iVariableBinding);
                }
                return super.visit(superFieldAccess);
            }
        };
        this.fAnonymousInnerClassNode.accept(aSTVisitor);
        return arrayList;
    }

    private List getAllEnclosingAnonymousTypesField() {
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz);
        AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, 1);
        while (anonymousClassDeclaration != null) {
            if (!ASTNodes.isParent((ASTNode)anonymousClassDeclaration, (ASTNode)abstractTypeDeclaration)) break;
            ITypeBinding iTypeBinding = anonymousClassDeclaration.resolveBinding();
            if (iTypeBinding != null) {
                arrayList.addAll(Arrays.asList(iTypeBinding.getDeclaredFields()));
            }
            anonymousClassDeclaration = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)anonymousClassDeclaration, 1);
        }
        return arrayList;
    }

    private boolean classNameHidesEnclosingType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITypeBinding iTypeBinding = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz)).resolveBinding();
        while (iTypeBinding != null) {
            if (this.fClassName.equals(iTypeBinding.getName())) {
                return true;
            }
            iTypeBinding = iTypeBinding.getDeclaringClass();
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        try {
            RefactoringStatus refactoringStatus2 = this.validateInput();
            if (this.accessesAnonymousFields()) {
                refactoringStatus2.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_anonymous_field_access));
            }
            refactoringStatus = refactoringStatus2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public CompilationUnitChange createCompilationUnitChange(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
        ITypeBinding[] iTypeBindingArray = this.getTypeParameters();
        this.addNestedClass(compilationUnitRewrite, iTypeBindingArray);
        this.modifyConstructorCall(compilationUnitRewrite, iTypeBindingArray);
        return compilationUnitRewrite.createChange(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name, false, iProgressMonitor);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitChange compilationUnitChange = this.createCompilationUnitChange(iProgressMonitor);
        compilationUnitChange.setDescriptor((ChangeDescriptor)this.createRefactoringDescriptor());
        return compilationUnitChange;
    }

    private ITypeBinding[] getTypeParameters() {
        TypeParameter typeParameter;
        ITypeBinding iTypeBinding;
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>(4);
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (this.fDeclareStatic) {
            TypeVariableFinder typeVariableFinder = new TypeVariableFinder();
            classInstanceCreation.accept((ASTVisitor)typeVariableFinder);
            return typeVariableFinder.getResult();
        }
        Object object = this.getEnclosingMethodDeclaration((ASTNode)classInstanceCreation);
        if (object != null) {
            iTypeBinding = null;
            typeParameter = null;
            Iterator iterator = object.typeParameters().iterator();
            while (iterator.hasNext()) {
                typeParameter = (TypeParameter)iterator.next();
                iTypeBinding = typeParameter.resolveBinding();
                if (iTypeBinding == null) continue;
                arrayList.add(iTypeBinding);
            }
        }
        object = new TypeVariableFinder();
        classInstanceCreation.accept((ASTVisitor)object);
        iTypeBinding = ((TypeVariableFinder)((Object)object)).getResult();
        typeParameter = new ArrayList(4);
        boolean bl = false;
        ITypeBinding iTypeBinding2 = null;
        ITypeBinding iTypeBinding3 = null;
        ITypeBinding[] iTypeBindingArray = arrayList.iterator();
        while (iTypeBindingArray.hasNext()) {
            bl = false;
            iTypeBinding2 = (ITypeBinding)iTypeBindingArray.next();
            int n = 0;
            while (n < ((ITypeBinding)iTypeBinding).length) {
                iTypeBinding3 = iTypeBinding[n];
                if (iTypeBinding3.equals((Object)iTypeBinding2)) {
                    bl = true;
                }
                ++n;
            }
            if (bl) continue;
            typeParameter.add(iTypeBinding2);
        }
        arrayList.removeAll((Collection<?>)typeParameter);
        iTypeBindingArray = new ITypeBinding[arrayList.size()];
        arrayList.toArray(iTypeBindingArray);
        return iTypeBindingArray;
    }

    private MethodDeclaration getEnclosingMethodDeclaration(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 != null) {
            if (aSTNode2 instanceof AbstractTypeDeclaration) {
                return null;
            }
            if (aSTNode2 instanceof MethodDeclaration) {
                return (MethodDeclaration)aSTNode2;
            }
            return this.getEnclosingMethodDeclaration(aSTNode2);
        }
        return null;
    }

    private RefactoringChangeDescriptor createRefactoringDescriptor() {
        ITypeBinding iTypeBinding = this.fAnonymousInnerClassNode.resolveBinding();
        Object[] objectArray = new String[]{BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding.getDeclaringMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.fCu.getJavaProject().getElementName();
        String string2 = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description_short;
        String string3 = Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description, objectArray);
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_class_name_pattern, this.fClassName));
        String string4 = JdtFlags.getVisibilityString(this.fVisibility);
        if (string4.length() == 0) {
            string4 = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_default_visibility;
        }
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_visibility_pattern, string4));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_static);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.convert.anonymous", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, 786434);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCu));
        hashMap.put("name", this.fClassName);
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + ' ' + new Integer(this.fSelectionLength).toString());
        hashMap.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        hashMap.put(ATTRIBUTE_STATIC, Boolean.valueOf(this.fDeclareStatic).toString());
        hashMap.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        return new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor);
    }

    private void modifyConstructorCall(CompilationUnitRewrite compilationUnitRewrite, ITypeBinding[] iTypeBindingArray) {
        compilationUnitRewrite.getASTRewrite().replace(this.fAnonymousInnerClassNode.getParent(), this.createNewClassInstanceCreation(compilationUnitRewrite, iTypeBindingArray), null);
    }

    private ASTNode createNewClassInstanceCreation(CompilationUnitRewrite compilationUnitRewrite, ITypeBinding[] iTypeBindingArray) {
        AST aST = this.fAnonymousInnerClassNode.getAST();
        ClassInstanceCreation classInstanceCreation = aST.newClassInstanceCreation();
        classInstanceCreation.setAnonymousClassDeclaration(null);
        SimpleType simpleType = null;
        SimpleName simpleName = aST.newSimpleName(this.fClassName);
        if (iTypeBindingArray.length > 0) {
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)aST.newSimpleType((Name)simpleName));
            int n = 0;
            while (n < iTypeBindingArray.length) {
                parameterizedType.typeArguments().add(aST.newSimpleType((Name)aST.newSimpleName(iTypeBindingArray[n].getName())));
                ++n;
            }
            simpleType = parameterizedType;
        } else {
            simpleType = aST.newSimpleType((Name)simpleName);
        }
        classInstanceCreation.setType((Type)simpleType);
        this.copyArguments(compilationUnitRewrite, classInstanceCreation);
        this.addArgumentsForLocalsUsedInInnerClass(compilationUnitRewrite, classInstanceCreation);
        this.addLinkedPosition(KEY_TYPE_NAME, (ASTNode)simpleName, compilationUnitRewrite.getASTRewrite(), true);
        return classInstanceCreation;
    }

    private void addArgumentsForLocalsUsedInInnerClass(CompilationUnitRewrite compilationUnitRewrite, ClassInstanceCreation classInstanceCreation) {
        IVariableBinding[] iVariableBindingArray = this.getUsedLocalVariables();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            AST aST = this.fAnonymousInnerClassNode.getAST();
            IVariableBinding iVariableBinding = iVariableBindingArray[n];
            Object object = null;
            object = iVariableBinding.isEnumConstant() ? aST.newQualifiedName((Name)aST.newSimpleName(iVariableBinding.getDeclaringClass().getName()), aST.newSimpleName(iVariableBinding.getName())) : aST.newSimpleName(iVariableBinding.getName());
            classInstanceCreation.arguments().add(object);
            ++n;
        }
    }

    private void copyArguments(CompilationUnitRewrite compilationUnitRewrite, ClassInstanceCreation classInstanceCreation) {
        Iterator iterator = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).arguments().iterator();
        while (iterator.hasNext()) {
            classInstanceCreation.arguments().add(compilationUnitRewrite.getASTRewrite().createCopyTarget((ASTNode)((Expression)iterator.next())));
        }
    }

    private void addNestedClass(CompilationUnitRewrite compilationUnitRewrite, ITypeBinding[] iTypeBindingArray) throws CoreException {
        AbstractTypeDeclaration abstractTypeDeclaration;
        int n;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n = ConvertAnonymousToNestedRefactoring.findIndexOfFistNestedClass((abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz)).bodyDeclarations())) == -1) {
            n = 0;
        }
        compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAt((ASTNode)this.createNewNestedClass(compilationUnitRewrite, iTypeBindingArray), n, null);
    }

    private static int findIndexOfFistNestedClass(List list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)list.get(n);
            if (ConvertAnonymousToNestedRefactoring.isNestedType(bodyDeclaration)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean isNestedType(BodyDeclaration bodyDeclaration) {
        if (!(bodyDeclaration instanceof AbstractTypeDeclaration)) {
            return false;
        }
        return bodyDeclaration.getParent() instanceof AbstractTypeDeclaration;
    }

    private AbstractTypeDeclaration createNewNestedClass(CompilationUnitRewrite compilationUnitRewrite, ITypeBinding[] iTypeBindingArray) throws CoreException {
        int n;
        String[] stringArray;
        MethodDeclaration methodDeclaration;
        Object object;
        AST aST = this.fAnonymousInnerClassNode.getAST();
        TypeDeclaration typeDeclaration = aST.newTypeDeclaration();
        typeDeclaration.setInterface(false);
        typeDeclaration.setJavadoc(null);
        typeDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.createModifiersForNestedClass()));
        typeDeclaration.setName(aST.newSimpleName(this.fClassName));
        TypeParameter typeParameter = null;
        int n2 = 0;
        while (n2 < iTypeBindingArray.length) {
            typeParameter = aST.newTypeParameter();
            typeParameter.setName(aST.newSimpleName(iTypeBindingArray[n2].getName()));
            typeDeclaration.typeParameters().add(typeParameter);
            ++n2;
        }
        this.setSuperType(typeDeclaration);
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        IVariableBinding[] iVariableBindingArray = this.getUsedLocalVariables();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        while (n3 < iVariableBindingArray.length) {
            object = StubUtility.removePrefixAndSuffixForVariable(iJavaProject, iVariableBindingArray[n3]);
            methodDeclaration = StubUtility.getVariableNameSuggestions(2, iJavaProject, (String)object, 0, arrayList, true);
            arrayList.add(methodDeclaration[0]);
            if (this.fLinkedProposalModel != null) {
                stringArray = this.fLinkedProposalModel.getPositionGroup(KEY_FIELD_NAME_EXT + n3, true);
                n = 0;
                while (n < ((MethodDeclaration)methodDeclaration).length) {
                    stringArray.addProposal((String)methodDeclaration[n], null, ((MethodDeclaration)methodDeclaration).length - n);
                    ++n;
                }
            }
            ++n3;
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        object = typeDeclaration.bodyDeclarations();
        this.createFieldsForAccessedLocals(compilationUnitRewrite, iVariableBindingArray, stringArray2, (List)object);
        methodDeclaration = this.createNewConstructor(compilationUnitRewrite, iVariableBindingArray, stringArray2);
        if (methodDeclaration != null) {
            object.add(methodDeclaration);
        }
        this.updateAndMoveBodyDeclarations(compilationUnitRewrite, iVariableBindingArray, stringArray2, (List)object, methodDeclaration);
        if (this.doAddComments()) {
            stringArray = new String[iTypeBindingArray.length];
            n = 0;
            while (n < stringArray.length) {
                stringArray[n] = iTypeBindingArray[n].getName();
                ++n;
            }
            String string = CodeGeneration.getTypeComment(compilationUnitRewrite.getCu(), this.fClassName, stringArray, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu));
            if (string != null) {
                Javadoc javadoc = (Javadoc)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(string, 29);
                typeDeclaration.setJavadoc(javadoc);
            }
        }
        if (this.fLinkedProposalModel != null) {
            this.addLinkedPosition(KEY_TYPE_NAME, (ASTNode)typeDeclaration.getName(), compilationUnitRewrite.getASTRewrite(), false);
            ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.fLinkedProposalModel, compilationUnitRewrite.getASTRewrite(), typeDeclaration.modifiers(), false);
        }
        return typeDeclaration;
    }

    private void updateAndMoveBodyDeclarations(CompilationUnitRewrite compilationUnitRewrite, IVariableBinding[] iVariableBindingArray, String[] stringArray, List list, MethodDeclaration methodDeclaration) throws JavaModelException {
        SimpleName simpleName;
        String string;
        VariableDeclarationFragment variableDeclarationFragment;
        Object object;
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        AST aST = aSTRewrite.getAST();
        boolean bl = this.useThisForFieldAccess();
        int n = methodDeclaration != null ? list.lastIndexOf(methodDeclaration) : list.size();
        Object object2 = this.fAnonymousInnerClassNode.bodyDeclarations().iterator();
        while (object2.hasNext()) {
            object = (BodyDeclaration)object2.next();
            int n2 = 0;
            while (n2 < iVariableBindingArray.length) {
                variableDeclarationFragment = LinkedNodeFinder.findByBinding((ASTNode)object, (IBinding)iVariableBindingArray[n2]);
                string = stringArray[n2];
                int n3 = 0;
                while (n3 < ((VariableDeclarationFragment)variableDeclarationFragment).length) {
                    simpleName = aST.newSimpleName(string);
                    if (bl) {
                        FieldAccess fieldAccess = aST.newFieldAccess();
                        fieldAccess.setExpression((Expression)aST.newThisExpression());
                        fieldAccess.setName(simpleName);
                        aSTRewrite.replace((ASTNode)variableDeclarationFragment[n3], (ASTNode)fieldAccess, null);
                    } else {
                        aSTRewrite.replace((ASTNode)variableDeclarationFragment[n3], (ASTNode)simpleName, null);
                    }
                    this.addLinkedPosition(KEY_FIELD_NAME_EXT + n2, (ASTNode)simpleName, aSTRewrite, false);
                    ++n3;
                }
                ++n2;
            }
            if (object instanceof Initializer || object instanceof FieldDeclaration) {
                list.add(n++, aSTRewrite.createMoveTarget((ASTNode)object));
                continue;
            }
            list.add(aSTRewrite.createMoveTarget((ASTNode)object));
        }
        if (methodDeclaration != null) {
            object2 = methodDeclaration.getBody().statements();
            object = this.getFieldsToInitializeInConstructor();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
                string = variableDeclarationFragment.getInitializer();
                Expression expression = (Expression)aSTRewrite.get((ASTNode)variableDeclarationFragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY);
                if (expression == string) {
                    expression = (Expression)aSTRewrite.createMoveTarget((ASTNode)string);
                }
                aSTRewrite.remove((ASTNode)string, null);
                simpleName = aST.newSimpleName(variableDeclarationFragment.getName().getIdentifier());
                object2.add(this.newFieldAssignment(aST, simpleName, expression, bl));
            }
        }
    }

    private void createFieldsForAccessedLocals(CompilationUnitRewrite compilationUnitRewrite, IVariableBinding[] iVariableBindingArray, String[] stringArray, List list) {
        ImportRewrite importRewrite = compilationUnitRewrite.getImportRewrite();
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        AST aST = aSTRewrite.getAST();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
            variableDeclarationFragment.setExtraDimensions(0);
            variableDeclarationFragment.setInitializer(null);
            variableDeclarationFragment.setName(aST.newSimpleName(stringArray[n]));
            FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
            ITypeBinding iTypeBinding = iVariableBindingArray[n].getType();
            fieldDeclaration.setType(importRewrite.addImport(iTypeBinding, aST));
            fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, 18));
            if (this.doAddComments()) {
                try {
                    String string = CodeGeneration.getFieldComment(compilationUnitRewrite.getCu(), iTypeBinding.getName(), stringArray[n], StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu));
                    if (string != null) {
                        Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder(string, 29);
                        fieldDeclaration.setJavadoc(javadoc);
                    }
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            }
            list.add(fieldDeclaration);
            this.addLinkedPosition(KEY_FIELD_NAME_EXT + n, (ASTNode)variableDeclarationFragment.getName(), aSTRewrite, false);
            ++n;
        }
    }

    private void addLinkedPosition(String string, ASTNode aSTNode, ASTRewrite aSTRewrite, boolean bl) {
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(string, true).addPosition(aSTRewrite.track(aSTNode), bl);
        }
    }

    private IVariableBinding[] getUsedLocalVariables() {
        HashSet hashSet = new HashSet(0);
        this.collectRefrencedVariables((ASTNode)this.fAnonymousInnerClassNode, hashSet);
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IVariableBinding iVariableBinding = (IVariableBinding)iterator.next();
            if (!this.isBindingToTemp(iVariableBinding)) continue;
            arrayList.add(iVariableBinding);
        }
        return arrayList.toArray(new IVariableBinding[arrayList.size()]);
    }

    private void collectRefrencedVariables(ASTNode aSTNode, final Set set) {
        aSTNode.accept(new ASTVisitor(){

            public boolean visit(SimpleName simpleName) {
                IBinding iBinding = simpleName.resolveBinding();
                if (iBinding instanceof IVariableBinding) {
                    set.add(iBinding);
                }
                return true;
            }
        });
    }

    private boolean isBindingToTemp(IVariableBinding iVariableBinding) {
        if (iVariableBinding.isField()) {
            return false;
        }
        if (!Modifier.isFinal((int)iVariableBinding.getModifiers())) {
            return false;
        }
        ASTNode aSTNode = this.fCompilationUnitNode.findDeclaringNode((IBinding)iVariableBinding);
        if (aSTNode == null) {
            return false;
        }
        return !ASTNodes.isParent(aSTNode, (ASTNode)this.fAnonymousInnerClassNode);
    }

    private MethodDeclaration createNewConstructor(CompilationUnitRewrite compilationUnitRewrite, IVariableBinding[] iVariableBindingArray, String[] stringArray) throws JavaModelException {
        int n;
        LinkedProposalPositionGroup linkedProposalPositionGroup;
        SimpleName simpleName;
        SingleVariableDeclaration singleVariableDeclaration;
        String string;
        SingleVariableDeclaration singleVariableDeclaration2;
        Javadoc javadoc;
        Object object;
        IMethodBinding iMethodBinding;
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (classInstanceCreation.arguments().isEmpty() && iVariableBindingArray.length == 0) {
            return null;
        }
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        AST aST = compilationUnitRewrite.getAST();
        ImportRewrite importRewrite = compilationUnitRewrite.getImportRewrite();
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setConstructor(true);
        methodDeclaration.setExtraDimensions(0);
        methodDeclaration.setJavadoc(null);
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.fVisibility));
        methodDeclaration.setName(aST.newSimpleName(this.fClassName));
        this.addLinkedPosition(KEY_TYPE_NAME, (ASTNode)methodDeclaration.getName(), aSTRewrite, false);
        methodDeclaration.setBody(aST.newBlock());
        List list = methodDeclaration.getBody().statements();
        List list2 = methodDeclaration.parameters();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!classInstanceCreation.arguments().isEmpty() && (iMethodBinding = this.getSuperConstructorBinding()) != null) {
            SuperConstructorInvocation superConstructorInvocation = aST.newSuperConstructorInvocation();
            object = iMethodBinding.getParameterTypes();
            javadoc = StubUtility.suggestArgumentNamesWithProposals(iJavaProject, iMethodBinding);
            int n2 = 0;
            while (n2 < ((String[][])javadoc).length) {
                singleVariableDeclaration2 = javadoc[n2];
                string = singleVariableDeclaration2[0];
                singleVariableDeclaration = this.newParameterDeclaration(aST, importRewrite, string, object[n2]);
                list2.add(singleVariableDeclaration);
                arrayList.add(string);
                simpleName = aST.newSimpleName(string);
                superConstructorInvocation.arguments().add(simpleName);
                if (this.fLinkedProposalModel != null) {
                    linkedProposalPositionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_PARAM_NAME_CONST + String.valueOf(n2), true);
                    linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getName()), false);
                    linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)simpleName), false);
                    n = 0;
                    while (n < ((SingleVariableDeclaration)singleVariableDeclaration2).length) {
                        linkedProposalPositionGroup.addProposal((String)singleVariableDeclaration2[n], null, ((SingleVariableDeclaration)singleVariableDeclaration2).length - n);
                        ++n;
                    }
                }
                ++n2;
            }
            list.add(superConstructorInvocation);
        }
        boolean bl = this.useThisForFieldAccess();
        int n3 = 0;
        while (n3 < iVariableBindingArray.length) {
            object = StubUtility.removePrefixAndSuffixForVariable(iJavaProject, iVariableBindingArray[n3]);
            javadoc = StubUtility.getVariableNameSuggestions(4, iJavaProject, (String)object, 0, arrayList, true);
            String[] stringArray2 = javadoc[0];
            singleVariableDeclaration2 = this.newParameterDeclaration(aST, importRewrite, (String)stringArray2, iVariableBindingArray[n3].getType());
            list2.add(singleVariableDeclaration2);
            arrayList.add(stringArray2);
            string = stringArray[n3];
            singleVariableDeclaration = aST.newSimpleName(string);
            simpleName = aST.newSimpleName((String)stringArray2);
            list.add(this.newFieldAssignment(aST, (SimpleName)singleVariableDeclaration, (Expression)simpleName, bl || arrayList.contains(string)));
            if (this.fLinkedProposalModel != null) {
                linkedProposalPositionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_PARAM_NAME_EXT + String.valueOf(n3), true);
                linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration2.getName()), false);
                linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)simpleName), false);
                n = 0;
                while (n < ((Javadoc)javadoc).length) {
                    linkedProposalPositionGroup.addProposal((String)javadoc[n], null, ((Javadoc)javadoc).length - n);
                    ++n;
                }
                this.fLinkedProposalModel.getPositionGroup(KEY_FIELD_NAME_EXT + n3, true).addPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration), false);
            }
            ++n3;
        }
        this.addExceptionsToNewConstructor(methodDeclaration);
        if (this.doAddComments()) {
            try {
                String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
                object = CodeGeneration.getMethodComment(this.fCu, this.fClassName, this.fClassName, stringArray3, new String[0], null, new String[0], null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu));
                if (object != null) {
                    javadoc = (Javadoc)aSTRewrite.createStringPlaceholder((String)object, 29);
                    methodDeclaration.setJavadoc(javadoc);
                }
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        return methodDeclaration;
    }

    private Statement newFieldAssignment(AST aST, SimpleName simpleName, Expression expression, boolean bl) {
        Assignment assignment = aST.newAssignment();
        if (bl) {
            FieldAccess fieldAccess = aST.newFieldAccess();
            fieldAccess.setExpression((Expression)aST.newThisExpression());
            fieldAccess.setName(simpleName);
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)simpleName);
        }
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(expression);
        return aST.newExpressionStatement((Expression)assignment);
    }

    private List getFieldsToInitializeInConstructor() {
        ArrayList<VariableDeclarationFragment> arrayList = new ArrayList<VariableDeclarationFragment>(0);
        Iterator iterator = this.fAnonymousInnerClassNode.bodyDeclarations().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FieldDeclaration)) continue;
            List list = ((FieldDeclaration)e).fragments();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator2.next();
                if (!this.isToBeInitializerInConstructor(variableDeclarationFragment, arrayList)) continue;
                arrayList.add(variableDeclarationFragment);
            }
        }
        return arrayList;
    }

    private boolean isToBeInitializerInConstructor(VariableDeclarationFragment variableDeclarationFragment, List list) {
        return variableDeclarationFragment.getInitializer() != null && this.areLocalsUsedIn(variableDeclarationFragment.getInitializer(), list);
    }

    private boolean areLocalsUsedIn(Expression expression, List list) {
        HashSet hashSet = new HashSet(0);
        this.collectRefrencedVariables((ASTNode)expression, hashSet);
        ITypeBinding iTypeBinding = this.fAnonymousInnerClassNode.resolveBinding();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IVariableBinding iVariableBinding = (IVariableBinding)iterator.next();
            if (this.isBindingToTemp(iVariableBinding)) {
                return true;
            }
            if (!iVariableBinding.isField() || iVariableBinding.getDeclaringClass() != iTypeBinding || !list.contains(this.fCompilationUnitNode.findDeclaringNode((IBinding)iVariableBinding))) continue;
            return true;
        }
        return false;
    }

    private IMethodBinding getSuperConstructorBinding() {
        IMethodBinding iMethodBinding = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).resolveConstructorBinding();
        if (iMethodBinding == null) {
            return null;
        }
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass().getSuperclass();
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            IMethodBinding iMethodBinding2 = iMethodBindingArray[n];
            if (iMethodBinding2.isConstructor() && ConvertAnonymousToNestedRefactoring.parameterTypesMatch(iMethodBinding2, iMethodBinding)) {
                return iMethodBinding2;
            }
            ++n;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static boolean parameterTypesMatch(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        ITypeBinding[] iTypeBindingArray;
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getParameterTypes();
        if (iTypeBindingArray2.length != (iTypeBindingArray = iMethodBinding2.getParameterTypes()).length) {
            return false;
        }
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (!iTypeBindingArray2[n].equals((Object)iTypeBindingArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void addExceptionsToNewConstructor(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = this.getSuperConstructorBinding();
        if (iMethodBinding == null) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            Name name = this.fAnonymousInnerClassNode.getAST().newName(Bindings.getNameComponents(iTypeBindingArray[n]));
            methodDeclaration.thrownExceptions().add(name);
            ++n;
        }
    }

    private SingleVariableDeclaration newParameterDeclaration(AST aST, ImportRewrite importRewrite, String string, ITypeBinding iTypeBinding) {
        SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
        singleVariableDeclaration.setExtraDimensions(0);
        singleVariableDeclaration.setInitializer(null);
        singleVariableDeclaration.setType(importRewrite.addImport(iTypeBinding, aST));
        singleVariableDeclaration.setName(aST.newSimpleName(string));
        return singleVariableDeclaration;
    }

    private void setSuperType(TypeDeclaration typeDeclaration) throws JavaModelException {
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        ITypeBinding iTypeBinding = classInstanceCreation.resolveTypeBinding();
        if (iTypeBinding == null) {
            return;
        }
        Type type = (Type)ASTNode.copySubtree((AST)this.fAnonymousInnerClassNode.getAST(), (ASTNode)classInstanceCreation.getType());
        if (iTypeBinding.getSuperclass().getQualifiedName().equals("java.lang.Object")) {
            Assert.isTrue((iTypeBinding.getInterfaces().length <= 1 ? 1 : 0) != 0);
            if (iTypeBinding.getInterfaces().length == 0) {
                return;
            }
            typeDeclaration.superInterfaceTypes().add(0, type);
        } else {
            typeDeclaration.setSuperclassType(type);
        }
    }

    private ITypeBinding getSuperTypeBinding() {
        ITypeBinding iTypeBinding = this.fAnonymousInnerClassNode.resolveBinding();
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        if (iTypeBindingArray.length > 0) {
            return iTypeBindingArray[0];
        }
        return iTypeBinding.getSuperclass();
    }

    private int createModifiersForNestedClass() {
        int n = this.fVisibility;
        if (this.fDeclareFinal) {
            n |= 0x10;
        }
        if (this.mustInnerClassBeStatic() || this.fDeclareStatic) {
            n |= 8;
        }
        return n;
    }

    public boolean mustInnerClassBeStatic() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITypeBinding iTypeBinding = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, clazz)).resolveBinding();
        ASTNode aSTNode = this.fAnonymousInnerClassNode.getParent();
        boolean bl = false;
        while (aSTNode != null) {
            switch (aSTNode.getNodeType()) {
                case 1: {
                    AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)aSTNode;
                    ITypeBinding iTypeBinding2 = anonymousClassDeclaration.resolveBinding();
                    if (iTypeBinding2 == null || !Bindings.isSuperType(iTypeBinding, iTypeBinding2.getSuperclass())) break;
                    return false;
                }
                case 23: {
                    AnonymousClassDeclaration anonymousClassDeclaration = (FieldDeclaration)aSTNode;
                    if (!Modifier.isStatic((int)anonymousClassDeclaration.getModifiers())) break;
                    bl = true;
                    break;
                }
                case 31: {
                    AnonymousClassDeclaration anonymousClassDeclaration = (MethodDeclaration)aSTNode;
                    if (!Modifier.isStatic((int)anonymousClassDeclaration.getModifiers())) break;
                    bl = true;
                    break;
                }
                case 55: {
                    return bl;
                }
            }
            aSTNode = aSTNode.getParent();
        }
        return bl;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        this.fSelfInitializing = true;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            int n;
            int n2;
            String string2;
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string3 = javaRefactoringArguments.getAttribute("input");
            if (string3 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string3, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.convert.anonymous");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)object;
            object = javaRefactoringArguments.getAttribute("name");
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fClassName = object;
            String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_VISIBILITY);
            if (string4 != null && !"".equals(string4)) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = n3;
            }
            if ((string2 = javaRefactoringArguments.getAttribute("selection")) != null) {
                n2 = -1;
                n = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string2, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_STATIC);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
            }
            this.fDeclareStatic = Boolean.valueOf(string);
            String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_FINAL);
            if (string5 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    public static class TypeVariableFinder
    extends ASTVisitor {
        private final Map fBindings = new HashMap();
        private final List fFound = new ArrayList();

        public final boolean visit(SimpleName simpleName) {
            Assert.isNotNull((Object)simpleName);
            ITypeBinding iTypeBinding = simpleName.resolveTypeBinding();
            if (iTypeBinding != null && iTypeBinding.isTypeVariable() && !this.fBindings.containsKey(iTypeBinding.getKey())) {
                this.fBindings.put(iTypeBinding.getKey(), iTypeBinding);
                this.fFound.add(iTypeBinding);
            }
            return true;
        }

        public final ITypeBinding[] getResult() {
            ITypeBinding[] iTypeBindingArray = new ITypeBinding[this.fFound.size()];
            this.fFound.toArray(iTypeBindingArray);
            return iTypeBindingArray;
        }
    }
}

