/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class NLSHint {
    private String fAccessorName;
    private IPackageFragment fAccessorPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private NLSSubstitution[] fSubstitutions;
    static /* synthetic */ Class class$0;

    public NLSHint(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
        NLSLine[] nLSLineArray;
        Cloneable cloneable;
        Assert.isNotNull((Object)iCompilationUnit);
        Assert.isNotNull((Object)compilationUnit);
        IPackageFragment iPackageFragment = (IPackageFragment)iCompilationUnit.getAncestor(4);
        this.fAccessorName = "Messages";
        this.fAccessorPackage = iPackageFragment;
        this.fResourceBundleName = "messages.properties";
        this.fResourceBundlePackage = iPackageFragment;
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        NLSLine[] nLSLineArray2 = NLSHint.createRawLines(iCompilationUnit);
        AccessorClassReference accessorClassReference = NLSHint.findFirstAccessorReference(nLSLineArray2, compilationUnit);
        if (accessorClassReference == null) {
            cloneable = new ArrayList();
            accessorClassReference = this.createEclipseNLSLines(this.getDocument(iCompilationUnit), compilationUnit, (List)((Object)cloneable));
            if (!cloneable.isEmpty()) {
                nLSLineArray = nLSLineArray2;
                int n = nLSLineArray.length;
                int n2 = cloneable.size();
                nLSLineArray2 = new NLSLine[n + n2];
                int n3 = 0;
                while (n3 < n) {
                    nLSLineArray2[n3] = nLSLineArray[n3];
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    nLSLineArray2[n3 + n] = (NLSLine)cloneable.get(n3);
                    ++n3;
                }
            }
        }
        cloneable = null;
        if (accessorClassReference != null) {
            cloneable = NLSHintHelper.getProperties(iJavaProject, accessorClassReference);
        }
        if (cloneable == null) {
            cloneable = new Properties();
        }
        this.fSubstitutions = this.createSubstitutions(nLSLineArray2, (Properties)cloneable, compilationUnit);
        if (accessorClassReference != null) {
            this.fAccessorName = accessorClassReference.getName();
            nLSLineArray = accessorClassReference.getBinding();
            try {
                String string;
                IPackageFragment iPackageFragment2 = NLSHintHelper.getPackageOfAccessorClass(iJavaProject, (ITypeBinding)nLSLineArray);
                if (iPackageFragment2 != null) {
                    this.fAccessorPackage = iPackageFragment2;
                }
                if ((string = accessorClassReference.getResourceBundleName()) != null) {
                    this.fResourceBundleName = String.valueOf(Signature.getSimpleName((String)string)) + ".properties";
                    String string2 = Signature.getQualifier((String)string);
                    IPackageFragment iPackageFragment3 = NLSHintHelper.getResourceBundlePackage(iJavaProject, string2, this.fResourceBundleName);
                    if (iPackageFragment3 != null) {
                        this.fResourceBundlePackage = iPackageFragment3;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private AccessorClassReference createEclipseNLSLines(final IDocument iDocument, CompilationUnit compilationUnit, List list) {
        final AccessorClassReference[] accessorClassReferenceArray = new AccessorClassReference[1];
        final TreeMap treeMap = new TreeMap();
        compilationUnit.accept(new ASTVisitor(){
            private ICompilationUnit fCache_CU;
            private CompilationUnit fCache_AST;

            public boolean visit(QualifiedName qualifiedName) {
                ITypeBinding iTypeBinding;
                ITypeBinding iTypeBinding2 = qualifiedName.getQualifier().resolveTypeBinding();
                if (iTypeBinding2 != null && (iTypeBinding = iTypeBinding2.getSuperclass()) != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.osgi.util.NLS");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.getName().equals(iTypeBinding.getQualifiedName())) {
                        String string;
                        Integer n;
                        try {
                            n = new Integer(iDocument.getLineOfOffset(qualifiedName.getStartPosition()));
                        }
                        catch (BadLocationException badLocationException) {
                            return true;
                        }
                        NLSLine nLSLine = (NLSLine)treeMap.get(n);
                        if (nLSLine == null) {
                            nLSLine = new NLSLine(n);
                            treeMap.put(n, nLSLine);
                        }
                        SimpleName simpleName = qualifiedName.getName();
                        NLSElement nLSElement = new NLSElement(qualifiedName.getName().getIdentifier(), simpleName.getStartPosition(), simpleName.getLength(), nLSLine.size() - 1, true);
                        nLSLine.add(nLSElement);
                        try {
                            ICompilationUnit iCompilationUnit = (ICompilationUnit)iTypeBinding2.getJavaElement().getAncestor(5);
                            if (this.fCache_CU == null || !this.fCache_CU.equals(iCompilationUnit) || this.fCache_AST == null) {
                                this.fCache_CU = iCompilationUnit;
                                this.fCache_AST = this.fCache_CU != null ? JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCache_CU, ASTProvider.WAIT_YES, null) : null;
                            }
                            string = NLSHintHelper.getResourceBundleName(this.fCache_AST);
                        }
                        catch (JavaModelException javaModelException) {
                            return true;
                        }
                        nLSElement.setAccessorClassReference(new AccessorClassReference(iTypeBinding2, string, new Region(qualifiedName.getStartPosition(), qualifiedName.getLength())));
                        if (accessorClassReferenceArray[0] == null) {
                            accessorClassReferenceArray[0] = nLSElement.getAccessorClassReference();
                        }
                    }
                }
                return true;
            }
        });
        list.addAll(treeMap.values());
        return accessorClassReferenceArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDocument getDocument(ICompilationUnit iCompilationUnit) {
        ITextFileBufferManager iTextFileBufferManager;
        IPath iPath;
        block9: {
            IDocument iDocument;
            iPath = iCompilationUnit.getPath();
            iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            try {
                iTextFileBufferManager.connect(iPath, LocationKind.NORMALIZE, null);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                ITextFileBuffer iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.NORMALIZE);
                if (iTextFileBuffer == null) break block9;
                iDocument = iTextFileBuffer.getDocument();
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {}
                catch (CoreException coreException) {
                    return null;
                }
                iTextFileBufferManager.disconnect(iPath, LocationKind.NORMALIZE, null);
                throw throwable;
            }
            try {
                iTextFileBufferManager.disconnect(iPath, LocationKind.NORMALIZE, null);
                return iDocument;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        Object var5_8 = null;
        try {}
        catch (CoreException coreException) {
            return null;
        }
        iTextFileBufferManager.disconnect(iPath, LocationKind.NORMALIZE, null);
        return null;
    }

    private NLSSubstitution[] createSubstitutions(NLSLine[] nLSLineArray, Properties properties, CompilationUnit compilationUnit) {
        ArrayList<NLSSubstitution> arrayList = new ArrayList<NLSSubstitution>();
        int n = 0;
        while (n < nLSLineArray.length) {
            NLSElement[] nLSElementArray = nLSLineArray[n].getElements();
            int n2 = 0;
            while (n2 < nLSElementArray.length) {
                Object object;
                NLSElement nLSElement = nLSElementArray[n2];
                if (nLSElement.hasTag()) {
                    object = NLSHintHelper.getAccessorClassReference(compilationUnit, nLSElement);
                    if (object == null) {
                        arrayList.add(new NLSSubstitution(1, NLSHint.stripQuotes(nLSElement.getValue()), nLSElement));
                    } else {
                        String string = NLSHint.stripQuotes(nLSElement.getValue());
                        String string2 = properties.getProperty(string);
                        arrayList.add(new NLSSubstitution(0, string, string2, nLSElement, (AccessorClassReference)object));
                    }
                } else if (nLSElement.isEclipseNLS()) {
                    object = nLSElement.getValue();
                    arrayList.add(new NLSSubstitution(0, (String)object, properties.getProperty((String)object), nLSElement, nLSElement.getAccessorClassReference()));
                } else {
                    arrayList.add(new NLSSubstitution(2, NLSHint.stripQuotes(nLSElement.getValue()), nLSElement));
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new NLSSubstitution[arrayList.size()]);
    }

    private static AccessorClassReference findFirstAccessorReference(NLSLine[] nLSLineArray, CompilationUnit compilationUnit) {
        AccessorClassReference accessorClassReference;
        NLSElement nLSElement;
        int n;
        NLSElement[] nLSElementArray;
        int n2 = 0;
        while (n2 < nLSLineArray.length) {
            nLSElementArray = nLSLineArray[n2].getElements();
            n = 0;
            while (n < nLSElementArray.length) {
                nLSElement = nLSElementArray[n];
                if (nLSElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(compilationUnit, nLSElement)) != null) {
                    return accessorClassReference;
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nLSLineArray.length) {
            nLSElementArray = nLSLineArray[n2].getElements();
            n = 0;
            while (n < nLSElementArray.length) {
                nLSElement = nLSElementArray[n];
                if (!nLSElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(compilationUnit, nLSElement)) != null) {
                    return accessorClassReference;
                }
                ++n;
            }
            ++n2;
        }
        return null;
    }

    private static String stripQuotes(String string) {
        return string.substring(1, string.length() - 1);
    }

    private static NLSLine[] createRawLines(ICompilationUnit iCompilationUnit) {
        try {
            return NLSScanner.scan(iCompilationUnit);
        }
        catch (JavaModelException javaModelException) {
            return new NLSLine[0];
        }
        catch (InvalidInputException invalidInputException) {
            return new NLSLine[0];
        }
    }

    public String getAccessorClassName() {
        return this.fAccessorName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }
}

