/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;

public class NLSSubstitution {
    public static final int EXTERNALIZED = 0;
    public static final int IGNORED = 1;
    public static final int INTERNALIZED = 2;
    public static final int DEFAULT = 0;
    public static final int STATE_COUNT = 3;
    private int fState;
    private String fKey;
    private String fCachedPrefixPlusKey;
    private String fValue;
    private int fInitialState;
    private String fInitialKey;
    private String fInitialValue;
    private NLSElement fNLSElement;
    private AccessorClassReference fAccessorClassReference;
    private String fNewAccessorClassName;
    private String fPrefix = "";

    public NLSSubstitution(int n, String string, NLSElement nLSElement) {
        this.fNLSElement = nLSElement;
        this.fValue = string;
        this.fState = n;
        this.fInitialState = n;
        this.fInitialValue = string;
        this.fCachedPrefixPlusKey = null;
        Assert.isTrue((n == 0 || n == 1 || n == 2 ? 1 : 0) != 0);
    }

    public NLSSubstitution(int n, String string, String string2, NLSElement nLSElement, AccessorClassReference accessorClassReference) {
        this(n, string2, nLSElement);
        if (n != 0) {
            throw new IllegalArgumentException("Set to INTERNALIZE/IGNORED State with different Constructor");
        }
        this.fKey = string;
        this.fInitialKey = string;
        this.fAccessorClassReference = accessorClassReference;
        this.fNewAccessorClassName = null;
    }

    public static int countItems(NLSSubstitution[] nLSSubstitutionArray, int n) {
        Assert.isTrue((n == 0 || n == 1 || n == 2 ? 1 : 0) != 0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < nLSSubstitutionArray.length) {
            if (nLSSubstitutionArray[n3].fState == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public NLSElement getNLSElement() {
        return this.fNLSElement;
    }

    public String getKeyWithoutPrefix() {
        return this.fKey;
    }

    public String getKey() {
        if (this.fState == 0 && this.hasStateChanged()) {
            if (this.fCachedPrefixPlusKey == null) {
                int n = 0;
                if (this.fPrefix != null) {
                    n += this.fPrefix.length();
                }
                if (this.fKey != null) {
                    n += this.fKey.length();
                }
                StringBuffer stringBuffer = new StringBuffer(n);
                stringBuffer.append(this.fPrefix);
                stringBuffer.append(this.fKey);
                this.fCachedPrefixPlusKey = stringBuffer.toString();
            }
            return this.fCachedPrefixPlusKey;
        }
        return this.fKey;
    }

    public void setKey(String string) {
        if (this.fState != 0) {
            throw new IllegalStateException("Must be in Externalized State !");
        }
        this.fCachedPrefixPlusKey = null;
        this.fKey = string;
    }

    public void setValue(String string) {
        this.fValue = string;
    }

    public void setInitialValue(String string) {
        this.fInitialValue = string;
    }

    public String getValue() {
        return this.fValue;
    }

    public String getValueNonEmpty() {
        if (this.fValue == null) {
            return "";
        }
        return this.fValue;
    }

    public int getState() {
        return this.fState;
    }

    public void setState(int n) {
        this.fCachedPrefixPlusKey = null;
        this.fState = n;
    }

    public void setUpdatedAccessor(String string) {
        this.fNewAccessorClassName = string;
    }

    public String getUpdatedAccessor() {
        return this.fNewAccessorClassName;
    }

    public boolean hasStateChanged() {
        return this.fState != this.fInitialState;
    }

    public boolean isKeyRename() {
        return this.fInitialKey != null && !this.fInitialKey.equals(this.fKey);
    }

    public boolean isValueRename() {
        return this.fInitialValue != null && !this.fInitialValue.equals(this.fValue);
    }

    public boolean isAccessorRename() {
        return this.fAccessorClassReference != null && this.fNewAccessorClassName != null && !this.fNewAccessorClassName.equals(this.fAccessorClassReference.getName());
    }

    public boolean hasPropertyFileChange() {
        if (this.fInitialState != 0 && this.fState != 0) {
            return false;
        }
        if (this.fInitialState != this.fState) {
            return true;
        }
        if (this.fState == 0) {
            if (this.fInitialValue == null) {
                return true;
            }
            if (!this.fInitialValue.equals(this.fValue)) {
                return true;
            }
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAccessorClassChange() {
        if (this.fInitialState != 0 && this.fState != 0) {
            return false;
        }
        if (this.fInitialState != this.fState) {
            return true;
        }
        if (this.fState == 0) {
            if (this.fInitialValue == null) {
                return true;
            }
            if (!this.fInitialValue.equals(this.fValue)) {
                return false;
            }
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasSourceChange() {
        if (this.hasStateChanged()) {
            return true;
        }
        if (this.fState == 0) {
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
            if (this.isAccessorRename()) {
                return true;
            }
        } else if (!this.fInitialValue.equals(this.fValue)) {
            return true;
        }
        return false;
    }

    public int getInitialState() {
        return this.fInitialState;
    }

    public String getInitialKey() {
        return this.fInitialKey;
    }

    public String getInitialValue() {
        return this.fInitialValue;
    }

    public AccessorClassReference getAccessorClassReference() {
        return this.fAccessorClassReference;
    }

    public void setPrefix(String string) {
        this.fPrefix = string;
        this.fCachedPrefixPlusKey = null;
    }

    public boolean isConflicting(NLSSubstitution[] nLSSubstitutionArray) {
        if (this.fState == 0) {
            String string = this.getKey();
            String string2 = this.getValueNonEmpty();
            int n = 0;
            while (n < nLSSubstitutionArray.length) {
                NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
                if (nLSSubstitution != this && nLSSubstitution.getState() == 0 && string.equals(nLSSubstitution.getKey()) && !string2.equals(nLSSubstitution.getValueNonEmpty())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String internalGetKeyWithoutPrefix() {
        if (this.fState == 0 && this.fPrefix != null && this.fKey != null && this.fKey.indexOf(this.fPrefix) == 0) {
            return this.fKey.substring(this.fPrefix.length());
        }
        return this.fKey;
    }

    public void generateKey(NLSSubstitution[] nLSSubstitutionArray) {
        if (this.fState != 0 || this.fState == 0 && this.hasStateChanged()) {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = 0;
            while (n3 < nLSSubstitutionArray.length) {
                NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n3];
                if (nLSSubstitution != this && nLSSubstitution.fState == 0) {
                    try {
                        int n4 = Integer.parseInt(nLSSubstitution.internalGetKeyWithoutPrefix());
                        n = Math.min(n, n4);
                        n2 = Math.max(n2, n4);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n3;
            }
            this.fCachedPrefixPlusKey = null;
            this.fKey = n == Integer.MAX_VALUE ? this.createKey(0) : (n > 0 ? this.createKey(n - 1) : this.createKey(n2 + 1));
        }
    }

    public static void updateSubtitutions(NLSSubstitution[] nLSSubstitutionArray, Properties properties, String string) {
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (nLSSubstitution.getState() == 0 && !nLSSubstitution.hasStateChanged()) {
                nLSSubstitution.setInitialValue(properties.getProperty(nLSSubstitution.getKey()));
                nLSSubstitution.setUpdatedAccessor(string);
            }
            ++n;
        }
    }

    public void revert() {
        this.fState = this.fInitialState;
        this.fKey = this.fInitialKey;
        this.fCachedPrefixPlusKey = null;
        this.fValue = this.fInitialValue;
    }

    private String createKey(int n) {
        return String.valueOf(n);
    }
}

