/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.refactoring.RenameTypeArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.RefactoringModifications;

public class RenameModifications
extends RefactoringModifications {
    private List fRename = new ArrayList();
    private List fRenameArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void rename(IResource iResource, RenameArguments renameArguments) {
        this.add(iResource, (RefactoringArguments)renameArguments, null);
    }

    public void rename(IJavaProject iJavaProject, RenameArguments renameArguments) {
        this.add(iJavaProject, (RefactoringArguments)renameArguments, null);
        IProject iProject = iJavaProject.getProject();
        if (iProject != null) {
            this.getResourceModifications().addRename((IResource)iProject, renameArguments);
            IProject[] iProjectArray = iProject.getReferencingProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                IFile iFile = this.getClasspathFile((IResource)iProjectArray[n]);
                if (iFile != null) {
                    this.getResourceModifications().addChanged(iFile);
                }
                ++n;
            }
        }
    }

    public void rename(IPackageFragmentRoot iPackageFragmentRoot, RenameArguments renameArguments) {
        this.add(iPackageFragmentRoot, (RefactoringArguments)renameArguments, null);
        if (iPackageFragmentRoot.getResource() != null) {
            this.getResourceModifications().addRename(iPackageFragmentRoot.getResource(), renameArguments);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rename(IPackageFragment iPackageFragment, RenameArguments renameArguments, boolean bl) throws CoreException {
        IContainer iContainer;
        RenameArguments renameArguments2;
        IPackageFragment iPackageFragment2;
        this.add(iPackageFragment, (RefactoringArguments)renameArguments, null);
        IPackageFragment[] iPackageFragmentArray = null;
        if (bl) {
            iPackageFragmentArray = this.getSubpackages(iPackageFragment);
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                iPackageFragment2 = iPackageFragmentArray[n];
                renameArguments2 = new RenameArguments(this.getNewPackageName(iPackageFragment, renameArguments.getNewName(), iPackageFragment2.getElementName()), renameArguments.getUpdateReferences());
                this.add(iPackageFragment2, (RefactoringArguments)renameArguments2, null);
                ++n;
            }
        }
        if ((iContainer = (IContainer)iPackageFragment.getResource()) == null) {
            return;
        }
        iPackageFragment2 = (IContainer)((IPackageFragmentRoot)iPackageFragment.getParent()).getPackageFragment(renameArguments.getNewName()).getResource();
        if ((!iPackageFragment.hasSubpackages() || bl) && this.canMove(iContainer, (IContainer)iPackageFragment2)) {
            this.createIncludingParents(iPackageFragment2.getParent());
            if (iContainer.getParent().equals((Object)iPackageFragment2.getParent())) {
                this.getResourceModifications().addRename((IResource)iContainer, new RenameArguments(iPackageFragment2.getName(), renameArguments.getUpdateReferences()));
                return;
            }
            try {
                this.getResourceModifications().ignoreForDelta();
                this.addAllResourceModifications(iPackageFragment, renameArguments, bl, iPackageFragmentArray);
            }
            catch (Throwable throwable) {
                renameArguments2 = null;
                this.getResourceModifications().trackForDelta();
                throw throwable;
            }
            {
                renameArguments2 = null;
                this.getResourceModifications().trackForDelta();
                this.getResourceModifications().addDelta(new ResourceModifications.MoveDescription((IResource)iContainer, iPackageFragment2.getFullPath()));
                return;
            }
        }
        this.addAllResourceModifications(iPackageFragment, renameArguments, bl, iPackageFragmentArray);
    }

    public void rename(ICompilationUnit iCompilationUnit, RenameArguments renameArguments) {
        this.add(iCompilationUnit, (RefactoringArguments)renameArguments, null);
        if (iCompilationUnit.getResource() != null) {
            this.getResourceModifications().addRename(iCompilationUnit.getResource(), new RenameArguments(renameArguments.getNewName(), renameArguments.getUpdateReferences()));
        }
    }

    public void rename(IType iType, RenameTypeArguments renameTypeArguments, IParticipantDescriptorFilter iParticipantDescriptorFilter) {
        this.add(iType, (RefactoringArguments)renameTypeArguments, iParticipantDescriptorFilter);
    }

    public void rename(IField iField, RenameArguments renameArguments) {
        this.add(iField, (RefactoringArguments)renameArguments, null);
    }

    public void rename(IMethod iMethod, RenameArguments renameArguments) {
        this.add(iMethod, (RefactoringArguments)renameArguments, null);
    }

    public void rename(ILocalVariable iLocalVariable, RenameArguments renameArguments) {
        this.add(iLocalVariable, (RefactoringArguments)renameArguments, null);
    }

    public void rename(ITypeParameter iTypeParameter, RenameArguments renameArguments) {
        this.add(iTypeParameter, (RefactoringArguments)renameArguments, null);
    }

    public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
        int n = 0;
        while (n < this.fRename.size()) {
            Object e = this.fRename.get(n);
            if (e instanceof IResource) {
                ResourceModifications.buildMoveDelta(iResourceChangeDescriptionFactory, (IResource)e, (RenameArguments)this.fRenameArguments.get(n));
            }
            ++n;
        }
        this.getResourceModifications().buildDelta(iResourceChangeDescriptionFactory);
    }

    public void buildValidateEdits(ValidateEditChecker validateEditChecker) {
        Iterator iterator = this.fRename.iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit;
            IResource iResource;
            Object e = iterator.next();
            if (!(e instanceof ICompilationUnit) || (iResource = (iCompilationUnit = (ICompilationUnit)e).getResource()) == null || iResource.getType() != 1) continue;
            validateEditChecker.addFile((IFile)iResource);
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, RefactoringProcessor refactoringProcessor, String[] stringArray, SharableParticipants sharableParticipants) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.fRename.size()) {
            arrayList.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, this.fRename.get(n), (RenameArguments)((RenameArguments)this.fRenameArguments.get(n)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(n)), (String[])stringArray, (SharableParticipants)sharableParticipants)));
            ++n;
        }
        arrayList.addAll(Arrays.asList(this.getResourceModifications().getParticipants(refactoringStatus, refactoringProcessor, stringArray, sharableParticipants)));
        return arrayList.toArray(new RefactoringParticipant[arrayList.size()]);
    }

    private void add(Object object, RefactoringArguments refactoringArguments, IParticipantDescriptorFilter iParticipantDescriptorFilter) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)refactoringArguments);
        this.fRename.add(object);
        this.fRenameArguments.add(refactoringArguments);
        this.fParticipantDescriptorFilter.add(iParticipantDescriptorFilter);
    }

    private void addAllResourceModifications(IPackageFragment iPackageFragment, RenameArguments renameArguments, boolean bl, IPackageFragment[] iPackageFragmentArray) throws CoreException {
        this.addResourceModifications(iPackageFragment, renameArguments, iPackageFragment, bl);
        if (bl) {
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment2 = iPackageFragmentArray[n];
                this.addResourceModifications(iPackageFragment, renameArguments, iPackageFragment2, bl);
                ++n;
            }
        }
    }

    private void addResourceModifications(IPackageFragment iPackageFragment, RenameArguments renameArguments, IPackageFragment iPackageFragment2, boolean bl) throws CoreException {
        IResource iResource;
        IContainer iContainer = (IContainer)iPackageFragment2.getResource();
        if (iContainer == null) {
            return;
        }
        IFolder iFolder = this.computeTargetFolder(iPackageFragment, renameArguments, iPackageFragment2);
        this.createIncludingParents((IContainer)iFolder);
        MoveArguments moveArguments = new MoveArguments((Object)iFolder, renameArguments.getUpdateReferences());
        IResource[] iResourceArray = this.collectResourcesOfInterest(iPackageFragment2);
        HashSet<IResource> hashSet = new HashSet<IResource>(Arrays.asList(iContainer.members()));
        int n = 0;
        while (n < iResourceArray.length) {
            iResource = iResourceArray[n];
            this.getResourceModifications().addMove(iResource, moveArguments);
            hashSet.remove(iResource);
            ++n;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            if (!(iResource instanceof IFile)) continue;
            this.getResourceModifications().addDelete(iResource);
            iterator.remove();
        }
        if (bl && iPackageFragment.equals(iPackageFragment2) || !bl && hashSet.isEmpty()) {
            this.getResourceModifications().addDelete((IResource)iContainer);
        }
    }

    private boolean canMove(IContainer iContainer, IContainer iContainer2) {
        return !iContainer2.exists() && !iContainer.getFullPath().isPrefixOf(iContainer2.getFullPath());
    }

    private IPackageFragment[] getSubpackages(IPackageFragment iPackageFragment) throws CoreException {
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        if (iPackageFragment.isDefaultPackage()) {
            return new IPackageFragment[0];
        }
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        String string = String.valueOf(iPackageFragment.getElementName()) + '.';
        int n = 0;
        while (n < iJavaElementArray.length) {
            IPackageFragment iPackageFragment2 = (IPackageFragment)iJavaElementArray[n];
            if (iPackageFragment2.getElementName().startsWith(string)) {
                arrayList.add(iPackageFragment2);
            }
            ++n;
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    private IFolder computeTargetFolder(IPackageFragment iPackageFragment, RenameArguments renameArguments, IPackageFragment iPackageFragment2) {
        IPath iPath = iPackageFragment2.getParent().getPath();
        iPath = iPath.append(this.getNewPackageName(iPackageFragment, renameArguments.getNewName(), iPackageFragment2.getElementName()).replace('.', '/'));
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
        return iFolder;
    }

    private String getNewPackageName(IPackageFragment iPackageFragment, String string, String string2) {
        String string3 = iPackageFragment.getElementName();
        return String.valueOf(string) + string2.substring(string3.length());
    }
}

