/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;

public class DeleteModifications
extends RefactoringModifications {
    private List fDelete = new ArrayList();
    private List fPackagesToDelete = new ArrayList();

    public void delete(IResource iResource) {
        this.getResourceModifications().addDelete(iResource);
    }

    public void delete(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            this.delete(iResourceArray[n]);
            ++n;
        }
    }

    public void delete(IJavaElement[] iJavaElementArray) throws CoreException {
        int n = 0;
        while (n < iJavaElementArray.length) {
            this.delete(iJavaElementArray[n]);
            ++n;
        }
    }

    public void delete(IJavaElement iJavaElement) throws CoreException {
        switch (iJavaElement.getElementType()) {
            case 1: {
                return;
            }
            case 2: {
                this.fDelete.add(iJavaElement);
                if (iJavaElement.getResource() != null) {
                    this.getResourceModifications().addDelete(iJavaElement.getResource());
                }
                return;
            }
            case 3: {
                this.fDelete.add(iJavaElement);
                IResource iResource = iJavaElement.getResource();
                if (iResource != null) {
                    this.getResourceModifications().addDelete(iResource);
                }
                IJavaProject[] iJavaProjectArray = JavaElementUtil.getReferencingProjects((IPackageFragmentRoot)iJavaElement);
                int n = 0;
                while (n < iJavaProjectArray.length) {
                    IFile iFile = iJavaProjectArray[n].getProject().getFile(".jsdtscope");
                    this.getResourceModifications().addChanged(iFile);
                    ++n;
                }
                return;
            }
            case 4: {
                this.fDelete.add(iJavaElement);
                this.fPackagesToDelete.add(iJavaElement);
                return;
            }
            case 5: {
                this.fDelete.add(iJavaElement);
                IType[] iTypeArray = ((ICompilationUnit)iJavaElement).getTypes();
                this.fDelete.addAll(Arrays.asList(iTypeArray));
                if (iJavaElement.getResource() != null) {
                    this.getResourceModifications().addDelete(iJavaElement.getResource());
                }
                return;
            }
        }
        this.fDelete.add(iJavaElement);
    }

    public List postProcess() throws CoreException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fPackagesToDelete.iterator();
        while (iterator.hasNext()) {
            IPackageFragment iPackageFragment = (IPackageFragment)iterator.next();
            this.handlePackageFragmentDelete(iPackageFragment, arrayList);
        }
        return arrayList;
    }

    public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
        this.getResourceModifications().buildDelta(iResourceChangeDescriptionFactory);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, RefactoringProcessor refactoringProcessor, String[] stringArray, SharableParticipants sharableParticipants) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.fDelete.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, iterator.next(), (DeleteArguments)new DeleteArguments(), (String[])stringArray, (SharableParticipants)sharableParticipants)));
        }
        arrayList.addAll(Arrays.asList(this.getResourceModifications().getParticipants(refactoringStatus, refactoringProcessor, stringArray, sharableParticipants)));
        return arrayList.toArray(new RefactoringParticipant[arrayList.size()]);
    }

    private void handlePackageFragmentDelete(IPackageFragment iPackageFragment, ArrayList arrayList) throws CoreException {
        block11: {
            IResource[] iResourceArray;
            block10: {
                IContainer iContainer = (IContainer)iPackageFragment.getResource();
                if (iContainer == null) {
                    return;
                }
                iResourceArray = iContainer.members();
                if (iPackageFragment.isDefaultPackage() || !this.canRemoveCompletely(iPackageFragment)) break block10;
                boolean bl = false;
                IPackageFragment iPackageFragment2 = JavaElementUtil.getParentSubpackage(iPackageFragment);
                bl = iPackageFragment2 == null ? false : this.fPackagesToDelete.contains(iPackageFragment2);
                if (bl) {
                    if (!this.canRemoveCompletely(iPackageFragment2)) {
                        arrayList.add(iContainer);
                        this.getResourceModifications().addDelete((IResource)iContainer);
                    }
                } else {
                    arrayList.add(iContainer);
                    this.getResourceModifications().addDelete((IResource)iContainer);
                }
                break block11;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                block13: {
                    IFile iFile;
                    IResource iResource;
                    block12: {
                        iResource = iResourceArray[n];
                        if (!(iResource instanceof IFile)) break block12;
                        iFile = (IFile)iResource;
                        if ("class".equals(iFile.getFileExtension()) && iFile.isDerived() || iPackageFragment.isDefaultPackage() && !JavaCore.isJavaLikeFileName((String)iFile.getName())) break block13;
                        arrayList.add(iResource);
                        this.getResourceModifications().addDelete(iResource);
                    }
                    if (!iPackageFragment.isDefaultPackage() && iResource instanceof IFolder && (iFile = (IPackageFragment)JavaCore.create((IResource)iResource)) == null) {
                        arrayList.add(iResource);
                        this.getResourceModifications().addDelete(iResource);
                    }
                }
                ++n;
            }
        }
    }

    private boolean canRemoveCompletely(IPackageFragment iPackageFragment) throws JavaModelException {
        IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(iPackageFragment);
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            if (!iPackageFragmentArray[n].equals(iPackageFragment) && !this.fPackagesToDelete.contains(iPackageFragmentArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

