/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.LoggedCreateTargetChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.LoggedCreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MonitoringCreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public final class JavaMoveProcessor
extends MoveProcessor
implements IScriptableRefactoring,
ICommentProvider,
IQualifiedNameUpdating,
IReorgDestinationValidator {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.MoveProcessor";
    private String fComment;
    private ICreateTargetQueries fCreateTargetQueries;
    private IReorgPolicy.IMovePolicy fMovePolicy;
    private IReorgQueries fReorgQueries;
    private boolean fWasCanceled;

    public JavaMoveProcessor(IReorgPolicy.IMovePolicy iMovePolicy) {
        this.fMovePolicy = iMovePolicy;
    }

    public boolean canChildrenBeDestinations(IJavaElement iJavaElement) {
        return this.fMovePolicy.canChildrenBeDestinations(iJavaElement);
    }

    public boolean canChildrenBeDestinations(IResource iResource) {
        return this.fMovePolicy.canChildrenBeDestinations(iResource);
    }

    public boolean canElementBeDestination(IJavaElement iJavaElement) {
        return this.fMovePolicy.canElementBeDestination(iJavaElement);
    }

    public boolean canElementBeDestination(IResource iResource) {
        return this.fMovePolicy.canElementBeDestination(iResource);
    }

    public boolean canEnableComment() {
        return true;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return this.fMovePolicy.canEnableQualifiedNameUpdating();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public boolean canUpdateReferences() {
        return this.fMovePolicy.canUpdateReferences();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        try {
            Assert.isNotNull((Object)this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkFinalConditions(iProgressMonitor, checkConditionsContext, this.fReorgQueries);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fWasCanceled = true;
            throw operationCanceledException;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        iProgressMonitor.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus2 = new RefactoringStatus();
            refactoringStatus2.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] iResourceArray = ReorgUtils.getResources(this.fMovePolicy.getJavaElements());
            refactoringStatus2.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(iResourceArray))));
            refactoringStatus = refactoringStatus2;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        Assert.isTrue((this.fMovePolicy.getJavaElementDestination() == null || this.fMovePolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            Change change;
            ICreateTargetQueries iCreateTargetQueries;
            DynamicValidationStateChange dynamicValidationStateChange2 = new DynamicValidationStateChange(RefactoringCoreMessages.JavaMoveProcessor_change_name){

                public ChangeDescriptor getDescriptor() {
                    return JavaMoveProcessor.this.fMovePolicy.getDescriptor();
                }

                public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
                    Change change = super.perform(iProgressMonitor);
                    Change[] changeArray = this.getChildren();
                    int n = 0;
                    while (n < changeArray.length) {
                        if (!(changeArray[n] instanceof TextEditBasedChange)) {
                            return null;
                        }
                        ++n;
                    }
                    return change;
                }
            };
            CreateTargetExecutionLog createTargetExecutionLog = null;
            if (this.fCreateTargetQueries instanceof MonitoringCreateTargetQueries && (iCreateTargetQueries = (change = (Change)this.fCreateTargetQueries).getDelegate()) instanceof LoggedCreateTargetQueries) {
                createTargetExecutionLog = change.getCreateTargetExecutionLog();
            }
            if (createTargetExecutionLog != null) {
                change = createTargetExecutionLog.getSelectedElements();
                int n = 0;
                while (n < ((Change)change).length) {
                    dynamicValidationStateChange2.add(new LoggedCreateTargetChange(change[n], this.fCreateTargetQueries));
                    ++n;
                }
            }
            if ((change = this.fMovePolicy.createChange(iProgressMonitor)) instanceof CompositeChange) {
                iCreateTargetQueries = (CompositeChange)change;
                dynamicValidationStateChange2.merge((CompositeChange)iCreateTargetQueries);
            } else {
                dynamicValidationStateChange2.add(change);
            }
            dynamicValidationStateChange = dynamicValidationStateChange2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationStateChange;
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] stringArray = JavaProcessors.computeAffectedNaturs(this.fMovePolicy.getJavaElements());
        String[] stringArray2 = ResourceProcessors.computeAffectedNatures(this.fMovePolicy.getResources());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        hashSet.addAll(Arrays.asList(stringArray2));
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String getComment() {
        return this.fComment;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getJavaElements()).getCommonParent();
    }

    public ICreateTargetQuery getCreateTargetQuery() {
        return this.fMovePolicy.getCreateTargetQuery(this.fCreateTargetQueries);
    }

    protected Object getDestination() {
        IJavaElement iJavaElement = this.fMovePolicy.getJavaElementDestination();
        if (iJavaElement != null) {
            return iJavaElement;
        }
        return this.fMovePolicy.getResourceDestination();
    }

    public Object[] getElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(this.fMovePolicy.getJavaElements()));
        arrayList.addAll(Arrays.asList(this.fMovePolicy.getResources()));
        return arrayList.toArray();
    }

    public String getFilePatterns() {
        return this.fMovePolicy.getFilePatterns();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public IJavaElement[] getJavaElements() {
        return this.fMovePolicy.getJavaElements();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveRefactoring_0;
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fMovePolicy.getUpdateQualifiedNames();
    }

    public boolean getUpdateReferences() {
        if (!this.canUpdateReferences()) {
            return false;
        }
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        this.setReorgQueries(new NullReorgQueries());
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            this.fMovePolicy = ReorgPolicyFactory.createMovePolicy(refactoringStatus, refactoringArguments);
            if (this.fMovePolicy != null && !refactoringStatus.hasFatalError()) {
                CreateTargetExecutionLog createTargetExecutionLog = ReorgPolicyFactory.loadCreateTargetExecutionLog(refactoringStatus, javaRefactoringArguments);
                if (createTargetExecutionLog != null && !refactoringStatus.hasFatalError()) {
                    this.fMovePolicy.setDestinationCheck(false);
                    this.fCreateTargetQueries = new MonitoringCreateTargetQueries(new LoggedCreateTargetQueries(createTargetExecutionLog), createTargetExecutionLog);
                }
                refactoringStatus.merge(this.fMovePolicy.initialize(refactoringArguments));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return refactoringStatus;
    }

    public boolean isApplicable() throws CoreException {
        return this.fMovePolicy.canEnable();
    }

    public boolean isTextualMove() {
        return this.fMovePolicy.isTextualMove();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, SharableParticipants sharableParticipants) throws CoreException {
        return this.fMovePolicy.loadParticipants(refactoringStatus, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharableParticipants);
    }

    public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.fMovePolicy.postCreateChange(changeArray, iProgressMonitor);
    }

    public void setComment(String string) {
        this.fComment = string;
    }

    public void setCreateTargetQueries(ICreateTargetQueries iCreateTargetQueries) {
        Assert.isNotNull((Object)iCreateTargetQueries);
        this.fCreateTargetQueries = new MonitoringCreateTargetQueries(iCreateTargetQueries, this.fMovePolicy.getCreateTargetExecutionLog());
    }

    public RefactoringStatus setDestination(IJavaElement iJavaElement) throws JavaModelException {
        return this.fMovePolicy.setDestination(iJavaElement);
    }

    public RefactoringStatus setDestination(IResource iResource) throws JavaModelException {
        return this.fMovePolicy.setDestination(iResource);
    }

    public void setFilePatterns(String string) {
        this.fMovePolicy.setFilePatterns(string);
    }

    public void setReorgQueries(IReorgQueries iReorgQueries) {
        Assert.isNotNull((Object)iReorgQueries);
        this.fReorgQueries = iReorgQueries;
    }

    public void setUpdateQualifiedNames(boolean bl) {
        this.fMovePolicy.setUpdateQualifiedNames(bl);
    }

    public void setUpdateReferences(boolean bl) {
        this.fMovePolicy.setUpdateReferences(bl);
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }
}

