/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class ReorgUtils {
    private static final ISourceRange fgUnknownRange = new SourceRange(-1, 0);

    private ReorgUtils() {
    }

    public static boolean isArchiveMember(IJavaElement[] iJavaElementArray) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
            if (iPackageFragmentRoot != null && iPackageFragmentRoot.isArchive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean containsOnlyProjects(List list) {
        if (list.isEmpty()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (ReorgUtils.isProject(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object object) {
        return object instanceof IJavaProject || object instanceof IProject;
    }

    public static boolean isInsideCompilationUnit(IJavaElement iJavaElement) {
        return !(iJavaElement instanceof ICompilationUnit) && ReorgUtils.hasAncestorOfType(iJavaElement, 5);
    }

    public static boolean isInsideClassFile(IJavaElement iJavaElement) {
        return !(iJavaElement instanceof IClassFile) && ReorgUtils.hasAncestorOfType(iJavaElement, 6);
    }

    public static boolean hasAncestorOfType(IJavaElement iJavaElement, int n) {
        return iJavaElement.getAncestor(n) != null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement iJavaElement) {
        if (iJavaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)iJavaElement;
        }
        return (ICompilationUnit)iJavaElement.getAncestor(5);
    }

    public static ICompilationUnit[] getCompilationUnits(IJavaElement[] iJavaElementArray) {
        ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[iJavaElementArray.length];
        int n = 0;
        while (n < iJavaElementArray.length) {
            iCompilationUnitArray[n] = ReorgUtils.getCompilationUnit(iJavaElementArray[n]);
            ++n;
        }
        return iCompilationUnitArray;
    }

    public static IResource getResource(IJavaElement iJavaElement) {
        if (iJavaElement instanceof ICompilationUnit) {
            return ((ICompilationUnit)iJavaElement).getPrimary().getResource();
        }
        return iJavaElement.getResource();
    }

    public static IResource[] getResources(IJavaElement[] iJavaElementArray) {
        IResource[] iResourceArray = new IResource[iJavaElementArray.length];
        int n = 0;
        while (n < iJavaElementArray.length) {
            iResourceArray[n] = ReorgUtils.getResource(iJavaElementArray[n]);
            ++n;
        }
        return iResourceArray;
    }

    public static String getName(IResource iResource) {
        String string = ReorgUtils.createNamePattern(iResource);
        Object[] objectArray = ReorgUtils.createNameArguments(iResource);
        return Messages.format(string, objectArray);
    }

    private static String createNamePattern(IResource iResource) {
        switch (iResource.getType()) {
            case 1: {
                return RefactoringCoreMessages.ReorgUtils_0;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_1;
            }
            case 4: {
                return RefactoringCoreMessages.ReorgUtils_2;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String[] createNameArguments(IResource iResource) {
        return new String[]{iResource.getName()};
    }

    public static String getName(IJavaElement iJavaElement) throws JavaModelException {
        String string = ReorgUtils.createNamePattern(iJavaElement);
        Object[] objectArray = ReorgUtils.createNameArguments(iJavaElement);
        return Messages.format(string, objectArray);
    }

    private static String[] createNameArguments(IJavaElement iJavaElement) throws JavaModelException {
        switch (iJavaElement.getElementType()) {
            case 6: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 5: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 8: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 12: {
                return new String[0];
            }
            case 13: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 10: {
                return new String[0];
            }
            case 2: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 9: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 11: {
                if (JavaElementUtil.isDefaultPackage(iJavaElement)) {
                    return new String[0];
                }
                return new String[]{iJavaElement.getElementName()};
            }
            case 4: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 3: {
                return new String[]{iJavaElement.getElementName()};
            }
            case 7: {
                IType iType = (IType)iJavaElement;
                String string = iType.getElementName();
                if (string.length() == 0 && iType.isAnonymous()) {
                    String string2 = Signature.getSimpleName((String)iType.getSuperclassName());
                    return new String[]{Messages.format(RefactoringCoreMessages.ReorgUtils_19, string2)};
                }
                return new String[]{iJavaElement.getElementName()};
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String createNamePattern(IJavaElement iJavaElement) throws JavaModelException {
        switch (iJavaElement.getElementType()) {
            case 6: {
                return RefactoringCoreMessages.ReorgUtils_3;
            }
            case 5: {
                return RefactoringCoreMessages.ReorgUtils_4;
            }
            case 8: {
                return RefactoringCoreMessages.ReorgUtils_5;
            }
            case 12: {
                return RefactoringCoreMessages.ReorgUtils_6;
            }
            case 13: {
                return RefactoringCoreMessages.ReorgUtils_7;
            }
            case 10: {
                return RefactoringCoreMessages.ReorgUtils_8;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_9;
            }
            case 9: {
                if (((IMethod)iJavaElement).isConstructor()) {
                    return RefactoringCoreMessages.ReorgUtils_10;
                }
                return RefactoringCoreMessages.ReorgUtils_11;
            }
            case 11: {
                return RefactoringCoreMessages.ReorgUtils_12;
            }
            case 4: {
                if (JavaElementUtil.isDefaultPackage(iJavaElement)) {
                    return RefactoringCoreMessages.ReorgUtils_13;
                }
                return RefactoringCoreMessages.ReorgUtils_14;
            }
            case 3: {
                if (ReorgUtils.isSourceFolder(iJavaElement)) {
                    return RefactoringCoreMessages.ReorgUtils_15;
                }
                if (ReorgUtils.isClassFolder(iJavaElement)) {
                    return RefactoringCoreMessages.ReorgUtils_16;
                }
                return RefactoringCoreMessages.ReorgUtils_17;
            }
            case 7: {
                IType iType = (IType)iJavaElement;
                if (iType.getElementName().length() == 0 && iType.isAnonymous()) {
                    return RefactoringCoreMessages.ReorgUtils_20;
                }
                return RefactoringCoreMessages.ReorgUtils_18;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IResource[] getResources(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IResource)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static IJavaElement[] getJavaElements(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IJavaElement)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    public static IWorkingSet[] getWorkingSets(List list) {
        ArrayList arrayList = new ArrayList(1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IWorkingSet)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    public static boolean hasSourceAvailable(IMember iMember) throws JavaModelException {
        return !iMember.isBinary() || iMember.getSourceRange() != null && !fgUnknownRange.equals(iMember.getSourceRange());
    }

    public static IResource[] setMinus(IResource[] iResourceArray, IResource[] iResourceArray2) {
        HashSet<IResource> hashSet = new HashSet<IResource>(iResourceArray.length - iResourceArray.length);
        hashSet.addAll(Arrays.asList(iResourceArray));
        hashSet.removeAll(Arrays.asList(iResourceArray2));
        return hashSet.toArray(new IResource[hashSet.size()]);
    }

    public static IJavaElement[] setMinus(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2) {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(iJavaElementArray.length - iJavaElementArray.length);
        hashSet.addAll(Arrays.asList(iJavaElementArray));
        hashSet.removeAll(Arrays.asList(iJavaElementArray2));
        return hashSet.toArray(new IJavaElement[hashSet.size()]);
    }

    public static IJavaElement[] union(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2) {
        ArrayList arrayList = new ArrayList(iJavaElementArray.length + iJavaElementArray2.length);
        ReorgUtils.addAll(iJavaElementArray, arrayList);
        ReorgUtils.addAll(iJavaElementArray2, arrayList);
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    public static IResource[] union(IResource[] iResourceArray, IResource[] iResourceArray2) {
        ArrayList arrayList = new ArrayList(iResourceArray.length + iResourceArray2.length);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(iResourceArray), arrayList);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(iResourceArray2), arrayList);
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private static void addAll(Object[] objectArray, List list) {
        int n = 0;
        while (n < objectArray.length) {
            if (!list.contains(objectArray[n])) {
                list.add(objectArray[n]);
            }
            ++n;
        }
    }

    public static Set union(Set set, Set set2) {
        HashSet hashSet = new HashSet(set.size() + set2.size());
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    public static IType[] getMainTypes(IJavaElement[] iJavaElementArray) throws JavaModelException {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (iJavaElement instanceof IType && JavaElementUtil.isMainType((IType)iJavaElement)) {
                arrayList.add(iJavaElement);
            }
            ++n;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    public static IFolder[] getFolders(IResource[] iResourceArray) {
        Set set = ReorgUtils.getResourcesOfType(iResourceArray, 2);
        return set.toArray(new IFolder[set.size()]);
    }

    public static IFile[] getFiles(IResource[] iResourceArray) {
        Set set = ReorgUtils.getResourcesOfType(iResourceArray, 1);
        return set.toArray(new IFile[set.size()]);
    }

    public static Set getResourcesOfType(IResource[] iResourceArray, int n) {
        HashSet<IResource> hashSet = new HashSet<IResource>(iResourceArray.length);
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            if (ReorgUtils.isOfType(iResourceArray[n2], n)) {
                hashSet.add(iResourceArray[n2]);
            }
            ++n2;
        }
        return hashSet;
    }

    public static List getElementsOfType(IJavaElement[] iJavaElementArray, int n) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(iJavaElementArray.length);
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            if (ReorgUtils.isOfType(iJavaElementArray[n2], n)) {
                arrayList.add(iJavaElementArray[n2]);
            }
            ++n2;
        }
        return arrayList;
    }

    public static boolean hasElementsNotOfType(IResource[] iResourceArray, int n) {
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            IResource iResource = iResourceArray[n2];
            if (iResource != null && !ReorgUtils.isOfType(iResource, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IJavaElement[] iJavaElementArray, int n) {
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (iJavaElement != null && !ReorgUtils.isOfType(iJavaElement, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] iJavaElementArray, int n) {
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (iJavaElement != null && ReorgUtils.isOfType(iJavaElement, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] iJavaElementArray, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (ReorgUtils.hasElementsOfType(iJavaElementArray, nArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean hasElementsOfType(IResource[] iResourceArray, int n) {
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            IResource iResource = iResourceArray[n2];
            if (iResource != null && ReorgUtils.isOfType(iResource, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isOfType(IJavaElement iJavaElement, int n) {
        return iJavaElement.getElementType() == n;
    }

    private static boolean isOfType(IResource iResource, int n) {
        return iResource != null && ReorgUtils.isFlagSet(iResource.getType(), n);
    }

    private static boolean isFlagSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean isSourceFolder(IJavaElement iJavaElement) throws JavaModelException {
        return iJavaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)iJavaElement).getKind() == 1;
    }

    public static boolean isClassFolder(IJavaElement iJavaElement) throws JavaModelException {
        return iJavaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)iJavaElement).getKind() == 2;
    }

    public static boolean isPackageFragmentRoot(IJavaProject iJavaProject) throws JavaModelException {
        return ReorgUtils.getCorrespondingPackageFragmentRoot(iJavaProject) != null;
    }

    private static boolean isPackageFragmentRootCorrespondingToProject(IPackageFragmentRoot iPackageFragmentRoot) {
        return iPackageFragmentRoot.getResource() instanceof IProject;
    }

    public static IPackageFragmentRoot getCorrespondingPackageFragmentRoot(IJavaProject iJavaProject) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            if (ReorgUtils.isPackageFragmentRootCorrespondingToProject(iPackageFragmentRootArray[n])) {
                return iPackageFragmentRootArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean containsLinkedResources(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] != null && iResourceArray[n].isLinked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean containsLinkedResources(IJavaElement[] iJavaElementArray) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            IResource iResource = ReorgUtils.getResource(iJavaElementArray[n]);
            if (iResource != null && iResource.isLinked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean canBeDestinationForLinkedResources(IResource iResource) {
        return iResource.isAccessible() && iResource instanceof IProject;
    }

    public static boolean canBeDestinationForLinkedResources(IJavaElement iJavaElement) {
        if (iJavaElement instanceof IPackageFragmentRoot) {
            return ReorgUtils.isPackageFragmentRootCorrespondingToProject((IPackageFragmentRoot)iJavaElement);
        }
        return iJavaElement instanceof IJavaProject;
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragment iPackageFragment, IPackageFragmentRoot iPackageFragmentRoot) {
        if (iPackageFragment == null) {
            return false;
        }
        IJavaElement iJavaElement = iPackageFragment.getParent();
        if (iJavaElement == null) {
            return false;
        }
        if (iJavaElement.equals(iPackageFragmentRoot)) {
            return true;
        }
        IResource iResource = ResourceUtil.getResource(iPackageFragment);
        IResource iResource2 = ResourceUtil.getResource(iPackageFragmentRoot);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(iResource, iResource2);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragmentRoot iPackageFragmentRoot, IJavaProject iJavaProject) {
        if (iPackageFragmentRoot == null) {
            return false;
        }
        IJavaElement iJavaElement = iPackageFragmentRoot.getParent();
        if (iJavaElement == null) {
            return false;
        }
        if (iJavaElement.equals(iPackageFragmentRoot)) {
            return true;
        }
        IResource iResource = ResourceUtil.getResource(iPackageFragmentRoot);
        IResource iResource2 = ResourceUtil.getResource(iJavaProject);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(iResource, iResource2);
    }

    public static boolean isParentInWorkspaceOrOnDisk(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
        if (iCompilationUnit == null) {
            return false;
        }
        IJavaElement iJavaElement = iCompilationUnit.getParent();
        if (iJavaElement == null) {
            return false;
        }
        if (iJavaElement.equals(iPackageFragment)) {
            return true;
        }
        IResource iResource = iCompilationUnit.getResource();
        IResource iResource2 = ResourceUtil.getResource(iPackageFragment);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(iResource, iResource2);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource iResource, IResource iResource2) {
        if (iResource == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)iResource.getParent(), iResource2);
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource iResource, IResource iResource2) {
        if (iResource == null || iResource2 == null) {
            return false;
        }
        if (iResource.equals((Object)iResource2)) {
            return true;
        }
        URI uRI = iResource.getLocationURI();
        URI uRI2 = iResource2.getLocationURI();
        if (uRI == null || uRI2 == null) {
            return false;
        }
        return uRI.equals(uRI2);
    }

    public static IResource[] getNotNulls(IResource[] iResourceArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource != null && !arrayList.contains(iResource)) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static IResource[] getNotLinked(IResource[] iResourceArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource != null && !arrayList.contains(iResource) && !iResource.isLinked()) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static Map groupByCompilationUnit(List list) {
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            ICompilationUnit iCompilationUnit = ReorgUtils.getCompilationUnit(iJavaElement);
            if (iCompilationUnit == null) continue;
            if (!hashMap.containsKey(iCompilationUnit)) {
                hashMap.put(iCompilationUnit, new ArrayList(1));
            }
            ((List)hashMap.get(iCompilationUnit)).add(iJavaElement);
        }
        return hashMap;
    }

    public static void splitIntoJavaElementsAndResources(Object[] objectArray, List list, List list2) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IJavaElement) {
                list.add(object);
            } else if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                if (iJavaElement != null && iJavaElement.exists()) {
                    list.add(iJavaElement);
                } else {
                    list2.add(iResource);
                }
            }
            ++n;
        }
    }

    public static boolean containsElementOrParent(Set set, IJavaElement iJavaElement) {
        IJavaElement iJavaElement2 = iJavaElement;
        do {
            if (!set.contains(iJavaElement2)) continue;
            return true;
        } while ((iJavaElement2 = iJavaElement2.getParent()) != null);
        return false;
    }

    public static boolean containsElementOrParent(Set set, IResource iResource) {
        IResource iResource2 = iResource;
        do {
            if (set.contains(iResource2)) {
                return true;
            }
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource2);
            if (iJavaElement == null || !iJavaElement.exists()) continue;
            return ReorgUtils.containsElementOrParent(set, iJavaElement);
        } while ((iResource2 = iResource2.getParent()) != null);
        return false;
    }
}

