/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;

public class SourceReferenceUtil {
    private SourceReferenceUtil() {
    }

    public static IFile getFile(ISourceReference iSourceReference) {
        ICompilationUnit iCompilationUnit = SourceReferenceUtil.getCompilationUnit(iSourceReference);
        return (IFile)iCompilationUnit.getPrimary().getResource();
    }

    public static ICompilationUnit getCompilationUnit(ISourceReference iSourceReference) {
        Assert.isTrue((!(iSourceReference instanceof IClassFile) ? 1 : 0) != 0);
        if (iSourceReference instanceof ICompilationUnit) {
            return (ICompilationUnit)iSourceReference;
        }
        if (iSourceReference instanceof IJavaElement) {
            return (ICompilationUnit)((IJavaElement)iSourceReference).getAncestor(5);
        }
        return null;
    }

    private static boolean hasParentInSet(IJavaElement iJavaElement, Set set) {
        IJavaElement iJavaElement2 = iJavaElement.getParent();
        while (iJavaElement2 != null) {
            if (set.contains(iJavaElement2)) {
                return true;
            }
            iJavaElement2 = iJavaElement2.getParent();
        }
        return false;
    }

    public static ISourceReference[] removeAllWithParentsSelected(ISourceReference[] iSourceReferenceArray) {
        HashSet<ISourceReference> hashSet = new HashSet<ISourceReference>(Arrays.asList(iSourceReferenceArray));
        ArrayList<ISourceReference> arrayList = new ArrayList<ISourceReference>(iSourceReferenceArray.length);
        int n = 0;
        while (n < iSourceReferenceArray.length) {
            ISourceReference iSourceReference = iSourceReferenceArray[n];
            if (!(iSourceReference instanceof IJavaElement)) {
                arrayList.add(iSourceReference);
            } else if (!SourceReferenceUtil.hasParentInSet((IJavaElement)iSourceReference, hashSet)) {
                arrayList.add(iSourceReference);
            }
            ++n;
        }
        return arrayList.toArray(new ISourceReference[arrayList.size()]);
    }

    public static Map groupByFile(ISourceReference[] iSourceReferenceArray) {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < iSourceReferenceArray.length) {
            ISourceReference iSourceReference = iSourceReferenceArray[n];
            IFile iFile = SourceReferenceUtil.getFile(iSourceReference);
            if (!hashMap.containsKey(iFile)) {
                hashMap.put(iFile, new ArrayList());
            }
            ((List)hashMap.get(iFile)).add(iSourceReference);
            ++n;
        }
        return hashMap;
    }

    public static ISourceReference[] sortByOffset(ISourceReference[] iSourceReferenceArray) {
        Arrays.sort(iSourceReferenceArray, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    return ((ISourceReference)object2).getSourceRange().getOffset() - ((ISourceReference)object).getSourceRange().getOffset();
                }
                catch (JavaModelException javaModelException) {
                    return object2.hashCode() - object.hashCode();
                }
            }
        });
        return iSourceReferenceArray;
    }
}

