/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;

public class ImportRemover {
    private Set fAddedImports = new HashSet();
    private Set fAddedStaticImports = new HashSet();
    private final IJavaProject fProject;
    private List fRemovedNodes = new ArrayList();
    private final CompilationUnit fRoot;

    public ImportRemover(IJavaProject iJavaProject, CompilationUnit compilationUnit) {
        this.fProject = iJavaProject;
        this.fRoot = compilationUnit;
    }

    private void divideTypeRefs(List list, List list2, List list3, List list4) {
        ASTNode aSTNode;
        int[] nArray = new int[2 * this.fRemovedNodes.size()];
        int n = 0;
        while (n < this.fRemovedNodes.size()) {
            int n2;
            aSTNode = (ASTNode)this.fRemovedNodes.get(n);
            nArray[2 * n] = n2 = aSTNode.getStartPosition();
            nArray[2 * n + 1] = n2 + aSTNode.getLength();
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSTNode = (SimpleName)iterator.next();
            if (this.isInRemoved((SimpleName)aSTNode, nArray)) {
                list3.add(aSTNode);
                continue;
            }
            list4.add(aSTNode);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            aSTNode = (SimpleName)iterator.next();
            if (this.isInRemoved((SimpleName)aSTNode, nArray)) {
                list3.add(aSTNode);
                continue;
            }
            list4.add(aSTNode);
        }
    }

    public IBinding[] getImportsToRemove() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.fRoot.accept((ASTVisitor)new ImportReferencesCollector(this.fProject, null, arrayList, arrayList2));
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        this.divideTypeRefs(arrayList, arrayList2, arrayList3, arrayList4);
        if (arrayList3.size() == 0) {
            return new IBinding[0];
        }
        HashMap hashMap = this.getPotentialRemoves(arrayList3);
        Object object = arrayList4.iterator();
        while (object.hasNext()) {
            SimpleName simpleName = (SimpleName)object.next();
            hashMap.remove(simpleName.getIdentifier());
        }
        object = hashMap.values();
        return object.toArray(new IBinding[object.size()]);
    }

    private HashMap getPotentialRemoves(List list) {
        HashMap<String, IBinding> hashMap = new HashMap<String, IBinding>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IBinding iBinding;
            SimpleName simpleName = (SimpleName)iterator.next();
            if (this.fAddedImports.contains(simpleName.getIdentifier()) || this.hasAddedStaticImport(simpleName) || (iBinding = simpleName.resolveBinding()) == null) continue;
            hashMap.put(simpleName.getIdentifier(), iBinding);
        }
        return hashMap;
    }

    private boolean hasAddedStaticImport(SimpleName simpleName) {
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            return this.hasAddedStaticImport(iVariableBinding.getDeclaringClass().getQualifiedName(), iVariableBinding.getName(), true);
        }
        if (iBinding instanceof IMethodBinding) {
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            return this.hasAddedStaticImport(iMethodBinding.getDeclaringClass().getQualifiedName(), iMethodBinding.getName(), false);
        }
        return false;
    }

    private boolean hasAddedStaticImport(String string, String string2, boolean bl) {
        StaticImportData staticImportData = null;
        Iterator iterator = this.fAddedStaticImports.iterator();
        while (iterator.hasNext()) {
            staticImportData = (StaticImportData)iterator.next();
            if (!staticImportData.fQualifier.equals(string) || !staticImportData.fMember.equals(string2) || staticImportData.fField != bl) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemovedNodes() {
        return this.fRemovedNodes.size() != 0;
    }

    private boolean isInRemoved(SimpleName simpleName, int[] nArray) {
        int n = simpleName.getStartPosition();
        int n2 = n + simpleName.getLength();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n >= nArray[n3] && n2 <= nArray[n3 + 1]) {
                return true;
            }
            n3 += 2;
        }
        return false;
    }

    public void registerAddedImport(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            this.fAddedImports.add(string);
        } else {
            this.fAddedImports.add(string.substring(n + 1));
        }
    }

    public void registerAddedImports(Type type) {
        type.accept(new ASTVisitor(true){

            private void addName(SimpleName simpleName) {
                ImportRemover.this.fAddedImports.add(simpleName.getIdentifier());
            }

            public boolean visit(QualifiedName qualifiedName) {
                this.addName(qualifiedName.getName());
                return false;
            }

            public boolean visit(QualifiedType qualifiedType) {
                this.addName(qualifiedType.getName());
                return false;
            }

            public boolean visit(SimpleName simpleName) {
                this.addName(simpleName);
                return false;
            }
        });
    }

    public void registerAddedStaticImport(String string, String string2, boolean bl) {
        this.fAddedStaticImports.add(new StaticImportData(string, string2, bl));
    }

    public void registerAddedStaticImport(IBinding iBinding) {
        if (iBinding instanceof IVariableBinding) {
            ITypeBinding iTypeBinding = ((IVariableBinding)iBinding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(iTypeBinding), iBinding.getName(), true));
        } else if (iBinding instanceof IMethodBinding) {
            ITypeBinding iTypeBinding = ((IMethodBinding)iBinding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(iTypeBinding), iBinding.getName(), false));
        } else {
            throw new IllegalArgumentException(iBinding.toString());
        }
    }

    public void registerRemovedNode(ASTNode aSTNode) {
        this.fRemovedNodes.add(aSTNode);
    }

    public void applyRemoves(ImportRewrite importRewrite) {
        IBinding[] iBindingArray = this.getImportsToRemove();
        int n = 0;
        while (n < iBindingArray.length) {
            ITypeBinding iTypeBinding;
            if (iBindingArray[n] instanceof ITypeBinding) {
                iTypeBinding = (ITypeBinding)iBindingArray[n];
                importRewrite.removeImport(iTypeBinding.getTypeDeclaration().getQualifiedName());
            } else if (iBindingArray[n] instanceof IMethodBinding) {
                iTypeBinding = (IMethodBinding)iBindingArray[n];
                importRewrite.removeStaticImport(String.valueOf(iTypeBinding.getDeclaringClass().getQualifiedName()) + '.' + iTypeBinding.getName());
            } else if (iBindingArray[n] instanceof IVariableBinding) {
                iTypeBinding = (IVariableBinding)iBindingArray[n];
                importRewrite.removeStaticImport(String.valueOf(iTypeBinding.getDeclaringClass().getQualifiedName()) + '.' + iTypeBinding.getName());
            }
            ++n;
        }
    }

    private static class StaticImportData {
        private boolean fField;
        private String fMember;
        private String fQualifier;

        private StaticImportData(String string, String string2, boolean bl) {
            this.fQualifier = string;
            this.fMember = string2;
            this.fField = bl;
        }
    }
}

