/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;

public final class ImportRewriteUtil {
    public static void addImports(CompilationUnitRewrite compilationUnitRewrite, ASTNode aSTNode, Map map, Map map2, boolean bl) {
        ImportRewriteUtil.addImports(compilationUnitRewrite, aSTNode, map, map2, null, bl);
    }

    public static void addImports(CompilationUnitRewrite compilationUnitRewrite, ASTNode aSTNode, Map map, Map map2, Collection collection, final boolean bl) {
        ITypeBinding iTypeBinding;
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)aSTNode);
        Assert.isNotNull((Object)map);
        Assert.isNotNull((Object)map2);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ImportReferencesCollector importReferencesCollector = new ImportReferencesCollector(compilationUnitRewrite.getCu().getJavaProject(), null, hashSet, hashSet2){

            public final boolean visit(Block block) {
                Assert.isNotNull((Object)block);
                if (bl && block.getParent() instanceof MethodDeclaration) {
                    return false;
                }
                return super.visit(block);
            }
        };
        aSTNode.accept((ASTVisitor)importReferencesCollector);
        ImportRewrite importRewrite = compilationUnitRewrite.getImportRewrite();
        ImportRemover importRemover = compilationUnitRewrite.getImportRemover();
        Name name = null;
        IBinding iBinding = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            name = (Name)iterator.next();
            iBinding = name.resolveBinding();
            if (!(iBinding instanceof ITypeBinding)) continue;
            iTypeBinding = (ITypeBinding)iBinding;
            if (collection != null && collection.contains(iTypeBinding)) continue;
            map.put(name, importRewrite.addImport(iTypeBinding));
            importRemover.registerAddedImport(iTypeBinding.getQualifiedName());
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2;
            name = (Name)iterator.next();
            iBinding = name.resolveBinding();
            if (iBinding instanceof IVariableBinding) {
                iTypeBinding = (IVariableBinding)iBinding;
                iTypeBinding2 = iTypeBinding.getDeclaringClass();
                if (iTypeBinding2 == null || collection != null && collection.contains(iTypeBinding)) continue;
                map2.put(name, importRewrite.addStaticImport((IBinding)iTypeBinding));
                importRemover.registerAddedStaticImport(iTypeBinding2.getQualifiedName(), iTypeBinding.getName(), true);
                continue;
            }
            if (!(iBinding instanceof IMethodBinding) || (iTypeBinding2 = (iTypeBinding = (IMethodBinding)iBinding).getDeclaringClass()) == null || collection != null && collection.contains(iTypeBinding)) continue;
            map2.put(name, importRewrite.addStaticImport((IBinding)iTypeBinding));
            importRemover.registerAddedStaticImport(iTypeBinding2.getQualifiedName(), iTypeBinding.getName(), false);
        }
    }

    public static void collectImports(IJavaProject iJavaProject, ASTNode aSTNode, Collection collection, Collection collection2, boolean bl) {
        ImportRewriteUtil.collectImports(iJavaProject, aSTNode, collection, collection2, null, bl);
    }

    public static void collectImports(IJavaProject iJavaProject, ASTNode aSTNode, Collection collection, Collection collection2, Collection collection3, final boolean bl) {
        Assert.isNotNull((Object)iJavaProject);
        Assert.isNotNull((Object)aSTNode);
        Assert.isNotNull((Object)collection);
        Assert.isNotNull((Object)collection2);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ImportReferencesCollector importReferencesCollector = new ImportReferencesCollector(iJavaProject, null, hashSet, hashSet2){

            public final boolean visit(Block block) {
                Assert.isNotNull((Object)block);
                if (bl && block.getParent() instanceof MethodDeclaration) {
                    return false;
                }
                return super.visit(block);
            }
        };
        aSTNode.accept((ASTVisitor)importReferencesCollector);
        Name name = null;
        IBinding iBinding = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            name = (Name)iterator.next();
            iBinding = name.resolveBinding();
            if (!(iBinding instanceof ITypeBinding)) continue;
            ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
            if (collection3 != null && collection3.contains(iTypeBinding)) continue;
            collection.add(iTypeBinding);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            name = (Name)iterator.next();
            iBinding = name.resolveBinding();
            if (iBinding == null || collection3 != null && collection3.contains(iBinding)) continue;
            collection2.add(iBinding);
        }
    }

    private ImportRewriteUtil() {
    }
}

