/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;

public class ReferenceFinderUtil {
    private ReferenceFinderUtil() {
    }

    public static IType[] getTypesReferencedIn(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchMatch[] searchMatchArray = ReferenceFinderUtil.getTypeReferencesIn(iJavaElementArray, null, iProgressMonitor);
        Set set = ReferenceFinderUtil.extractElements(searchMatchArray, 7);
        return set.toArray(new IType[set.size()]);
    }

    public static IType[] getTypesReferencedIn(IJavaElement[] iJavaElementArray, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchMatch[] searchMatchArray = ReferenceFinderUtil.getTypeReferencesIn(iJavaElementArray, workingCopyOwner, iProgressMonitor);
        Set set = ReferenceFinderUtil.extractElements(searchMatchArray, 7);
        return set.toArray(new IType[set.size()]);
    }

    private static SearchMatch[] getTypeReferencesIn(IJavaElement[] iJavaElementArray, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        iProgressMonitor.beginTask("", iJavaElementArray.length);
        int n = 0;
        while (n < iJavaElementArray.length) {
            arrayList.addAll(ReferenceFinderUtil.getTypeReferencesIn(iJavaElementArray[n], workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
            ++n;
        }
        iProgressMonitor.done();
        return arrayList.toArray(new SearchMatch[arrayList.size()]);
    }

    private static List getTypeReferencesIn(IJavaElement iJavaElement, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CollectingSearchRequestor collectingSearchRequestor = new CollectingSearchRequestor();
        SearchEngine searchEngine = workingCopyOwner != null ? new SearchEngine(workingCopyOwner) : new SearchEngine();
        searchEngine.searchDeclarationsOfReferencedTypes(iJavaElement, (SearchRequestor)collectingSearchRequestor, iProgressMonitor);
        return collectingSearchRequestor.getResults();
    }

    public static IField[] getFieldsReferencedIn(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchMatch[] searchMatchArray = ReferenceFinderUtil.getFieldReferencesIn(iJavaElementArray, null, iProgressMonitor);
        Set set = ReferenceFinderUtil.extractElements(searchMatchArray, 8);
        return set.toArray(new IField[set.size()]);
    }

    public static IField[] getFieldsReferencedIn(IJavaElement[] iJavaElementArray, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchMatch[] searchMatchArray = ReferenceFinderUtil.getFieldReferencesIn(iJavaElementArray, workingCopyOwner, iProgressMonitor);
        Set set = ReferenceFinderUtil.extractElements(searchMatchArray, 8);
        return set.toArray(new IField[set.size()]);
    }

    private static SearchMatch[] getFieldReferencesIn(IJavaElement[] iJavaElementArray, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        iProgressMonitor.beginTask("", iJavaElementArray.length);
        int n = 0;
        while (n < iJavaElementArray.length) {
            arrayList.addAll(ReferenceFinderUtil.getFieldReferencesIn(iJavaElementArray[n], workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
            ++n;
        }
        iProgressMonitor.done();
        return arrayList.toArray(new SearchMatch[arrayList.size()]);
    }

    private static List getFieldReferencesIn(IJavaElement iJavaElement, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CollectingSearchRequestor collectingSearchRequestor = new CollectingSearchRequestor();
        SearchEngine searchEngine = workingCopyOwner != null ? new SearchEngine(workingCopyOwner) : new SearchEngine();
        searchEngine.searchDeclarationsOfAccessedFields(iJavaElement, (SearchRequestor)collectingSearchRequestor, iProgressMonitor);
        return collectingSearchRequestor.getResults();
    }

    public static IMethod[] getMethodsReferencedIn(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchMatch[] searchMatchArray = ReferenceFinderUtil.getMethodReferencesIn(iJavaElementArray, null, iProgressMonitor);
        Set set = ReferenceFinderUtil.extractElements(searchMatchArray, 9);
        return set.toArray(new IMethod[set.size()]);
    }

    public static IMethod[] getMethodsReferencedIn(IJavaElement[] iJavaElementArray, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchMatch[] searchMatchArray = ReferenceFinderUtil.getMethodReferencesIn(iJavaElementArray, workingCopyOwner, iProgressMonitor);
        Set set = ReferenceFinderUtil.extractElements(searchMatchArray, 9);
        return set.toArray(new IMethod[set.size()]);
    }

    private static SearchMatch[] getMethodReferencesIn(IJavaElement[] iJavaElementArray, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        iProgressMonitor.beginTask("", iJavaElementArray.length);
        int n = 0;
        while (n < iJavaElementArray.length) {
            arrayList.addAll(ReferenceFinderUtil.getMethodReferencesIn(iJavaElementArray[n], workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
            ++n;
        }
        iProgressMonitor.done();
        return arrayList.toArray(new SearchMatch[arrayList.size()]);
    }

    private static List getMethodReferencesIn(IJavaElement iJavaElement, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CollectingSearchRequestor collectingSearchRequestor = new CollectingSearchRequestor();
        SearchEngine searchEngine = workingCopyOwner != null ? new SearchEngine(workingCopyOwner) : new SearchEngine();
        searchEngine.searchDeclarationsOfSentMessages(iJavaElement, (SearchRequestor)collectingSearchRequestor, iProgressMonitor);
        return collectingSearchRequestor.getResults();
    }

    public static ITypeBinding[] getTypesReferencedInDeclarations(MethodDeclaration[] methodDeclarationArray) {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < methodDeclarationArray.length) {
            hashSet.addAll(ReferenceFinderUtil.getTypesUsedInDeclaration(methodDeclarationArray[n]));
            ++n;
        }
        return hashSet.toArray(new ITypeBinding[hashSet.size()]);
    }

    public static Set getTypesUsedInDeclaration(MethodDeclaration methodDeclaration) {
        if (methodDeclaration == null) {
            return new HashSet(0);
        }
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        ITypeBinding iTypeBinding = null;
        Type type = methodDeclaration.getReturnType2();
        if (type != null && (iTypeBinding = type.resolveBinding()) != null) {
            hashSet.add(iTypeBinding);
        }
        Iterator iterator = methodDeclaration.parameters().iterator();
        while (iterator.hasNext()) {
            iTypeBinding = ((SingleVariableDeclaration)iterator.next()).getType().resolveBinding();
            if (iTypeBinding == null) continue;
            hashSet.add(iTypeBinding);
        }
        iterator = methodDeclaration.thrownExceptions().iterator();
        while (iterator.hasNext()) {
            iTypeBinding = ((Name)iterator.next()).resolveTypeBinding();
            if (iTypeBinding == null) continue;
            hashSet.add(iTypeBinding);
        }
        return hashSet;
    }

    private static Set extractElements(SearchMatch[] searchMatchArray, int n) {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>();
        int n2 = 0;
        while (n2 < searchMatchArray.length) {
            IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatchArray[n2]);
            if (iJavaElement.exists() && iJavaElement.getElementType() == n) {
                hashSet.add(iJavaElement);
            }
            ++n2;
        }
        return hashSet;
    }
}

