/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public final class TypeVariableUtil {
    public static TypeVariableMaplet[] composeMappings(TypeVariableMaplet[] typeVariableMapletArray, TypeVariableMaplet[] typeVariableMapletArray2) {
        Assert.isNotNull((Object)typeVariableMapletArray);
        Assert.isNotNull((Object)typeVariableMapletArray2);
        if (typeVariableMapletArray.length == 0) {
            return typeVariableMapletArray;
        }
        if (typeVariableMapletArray2.length == 0) {
            return typeVariableMapletArray2;
        }
        TypeVariableMaplet typeVariableMaplet = null;
        TypeVariableMaplet typeVariableMaplet2 = null;
        HashSet<TypeVariableMaplet> hashSet = new HashSet<TypeVariableMaplet>(typeVariableMapletArray.length * typeVariableMapletArray2.length);
        int n = 0;
        while (n < typeVariableMapletArray.length) {
            int n2 = 0;
            while (n2 < typeVariableMapletArray2.length) {
                typeVariableMaplet = typeVariableMapletArray[n];
                typeVariableMaplet2 = typeVariableMapletArray2[n2];
                if (typeVariableMaplet.getTargetIndex() == typeVariableMaplet2.getSourceIndex() && typeVariableMaplet.getTargetName().equals(typeVariableMaplet2.getSourceName())) {
                    hashSet.add(new TypeVariableMaplet(typeVariableMaplet.getSourceName(), n, typeVariableMaplet2.getTargetName(), n2));
                }
                ++n2;
            }
            ++n;
        }
        TypeVariableMaplet[] typeVariableMapletArray3 = new TypeVariableMaplet[hashSet.size()];
        hashSet.toArray(typeVariableMapletArray3);
        return typeVariableMapletArray3;
    }

    private static void extractTypeVariables(String string, Set set) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)set);
        String[] stringArray = Signature.getTypeArguments((String)string);
        if (stringArray.length == 0) {
            set.add(Signature.toString((String)string));
        } else {
            int n = 0;
            while (n < stringArray.length) {
                set.add(Signature.toString((String)stringArray[n]));
                ++n;
            }
        }
    }

    private static String[] getReferencedVariables(IType iType, IMember iMember) throws JavaModelException {
        Object object;
        Object object2;
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)iMember);
        String[] stringArray = TypeVariableUtil.parametersToVariables(iType.getTypeParameters());
        String[] stringArray2 = new String[]{};
        if (iMember instanceof IField) {
            object2 = ((IField)iMember).getTypeSignature();
            object = TypeVariableUtil.getVariableSignatures((String)object2);
            if (((String[])object).length == 0) {
                String string = Signature.toString((String)object2);
                int n = 0;
                while (n < stringArray.length) {
                    if (string.equals(stringArray[n])) {
                        stringArray2 = new String[]{string};
                        break;
                    }
                    ++n;
                }
            } else {
                stringArray2 = new String[((String[])object).length];
                int n = 0;
                while (n < stringArray2.length) {
                    stringArray2[n] = Signature.toString((String)object[n]);
                    ++n;
                }
            }
        } else if (iMember instanceof IMethod) {
            object2 = (IMethod)iMember;
            object = new HashSet();
            String[] stringArray3 = object2.getParameterTypes();
            int n = 0;
            while (n < stringArray3.length) {
                TypeVariableUtil.extractTypeVariables(stringArray3[n], (Set)object);
                ++n;
            }
            TypeVariableUtil.extractTypeVariables(object2.getReturnType(), (Set)object);
            String[] stringArray4 = TypeVariableUtil.parametersToVariables(((IMethod)iMember).getTypeParameters());
            int n2 = 0;
            while (n2 < stringArray4.length) {
                ((HashSet)object).add(stringArray4[n2]);
                ++n2;
            }
            stringArray2 = new String[((HashSet)object).size()];
            ((HashSet)object).toArray(stringArray2);
        } else if (iMember instanceof IType) {
            stringArray2 = TypeVariableUtil.parametersToVariables(((IType)iMember).getTypeParameters());
        } else {
            JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + iMember.getClass().getName());
            Assert.isTrue((boolean)false);
        }
        object2 = new ArrayList(stringArray.length);
        object = null;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (((String)object).equals(stringArray2[n3])) {
                    object2.add(stringArray2[n3]);
                }
                ++n3;
            }
            ++n;
        }
        stringArray2 = new String[object2.size()];
        object2.toArray(stringArray2);
        return stringArray2;
    }

    public static String[] getUnmappedVariables(TypeVariableMaplet[] typeVariableMapletArray, IType iType, IMember iMember) throws JavaModelException {
        String[] stringArray;
        Assert.isNotNull((Object)typeVariableMapletArray);
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)iMember);
        ArrayList<String> arrayList = null;
        String[] stringArray2 = TypeVariableUtil.getReferencedVariables(iType, iMember);
        if (typeVariableMapletArray.length == 0) {
            arrayList = new ArrayList<String>(stringArray2.length);
            arrayList.addAll(Arrays.asList(stringArray2));
        } else {
            stringArray = new HashSet(stringArray2.length);
            String string = null;
            int n = 0;
            while (n < stringArray2.length) {
                int n2 = 0;
                while (n2 < typeVariableMapletArray.length) {
                    string = stringArray2[n];
                    if (typeVariableMapletArray[n2].getSourceName().equals(string)) {
                        stringArray.add(string);
                    }
                    ++n2;
                }
                ++n;
            }
            arrayList = new ArrayList(stringArray2.length - stringArray.size());
            n = 0;
            while (n < stringArray2.length) {
                string = stringArray2[n];
                if (!stringArray.contains(string)) {
                    arrayList.add(string);
                }
                ++n;
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getVariableSignatures(String string) {
        Assert.isNotNull((Object)string);
        String[] stringArray = null;
        try {
            stringArray = Signature.getTypeArguments((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static TypeVariableMaplet[] inverseMapping(TypeVariableMaplet[] typeVariableMapletArray) {
        Assert.isNotNull((Object)typeVariableMapletArray);
        TypeVariableMaplet[] typeVariableMapletArray2 = new TypeVariableMaplet[typeVariableMapletArray.length];
        TypeVariableMaplet typeVariableMaplet = null;
        int n = 0;
        while (n < typeVariableMapletArray.length) {
            typeVariableMaplet = typeVariableMapletArray[n];
            typeVariableMapletArray2[n] = new TypeVariableMaplet(typeVariableMaplet.getTargetName(), typeVariableMaplet.getTargetIndex(), typeVariableMaplet.getSourceName(), typeVariableMaplet.getSourceIndex());
            ++n;
        }
        return typeVariableMapletArray2;
    }

    private static TypeVariableMaplet[] parametersToSignatures(ITypeParameter[] iTypeParameterArray, String[] stringArray, boolean bl) {
        Assert.isNotNull((Object)iTypeParameterArray);
        Assert.isNotNull((Object)stringArray);
        HashSet<TypeVariableMaplet> hashSet = new HashSet<TypeVariableMaplet>();
        ITypeParameter iTypeParameter = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < iTypeParameterArray.length) {
            iTypeParameter = iTypeParameterArray[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                string = stringArray[n2];
                string2 = iTypeParameter.getElementName();
                string3 = Signature.toString((String)string);
                if (bl) {
                    if (n2 == n) {
                        hashSet.add(new TypeVariableMaplet(string2, n, string3, n2));
                    }
                } else if (string2.equals(string3)) {
                    hashSet.add(new TypeVariableMaplet(string2, n, string3, n2));
                }
                ++n2;
            }
            ++n;
        }
        TypeVariableMaplet[] typeVariableMapletArray = new TypeVariableMaplet[hashSet.size()];
        hashSet.toArray(typeVariableMapletArray);
        return typeVariableMapletArray;
    }

    private static String[] parametersToVariables(ITypeParameter[] iTypeParameterArray) {
        Assert.isNotNull((Object)iTypeParameterArray);
        String[] stringArray = new String[iTypeParameterArray.length];
        int n = 0;
        while (n < iTypeParameterArray.length) {
            stringArray[n] = iTypeParameterArray[n].getElementName();
            ++n;
        }
        return stringArray;
    }

    private static TypeVariableMaplet[] signaturesToParameters(String[] stringArray, ITypeParameter[] iTypeParameterArray) {
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)iTypeParameterArray);
        Assert.isTrue((stringArray.length == 0 || stringArray.length == iTypeParameterArray.length ? 1 : 0) != 0);
        ArrayList<TypeVariableMaplet> arrayList = new ArrayList<TypeVariableMaplet>();
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            string = Signature.toString((String)stringArray[n]);
            string2 = iTypeParameterArray[n].getElementName();
            arrayList.add(new TypeVariableMaplet(string, n, string2, n));
            ++n;
        }
        TypeVariableMaplet[] typeVariableMapletArray = new TypeVariableMaplet[arrayList.size()];
        arrayList.toArray(typeVariableMapletArray);
        return typeVariableMapletArray;
    }

    public static TypeVariableMaplet[] subTypeToInheritedType(IType iType) throws JavaModelException {
        String[] stringArray;
        String string;
        Assert.isNotNull((Object)iType);
        ITypeParameter[] iTypeParameterArray = iType.getTypeParameters();
        if (iTypeParameterArray.length > 0 && (string = iType.getSuperclassTypeSignature()) != null && (stringArray = TypeVariableUtil.getVariableSignatures(string)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(iTypeParameterArray, stringArray, false);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] subTypeToSuperType(IType iType, IType iType2) throws JavaModelException {
        String[] stringArray;
        String string;
        ITypeParameter[] iTypeParameterArray;
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)iType2);
        TypeVariableMaplet[] typeVariableMapletArray = TypeVariableUtil.subTypeToInheritedType(iType);
        if (typeVariableMapletArray.length > 0 && (iTypeParameterArray = iType2.getTypeParameters()).length > 0 && (string = iType.getSuperclassTypeSignature()) != null && (stringArray = TypeVariableUtil.getVariableSignatures(string)).length > 0) {
            return TypeVariableUtil.composeMappings(typeVariableMapletArray, TypeVariableUtil.signaturesToParameters(stringArray, iTypeParameterArray));
        }
        return typeVariableMapletArray;
    }

    public static TypeVariableMaplet[] superTypeToInheritedType(IType iType, IType iType2) throws JavaModelException {
        String[] stringArray;
        String string;
        Assert.isNotNull((Object)iType2);
        Assert.isNotNull((Object)iType);
        ITypeParameter[] iTypeParameterArray = iType.getTypeParameters();
        if (iTypeParameterArray.length > 0 && (string = iType2.getSuperclassTypeSignature()) != null && (stringArray = TypeVariableUtil.getVariableSignatures(string)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(iTypeParameterArray, stringArray, true);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] superTypeToSubType(IType iType, IType iType2) throws JavaModelException {
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)iType2);
        return TypeVariableUtil.inverseMapping(TypeVariableUtil.subTypeToSuperType(iType2, iType));
    }

    private TypeVariableUtil() {
    }
}

