/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;

public abstract class AbstractTypeVariable
extends TType {
    protected TType[] fBounds;

    protected AbstractTypeVariable(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding) {
        super.initialize(iTypeBinding);
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeBounds();
        if (iTypeBindingArray.length == 0) {
            this.fBounds = EMPTY_TYPE_ARRAY;
            if (this.getEnvironment().getJavaLangObject() == null) {
                this.getEnvironment().initializeJavaLangObject(iTypeBinding.getErasure());
            }
        } else {
            this.fBounds = new TType[iTypeBindingArray.length];
            int n = 0;
            while (n < iTypeBindingArray.length) {
                this.fBounds[n] = this.getEnvironment().create(iTypeBindingArray[n]);
                ++n;
            }
        }
    }

    public TType getErasure() {
        if (this.fBounds.length == 0) {
            return this.getEnvironment().getJavaLangObject();
        }
        return this.fBounds[0].getErasure();
    }

    final boolean isUnbounded() {
        if (this.fBounds.length == 0) {
            return true;
        }
        return this.fBounds[0].isJavaLangObject();
    }

    public final TType[] getBounds() {
        return (TType[])this.fBounds.clone();
    }

    public final TType[] getSubTypes() {
        return EMPTY_TYPE_ARRAY;
    }

    protected final boolean checkAssignmentBound(TType tType) {
        if (this.fBounds.length == 0) {
            return true;
        }
        int n = 0;
        while (n < this.fBounds.length) {
            if (tType.canAssignTo(this.fBounds[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected final boolean canAssignOneBoundTo(TType tType) {
        if (this.fBounds.length == 0) {
            return tType.isJavaLangObject();
        }
        int n = 0;
        while (n < this.fBounds.length) {
            if (this.fBounds[n].canAssignTo(tType)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

