/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.RawType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class ParameterizedType
extends HierarchyType {
    private GenericType fTypeDeclaration;
    private TType[] fTypeArguments;

    protected ParameterizedType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding, IType iType) {
        Assert.isTrue((boolean)iTypeBinding.isParameterizedType());
        super.initialize(iTypeBinding, iType);
        TypeEnvironment typeEnvironment = this.getEnvironment();
        this.fTypeDeclaration = (GenericType)typeEnvironment.create(iTypeBinding.getTypeDeclaration());
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        this.fTypeArguments = new TType[iTypeBindingArray.length];
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.fTypeArguments[n] = typeEnvironment.create(iTypeBindingArray[n]);
            ++n;
        }
    }

    public int getKind() {
        return 7;
    }

    public TType getTypeDeclaration() {
        return this.fTypeDeclaration;
    }

    public TType getErasure() {
        return this.fTypeDeclaration;
    }

    public TType[] getTypeArguments() {
        return (TType[])this.fTypeArguments.clone();
    }

    public boolean doEquals(TType tType) {
        ParameterizedType parameterizedType = (ParameterizedType)tType;
        if (!this.getBindingKey().equals(parameterizedType.getBindingKey())) {
            return false;
        }
        return this.getJavaElementType().equals(parameterizedType.getJavaElementType());
    }

    public int hashCode() {
        return this.getBindingKey().hashCode();
    }

    protected boolean doCanAssignTo(TType tType) {
        int n = tType.getKind();
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)tType);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.canAssignToParameterizedType((ParameterizedType)tType);
            }
            case 8: {
                return this.canAssignToRawType((RawType)tType);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)tType).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)tType).checkLowerBound(this);
            }
        }
        return false;
    }

    protected boolean isTypeEquivalentTo(TType tType) {
        int n = tType.getKind();
        if (n == 8 || n == 6) {
            return this.getErasure().isTypeEquivalentTo(tType.getErasure());
        }
        return super.isTypeEquivalentTo(tType);
    }

    private boolean canAssignToRawType(RawType rawType) {
        return this.fTypeDeclaration.isSubType(rawType.getHierarchyType());
    }

    private boolean canAssignToParameterizedType(ParameterizedType parameterizedType) {
        GenericType genericType = parameterizedType.fTypeDeclaration;
        ParameterizedType parameterizedType2 = this.findSameDeclaration(genericType);
        if (parameterizedType2 == null) {
            return false;
        }
        TType[] tTypeArray = parameterizedType.fTypeArguments;
        TType[] tTypeArray2 = parameterizedType2.fTypeArguments;
        if (tTypeArray.length != tTypeArray2.length) {
            return false;
        }
        int n = 0;
        while (n < tTypeArray2.length) {
            if (!tTypeArray[n].checkTypeArgument(tTypeArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private ParameterizedType findSameDeclaration(GenericType genericType) {
        if (this.fTypeDeclaration.equals(genericType)) {
            return this;
        }
        ParameterizedType parameterizedType = null;
        TType tType = this.getSuperclass();
        if (tType != null && tType.getKind() == 7 && (parameterizedType = ((ParameterizedType)tType).findSameDeclaration(genericType)) != null) {
            return parameterizedType;
        }
        TType[] tTypeArray = this.getInterfaces();
        int n = 0;
        while (n < tTypeArray.length) {
            tType = tTypeArray[n];
            if (tType != null && tType.getKind() == 7 && (parameterizedType = ((ParameterizedType)tType).findSameDeclaration(genericType)) != null) {
                return parameterizedType;
            }
            ++n;
        }
        return null;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer(this.getJavaElementType().getElementName());
        stringBuffer.append("<");
        stringBuffer.append(this.fTypeArguments[0].getName());
        int n = 1;
        while (n < this.fTypeArguments.length) {
            stringBuffer.append(", ");
            stringBuffer.append(this.fTypeArguments[n].getName());
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected String getPlainPrettySignature() {
        StringBuffer stringBuffer = new StringBuffer(this.getJavaElementType().getFullyQualifiedName('.'));
        stringBuffer.append("<");
        stringBuffer.append(this.fTypeArguments[0].getPlainPrettySignature());
        int n = 1;
        while (n < this.fTypeArguments.length) {
            stringBuffer.append(", ");
            stringBuffer.append(this.fTypeArguments[n].getPlainPrettySignature());
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

