/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class RawType
extends HierarchyType {
    private HierarchyType fTypeDeclaration;

    protected RawType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding, IType iType) {
        Assert.isTrue((boolean)iTypeBinding.isRawType());
        super.initialize(iTypeBinding, iType);
        TypeEnvironment typeEnvironment = this.getEnvironment();
        this.fTypeDeclaration = (HierarchyType)typeEnvironment.create(iTypeBinding.getTypeDeclaration());
    }

    public int getKind() {
        return 8;
    }

    public boolean doEquals(TType tType) {
        return this.getJavaElementType().equals(((RawType)tType).getJavaElementType());
    }

    public int hashCode() {
        return this.getJavaElementType().hashCode();
    }

    public TType getTypeDeclaration() {
        return this.fTypeDeclaration;
    }

    public TType getErasure() {
        return this.fTypeDeclaration;
    }

    HierarchyType getHierarchyType() {
        return this.fTypeDeclaration;
    }

    protected boolean doCanAssignTo(TType tType) {
        int n = tType.getKind();
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)tType);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.isSubType((ParameterizedType)tType);
            }
            case 8: {
                return this.isSubType((HierarchyType)tType);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)tType).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)tType).checkLowerBound(this);
            }
        }
        return false;
    }

    protected boolean isTypeEquivalentTo(TType tType) {
        int n = tType.getKind();
        if (n == 7 || n == 6) {
            return this.getErasure().isTypeEquivalentTo(tType.getErasure());
        }
        return super.isTypeEquivalentTo(tType);
    }

    public String getName() {
        return this.getJavaElementType().getElementName();
    }

    protected String getPlainPrettySignature() {
        return this.getJavaElementType().getFullyQualifiedName('.');
    }
}

