/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ExtendsWildcardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.NullType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.RawType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.SuperWildcardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.UnboundWildcardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.VoidType;

public class TypeEnvironment {
    public final PrimitiveType INT = new PrimitiveType(this, 0, BindingKey.createTypeBindingKey((String)"int"));
    public final PrimitiveType CHAR = new PrimitiveType(this, 1, BindingKey.createTypeBindingKey((String)"char"));
    public final PrimitiveType BOOLEAN = new PrimitiveType(this, 2, BindingKey.createTypeBindingKey((String)"boolean"));
    public final PrimitiveType SHORT = new PrimitiveType(this, 3, BindingKey.createTypeBindingKey((String)"short"));
    public final PrimitiveType LONG = new PrimitiveType(this, 4, BindingKey.createTypeBindingKey((String)"long"));
    public final PrimitiveType FLOAT = new PrimitiveType(this, 5, BindingKey.createTypeBindingKey((String)"float"));
    public final PrimitiveType DOUBLE = new PrimitiveType(this, 6, BindingKey.createTypeBindingKey((String)"double"));
    public final PrimitiveType BYTE = new PrimitiveType(this, 7, BindingKey.createTypeBindingKey((String)"byte"));
    public final NullType NULL = new NullType(this);
    public final VoidType VOID = new VoidType(this);
    final PrimitiveType[] PRIMITIVE_TYPES = new PrimitiveType[]{this.INT, this.CHAR, this.BOOLEAN, this.SHORT, this.LONG, this.FLOAT, this.DOUBLE, this.BYTE};
    private static final String[] BOXED_PRIMITIVE_NAMES = new String[]{"java.lang.Integer", "java.lang.Character", "java.lang.Boolean", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Byte"};
    private TType OBJECT_TYPE = null;
    private Map[] fArrayTypes = new Map[]{new HashMap()};
    private Map fStandardTypes = new HashMap();
    private Map fGenericTypes = new HashMap();
    private Map fParameterizedTypes = new HashMap();
    private Map fRawTypes = new HashMap();
    private Map fTypeVariables = new HashMap();
    private Map fCaptureTypes = new HashMap();
    private Map fExtendsWildcardTypes = new HashMap();
    private Map fSuperWildcardTypes = new HashMap();
    private UnboundWildcardType fUnboundWildcardType = null;
    private static final int MAX_ENTRIES = 1024;
    private Map fSubTypeCache = new LinkedHashMap(50, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1024;
        }
    };
    private Map fSubTypes;

    public static ITypeBinding[] createTypeBindings(TType[] tTypeArray, IJavaProject iJavaProject) {
        ITypeBinding[] iTypeBindingArray;
        final HashMap<String, ITypeBinding[]> hashMap = new HashMap<String, ITypeBinding[]>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < tTypeArray.length) {
            iTypeBindingArray = tTypeArray[n];
            String string = iTypeBindingArray.getBindingKey();
            hashMap.put(string, iTypeBindingArray);
            arrayList.add(string);
            ++n;
        }
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setProject(iJavaProject);
        aSTParser.setResolveBindings(true);
        aSTParser.createASTs(new ICompilationUnit[0], arrayList.toArray(new String[arrayList.size()]), new ASTRequestor(){

            public void acceptBinding(String string, IBinding iBinding) {
                hashMap.put(string, iBinding);
            }
        }, null);
        iTypeBindingArray = new ITypeBinding[tTypeArray.length];
        int n2 = 0;
        while (n2 < tTypeArray.length) {
            TType tType = tTypeArray[n2];
            String string = tType.getBindingKey();
            Object v = hashMap.get(string);
            if (v instanceof ITypeBinding) {
                iTypeBindingArray[n2] = (ITypeBinding)v;
            }
            ++n2;
        }
        return iTypeBindingArray;
    }

    public TypeEnvironment() {
        this(false);
    }

    public TypeEnvironment(boolean bl) {
        if (bl) {
            this.fSubTypes = new HashMap();
        }
    }

    Map getSubTypeCache() {
        return this.fSubTypeCache;
    }

    public TType create(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isPrimitive()) {
            return this.createPrimitiveType(iTypeBinding);
        }
        if (iTypeBinding.isArray()) {
            return this.createArrayType(iTypeBinding);
        }
        if (iTypeBinding.isRawType()) {
            return this.createRawType(iTypeBinding);
        }
        if (iTypeBinding.isGenericType()) {
            return this.createGenericType(iTypeBinding);
        }
        if (iTypeBinding.isParameterizedType()) {
            return this.createParameterizedType(iTypeBinding);
        }
        if (iTypeBinding.isTypeVariable()) {
            return this.createTypeVariable(iTypeBinding);
        }
        if (iTypeBinding.isWildcardType()) {
            if (iTypeBinding.getBound() == null) {
                return this.createUnboundWildcardType(iTypeBinding);
            }
            if (iTypeBinding.isUpperbound()) {
                return this.createExtendsWildCardType(iTypeBinding);
            }
            return this.createSuperWildCardType(iTypeBinding);
        }
        if (iTypeBinding.isCapture()) {
            return this.createCaptureType(iTypeBinding);
        }
        if ("null".equals(iTypeBinding.getName())) {
            return this.NULL;
        }
        return this.createStandardType(iTypeBinding);
    }

    public TType[] create(ITypeBinding[] iTypeBindingArray) {
        TType[] tTypeArray = new TType[iTypeBindingArray.length];
        int n = 0;
        while (n < iTypeBindingArray.length) {
            tTypeArray[n] = this.create(iTypeBindingArray[n]);
            ++n;
        }
        return tTypeArray;
    }

    public TType getJavaLangObject() {
        return this.OBJECT_TYPE;
    }

    void initializeJavaLangObject(ITypeBinding iTypeBinding) {
        if (this.OBJECT_TYPE != null) {
            return;
        }
        StandardType standardType = this.createStandardType(iTypeBinding);
        Assert.isTrue((boolean)((TType)standardType).isJavaLangObject());
    }

    PrimitiveType createUnBoxed(StandardType standardType) {
        String string = standardType.getPlainPrettySignature();
        int n = 0;
        while (n < BOXED_PRIMITIVE_NAMES.length) {
            if (BOXED_PRIMITIVE_NAMES[n].equals(string)) {
                return this.PRIMITIVE_TYPES[n];
            }
            ++n;
        }
        return null;
    }

    StandardType createBoxed(PrimitiveType primitiveType, IJavaProject iJavaProject) {
        String string = BOXED_PRIMITIVE_NAMES[primitiveType.getId()];
        try {
            IType iType = iJavaProject.findType(string);
            StandardType standardType = (StandardType)this.fStandardTypes.get(iType);
            if (standardType != null) {
                return standardType;
            }
            ASTParser aSTParser = ASTParser.newParser((int)3);
            aSTParser.setProject(iJavaProject);
            IBinding[] iBindingArray = aSTParser.createBindings(new IJavaElement[]{iType}, null);
            return this.createStandardType((ITypeBinding)iBindingArray[0]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    Map getSubTypes() {
        return this.fSubTypes;
    }

    private void cacheSubType(TType tType, TType tType2) {
        ArrayList<TType> arrayList;
        if (this.fSubTypes == null) {
            return;
        }
        if (tType == null) {
            tType = this.OBJECT_TYPE;
        }
        if ((arrayList = (ArrayList<TType>)this.fSubTypes.get(tType)) == null) {
            arrayList = new ArrayList<TType>(5);
            this.fSubTypes.put(tType, arrayList);
        } else {
            Assert.isTrue((!arrayList.contains(tType2) ? 1 : 0) != 0);
        }
        arrayList.add(tType2);
    }

    private void cacheSubTypes(TType[] tTypeArray, TType tType) {
        int n = 0;
        while (n < tTypeArray.length) {
            this.cacheSubType(tTypeArray[n], tType);
            ++n;
        }
    }

    private TType createPrimitiveType(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getName();
        String[] stringArray = PrimitiveType.NAMES;
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return this.PRIMITIVE_TYPES[n];
            }
            ++n;
        }
        Assert.isTrue((boolean)false, (String)("Primitive type " + string + "unkown"));
        return null;
    }

    private ArrayType createArrayType(ITypeBinding iTypeBinding) {
        int n = iTypeBinding.getDimensions() - 1;
        TType tType = this.create(iTypeBinding.getElementType());
        Map map = this.getArrayTypesMap(n);
        ArrayType arrayType = (ArrayType)map.get(tType);
        if (arrayType != null) {
            return arrayType;
        }
        arrayType = new ArrayType(this);
        map.put(tType, arrayType);
        arrayType.initialize(iTypeBinding, tType);
        return arrayType;
    }

    public ArrayType createArrayType(TType tType, int n) {
        Assert.isTrue((!tType.isArrayType() ? 1 : 0) != 0);
        Assert.isTrue((!tType.isAnonymous() ? 1 : 0) != 0);
        Assert.isTrue((n > 0 ? 1 : 0) != 0);
        int n2 = n - 1;
        Map map = this.getArrayTypesMap(n2);
        ArrayType arrayType = (ArrayType)map.get(tType);
        if (arrayType != null) {
            return arrayType;
        }
        arrayType = new ArrayType(this, BindingKey.createArrayTypeBindingKey((String)tType.getBindingKey(), (int)n));
        map.put(tType, arrayType);
        arrayType.initialize(tType, n);
        return arrayType;
    }

    private Map getArrayTypesMap(int n) {
        Object object;
        int n2 = this.fArrayTypes.length;
        if (n >= n2) {
            object = new Map[n + 1];
            System.arraycopy(this.fArrayTypes, 0, object, 0, n2);
            this.fArrayTypes = object;
        }
        if ((object = this.fArrayTypes[n]) == null) {
            this.fArrayTypes[n] = object = new HashMap();
        }
        return object;
    }

    private StandardType createStandardType(ITypeBinding iTypeBinding) {
        IJavaElement iJavaElement = iTypeBinding.getJavaElement();
        StandardType standardType = (StandardType)this.fStandardTypes.get(iJavaElement);
        if (standardType != null) {
            return standardType;
        }
        standardType = new StandardType(this);
        this.fStandardTypes.put(iJavaElement, standardType);
        standardType.initialize(iTypeBinding, (IType)iJavaElement);
        if (this.OBJECT_TYPE == null && standardType.isJavaLangObject()) {
            this.OBJECT_TYPE = standardType;
        }
        return standardType;
    }

    private GenericType createGenericType(ITypeBinding iTypeBinding) {
        IJavaElement iJavaElement = iTypeBinding.getJavaElement();
        GenericType genericType = (GenericType)this.fGenericTypes.get(iJavaElement);
        if (genericType != null) {
            return genericType;
        }
        genericType = new GenericType(this);
        this.fGenericTypes.put(iJavaElement, genericType);
        genericType.initialize(iTypeBinding, (IType)iJavaElement);
        this.cacheSubType(genericType.getSuperclass(), genericType);
        this.cacheSubTypes(genericType.getInterfaces(), genericType);
        return genericType;
    }

    private ParameterizedType createParameterizedType(ITypeBinding iTypeBinding) {
        String string;
        IJavaProject iJavaProject = iTypeBinding.getJavaElement().getJavaProject();
        ProjectKeyPair projectKeyPair = new ProjectKeyPair(iJavaProject, string = iTypeBinding.getKey());
        ParameterizedType parameterizedType = (ParameterizedType)this.fParameterizedTypes.get(projectKeyPair);
        if (parameterizedType != null) {
            return parameterizedType;
        }
        parameterizedType = new ParameterizedType(this);
        this.fParameterizedTypes.put(projectKeyPair, parameterizedType);
        parameterizedType.initialize(iTypeBinding, (IType)iTypeBinding.getJavaElement());
        this.cacheSubType(parameterizedType.getSuperclass(), parameterizedType);
        this.cacheSubTypes(parameterizedType.getInterfaces(), parameterizedType);
        return parameterizedType;
    }

    private RawType createRawType(ITypeBinding iTypeBinding) {
        IJavaElement iJavaElement = iTypeBinding.getJavaElement();
        RawType rawType = (RawType)this.fRawTypes.get(iJavaElement);
        if (rawType != null) {
            return rawType;
        }
        rawType = new RawType(this);
        this.fRawTypes.put(iJavaElement, rawType);
        rawType.initialize(iTypeBinding, (IType)iJavaElement);
        this.cacheSubType(rawType.getSuperclass(), rawType);
        this.cacheSubTypes(rawType.getInterfaces(), rawType);
        return rawType;
    }

    private TType createUnboundWildcardType(ITypeBinding iTypeBinding) {
        if (this.fUnboundWildcardType == null) {
            this.fUnboundWildcardType = new UnboundWildcardType(this);
            this.fUnboundWildcardType.initialize(iTypeBinding);
        }
        return this.fUnboundWildcardType;
    }

    private TType createExtendsWildCardType(ITypeBinding iTypeBinding) {
        TType tType = this.create(iTypeBinding.getBound());
        ExtendsWildcardType extendsWildcardType = (ExtendsWildcardType)this.fExtendsWildcardTypes.get(tType);
        if (extendsWildcardType != null) {
            return extendsWildcardType;
        }
        extendsWildcardType = new ExtendsWildcardType(this);
        this.fExtendsWildcardTypes.put(tType, extendsWildcardType);
        extendsWildcardType.initialize(iTypeBinding);
        return extendsWildcardType;
    }

    private TType createSuperWildCardType(ITypeBinding iTypeBinding) {
        TType tType = this.create(iTypeBinding.getBound());
        SuperWildcardType superWildcardType = (SuperWildcardType)this.fSuperWildcardTypes.get(tType);
        if (superWildcardType != null) {
            return superWildcardType;
        }
        superWildcardType = new SuperWildcardType(this);
        this.fSuperWildcardTypes.put(tType, superWildcardType);
        superWildcardType.initialize(iTypeBinding);
        return superWildcardType;
    }

    private TypeVariable createTypeVariable(ITypeBinding iTypeBinding) {
        IJavaElement iJavaElement = iTypeBinding.getJavaElement();
        TypeVariable typeVariable = (TypeVariable)this.fTypeVariables.get(iJavaElement);
        if (typeVariable != null) {
            return typeVariable;
        }
        typeVariable = new TypeVariable(this);
        this.fTypeVariables.put(iJavaElement, typeVariable);
        typeVariable.initialize(iTypeBinding, (ITypeParameter)iJavaElement);
        return typeVariable;
    }

    private CaptureType createCaptureType(ITypeBinding iTypeBinding) {
        String string;
        IJavaProject iJavaProject = iTypeBinding.getDeclaringClass().getJavaElement().getJavaProject();
        ProjectKeyPair projectKeyPair = new ProjectKeyPair(iJavaProject, string = iTypeBinding.getKey());
        CaptureType captureType = (CaptureType)this.fCaptureTypes.get(projectKeyPair);
        if (captureType != null) {
            return captureType;
        }
        captureType = new CaptureType(this);
        this.fCaptureTypes.put(projectKeyPair, captureType);
        captureType.initialize(iTypeBinding, iJavaProject);
        return captureType;
    }

    private static class ProjectKeyPair {
        private final IJavaProject fProject;
        private final String fBindingKey;

        public ProjectKeyPair(IJavaProject iJavaProject, String string) {
            this.fProject = iJavaProject;
            this.fBindingKey = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ProjectKeyPair)) {
                return false;
            }
            ProjectKeyPair projectKeyPair = (ProjectKeyPair)object;
            return this.fProject.equals(projectKeyPair.fProject) && this.fBindingKey.equals(projectKeyPair.fBindingKey);
        }

        public int hashCode() {
            return this.fProject.hashCode() + this.fBindingKey.hashCode();
        }
    }
}

