/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetIntersection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SuperTypesSet
extends TypeSet {
    private TypeSet fLowerBounds;
    private EnumeratedTypeSet fEnumCache = null;

    SuperTypesSet(TType tType, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBounds = new SingletonTypeSet(tType, typeSetEnvironment);
    }

    SuperTypesSet(TypeSet typeSet, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBounds = typeSet;
    }

    public boolean isUniverse() {
        return this.fLowerBounds.isUniverse();
    }

    public TypeSet makeClone() {
        return this;
    }

    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getTypeSetEnvironment().getJavaLangObject(), this.getTypeSetEnvironment());
    }

    public TypeSet lowerBound() {
        return this.fLowerBounds.lowerBound();
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        Object object;
        Object object2;
        TypeSet typeSet2;
        if (this.fLowerBounds.equals(typeSet)) {
            return typeSet;
        }
        if (typeSet instanceof SuperTypesSet) {
            typeSet2 = (SuperTypesSet)typeSet;
            if (this.fLowerBounds.isSingleton() && ((SuperTypesSet)typeSet2).fLowerBounds.isSingleton()) {
                object2 = this.fLowerBounds.anyMember();
                if (TTypes.canAssignTo((TType)object2, (TType)(object = ((SuperTypesSet)typeSet2).fLowerBounds.anyMember()))) {
                    return new SuperTypesSet(((SuperTypesSet)typeSet2).fLowerBounds, this.getTypeSetEnvironment());
                }
            } else if (this.fLowerBounds instanceof SubTypesSet && ((SubTypesSet)(object2 = (SubTypesSet)this.fLowerBounds)).upperBound().equals(((SuperTypesSet)typeSet2).upperBound())) {
                return typeSet2;
            }
        }
        if (typeSet instanceof SuperTypesOfSingleton) {
            typeSet2 = (SuperTypesOfSingleton)typeSet;
            if (this.fLowerBounds.isSingleton()) {
                object2 = this.fLowerBounds.anyMember();
                if (TTypes.canAssignTo((TType)object2, (TType)(object = ((SuperTypesOfSingleton)typeSet2).uniqueLowerBound()))) {
                    return this.getTypeSetEnvironment().createSuperTypesOfSingleton((TType)object);
                }
            } else if (this.fLowerBounds instanceof SubTypesOfSingleton && ((SubTypesOfSingleton)(object2 = (SubTypesOfSingleton)this.fLowerBounds)).uniqueUpperBound().equals(((SuperTypesOfSingleton)typeSet2).uniqueUpperBound())) {
                return typeSet2;
            }
        }
        if (typeSet instanceof SubTypesSet) {
            typeSet2 = (SubTypesSet)typeSet;
            if (this.fLowerBounds.equals(((SubTypesSet)typeSet2).upperBound())) {
                return this.fLowerBounds;
            }
            if (this.fLowerBounds instanceof TypeSetIntersection) {
                object2 = (TypeSetIntersection)this.fLowerBounds;
                object = ((TypeSetIntersection)object2).getLHS();
                TypeSet typeSet3 = ((TypeSetIntersection)object2).getRHS();
                if (object.equals(((SubTypesSet)typeSet2).upperBound())) {
                    return new TypeSetIntersection(typeSet, new SuperTypesSet(typeSet3, this.getTypeSetEnvironment()));
                }
            }
        }
        return null;
    }

    public TypeSet superTypes() {
        return this;
    }

    public boolean isEmpty() {
        return this.fLowerBounds.isEmpty();
    }

    public boolean contains(TType tType) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.contains(tType);
        }
        if (tType.equals(this.getJavaLangObject())) {
            return true;
        }
        if (this.fLowerBounds.contains(tType)) {
            return true;
        }
        Iterator iterator = this.fLowerBounds.iterator();
        while (iterator.hasNext()) {
            TType tType2 = (TType)iterator.next();
            if (!TTypes.canAssignTo(tType2, tType)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(TypeSet typeSet) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.containsAll(typeSet);
        }
        if (!this.isUniverse() && typeSet.isUniverse()) {
            return false;
        }
        if (this.equals(typeSet)) {
            return true;
        }
        if (this.fLowerBounds.containsAll(typeSet)) {
            return true;
        }
        Iterator iterator = typeSet.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            boolean bl = false;
            Iterator iterator2 = this.fLowerBounds.iterator();
            while (iterator2.hasNext()) {
                TType tType2 = (TType)iterator2.next();
                if (!TTypes.canAssignTo(tType2, tType)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleton() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.isSingleton();
        }
        return this.fLowerBounds.isSingleton() && this.fLowerBounds.anyMember() == this.getJavaLangObject();
    }

    public TType anyMember() {
        return this.fLowerBounds.anyMember();
    }

    public boolean equals(Object object) {
        if (object instanceof SuperTypesSet) {
            SuperTypesSet superTypesSet = (SuperTypesSet)object;
            return superTypesSet.fLowerBounds.equals(this.fLowerBounds);
        }
        return false;
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public String toString() {
        return "<" + this.fID + ": superTypes(" + this.fLowerBounds + ")>";
    }

    public boolean hasUniqueLowerBound() {
        return this.fLowerBounds.isSingleton();
    }

    public boolean hasUniqueUpperBound() {
        return false;
    }

    public TType uniqueLowerBound() {
        return this.fLowerBounds.isSingleton() ? this.fLowerBounds.anyMember() : null;
    }

    public TType uniqueUpperBound() {
        return null;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            boolean bl = false;
            Iterator iterator = this.fLowerBounds.iterator();
            while (iterator.hasNext()) {
                Object object;
                TType tType = (TType)iterator.next();
                if (tType instanceof ArrayType) {
                    object = (ArrayType)tType;
                    int n = ((ArrayType)object).getDimensions();
                    Iterator iterator2 = TTypes.getAllSuperTypesIterator(((ArrayType)object).getElementType());
                    while (iterator2.hasNext()) {
                        this.fEnumCache.add(TTypes.createArrayType((TType)iterator2.next(), n));
                    }
                    bl = true;
                } else {
                    object = TTypes.getAllSuperTypesIterator(tType);
                    while (object.hasNext()) {
                        this.fEnumCache.fMembers.add(object.next());
                    }
                }
                this.fEnumCache.add(tType);
            }
            if (bl) {
                this.fEnumCache.add(this.getJavaLangObject());
            }
        }
        return this.fEnumCache;
    }
}

