/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;

public class JavadocUtil {
    private JavadocUtil() {
    }

    public static TagElement createParamTag(String string, AST aST, IJavaProject iJavaProject) {
        TagElement tagElement = aST.newTagElement();
        tagElement.setTagName("@param");
        SimpleName simpleName = aST.newSimpleName(string);
        tagElement.fragments().add(simpleName);
        TextElement textElement = aST.newTextElement();
        String string2 = StubUtility.getTodoTaskTag(iJavaProject);
        if (string2 != null) {
            textElement.setText(string2);
        }
        tagElement.fragments().add(textElement);
        return tagElement;
    }

    public static boolean shouldAddParamJavadoc(MethodDeclaration methodDeclaration) {
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc == null) {
            return false;
        }
        if (methodDeclaration.parameters().size() == 0) {
            return true;
        }
        List list = javadoc.tags();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TagElement tagElement = (TagElement)iterator.next();
            if (!"@param".equals(tagElement.getTagName())) continue;
            return true;
        }
        return false;
    }

    public static void addParamJavadoc(String string, MethodDeclaration methodDeclaration, ASTRewrite aSTRewrite, IJavaProject iJavaProject, TextEditGroup textEditGroup) {
        if (!JavadocUtil.shouldAddParamJavadoc(methodDeclaration)) {
            return;
        }
        ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)methodDeclaration.getJavadoc(), Javadoc.TAGS_PROPERTY);
        HashSet<String> hashSet = new HashSet<String>();
        TagElement tagElement = methodDeclaration.parameters().iterator();
        while (tagElement.hasNext()) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)tagElement.next();
            hashSet.add(singleVariableDeclaration.getName().getIdentifier());
        }
        tagElement = JavadocUtil.createParamTag(string, aSTRewrite.getAST(), iJavaProject);
        JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, hashSet, textEditGroup);
    }
}

