/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;

public class TextChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean bl) {
        this.fKeepExecutedTextEdits = bl;
    }

    public void manage(ICompilationUnit iCompilationUnit, TextChange textChange) {
        this.fMap.put(iCompilationUnit, textChange);
    }

    public TextChange get(ICompilationUnit iCompilationUnit) {
        Object object = (TextChange)this.fMap.get(iCompilationUnit);
        if (object == null) {
            object = new CompilationUnitChange(iCompilationUnit.getElementName(), iCompilationUnit);
            object.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(iCompilationUnit, object);
        }
        return object;
    }

    public TextChange remove(ICompilationUnit iCompilationUnit) {
        return (TextChange)this.fMap.remove(iCompilationUnit);
    }

    public TextChange[] getAllChanges() {
        Set set = this.fMap.keySet();
        ICompilationUnit[] iCompilationUnitArray = set.toArray(new ICompilationUnit[set.size()]);
        Arrays.sort(iCompilationUnitArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((ICompilationUnit)object).getElementName();
                String string2 = ((ICompilationUnit)object2).getElementName();
                return string.compareTo(string2);
            }
        });
        TextChange[] textChangeArray = new TextChange[iCompilationUnitArray.length];
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            textChangeArray[n] = (TextChange)this.fMap.get(iCompilationUnitArray[n]);
            ++n;
        }
        return textChangeArray;
    }

    public ICompilationUnit[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new ICompilationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ICompilationUnit iCompilationUnit) {
        return this.fMap.containsKey(iCompilationUnit);
    }
}

