/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class SelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart iWorkbenchPart) throws JavaModelException {
        ISelection iSelection;
        if (iWorkbenchPart instanceof JavaEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((JavaEditor)iWorkbenchPart));
        }
        ISelectionProvider iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider();
        if (iSelectionProvider != null && (iSelection = iSelectionProvider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaElement[] getElements(IStructuredSelection iStructuredSelection) {
        if (!iStructuredSelection.isEmpty()) {
            IJavaElement[] iJavaElementArray = new IJavaElement[iStructuredSelection.size()];
            int n = 0;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IJavaElement)) {
                    return EMPTY_RESULT;
                }
                iJavaElementArray[n] = (IJavaElement)e;
                ++n;
            }
            return iJavaElementArray;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(JavaEditor javaEditor) {
        if (javaEditor == null) {
            return false;
        }
        return SelectionConverter.getInput(javaEditor) != null;
    }

    public static IJavaElement[] codeResolveOrInputForked(JavaEditor javaEditor) throws InvocationTargetException, InterruptedException {
        ITextSelection iTextSelection;
        IJavaElement iJavaElement = SelectionConverter.getInput(javaEditor);
        IJavaElement[] iJavaElementArray = SelectionConverter.performForkedCodeResolve(iJavaElement, iTextSelection = (ITextSelection)javaEditor.getSelectionProvider().getSelection());
        if (iJavaElementArray.length == 0) {
            iJavaElementArray = new IJavaElement[]{iJavaElement};
        }
        return iJavaElementArray;
    }

    public static IJavaElement[] codeResolve(JavaEditor javaEditor) throws JavaModelException {
        return SelectionConverter.codeResolve(javaEditor, true);
    }

    public static IJavaElement[] codeResolve(JavaEditor javaEditor, boolean bl) throws JavaModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(javaEditor, bl), (ITextSelection)javaEditor.getSelectionProvider().getSelection());
    }

    public static IJavaElement[] codeResolveForked(JavaEditor javaEditor, boolean bl) throws InvocationTargetException, InterruptedException {
        return SelectionConverter.performForkedCodeResolve(SelectionConverter.getInput(javaEditor, bl), (ITextSelection)javaEditor.getSelectionProvider().getSelection());
    }

    public static IJavaElement getElementAtOffset(JavaEditor javaEditor) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(javaEditor, true);
    }

    private static IJavaElement getElementAtOffset(JavaEditor javaEditor, boolean bl) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(javaEditor, bl), (ITextSelection)javaEditor.getSelectionProvider().getSelection());
    }

    public static IType getTypeAtOffset(JavaEditor javaEditor) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        IJavaElement iJavaElement = SelectionConverter.getElementAtOffset(javaEditor);
        IType iType = (IType)iJavaElement.getAncestor(7);
        if (iType == null && (iCompilationUnit = SelectionConverter.getInputAsCompilationUnit(javaEditor)) != null) {
            iType = iCompilationUnit.findPrimaryType();
        }
        return iType;
    }

    public static IJavaElement getInput(JavaEditor javaEditor) {
        return SelectionConverter.getInput(javaEditor, true);
    }

    private static IJavaElement getInput(JavaEditor javaEditor, boolean bl) {
        if (javaEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputJavaElement((IEditorPart)javaEditor, bl);
    }

    public static ITypeRoot getInputAsTypeRoot(JavaEditor javaEditor) {
        IJavaElement iJavaElement = SelectionConverter.getInput(javaEditor);
        if (iJavaElement instanceof ITypeRoot) {
            return (ITypeRoot)iJavaElement;
        }
        return null;
    }

    public static ICompilationUnit getInputAsCompilationUnit(JavaEditor javaEditor) {
        IJavaElement iJavaElement = SelectionConverter.getInput(javaEditor);
        if (iJavaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)iJavaElement;
        }
        return null;
    }

    public static IClassFile getInputAsClassFile(JavaEditor javaEditor) {
        IJavaElement iJavaElement = SelectionConverter.getInput(javaEditor);
        if (iJavaElement instanceof IClassFile) {
            return (IClassFile)iJavaElement;
        }
        return null;
    }

    private static IJavaElement[] performForkedCodeResolve(IJavaElement iJavaElement, ITextSelection iTextSelection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IJavaElement[] result;
            private final /* synthetic */ IJavaElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IJavaElement iJavaElement, ITextSelection iTextSelection) {
                this.val$input = iJavaElement;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (JavaModelException javaModelException) {
                    throw new InvocationTargetException(javaModelException);
                }
            }
        }
        CodeResolveRunnable codeResolveRunnable = new CodeResolveRunnable(iJavaElement, iTextSelection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)codeResolveRunnable);
        return codeResolveRunnable.result;
    }

    public static IJavaElement[] codeResolve(IJavaElement iJavaElement, ITextSelection iTextSelection) throws JavaModelException {
        if (iJavaElement instanceof ICodeAssist) {
            IJavaElement[] iJavaElementArray;
            if (iJavaElement instanceof ICompilationUnit) {
                JavaModelUtil.reconcile((ICompilationUnit)iJavaElement);
            }
            if ((iJavaElementArray = ((ICodeAssist)iJavaElement).codeSelect(iTextSelection.getOffset() + iTextSelection.getLength(), 0)).length > 0) {
                return iJavaElementArray;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(IJavaElement iJavaElement, ITextSelection iTextSelection) throws JavaModelException {
        if (iJavaElement instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
            JavaModelUtil.reconcile(iCompilationUnit);
            IJavaElement iJavaElement2 = iCompilationUnit.getElementAt(iTextSelection.getOffset());
            if (iJavaElement2 == null) {
                return iJavaElement;
            }
            return iJavaElement2;
        }
        if (iJavaElement instanceof IClassFile) {
            IJavaElement iJavaElement3 = ((IClassFile)iJavaElement).getElementAt(iTextSelection.getOffset());
            if (iJavaElement3 == null) {
                return iJavaElement;
            }
            return iJavaElement3;
        }
        return null;
    }

    public static IJavaElement resolveEnclosingElement(JavaEditor javaEditor, ITextSelection iTextSelection) throws JavaModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput(javaEditor), iTextSelection);
    }

    public static IJavaElement resolveEnclosingElement(IJavaElement iJavaElement, ITextSelection iTextSelection) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        IJavaElement iJavaElement2 = null;
        if (iJavaElement instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)iJavaElement;
            JavaModelUtil.reconcile(iCompilationUnit);
            iJavaElement2 = iCompilationUnit.getElementAt(iTextSelection.getOffset());
        } else if (iJavaElement instanceof IClassFile) {
            iCompilationUnit = (IClassFile)iJavaElement;
            iJavaElement2 = iCompilationUnit.getElementAt(iTextSelection.getOffset());
        } else {
            return null;
        }
        if (iJavaElement2 == null) {
            return iJavaElement;
        }
        int n = iTextSelection.getOffset() + iTextSelection.getLength();
        IJavaElement iJavaElement3 = iJavaElement2;
        if (iJavaElement2 instanceof ISourceReference) {
            ISourceRange iSourceRange = ((ISourceReference)iJavaElement2).getSourceRange();
            while (iSourceRange.getOffset() + iSourceRange.getLength() < n) {
                if (!((iJavaElement3 = iJavaElement3.getParent()) instanceof ISourceReference)) {
                    iJavaElement3 = iJavaElement;
                    break;
                }
                iSourceRange = ((ISourceReference)iJavaElement3).getSourceRange();
            }
        }
        return iJavaElement3;
    }

    public static IJavaElement selectJavaElement(IJavaElement[] iJavaElementArray, Shell shell, String string, String string2) {
        int n = iJavaElementArray.length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return iJavaElementArray[0];
        }
        int n2 = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(n2));
        elementListSelectionDialog.setTitle(string);
        elementListSelectionDialog.setMessage(string2);
        elementListSelectionDialog.setElements((Object[])iJavaElementArray);
        if (elementListSelectionDialog.open() == 0) {
            return (IJavaElement)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }
}

