/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.QuickTemplateProcessor;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SurroundWithTryCatchAction;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class SurroundWithTemplateMenuAction
implements IWorkbenchWindowPulldownDelegate2 {
    public static final String SURROUND_WITH_QUICK_MENU_ACTION_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.surround.with.quickMenu";
    private static final String JAVA_TEMPLATE_PREFERENCE_PAGE_ID = "org.eclipse.wst.jsdt.ui.preferences.JavaTemplatePreferencePage";
    private static final String TEMPLATE_GROUP = "templateGroup";
    private static final String CONFIG_GROUP = "configGroup";
    private static Action NONE_APPLICABLE_ACTION = new Action(ActionMessages.SurroundWithTemplateMenuAction_NoneApplicable){

        public void run() {
        }

        public boolean isEnabled() {
            return false;
        }
    };
    private Menu fMenu;
    private IPartService fPartService;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
            SurroundWithTemplateMenuAction.this.disposeMenuItems();
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };

    protected void disposeMenuItems() {
        if (this.fMenu == null || this.fMenu.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = this.fMenu.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            if (!menuItem.isDisposed()) {
                menuItem.dispose();
            }
            ++n;
        }
    }

    public Menu getMenu(Menu menu) {
        this.setMenu(new Menu(menu));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Control control) {
        this.setMenu(new Menu(control));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public static void fillMenu(IMenuManager iMenuManager, CompilationUnitEditor compilationUnitEditor) {
        IAction[] iActionArray = SurroundWithTemplateMenuAction.getTemplateActions(compilationUnitEditor);
        if (iActionArray == null) {
            iMenuManager.add((IAction)NONE_APPLICABLE_ACTION);
        } else {
            iMenuManager.add((IContributionItem)new Separator(TEMPLATE_GROUP));
            if (iActionArray == null) {
                iMenuManager.add((IAction)NONE_APPLICABLE_ACTION);
            } else {
                int n = 0;
                while (n < iActionArray.length) {
                    iMenuManager.add(iActionArray[n]);
                    ++n;
                }
            }
        }
        iMenuManager.add((IContributionItem)new Separator(CONFIG_GROUP));
        iMenuManager.add((IAction)new ConfigureTemplatesAction());
    }

    public void dispose() {
        if (this.fPartService != null) {
            this.fPartService.removePartListener(this.fPartListener);
            this.fPartService = null;
        }
        this.setMenu(null);
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        IPartService iPartService;
        if (this.fPartService != null) {
            this.fPartService.removePartListener(this.fPartListener);
            this.fPartService = null;
        }
        if (iWorkbenchWindow != null && (iPartService = iWorkbenchWindow.getPartService()) != null) {
            this.fPartService = iPartService;
            iPartService.addPartListener(this.fPartListener);
        }
    }

    public void run(IAction iAction) {
        IWorkbenchPart iWorkbenchPart = JavaPlugin.getActivePage().getActivePart();
        if (!(iWorkbenchPart instanceof CompilationUnitEditor)) {
            return;
        }
        final CompilationUnitEditor compilationUnitEditor = (CompilationUnitEditor)iWorkbenchPart;
        new JDTQuickMenuAction(compilationUnitEditor, SURROUND_WITH_QUICK_MENU_ACTION_ID){

            protected void fillMenu(IMenuManager iMenuManager) {
                SurroundWithTemplateMenuAction.fillMenu(iMenuManager, compilationUnitEditor);
            }
        }.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    protected void fillMenu(Menu menu) {
        ActionContributionItem actionContributionItem;
        ActionContributionItem actionContributionItem2;
        IWorkbenchPart iWorkbenchPart = JavaPlugin.getActivePage().getActivePart();
        if (!(iWorkbenchPart instanceof CompilationUnitEditor)) {
            ActionContributionItem actionContributionItem3 = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            actionContributionItem3.fill(menu, -1);
            return;
        }
        CompilationUnitEditor compilationUnitEditor = (CompilationUnitEditor)iWorkbenchPart;
        IAction[] iActionArray = SurroundWithTemplateMenuAction.getTemplateActions(compilationUnitEditor);
        SurroundWithTryCatchAction surroundWithTryCatchAction = SurroundWithTemplateMenuAction.createSurroundWithTryCatchAction(compilationUnitEditor);
        ActionContributionItem actionContributionItem4 = new ActionContributionItem((IAction)surroundWithTryCatchAction);
        actionContributionItem4.fill(menu, -1);
        Separator separator = new Separator(TEMPLATE_GROUP);
        separator.fill(menu, -1);
        if (iActionArray == null || iActionArray.length == 0) {
            actionContributionItem2 = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            actionContributionItem2.fill(menu, -1);
        } else {
            int n = 0;
            while (n < iActionArray.length) {
                actionContributionItem = new ActionContributionItem(iActionArray[n]);
                actionContributionItem.fill(menu, -1);
                ++n;
            }
        }
        actionContributionItem2 = new Separator(CONFIG_GROUP);
        actionContributionItem2.fill(menu, -1);
        actionContributionItem = new ActionContributionItem((IAction)new ConfigureTemplatesAction());
        actionContributionItem.fill(menu, -1);
    }

    private static SurroundWithTryCatchAction createSurroundWithTryCatchAction(CompilationUnitEditor compilationUnitEditor) {
        SurroundWithTryCatchAction surroundWithTryCatchAction = new SurroundWithTryCatchAction(compilationUnitEditor);
        surroundWithTryCatchAction.setText(ActionMessages.SurroundWithTemplateMenuAction_SurroundWithTryCatchActionName);
        surroundWithTryCatchAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.surround.with.try.catch");
        compilationUnitEditor.setAction("SurroundWithTryCatch", (IAction)surroundWithTryCatchAction);
        return surroundWithTryCatchAction;
    }

    protected void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.widget;
                MenuItem[] menuItemArray = menu.getItems();
                int n = 0;
                while (n < menuItemArray.length) {
                    menuItemArray[n].dispose();
                    ++n;
                }
                SurroundWithTemplateMenuAction.this.fillMenu(menu);
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    private static IAction[] getTemplateActions(JavaEditor javaEditor) {
        IJavaCompletionProposal[] iJavaCompletionProposalArray;
        AssistContext assistContext;
        block7: {
            ISelectionProvider iSelectionProvider = javaEditor.getSelectionProvider();
            if (iSelectionProvider == null) {
                return null;
            }
            ISelection iSelection = iSelectionProvider.getSelection();
            if (!(iSelection instanceof ITextSelection)) {
                return null;
            }
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            if (iTextSelection.getLength() == 0) {
                return null;
            }
            ICompilationUnit iCompilationUnit = JavaUI.getWorkingCopyManager().getWorkingCopy(javaEditor.getEditorInput());
            if (iCompilationUnit == null) {
                return null;
            }
            QuickTemplateProcessor quickTemplateProcessor = new QuickTemplateProcessor();
            assistContext = new AssistContext(iCompilationUnit, iTextSelection.getOffset(), iTextSelection.getLength());
            try {
                iJavaCompletionProposalArray = quickTemplateProcessor.getAssists(assistContext, null);
                if (iJavaCompletionProposalArray != null && iJavaCompletionProposalArray.length != 0) break block7;
                return null;
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                return null;
            }
        }
        return SurroundWithTemplateMenuAction.getActionsFromProposals(iJavaCompletionProposalArray, assistContext.getSelectionOffset(), (ITextViewer)javaEditor.getViewer());
    }

    private static IAction[] getActionsFromProposals(IJavaCompletionProposal[] iJavaCompletionProposalArray, final int n, final ITextViewer iTextViewer) {
        ArrayList<5> arrayList = new ArrayList<5>();
        int n2 = 0;
        int n3 = 1;
        while (n2 < iJavaCompletionProposalArray.length) {
            if (iJavaCompletionProposalArray[n2] instanceof ICompletionProposalExtension2) {
                final IJavaCompletionProposal iJavaCompletionProposal = iJavaCompletionProposalArray[n2];
                StringBuffer stringBuffer = new StringBuffer();
                if (n3 < 10) {
                    stringBuffer.append('&').append(n3).append(' ');
                }
                stringBuffer.append(iJavaCompletionProposalArray[n2].getDisplayString());
                Action action = new Action(stringBuffer.toString()){

                    public void run() {
                        SurroundWithTemplateMenuAction.applyProposal(iJavaCompletionProposal, iTextViewer, '\u0000', 0, n);
                    }
                };
                arrayList.add(action);
                ++n3;
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new IAction[arrayList.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void applyProposal(ICompletionProposal iCompletionProposal, ITextViewer iTextViewer, char c, int n, final int n2) {
        IEditingSupport iEditingSupport;
        IEditingSupportRegistry iEditingSupportRegistry;
        block8: {
            Assert.isTrue((boolean)(iCompletionProposal instanceof ICompletionProposalExtension2));
            IRewriteTarget iRewriteTarget = null;
            iEditingSupportRegistry = null;
            iEditingSupport = new IEditingSupport(){

                public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
                    return iRegion.getOffset() <= n2 && iRegion.getOffset() + iRegion.getLength() >= n2;
                }

                public boolean ownsFocusShell() {
                    return false;
                }
            };
            try {
                ITextViewerExtension iTextViewerExtension;
                IDocument iDocument = iTextViewer.getDocument();
                if (iTextViewer instanceof ITextViewerExtension) {
                    iTextViewerExtension = (ITextViewerExtension)iTextViewer;
                    iRewriteTarget = iTextViewerExtension.getRewriteTarget();
                }
                if (iRewriteTarget != null) {
                    iRewriteTarget.beginCompoundChange();
                }
                if (iTextViewer instanceof IEditingSupportRegistry) {
                    iEditingSupportRegistry = (IEditingSupportRegistry)iTextViewer;
                    iEditingSupportRegistry.register(iEditingSupport);
                }
                ((ICompletionProposalExtension2)iCompletionProposal).apply(iTextViewer, c, n, n2);
                iTextViewerExtension = iCompletionProposal.getSelection(iDocument);
                if (iTextViewerExtension != null) {
                    iTextViewer.setSelectedRange(iTextViewerExtension.x, iTextViewerExtension.y);
                    iTextViewer.revealRange(iTextViewerExtension.x, iTextViewerExtension.y);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (iRewriteTarget != null) {
                    iRewriteTarget.endCompoundChange();
                }
                if (iEditingSupportRegistry == null) throw throwable;
                iEditingSupportRegistry.unregister(iEditingSupport);
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (iRewriteTarget == null) break block8;
            }
            iRewriteTarget.endCompoundChange();
        }
        if (iEditingSupportRegistry == null) return;
        iEditingSupportRegistry.unregister(iEditingSupport);
    }

    private static class ConfigureTemplatesAction
    extends Action {
        public ConfigureTemplatesAction() {
            super(ActionMessages.SurroundWithTemplateMenuAction_ConfigureTemplatesActionName);
        }

        public void run() {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)SurroundWithTemplateMenuAction.JAVA_TEMPLATE_PREFERENCE_PAGE_ID, (String[])new String[]{SurroundWithTemplateMenuAction.JAVA_TEMPLATE_PREFERENCE_PAGE_ID}, null).open();
        }

        private Shell getShell() {
            return JavaPlugin.getActiveWorkbenchWindow().getShell();
        }
    }
}

