/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingContentProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaElementTypeComparator;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.MembersView;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesView;
import org.eclipse.wst.jsdt.internal.ui.browsing.PatchedOpenInNewWindowAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.ToggleLinkingAction;
import org.eclipse.wst.jsdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.BuildActionGroup;
import org.eclipse.wst.jsdt.ui.actions.CCPActionGroup;
import org.eclipse.wst.jsdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.ImportActionGroup;
import org.eclipse.wst.jsdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenViewActionGroup;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

abstract class JavaBrowsingPart
extends ViewPart
implements IMenuListener,
ISelectionListener,
IViewPartInputProvider {
    private static final String TAG_SELECTED_ELEMENTS = "selectedElements";
    private static final String TAG_SELECTED_ELEMENT = "selectedElement";
    private static final String TAG_LOGICAL_PACKAGE = "logicalPackage";
    private static final String TAG_SELECTED_ELEMENT_PATH = "selectedElementPath";
    private JavaUILabelProvider fLabelProvider;
    private ILabelProvider fTitleProvider;
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private JavaElementTypeComparator fTypeComparator;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private boolean fHasWorkingSetFilter = true;
    private boolean fHasCustomFilter = true;
    private OpenEditorActionGroup fOpenEditorGroup;
    private CCPActionGroup fCCPActionGroup;
    private BuildActionGroup fBuildActionGroup;
    private ToggleLinkingAction fToggleLinkingAction;
    protected CompositeActionGroup fActionGroups;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getId() == JavaBrowsingPart.this.getSite().getId()) {
                JavaBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage iWorkbenchPage = JavaBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    JavaBrowsingPart.this.selectionChanged(iWorkbenchPage.getActivePart(), iWorkbenchPage.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getId() == JavaBrowsingPart.this.getSite().getId()) {
                JavaBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JavaBrowsingPart() {
        this.initLinkingEnabled();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.fMemento = iMemento;
    }

    public void saveState(IMemento iMemento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                iMemento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.saveState(iMemento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.saveState(iMemento);
        }
        this.saveSelectionState(iMemento);
        this.saveLinkingEnabled(iMemento);
    }

    private void saveLinkingEnabled(IMemento iMemento) {
        iMemento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    private void saveSelectionState(IMemento iMemento) {
        Object[] objectArray = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (objectArray.length > 0) {
            IMemento iMemento2 = iMemento.createChild(TAG_SELECTED_ELEMENTS);
            int n = 0;
            while (n < objectArray.length) {
                IMemento iMemento3 = iMemento2.createChild(TAG_SELECTED_ELEMENT);
                Object object = objectArray[n];
                if (object instanceof IJavaElement) {
                    iMemento3.putString(TAG_SELECTED_ELEMENT_PATH, ((IJavaElement)objectArray[n]).getHandleIdentifier());
                } else if (object instanceof LogicalPackage) {
                    IPackageFragment[] iPackageFragmentArray = ((LogicalPackage)((Object)object)).getFragments();
                    int n2 = 0;
                    while (n2 < iPackageFragmentArray.length) {
                        IMemento iMemento4 = iMemento3.createChild(TAG_LOGICAL_PACKAGE);
                        iMemento4.putString(TAG_SELECTED_ELEMENT_PATH, iPackageFragmentArray[n2].getHandleIdentifier());
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    protected void restoreState(IMemento iMemento) {
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.restoreState(iMemento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.restoreState(iMemento);
        }
        if (this.fHasCustomFilter || this.fHasWorkingSetFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private ISelection restoreSelectionState(IMemento iMemento) {
        if (iMemento == null) {
            return null;
        }
        IMemento iMemento2 = iMemento.getChild(TAG_SELECTED_ELEMENTS);
        if (iMemento2 != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IMemento[] iMementoArray = iMemento2.getChildren(TAG_SELECTED_ELEMENT);
            int n = 0;
            while (n < iMementoArray.length) {
                IMemento[] iMementoArray2;
                String string = iMementoArray[n].getString(TAG_SELECTED_ELEMENT_PATH);
                if (string == null) {
                    iMementoArray2 = iMementoArray[n].getChildren(TAG_LOGICAL_PACKAGE);
                    LogicalPackage logicalPackage = null;
                    int n2 = 0;
                    while (n2 < iMementoArray2.length) {
                        string = iMementoArray2[n2].getString(TAG_SELECTED_ELEMENT_PATH);
                        IJavaElement iJavaElement = JavaCore.create((String)string);
                        if (iJavaElement instanceof IPackageFragment && ((IPackageFragment)iJavaElement).exists()) {
                            if (logicalPackage == null) {
                                logicalPackage = new LogicalPackage((IPackageFragment)iJavaElement);
                            } else {
                                logicalPackage.add((IPackageFragment)iJavaElement);
                            }
                        }
                        ++n2;
                    }
                    if (logicalPackage != null) {
                        arrayList.add((Object)logicalPackage);
                    }
                } else {
                    iMementoArray2 = JavaCore.create((String)string);
                    if (iMementoArray2 != null && iMementoArray2.exists()) {
                        arrayList.add(iMementoArray2);
                    }
                }
                ++n;
            }
            return new StructuredSelection(arrayList);
        }
        return null;
    }

    private void restoreLinkingEnabled(IMemento iMemento) {
        Integer n = iMemento.getInteger(this.getLinkToEditorKey());
        if (n != null) {
            this.fLinkingEnabled = n != 0;
        }
    }

    public void createPartControl(Composite composite) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fTypeComparator = new JavaElementTypeComparator();
        this.fViewer = this.createViewer(composite);
        this.initDragAndDrop();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(this.fLabelProvider));
        this.fViewer.setComparator((ViewerComparator)this.createJavaElementComparator());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        this.addKeyListener();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.createStatusBarUpdater(iStatusLineManager));
        this.hookViewerListeners();
        this.addFilters();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.fMemento = null;
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.fillActionBars(this.getViewSite().getActionBars());
        this.setHelp();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, this.getHelpContextId());
        }
        return super.getAdapter(clazz);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, JavaBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected DecoratingJavaLabelProvider createDecoratingLabelProvider(JavaUILabelProvider javaUILabelProvider) {
        return new DecoratingJavaLabelProvider(javaUILabelProvider);
    }

    protected JavaElementComparator createJavaElementComparator() {
        return new JavaElementComparator();
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager iStatusLineManager) {
        return new StatusBarUpdater(iStatusLineManager);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    protected void initDragAndDrop() {
        int n = 7;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance()};
        TransferDropTargetListener[] transferDropTargetListenerArray = new TransferDropTargetListener[]{new SelectionTransferDropAdapter(this.fViewer)};
        this.fViewer.addDropSupport(n | 0x10, transferArray, (DropTargetListener)new DelegatingDropAdapter(transferDropTargetListenerArray));
        Transfer[] transferArray2 = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] transferDragSourceListenerArray = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(n, transferArray2, (DragSourceListener)new JdtViewerDragAdapter(this.fViewer, transferDragSourceListenerArray));
    }

    protected void fillActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.fillToolBar(iToolBarManager);
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
        iActionBars.updateActionBars();
        this.fActionGroups.fillActionBars(iActionBars);
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.fillActionBars(iActionBars);
        }
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.fToggleLinkingAction);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fWorkingSetFilterActionGroup != null) {
            this.fWorkingSetFilterActionGroup.dispose();
        }
        super.dispose();
    }

    protected void addKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JavaBrowsingPart.this.handleKeyReleased(keyEvent);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent keyEvent) {
        IAction iAction;
        if (keyEvent.stateMask != 0) {
            return;
        }
        int n = keyEvent.keyCode;
        if (n == 0x100000E && (iAction = this.fBuildActionGroup.getRefreshAction()).isEnabled()) {
            iAction.run();
        }
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        JavaPlugin.createStandardGroups(iMenuManager);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        int n = iStructuredSelection.size();
        Object object = iStructuredSelection.getFirstElement();
        if (n == 1) {
            this.addOpenNewWindowAction(iMenuManager, object);
        }
        this.fActionGroups.setContext(new ActionContext((ISelection)iStructuredSelection));
        this.fActionGroups.fillContextMenu(iMenuManager);
        this.fActionGroups.setContext(null);
    }

    private void addOpenNewWindowAction(IMenuManager iMenuManager, Object object) {
        if (object instanceof IJavaElement) {
            object = ((IJavaElement)object).getResource();
        }
        if (!(object instanceof IContainer)) {
            return;
        }
        iMenuManager.appendToGroup("group.open", (IAction)new PatchedOpenInNewWindowAction(this.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    protected void createActions() {
        ActionGroup[] actionGroupArray = new ActionGroup[9];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)this.getSite());
        this.fOpenEditorGroup = new OpenEditorActionGroup((IViewPart)this);
        actionGroupArray[1] = this.fOpenEditorGroup;
        actionGroupArray[2] = new OpenViewActionGroup((IViewPart)this);
        this.fCCPActionGroup = new CCPActionGroup((IViewPart)this);
        actionGroupArray[3] = this.fCCPActionGroup;
        actionGroupArray[4] = new GenerateActionGroup((IViewPart)this);
        actionGroupArray[5] = new RefactorActionGroup((IViewPart)this);
        actionGroupArray[6] = new ImportActionGroup((IViewPart)this);
        this.fBuildActionGroup = new BuildActionGroup((IViewPart)this);
        actionGroupArray[7] = this.fBuildActionGroup;
        actionGroupArray[8] = new JavaSearchActionGroup((IViewPart)this);
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        if (this.fHasWorkingSetFilter) {
            String string = this.getConfigurationElement().getAttribute("id");
            Assert.isNotNull((Object)string);
            IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JavaBrowsingPart.this.doWorkingSetChanged(propertyChangeEvent);
                }
            };
            this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getSite(), iPropertyChangeListener);
            this.fViewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this, this.fViewer);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
    }

    private void doWorkingSetChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("workingSetNameChange".equals(string)) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(string)) {
            this.updateTitle();
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean isValidElement(Object object) {
        if (!(object instanceof IJavaElement)) {
            return false;
        }
        Object object2 = this.getViewer().getInput();
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Collection) {
            return ((Collection)object2).contains(object);
        }
        return object2.equals(object);
    }

    private boolean isInputResetBy(Object object, Object object2, IWorkbenchPart iWorkbenchPart) {
        if (object == null) {
            return iWorkbenchPart == this.fPreviousSelectionProvider;
        }
        if (object2 instanceof IJavaElement && object instanceof IJavaElement) {
            return this.getTypeComparator().compare(object, object2) > 0;
        }
        return object instanceof List && iWorkbenchPart instanceof PackagesView;
    }

    private boolean isInputResetBy(IWorkbenchPart iWorkbenchPart) {
        if (!(iWorkbenchPart instanceof JavaBrowsingPart)) {
            return true;
        }
        Object object = this.getViewer().getInput();
        Object object2 = ((JavaBrowsingPart)iWorkbenchPart).getViewer().getInput();
        if (object instanceof Collection) {
            object = ((Collection)object).iterator().next();
        }
        if (object2 instanceof Collection) {
            object2 = ((Collection)object2).iterator().next();
        }
        if (object instanceof IJavaElement && object2 instanceof IJavaElement) {
            return this.getTypeComparator().compare(object2, object) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object object, Object object2) {
        if (object2 instanceof IJavaElement && object instanceof IJavaElement) {
            return !object2.equals(object) && this.internalIsAncestorOf((IJavaElement)object, (IJavaElement)object2);
        }
        return false;
    }

    private boolean internalIsAncestorOf(IJavaElement iJavaElement, IJavaElement iJavaElement2) {
        if (iJavaElement2 != null) {
            return iJavaElement2.equals(iJavaElement) || this.internalIsAncestorOf(iJavaElement, iJavaElement2.getParent());
        }
        return false;
    }

    private boolean isSearchResultView(IWorkbenchPart iWorkbenchPart) {
        return SearchUtil.isSearchPlugInActivated() && iWorkbenchPart instanceof ISearchResultViewPart;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.fProcessSelectionEvents || iWorkbenchPart == this || this.isSearchResultView(iWorkbenchPart) || iWorkbenchPart instanceof AbstractInfoView) {
            if (iWorkbenchPart == this) {
                this.fPreviousSelectionProvider = iWorkbenchPart;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.needsToProcessSelectionChanged(iWorkbenchPart, iSelection)) {
            return;
        }
        if (this.fToggleLinkingAction.isChecked() && iWorkbenchPart instanceof ITextEditor) {
            this.setSelectionFromEditor(iWorkbenchPart, iSelection);
            return;
        }
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        Object object = this.getSingleElementFromSelection(iSelection);
        if (object != null && (iWorkbenchPart == null || iWorkbenchPart.equals(this.fPreviousSelectionProvider)) && object.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = object;
        Object object2 = this.getViewer().getInput();
        if (object != null && object.equals(object2)) {
            IJavaElement iJavaElement = this.findElementToSelect(object);
            if (iJavaElement != null && this.getTypeComparator().compare(object, iJavaElement) < 0) {
                this.setSelection((ISelection)new StructuredSelection((Object)iJavaElement), true);
            } else if (iJavaElement == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (iWorkbenchPart != this.fPreviousSelectionProvider && object != null && !object.equals(object2) && this.isInputResetBy(object, object2, iWorkbenchPart)) {
            if (!this.isAncestorOf(object, object2)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (iSelection.isEmpty() && !this.isInputResetBy(iWorkbenchPart)) {
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (object == null && iWorkbenchPart == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        this.fPreviousSelectionProvider = iWorkbenchPart;
        this.adjustInputAndSetSelection(object);
    }

    void setHasWorkingSetFilter(boolean bl) {
        this.fHasWorkingSetFilter = bl;
    }

    void setHasCustomSetFilter(boolean bl) {
        this.fHasCustomFilter = bl;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    protected void setInput(Object object) {
        this.setViewerInput(object);
        this.updateTitle();
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private void setViewerInput(Object object) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(object);
        this.fProcessSelectionEvents = true;
    }

    void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object object) {
        IPath iPath;
        String string = !(object instanceof IResource) ? JavaElementLabels.getTextLabel(object, 36283885813801L) : ((iPath = ((IResource)object).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : iPath.makeRelative().toString());
        if (this.fWorkingSetFilterActionGroup == null || this.fWorkingSetFilterActionGroup.getWorkingSet() == null) {
            return string;
        }
        iPath = this.fWorkingSetFilterActionGroup.getWorkingSet();
        String string2 = Messages.format(JavaBrowsingMessages.JavaBrowsingPart_toolTip, new String[]{iPath.getLabel()});
        if (string.length() == 0) {
            return string2;
        }
        return Messages.format(JavaBrowsingMessages.JavaBrowsingPart_toolTip2, new String[]{string, iPath.getLabel()});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected final void setViewer(StructuredViewer structuredViewer) {
        this.fViewer = structuredViewer;
    }

    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(36283885813801L, 3);
    }

    protected ILabelProvider createTitleProvider() {
        return new JavaElementLabelProvider(256);
    }

    protected final ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final ILabelProvider getTitleProvider() {
        return this.fTitleProvider;
    }

    protected StructuredViewer createViewer(Composite composite) {
        return new ProblemTableViewer(composite, 2);
    }

    protected int getLabelProviderFlags() {
        return 786;
    }

    protected void addFilters() {
    }

    protected IContentProvider createContentProvider() {
        return new JavaBrowsingContentProvider(true, this);
    }

    protected void setInitialInput() {
        ISelection iSelection = this.getSite().getPage().getSelection();
        Object object = this.getSingleElementFromSelection(iSelection);
        if (!(object instanceof IJavaElement) && !((object = this.getSite().getPage().getInput()) instanceof IJavaElement) && object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = iAdaptable.getAdapter((Class)clazz);
        }
        this.setInput(this.findInputForJavaElement((IJavaElement)object));
    }

    protected void setInitialSelection() {
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        ISelection iSelection = null;
        if (iWorkbenchPage != null) {
            iSelection = iWorkbenchPage.getSelection();
        }
        if (iSelection instanceof ITextSelection && (iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)iWorkbenchPart));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (iSelection == null || iSelection.isEmpty()) {
            iSelection = this.restoreSelectionState(this.fMemento);
        }
        if (iSelection == null || iSelection.isEmpty()) {
            Object object = this.getSite().getPage().getInput();
            if (!(object instanceof IJavaElement)) {
                if (object instanceof IAdaptable) {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    object = object.getAdapter((Class)clazz);
                } else {
                    return;
                }
            }
            iSelection = new StructuredSelection(object);
        }
        this.selectionChanged(null, iSelection);
    }

    protected final void setHelp() {
        JavaUIHelp.setHelp(this.fViewer, this.getHelpContextId());
    }

    protected abstract String getHelpContextId();

    protected abstract String getLinkToEditorKey();

    protected void hookViewerListeners() {
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (!JavaBrowsingPart.this.fProcessSelectionEvents) {
                    return;
                }
                JavaBrowsingPart.this.fPreviousSelectedElement = JavaBrowsingPart.this.getSingleElementFromSelection(selectionChangedEvent.getSelection());
                IWorkbenchPage iWorkbenchPage = JavaBrowsingPart.this.getSite().getPage();
                if (iWorkbenchPage == null) {
                    return;
                }
                if (iWorkbenchPage.equals(JavaPlugin.getActivePage()) && JavaBrowsingPart.this.equals(iWorkbenchPage.getActivePart())) {
                    JavaBrowsingPart.this.linkToEditor((IStructuredSelection)selectionChangedEvent.getSelection());
                }
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                IAction iAction = JavaBrowsingPart.this.fOpenEditorGroup.getOpenAction();
                if (iAction.isEnabled()) {
                    iAction.run();
                    JavaBrowsingPart.this.restoreSelection();
                }
            }
        });
    }

    void restoreSelection() {
    }

    void adjustInputAndSetSelection(Object object) {
        if (!(object instanceof IJavaElement)) {
            if (object == null) {
                this.setInput(null);
            }
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        IJavaElement iJavaElement2 = this.findElementToSelect(iJavaElement);
        IJavaElement iJavaElement3 = this.findInputForJavaElement(iJavaElement);
        IJavaElement iJavaElement4 = null;
        if (this.getInput() instanceof IJavaElement) {
            iJavaElement4 = (IJavaElement)this.getInput();
        }
        if (iJavaElement2 == null && !this.isValidInput(iJavaElement3) && iJavaElement3 == null && !this.isAncestorOf(iJavaElement, iJavaElement4)) {
            this.setInput(null);
        } else if (this.mustSetNewInput(iJavaElement2, iJavaElement4, iJavaElement3)) {
            this.setInput(iJavaElement3);
        }
        if (iJavaElement2 != null && iJavaElement2.exists()) {
            this.setSelection((ISelection)new StructuredSelection((Object)iJavaElement2), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    private boolean mustSetNewInput(IJavaElement iJavaElement, IJavaElement iJavaElement2, IJavaElement iJavaElement3) {
        return !(iJavaElement3 != null && iJavaElement3.equals(iJavaElement2) || iJavaElement != null && iJavaElement2 != null && iJavaElement instanceof IPackageDeclaration && iJavaElement.getParent().equals(iJavaElement2.getParent()) && !this.isAncestorOf(this.getViewPartInput(), iJavaElement));
    }

    protected IJavaElement findInputForJavaElement(IJavaElement iJavaElement) {
        if (iJavaElement == null || !iJavaElement.exists()) {
            return null;
        }
        if (this.isValidInput(iJavaElement)) {
            return iJavaElement;
        }
        return this.findInputForJavaElement(iJavaElement.getParent());
    }

    protected final IJavaElement findElementToSelect(Object object) {
        if (object instanceof IJavaElement) {
            return this.findElementToSelect((IJavaElement)object);
        }
        return null;
    }

    protected abstract IJavaElement findElementToSelect(IJavaElement var1);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Object getSingleElementFromSelection(ISelection iSelection) {
        Object e;
        if (!(iSelection instanceof IStructuredSelection)) return null;
        if (iSelection.isEmpty()) {
            return null;
        }
        Iterator iterator = ((IStructuredSelection)iSelection).iterator();
        Object e2 = iterator.next();
        if (!(e2 instanceof IJavaElement)) {
            Class<?> clazz;
            IJavaElement iJavaElement;
            void var3_5;
            if (e2 instanceof IMarker) {
                IResource iResource = ((IMarker)e2).getResource();
            }
            if (!(var3_5 instanceof IAdaptable)) return var3_5;
            IAdaptable iAdaptable = (IAdaptable)var3_5;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$2 = clazz3;
            }
            if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz2)) != null) return iJavaElement;
            if (!(var3_5 instanceof IFile)) return iJavaElement;
            IContainer iContainer = ((IFile)var3_5).getParent();
            if (iContainer == null) return null;
            Class<?> clazz4 = class$2;
            Class<?> clazz5 = clazz4;
            if (clazz4 != null) return iContainer.getAdapter((Class)clazz5);
            try {
                clazz = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$2 = clazz;
            return iContainer.getAdapter((Class)clazz5);
        }
        Object object = this.getViewer().getInput();
        if (object == null || !object.equals(this.findInputForJavaElement((IJavaElement)e2))) {
            if (!iterator.hasNext()) return e2;
            return null;
        }
        do {
            if (!iterator.hasNext()) {
                return e2;
            }
            e = iterator.next();
            if (e instanceof IJavaElement) continue;
            return null;
        } while (object.equals(this.findInputForJavaElement((IJavaElement)e)));
        return null;
    }

    protected Comparator getTypeComparator() {
        return this.fTypeComparator;
    }

    private void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        Object object = iStructuredSelection.getFirstElement();
        if (iStructuredSelection.size() == 1 && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof IJavaElement) {
                EditorUtility.revealInEditor(iEditorPart, (IJavaElement)object);
            }
        }
    }

    void setSelectionFromEditor(IWorkbenchPart iWorkbenchPart) {
        if (!(this.fProcessSelectionEvents && this.linkBrowsingViewSelectionToEditor() && iWorkbenchPart instanceof IEditorPart)) {
            return;
        }
        IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
        if (iWorkbenchPartSite == null) {
            return;
        }
        ISelectionProvider iSelectionProvider = iWorkbenchPartSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.setSelectionFromEditor(iWorkbenchPart, iSelectionProvider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof IEditorPart) {
            Object object;
            IJavaElement iJavaElement = null;
            if (iSelection instanceof IStructuredSelection && (object = this.getSingleElementFromSelection(iSelection)) instanceof IJavaElement) {
                iJavaElement = (IJavaElement)object;
            }
            object = ((IEditorPart)iWorkbenchPart).getEditorInput();
            if (iSelection instanceof ITextSelection) {
                int n = ((ITextSelection)iSelection).getOffset();
                iJavaElement = this.getElementAt((IEditorInput)object, n);
            }
            if (iJavaElement != null) {
                this.adjustInputAndSetSelection(iJavaElement);
                return;
            }
            if (object instanceof IFileEditorInput) {
                IContainer iContainer;
                IJavaElement iJavaElement2;
                IFile iFile = ((IFileEditorInput)object).getFile();
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iJavaElement2 = (IJavaElement)iFile.getAdapter((Class)clazz)) == null && (iContainer = ((IFileEditorInput)object).getFile().getParent()) != null) {
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iJavaElement2 = (IJavaElement)iContainer.getAdapter((Class)clazz2);
                }
                if (iJavaElement2 == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(iJavaElement2);
            } else if (object instanceof IClassFileEditorInput) {
                IClassFile iClassFile = ((IClassFileEditorInput)object).getClassFile();
                this.adjustInputAndSetSelection(iClassFile);
            }
        }
    }

    Object getElementOfInput(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        if (iEditorInput != null) {
            return JavaUI.getEditorInputJavaElement(iEditorInput);
        }
        return null;
    }

    void setSelection(ISelection iSelection, boolean bl) {
        if (iSelection != null && iSelection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(iSelection, bl);
        this.fProcessSelectionEvents = true;
    }

    protected IJavaElement getElementAt(IEditorInput iEditorInput, int n) {
        if (iEditorInput instanceof IClassFileEditorInput) {
            try {
                return ((IClassFileEditorInput)iEditorInput).getClassFile().getElementAt(n);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit iCompilationUnit = workingCopyManager.getWorkingCopy(iEditorInput);
        if (iCompilationUnit != null) {
            try {
                if (iCompilationUnit.isConsistent()) {
                    return iCompilationUnit.getElementAt(n);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected IType getTypeForCU(ICompilationUnit iCompilationUnit) {
        IType iType = iCompilationUnit.findPrimaryType();
        if (iType != null) {
            return iType;
        }
        try {
            IType[] iTypeArray = iCompilationUnit.getTypes();
            if (iTypeArray.length > 0) {
                return iTypeArray[0];
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    void setProcessSelectionEvents(boolean bl) {
        this.fProcessSelectionEvents = bl;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected void setActionGroups(CompositeActionGroup compositeActionGroup) {
        this.fActionGroups = compositeActionGroup;
    }

    protected void setBuildActionGroup(BuildActionGroup buildActionGroup) {
        this.fBuildActionGroup = buildActionGroup;
    }

    protected void setCCPActionGroup(CCPActionGroup cCPActionGroup) {
        this.fCCPActionGroup = cCPActionGroup;
    }

    protected void setCustomFiltersActionGroup(CustomFiltersActionGroup customFiltersActionGroup) {
        this.fCustomFiltersActionGroup = customFiltersActionGroup;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected boolean hasWorkingSetFilter() {
        return this.fHasWorkingSetFilter;
    }

    protected void setOpenEditorGroup(OpenEditorActionGroup openEditorActionGroup) {
        this.fOpenEditorGroup = openEditorActionGroup;
    }

    protected OpenEditorActionGroup getOpenEditorGroup() {
        return this.fOpenEditorGroup;
    }

    protected BuildActionGroup getBuildActionGroup() {
        return this.fBuildActionGroup;
    }

    protected CCPActionGroup getCCPActionGroup() {
        return this.fCCPActionGroup;
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean bl) {
        IEditorPart iEditorPart;
        this.fLinkingEnabled = bl;
        PreferenceConstants.getPreferenceStore().setValue(this.getLinkToEditorKey(), bl);
        if (bl && (iEditorPart = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)iEditorPart);
        }
    }
}

