/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectAllAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackagesProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackageViewerWrapper;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewFlatContentProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewHierarchicalContentProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewTableViewer;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewTreeViewer;
import org.eclipse.wst.jsdt.internal.ui.filters.NonJavaElementFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class PackagesView
extends JavaBrowsingPart {
    private static final String TAG_VIEW_STATE = ".viewState";
    private static final int LIST_VIEW_STATE = 0;
    private static final int TREE_VIEW_STATE = 1;
    private SelectAllAction fSelectAllAction;
    private int fCurrViewState;
    private PackageViewerWrapper fWrappedViewer;
    private MultiActionGroup fSwitchActionGroup;
    private boolean fLastInputWasProject;
    static /* synthetic */ Class class$0;

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)this.createNonJavaElementFilter());
        this.getViewer().addFilter((ViewerFilter)new LibraryFilter());
    }

    protected NonJavaElementFilter createNonJavaElementFilter() {
        return new NonJavaElementFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return object2 instanceof IJavaElement || object2 instanceof LogicalPackage || object2 instanceof IFolder;
            }
        };
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.fWrappedViewer = new PackageViewerWrapper();
        this.restoreLayoutState(iMemento);
    }

    private void restoreLayoutState(IMemento iMemento) {
        if (iMemento == null) {
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            this.fCurrViewState = iPreferenceStore.getInt(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE);
        } else {
            Integer n = iMemento.getInteger(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE);
            this.fCurrViewState = n == null || !this.isValidState(n) ? 0 : n;
        }
    }

    private boolean isValidState(int n) {
        return n == 0 || n == 1;
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        iMemento.putInteger(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE, this.fCurrViewState);
    }

    protected StructuredViewer createViewer(Composite composite) {
        ResourceToItemsMapper.IContentViewerAccessor iContentViewerAccessor = this.isInListState() ? this.createTableViewer(composite) : this.createTreeViewer(composite);
        this.fWrappedViewer.setViewer((StructuredViewer)iContentViewerAccessor);
        return this.fWrappedViewer;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(clazz);
    }

    protected boolean isInListState() {
        return this.fCurrViewState == 0;
    }

    private ProblemTableViewer createTableViewer(Composite composite) {
        return new PackagesViewTableViewer(composite, 2);
    }

    private ProblemTreeViewer createTreeViewer(Composite composite) {
        return new PackagesViewTreeViewer(composite, 2);
    }

    protected IContentProvider createContentProvider() {
        if (this.isInListState()) {
            return new PackagesViewFlatContentProvider(this.fWrappedViewer.getViewer());
        }
        return new PackagesViewHierarchicalContentProvider(this.fWrappedViewer.getViewer());
    }

    protected JavaUILabelProvider createLabelProvider() {
        if (this.isInListState()) {
            return this.createListLabelProvider();
        }
        return this.createTreeLabelProvider();
    }

    private JavaUILabelProvider createTreeLabelProvider() {
        return new PackagesViewLabelProvider(0);
    }

    private JavaUILabelProvider createListLabelProvider() {
        return new PackagesViewLabelProvider(1);
    }

    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.packages_browsing_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.packagestoeditor";
    }

    protected boolean isValidInput(Object object) {
        if (object instanceof IJavaProject || object instanceof IPackageFragmentRoot && ((IJavaElement)object).getElementName() != "") {
            try {
                IJavaProject iJavaProject = ((IJavaElement)object).getJavaProject();
                if (iJavaProject != null) {
                    return iJavaProject.getProject().hasNature("org.eclipse.wst.jsdt.core.jsNature");
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    protected boolean isValidElement(Object object) {
        IJavaElement iJavaElement;
        if (object instanceof IPackageFragment && (iJavaElement = ((IPackageFragment)object).getParent()) != null) {
            return super.isValidElement(iJavaElement) || super.isValidElement(iJavaElement.getJavaProject());
        }
        return false;
    }

    protected IJavaElement findElementToSelect(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 4: {
                return iJavaElement;
            }
            case 5: {
                return ((ICompilationUnit)iJavaElement).getParent();
            }
            case 6: {
                return ((IClassFile)iJavaElement).getParent();
            }
            case 7: {
                return ((IType)iJavaElement).getPackageFragment();
            }
        }
        return this.findElementToSelect(iJavaElement.getParent());
    }

    protected void setInput(Object object) {
        this.setViewerWrapperInput(object);
        super.updateTitle();
    }

    private void setViewerWrapperInput(Object object) {
        this.fWrappedViewer.setViewerInput(object);
    }

    protected void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fSwitchActionGroup.fillActionBars(iActionBars);
    }

    private void setUpViewer(StructuredViewer structuredViewer) {
        Assert.isTrue((structuredViewer != null ? 1 : 0) != 0);
        JavaUILabelProvider javaUILabelProvider = this.createLabelProvider();
        structuredViewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(javaUILabelProvider));
        structuredViewer.setComparator((ViewerComparator)this.createJavaElementComparator());
        structuredViewer.setUseHashlookup(true);
        this.createContextMenu();
        this.addKeyListener();
        this.hookViewerListeners();
        structuredViewer.setContentProvider(this.createContentProvider());
        this.initDragAndDrop();
    }

    protected JavaElementComparator createJavaElementComparator() {
        return new JavaElementComparator(){

            public int category(Object object) {
                if (object instanceof LogicalPackage) {
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
                    return super.category(logicalPackage.getFragments()[0]);
                }
                return super.category(object);
            }

            public int compare(Viewer viewer, Object object, Object object2) {
                LogicalPackage logicalPackage;
                if (object instanceof LogicalPackage) {
                    logicalPackage = (LogicalPackage)((Object)object);
                    object = logicalPackage.getFragments()[0];
                }
                if (object2 instanceof LogicalPackage) {
                    logicalPackage = (LogicalPackage)((Object)object2);
                    object2 = logicalPackage.getFragments()[0];
                }
                return super.compare(viewer, object, object2);
            }
        };
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager iStatusLineManager) {
        return new StatusBarUpdater4LogicalPackage(iStatusLineManager);
    }

    protected void setSiteSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fWrappedViewer);
    }

    void adjustInputAndSetSelection(Object object) {
        if (!(object instanceof LogicalPackage)) {
            super.adjustInputAndSetSelection(object);
            return;
        }
        LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
        if (!logicalPackage.getJavaProject().equals(this.getInput())) {
            this.setInput(logicalPackage.getJavaProject());
        }
        this.setSelection((ISelection)new StructuredSelection((Object)logicalPackage), true);
    }

    protected void createActions() {
        super.createActions();
        this.createSelectAllAction();
        this.fSwitchActionGroup = this.createSwitchActionGroup();
    }

    private MultiActionGroup createSwitchActionGroup() {
        LayoutAction layoutAction = new LayoutAction(JavaBrowsingMessages.PackagesView_flatLayoutAction_label, 0);
        LayoutAction layoutAction2 = new LayoutAction(JavaBrowsingMessages.PackagesView_HierarchicalLayoutAction_label, 1);
        JavaPluginImages.setLocalImageDescriptors((IAction)layoutAction, "flatLayout.gif");
        JavaPluginImages.setLocalImageDescriptors((IAction)layoutAction2, "hierarchicalLayout.gif");
        return new LayoutActionGroup(new IAction[]{layoutAction, layoutAction2}, this.fCurrViewState);
    }

    private void switchViewer(int n) {
        if (this.fCurrViewState == n) {
            return;
        }
        this.fCurrViewState = n;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE, n);
        iPreferenceStore = this.fWrappedViewer.getViewer();
        Object object = iPreferenceStore.getInput();
        ISelection iSelection = iPreferenceStore.getSelection();
        Control control = this.createViewer(this.fWrappedViewer.getControl().getParent()).getControl();
        this.setUpViewer(this.fWrappedViewer);
        this.createSelectAllAction();
        this.fWrappedViewer.setViewerInput(object);
        this.fWrappedViewer.getControl().setFocus();
        this.fWrappedViewer.setSelection(iSelection, true);
        iPreferenceStore.getContentProvider().dispose();
        iPreferenceStore.getControl().dispose();
        if (control != null && !control.isDisposed()) {
            control.setVisible(true);
            control.getParent().layout(true);
        }
    }

    private void createSelectAllAction() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        if (this.isInListState()) {
            this.fSelectAllAction = new SelectAllAction((TableViewer)this.fWrappedViewer.getViewer());
            iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        } else {
            iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
            this.fSelectAllAction = null;
        }
        iActionBars.updateActionBars();
    }

    protected IJavaElement findInputForJavaElement(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        if (iJavaElement.getElementType() == 3 || iJavaElement.getElementType() == 2) {
            return this.findInputForJavaElement(iJavaElement, true);
        }
        return this.findInputForJavaElement(iJavaElement, false);
    }

    protected IJavaElement findInputForJavaElement(IJavaElement iJavaElement, boolean bl) {
        IPackageFragmentRoot iPackageFragmentRoot;
        if (iJavaElement == null || !iJavaElement.exists()) {
            return null;
        }
        if (this.isValidInput(iJavaElement)) {
            if (bl) {
                this.fLastInputWasProject = iJavaElement.getElementType() == 2;
            }
            return iJavaElement;
        }
        if (this.fLastInputWasProject && !(iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3)).isExternal()) {
            return iJavaElement.getJavaProject();
        }
        return this.findInputForJavaElement(iJavaElement.getParent(), bl);
    }

    protected DecoratingJavaLabelProvider createDecoratingLabelProvider(JavaUILabelProvider javaUILabelProvider) {
        return new DecoratingJavaLabelProvider(javaUILabelProvider, false, this.isInListState()){

            public String getText(Object object) {
                if (object instanceof LogicalPackage) {
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
                    return super.getText((Object)logicalPackage.getFragments()[0]);
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (object instanceof LogicalPackage) {
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
                    ILabelDecorator iLabelDecorator = this.getLabelDecorator();
                    IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
                    Image image = super.getImage((Object)logicalPackage);
                    int n = 0;
                    while (n < iPackageFragmentArray.length) {
                        IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                        Image image2 = iLabelDecorator.decorateImage(image, (Object)iPackageFragment);
                        if (image2 != null) {
                            image = image2;
                        }
                        ++n;
                    }
                    return image;
                }
                return super.getImage(object);
            }
        };
    }

    void adjustInputAndSetSelection(IJavaElement iJavaElement) {
        Object object;
        IJavaElement iJavaElement2;
        IJavaElement iJavaElement3 = this.findElementToSelect(iJavaElement);
        LogicalPackagesProvider logicalPackagesProvider = (LogicalPackagesProvider)this.fWrappedViewer.getContentProvider();
        Object object2 = iJavaElement3;
        if (iJavaElement3 != null && iJavaElement3.getElementType() == 4 && (object2 = logicalPackagesProvider.findLogicalPackage((IPackageFragment)(iJavaElement2 = (IPackageFragment)iJavaElement3))) == null) {
            object2 = iJavaElement2;
        }
        iJavaElement2 = this.findInputForJavaElement(iJavaElement);
        if (object2 == null && !this.isValidInput(iJavaElement2)) {
            this.setInput(null);
        } else if (object2 == null || this.getViewer().testFindItem(object2) == null) {
            IPackageFragment iPackageFragment;
            object = this.getViewer().getInput();
            if (object2 != null && iJavaElement2 != null) {
                if (iJavaElement2.equals(object)) {
                    this.getViewer().reveal(object2);
                } else {
                    this.setInput(iJavaElement2);
                    this.getViewer().reveal(object2);
                }
            } else {
                this.setInput(iJavaElement2);
            }
            if (object2 instanceof IPackageFragment && (object2 = logicalPackagesProvider.findLogicalPackage(iPackageFragment = (IPackageFragment)object2)) == null) {
                object2 = iPackageFragment;
            }
        }
        object = object2 != null ? new StructuredSelection(object2) : StructuredSelection.EMPTY;
        this.setSelection((ISelection)object, true);
    }

    private class LayoutAction
    extends Action {
        private int fState;

        public LayoutAction(String string, int n) {
            super(string, 8);
            this.fState = n;
            if (n == 0) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.layout_flat_action");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.layout_hierarchical_action");
            }
        }

        public int getState() {
            return this.fState;
        }

        public void setRunnable(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
        }

        public void run() {
            PackagesView.this.switchViewer(this.fState);
        }
    }

    private static class LayoutActionGroup
    extends MultiActionGroup {
        LayoutActionGroup(IAction[] iActionArray, int n) {
            super(iActionArray, n);
        }

        public void fillActionBars(IActionBars iActionBars) {
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            GroupMarker groupMarker = new GroupMarker("layout");
            iMenuManager.add((IContributionItem)groupMarker);
            MenuManager menuManager = new MenuManager(JavaBrowsingMessages.PackagesView_LayoutActionGroup_layout_label);
            iMenuManager.appendToGroup("layout", (IContributionItem)menuManager);
            super.addActions((IMenuManager)menuManager);
        }
    }

    private static class StatusBarUpdater4LogicalPackage
    extends StatusBarUpdater {
        private StatusBarUpdater4LogicalPackage(IStatusLineManager iStatusLineManager) {
            super(iStatusLineManager);
        }

        protected String formatMessage(ISelection iSelection) {
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                int n = iStructuredSelection.size();
                Object object = iStructuredSelection.getFirstElement();
                if (n == 1 && object instanceof LogicalPackage) {
                    return this.formatLogicalPackageMessage((LogicalPackage)((Object)object));
                }
            }
            return super.formatMessage(iSelection);
        }

        private String formatLogicalPackageMessage(LogicalPackage logicalPackage) {
            IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
            StringBuffer stringBuffer = new StringBuffer(logicalPackage.getElementName());
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            String string = "";
            boolean bl = true;
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                IJavaElement iJavaElement = iPackageFragment.getParent();
                if (iJavaElement instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                    String string2 = JavaElementLabels.getElementLabel((IJavaElement)iPackageFragmentRoot, JavaElementLabels.DEFAULT_QUALIFIED | 0x20000000000L);
                    if (bl) {
                        stringBuffer.append(string2);
                        bl = false;
                    } else {
                        string = Messages.format(JavaBrowsingMessages.StatusBar_concat, new String[]{string, string2});
                    }
                }
                ++n;
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
    }
}

