/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackagesProvider;

class PackagesViewFlatContentProvider
extends LogicalPackagesProvider
implements IStructuredContentProvider {
    PackagesViewFlatContentProvider(StructuredViewer structuredViewer) {
        super(structuredViewer);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            int n = iJavaElement.getElementType();
            try {
                switch (n) {
                    case 2: {
                        IJavaProject iJavaProject = (IJavaProject)iJavaElement;
                        Object[] objectArray = this.getPackageFragments(iJavaProject.getPackageFragments());
                        if (this.isInCompoundState()) {
                            this.fMapToLogicalPackage.clear();
                            this.fMapToPackageFragments.clear();
                            return this.combineSamePackagesIntoLogialPackages((IPackageFragment[])objectArray);
                        }
                        return objectArray;
                    }
                    case 3: {
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                        return iPackageFragmentRoot.getChildren();
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                return NO_CHILDREN;
            }
        }
        return NO_CHILDREN;
    }

    private IPackageFragment[] getPackageFragments(IPackageFragment[] iPackageFragmentArray) {
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot;
            IPackageFragment iPackageFragment = iPackageFragmentArray[n];
            IJavaElement iJavaElement = iPackageFragment.getParent();
            if (!(iJavaElement instanceof IPackageFragmentRoot && (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement).isArchive() && iPackageFragmentRoot.isExternal())) {
                arrayList.add(iPackageFragment);
            }
            ++n;
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    protected void processDelta(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        Object object;
        int n = iJavaElementDelta.getKind();
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        if (this.isClassPathChange(iJavaElementDelta) && (object = this.fViewer.getInput()) != null) {
            if (this.fInputIsProject && object.equals(iJavaElement.getJavaProject())) {
                this.postRefresh(object);
                return;
            }
            if (!this.fInputIsProject && object.equals(iJavaElement)) {
                if (iJavaElement.exists()) {
                    this.postRefresh(object);
                } else {
                    this.postRemove(object);
                }
                return;
            }
        }
        if (n == 2 && (object = this.fViewer.getInput()) != null && object.equals(iJavaElement)) {
            this.postRemove(object);
            return;
        }
        if (iJavaElement instanceof IPackageFragment) {
            object = (IPackageFragment)iJavaElement;
            if (n == 2) {
                this.removeElement((IPackageFragment)object);
            } else if (n == 1) {
                this.addElement((IPackageFragment)object);
            } else if (n == 4) {
                Object object2 = iJavaElement;
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                LogicalPackage logicalPackage = this.findLogicalPackage(iPackageFragment);
                object2 = logicalPackage != null ? this.findElementToRefresh(logicalPackage) : this.findElementToRefresh(iPackageFragment);
                this.postRefresh(object2);
            }
            return;
        }
        this.processAffectedChildren(iJavaElementDelta);
    }

    private Object findElementToRefresh(IPackageFragment iPackageFragment) {
        if (this.fViewer.testFindItem((Object)iPackageFragment) == null) {
            if (this.fInputIsProject) {
                return iPackageFragment.getJavaProject();
            }
            return iPackageFragment.getParent();
        }
        return iPackageFragment;
    }

    private Object findElementToRefresh(LogicalPackage logicalPackage) {
        if (this.fViewer.testFindItem((Object)logicalPackage) == null) {
            IPackageFragment iPackageFragment = logicalPackage.getFragments()[0];
            return iPackageFragment.getJavaProject();
        }
        return logicalPackage;
    }

    private void processAffectedChildren(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        int n = 0;
        while (n < iJavaElementDeltaArray.length) {
            IJavaElementDelta iJavaElementDelta2 = iJavaElementDeltaArray[n];
            this.processDelta(iJavaElementDelta2);
            ++n;
        }
    }

    private void postAdd(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = PackagesViewFlatContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ((TableViewer)PackagesViewFlatContentProvider.this.fViewer).add(object);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = PackagesViewFlatContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ((TableViewer)PackagesViewFlatContentProvider.this.fViewer).remove(object);
                }
            }
        });
    }

    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            Display display = Display.getCurrent();
            if (display != null && display.equals(control.getDisplay())) {
                control.getDisplay().syncExec(runnable);
            } else {
                control.getDisplay().asyncExec(runnable);
            }
        }
    }

    private void removeElement(IPackageFragment iPackageFragment) {
        String string = this.getKey(iPackageFragment);
        LogicalPackage logicalPackage = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(string));
        if (logicalPackage != null) {
            logicalPackage.remove(iPackageFragment);
            if (logicalPackage.getFragments().length == 1) {
                IPackageFragment iPackageFragment2 = logicalPackage.getFragments()[0];
                this.fMapToLogicalPackage.remove(string);
                this.fMapToPackageFragments.put(string, iPackageFragment2);
                this.postRemove((Object)logicalPackage);
                this.postAdd(iPackageFragment2);
            }
            return;
        }
        this.fMapToPackageFragments.remove(string);
        this.postRemove(iPackageFragment);
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = PackagesViewFlatContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    PackagesViewFlatContentProvider.this.fViewer.refresh(object);
                }
            }
        });
    }

    private void addElement(IPackageFragment iPackageFragment) {
        String string = this.getKey(iPackageFragment);
        LogicalPackage logicalPackage = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(string));
        if (logicalPackage != null && logicalPackage.belongs(iPackageFragment)) {
            logicalPackage.add(iPackageFragment);
            return;
        }
        IPackageFragment iPackageFragment2 = (IPackageFragment)this.fMapToPackageFragments.get(string);
        if (iPackageFragment2 != null) {
            if (!iPackageFragment2.equals(iPackageFragment)) {
                logicalPackage = new LogicalPackage(iPackageFragment2);
                logicalPackage.add(iPackageFragment);
                this.fMapToLogicalPackage.put(string, logicalPackage);
                this.postRemove(iPackageFragment2);
                this.postAdd((Object)logicalPackage);
                return;
            }
        } else {
            this.fMapToPackageFragments.put(string, iPackageFragment);
            this.postAdd(iPackageFragment);
        }
    }
}

