/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyFiltersActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CancelSearchAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CopyCallHierarchyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.FocusOnSelectionAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.HistoryDropDownAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.ICallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationCopyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationViewer;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.OpenLocationAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.RefreshAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.ToggleCallModeAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.ToggleOrientationAction;
import org.eclipse.wst.jsdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.actions.CCPActionGroup;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenViewActionGroup;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

public class CallHierarchyViewPart
extends ViewPart
implements ICallHierarchyViewPart,
ISelectionChangedListener {
    private static final String DIALOGSTORE_VIEWORIENTATION = "CallHierarchyViewPart.orientation";
    private static final String DIALOGSTORE_CALL_MODE = "CallHierarchyViewPart.call_mode";
    private static final String DIALOGSTORE_RATIO = "CallHierarchyViewPart.ratio";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_SINGLE = 2;
    static final int VIEW_ORIENTATION_AUTOMATIC = 3;
    static final int CALL_MODE_CALLERS = 0;
    static final int CALL_MODE_CALLEES = 1;
    static final String GROUP_SEARCH_SCOPE = "MENU_SEARCH_SCOPE";
    static final String ID_CALL_HIERARCHY = "org.eclipse.wst.jsdt.callhierarchy.view";
    private static final String GROUP_FOCUS = "group.focus";
    private static final int PAGE_EMPTY = 0;
    private static final int PAGE_VIEWER = 1;
    private Label fNoHierarchyShownLabel;
    private PageBook fPagebook;
    private IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    private int fCurrentOrientation;
    int fOrientation = 3;
    private int fCurrentCallMode;
    private MethodWrapper fCalleeRoot;
    private MethodWrapper fCallerRoot;
    private IMemento fMemento;
    private IMethod fShownMethod;
    private CallHierarchySelectionProvider fSelectionProviderMediator;
    private List fMethodHistory = new ArrayList();
    private LocationViewer fLocationViewer;
    private SashForm fHierarchyLocationSplitter;
    private Clipboard fClipboard;
    private SearchScopeActionGroup fSearchScopeActions;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ToggleCallModeAction[] fToggleCallModeActions;
    private CallHierarchyFiltersActionGroup fFiltersActionGroup;
    private HistoryDropDownAction fHistoryDropDownAction;
    private RefreshAction fRefreshAction;
    private OpenLocationAction fOpenLocationAction;
    private LocationCopyAction fLocationCopyAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private CopyCallHierarchyAction fCopyAction;
    private CancelSearchAction fCancelSearchAction;
    private CompositeActionGroup fActionGroups;
    private CallHierarchyViewer fCallHierarchyViewer;
    private boolean fShowCallDetails;
    protected Composite fParent;
    private IPartListener2 fPartListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setHistoryEntries(IMethod[] iMethodArray) {
        this.fMethodHistory.clear();
        int n = 0;
        while (n < iMethodArray.length) {
            this.fMethodHistory.add(iMethodArray[n]);
            ++n;
        }
        this.updateHistoryEntries();
    }

    public IMethod[] getHistoryEntries() {
        if (this.fMethodHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fMethodHistory.toArray(new IMethod[this.fMethodHistory.size()]);
    }

    public void setMethod(IMethod iMethod) {
        if (iMethod == null) {
            this.showPage(0);
            return;
        }
        if (!iMethod.equals(this.fShownMethod)) {
            this.addHistoryEntry((IJavaElement)iMethod);
        }
        this.fShownMethod = iMethod;
        this.refresh();
    }

    public IMethod getMethod() {
        return this.fShownMethod;
    }

    public MethodWrapper getCurrentMethodWrapper() {
        if (this.fCurrentCallMode == 0) {
            return this.fCallerRoot;
        }
        return this.fCalleeRoot;
    }

    void setOrientation(int n) {
        if (this.fCurrentOrientation != n) {
            if (this.fLocationViewer != null && !this.fLocationViewer.getControl().isDisposed() && this.fHierarchyLocationSplitter != null && !this.fHierarchyLocationSplitter.isDisposed()) {
                if (n == 2) {
                    this.setShowCallDetails(false);
                } else {
                    if (this.fCurrentOrientation == 2) {
                        this.setShowCallDetails(true);
                    }
                    boolean bl = n == 1;
                    this.fHierarchyLocationSplitter.setOrientation(bl ? 256 : 512);
                }
                this.fHierarchyLocationSplitter.layout();
            }
            this.updateCheckedState();
            this.fCurrentOrientation = n;
            this.restoreSplitterRatio();
        }
    }

    private void updateCheckedState() {
        int n = 0;
        while (n < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[n].setChecked(this.fOrientation == this.fToggleOrientationActions[n].getOrientation());
            ++n;
        }
    }

    void setCallMode(int n) {
        if (this.fCurrentCallMode != n) {
            int n2 = 0;
            while (n2 < this.fToggleCallModeActions.length) {
                this.fToggleCallModeActions[n2].setChecked(n == this.fToggleCallModeActions[n2].getMode());
                ++n2;
            }
            this.fCurrentCallMode = n;
            this.fDialogSettings.put(DIALOGSTORE_CALL_MODE, n);
            this.updateView();
        }
    }

    public IJavaSearchScope getSearchScope() {
        return this.fSearchScopeActions.getSearchScope();
    }

    public void setShowCallDetails(boolean bl) {
        this.fShowCallDetails = bl;
        this.showOrHideCallDetailsView();
    }

    private void initDragAndDrop() {
        this.addDragAdapters((StructuredViewer)this.fCallHierarchyViewer);
        this.addDropAdapters((StructuredViewer)this.fCallHierarchyViewer);
        this.addDropAdapters((StructuredViewer)this.fLocationViewer);
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new CallHierarchyTransferDropAdapter(this, (StructuredViewer)this.fCallHierarchyViewer));
    }

    private void addDropAdapters(StructuredViewer structuredViewer) {
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance()};
        int n = 23;
        TransferDropTargetListener[] transferDropTargetListenerArray = new TransferDropTargetListener[]{new CallHierarchyTransferDropAdapter(this, structuredViewer)};
        structuredViewer.addDropSupport(n, transferArray, (DropTargetListener)new DelegatingDropAdapter(transferDropTargetListenerArray));
    }

    private void addDragAdapters(StructuredViewer structuredViewer) {
        int n = 5;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] transferDragSourceListenerArray = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)structuredViewer), new ResourceTransferDragAdapter((ISelectionProvider)structuredViewer)};
        structuredViewer.addDragSupport(n, transferArray, (DragSourceListener)new JdtViewerDragAdapter(structuredViewer, transferDragSourceListenerArray));
    }

    public void createPartControl(Composite composite) {
        this.fParent = composite;
        this.addResizeListener(composite);
        this.fPagebook = new PageBook(composite, 0);
        this.createHierarchyLocationSplitter((Composite)this.fPagebook);
        this.createCallHierarchyViewer((Composite)this.fHierarchyLocationSplitter);
        this.createLocationViewer((Composite)this.fHierarchyLocationSplitter);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(CallHierarchyMessages.CallHierarchyViewPart_empty);
        this.initDragAndDrop();
        this.showPage(0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.eclipse.wst.jsdt.ui.call_hierarchy_view_context");
        this.fSelectionProviderMediator = new CallHierarchySelectionProvider(new StructuredViewer[]{this.fCallHierarchyViewer, this.fLocationViewer});
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fSelectionProviderMediator.addSelectionChangedListener(new StatusBarUpdater(iStatusLineManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProviderMediator);
        this.fCallHierarchyViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                CallHierarchyViewPart.this.fillCallHierarchyViewerContextMenu(iMenuManager);
            }
        }, this.getSite(), (ISelectionProvider)this.fSelectionProviderMediator);
        this.fClipboard = new Clipboard(composite.getDisplay());
        this.makeActions();
        this.fillViewMenu();
        this.fillActionBars();
        this.initOrientation();
        this.initCallMode();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.restoreSplitterRatio();
        this.addPartListener();
    }

    private void restoreSplitterRatio() {
        String string = this.fDialogSettings.get(DIALOGSTORE_RATIO + this.fCurrentOrientation);
        if (string == null) {
            return;
        }
        int n = Integer.parseInt(string);
        this.fHierarchyLocationSplitter.setWeights(new int[]{n, 1000 - n});
    }

    private void saveSplitterRatio() {
        if (this.fHierarchyLocationSplitter != null && !this.fHierarchyLocationSplitter.isDisposed()) {
            int[] nArray = this.fHierarchyLocationSplitter.getWeights();
            int n = nArray[0] * 1000 / (nArray[0] + nArray[1]);
            String string = DIALOGSTORE_RATIO + this.fCurrentOrientation;
            this.fDialogSettings.put(string, n);
        }
    }

    private void addPartListener() {
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                if (CallHierarchyViewPart.ID_CALL_HIERARCHY.equals(iWorkbenchPartReference.getId())) {
                    CallHierarchyViewPart.this.saveViewSettings();
                }
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
                if (CallHierarchyViewPart.ID_CALL_HIERARCHY.equals(iWorkbenchPartReference.getId())) {
                    CallHierarchyViewPart.this.saveViewSettings();
                }
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
    }

    protected void saveViewSettings() {
        this.saveSplitterRatio();
        this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, this.fOrientation);
    }

    private void addResizeListener(Composite composite) {
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                CallHierarchyViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        this.saveSplitterRatio();
        this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, this.fOrientation);
        if (this.fOrientation != 3) {
            this.setOrientation(this.fOrientation);
        } else {
            if (this.fOrientation == 2) {
                return;
            }
            Point point = this.fParent.getSize();
            if (point.x != 0 && point.y != 0) {
                if (point.x > point.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void showPage(int n) {
        if (n == 0) {
            this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        } else {
            this.fPagebook.showPage((Control)this.fHierarchyLocationSplitter);
        }
    }

    private void restoreState(IMemento iMemento) {
        this.fSearchScopeActions.restoreState(iMemento);
    }

    private void initCallMode() {
        int n;
        try {
            n = this.fDialogSettings.getInt(DIALOGSTORE_CALL_MODE);
            if (n < 0 || n > 1) {
                n = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.fCurrentCallMode = -1;
        this.setCallMode(n);
    }

    private void initOrientation() {
        try {
            this.fOrientation = this.fDialogSettings.getInt(DIALOGSTORE_VIEWORIENTATION);
            if (this.fOrientation < 0 || this.fOrientation > 3) {
                this.fOrientation = 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrientation = 3;
        }
        this.fCurrentOrientation = -1;
        this.setOrientation(this.fOrientation);
    }

    private void fillViewMenu() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IContributionItem)new Separator());
        int n = 0;
        while (n < this.fToggleCallModeActions.length) {
            iMenuManager.add((IAction)this.fToggleCallModeActions[n]);
            ++n;
        }
        iMenuManager.add((IContributionItem)new Separator());
        MenuManager menuManager = new MenuManager(CallHierarchyMessages.CallHierarchyViewPart_layout_menu);
        int n2 = 0;
        while (n2 < this.fToggleOrientationActions.length) {
            menuManager.add((IAction)this.fToggleOrientationActions[n2]);
            ++n2;
        }
        iMenuManager.add((IContributionItem)menuManager);
    }

    public void dispose() {
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fPartListener != null) {
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fPartListener = null;
        }
        super.dispose();
    }

    public void gotoHistoryEntry(IMethod iMethod) {
        if (this.fMethodHistory.contains(iMethod)) {
            this.setMethod(iMethod);
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.fMemento = iMemento;
    }

    public void refresh() {
        this.setCalleeRoot(null);
        this.setCallerRoot(null);
        this.updateView();
    }

    public void saveState(IMemento iMemento) {
        if (this.fPagebook == null) {
            if (this.fMemento != null) {
                iMemento.putMemento(this.fMemento);
            }
            return;
        }
        this.fSearchScopeActions.saveState(iMemento);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelectionProvider() == this.fCallHierarchyViewer) {
            this.methodSelectionChanged(selectionChangedEvent.getSelection());
        }
    }

    private void methodSelectionChanged(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof MethodWrapper) {
                MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
                this.revealElementInEditor((Object)methodWrapper, (Viewer)this.fCallHierarchyViewer);
                this.updateLocationsView(methodWrapper);
            } else {
                this.updateLocationsView(null);
            }
        } else {
            this.updateLocationsView(null);
        }
    }

    private void revealElementInEditor(Object object, Viewer viewer) {
        IEditorPart iEditorPart;
        if (this.getSite().getPage().getActivePart() != this) {
            return;
        }
        if (this.fSelectionProviderMediator.getViewerInFocus() != viewer) {
            return;
        }
        if (object instanceof MethodWrapper) {
            CallLocation callLocation = CallHierarchy.getCallLocation(object);
            if (callLocation != null) {
                IEditorPart iEditorPart2 = CallHierarchyUI.isOpenInEditor(callLocation);
                if (iEditorPart2 != null) {
                    this.getSite().getPage().bringToTop((IWorkbenchPart)iEditorPart2);
                    if (iEditorPart2 instanceof ITextEditor) {
                        ITextEditor iTextEditor = (ITextEditor)iEditorPart2;
                        iTextEditor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
                    }
                }
            } else {
                IEditorPart iEditorPart3 = CallHierarchyUI.isOpenInEditor(object);
                this.getSite().getPage().bringToTop((IWorkbenchPart)iEditorPart3);
                EditorUtility.revealInEditor(iEditorPart3, (IJavaElement)((MethodWrapper)((Object)object)).getMember());
            }
        } else if (object instanceof IJavaElement && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)iEditorPart);
            EditorUtility.revealInEditor(iEditorPart, (IJavaElement)object);
        }
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_view_context");
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(clazz);
    }

    protected ISelection getSelection() {
        StructuredViewer structuredViewer = this.fSelectionProviderMediator.getViewerInFocus();
        if (structuredViewer != null) {
            return structuredViewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    protected void fillLocationViewerContextMenu(IMenuManager iMenuManager) {
        JavaPlugin.createStandardGroups(iMenuManager);
        iMenuManager.appendToGroup("group.show", (IAction)this.fOpenLocationAction);
        iMenuManager.appendToGroup("group.show", (IAction)this.fRefreshAction);
        iMenuManager.appendToGroup("group.reorganize", (IAction)this.fLocationCopyAction);
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x100000E && this.fRefreshAction != null && this.fRefreshAction.isEnabled()) {
            this.fRefreshAction.run();
            return;
        }
    }

    private IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    private void setCalleeRoot(MethodWrapper methodWrapper) {
        this.fCalleeRoot = methodWrapper;
    }

    private MethodWrapper getCalleeRoot() {
        if (this.fCalleeRoot == null) {
            this.fCalleeRoot = CallHierarchy.getDefault().getCalleeRoot(this.fShownMethod);
        }
        return this.fCalleeRoot;
    }

    private void setCallerRoot(MethodWrapper methodWrapper) {
        this.fCallerRoot = methodWrapper;
    }

    private MethodWrapper getCallerRoot() {
        if (this.fCallerRoot == null) {
            this.fCallerRoot = CallHierarchy.getDefault().getCallerRoot(this.fShownMethod);
        }
        return this.fCallerRoot;
    }

    private void addHistoryEntry(IJavaElement iJavaElement) {
        if (this.fMethodHistory.contains(iJavaElement)) {
            this.fMethodHistory.remove(iJavaElement);
        }
        this.fMethodHistory.add(0, iJavaElement);
        this.fHistoryDropDownAction.setEnabled(!this.fMethodHistory.isEmpty());
    }

    private void createLocationViewer(Composite composite) {
        this.fLocationViewer = new LocationViewer(composite);
        this.fLocationViewer.getControl().addKeyListener(this.createKeyListener());
        this.fLocationViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                CallHierarchyViewPart.this.fillLocationViewerContextMenu(iMenuManager);
            }
        }, ID_CALL_HIERARCHY, this.getSite());
    }

    private void createHierarchyLocationSplitter(Composite composite) {
        this.fHierarchyLocationSplitter = new SashForm(composite, 0);
        this.fHierarchyLocationSplitter.addKeyListener(this.createKeyListener());
    }

    private void createCallHierarchyViewer(Composite composite) {
        this.fCallHierarchyViewer = new CallHierarchyViewer(composite, this);
        this.fCallHierarchyViewer.addKeyListener(this.createKeyListener());
        this.fCallHierarchyViewer.addSelectionChangedListener(this);
    }

    protected void fillCallHierarchyViewerContextMenu(IMenuManager iMenuManager) {
        JavaPlugin.createStandardGroups(iMenuManager);
        iMenuManager.appendToGroup("group.show", (IAction)this.fRefreshAction);
        iMenuManager.appendToGroup("group.show", (IContributionItem)new Separator(GROUP_FOCUS));
        if (this.fFocusOnSelectionAction.canActionBeAdded()) {
            iMenuManager.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnSelectionAction);
        }
        if (this.fCopyAction.canActionBeAdded()) {
            iMenuManager.appendToGroup(GROUP_FOCUS, (IAction)this.fCopyAction);
        }
        this.fActionGroups.setContext(new ActionContext(this.getSelection()));
        this.fActionGroups.fillContextMenu(iMenuManager);
        this.fActionGroups.setContext(null);
    }

    private void fillActionBars() {
        IActionBars iActionBars = this.getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.fActionGroups.fillActionBars(iActionBars);
        iToolBarManager.add((IAction)this.fCancelSearchAction);
        int n = 0;
        while (n < this.fToggleCallModeActions.length) {
            iToolBarManager.add((IAction)this.fToggleCallModeActions[n]);
            ++n;
        }
        iToolBarManager.add((IAction)this.fHistoryDropDownAction);
    }

    private KeyListener createKeyListener() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CallHierarchyViewPart.this.handleKeyEvent(keyEvent);
            }
        };
        return keyAdapter;
    }

    private void makeActions() {
        this.fRefreshAction = new RefreshAction(this);
        this.fOpenLocationAction = new OpenLocationAction(this, (IWorkbenchSite)this.getSite());
        this.fLocationViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                CallHierarchyViewPart.this.fOpenLocationAction.run();
            }
        });
        this.fLocationCopyAction = this.fLocationViewer.initCopyAction(this.getViewSite(), this.fClipboard);
        this.fFocusOnSelectionAction = new FocusOnSelectionAction(this);
        this.fCopyAction = new CopyCallHierarchyAction(this, this.fClipboard, this.fCallHierarchyViewer);
        this.fSearchScopeActions = new SearchScopeActionGroup(this, this.fDialogSettings);
        this.fFiltersActionGroup = new CallHierarchyFiltersActionGroup((IViewPart)this, (StructuredViewer)this.fCallHierarchyViewer);
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(false);
        this.fCancelSearchAction = new CancelSearchAction(this);
        this.setCancelEnabled(false);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 3), new ToggleOrientationAction(this, 2)};
        this.fToggleCallModeActions = new ToggleCallModeAction[]{new ToggleCallModeAction(this, 0), new ToggleCallModeAction(this, 1)};
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenEditorActionGroup((IViewPart)this), new OpenViewActionGroup((IViewPart)this), new CCPActionGroup((IViewPart)this), new GenerateActionGroup((IViewPart)this), new RefactorActionGroup((IViewPart)this), new JavaSearchActionGroup((IViewPart)this), this.fSearchScopeActions, this.fFiltersActionGroup});
    }

    private void showOrHideCallDetailsView() {
        if (this.fShowCallDetails) {
            this.fHierarchyLocationSplitter.setMaximizedControl(null);
        } else {
            this.fHierarchyLocationSplitter.setMaximizedControl(this.fCallHierarchyViewer.getControl());
        }
    }

    private void updateLocationsView(MethodWrapper methodWrapper) {
        if (methodWrapper != null && methodWrapper.getMethodCall().hasCallLocations()) {
            this.fLocationViewer.setInput(methodWrapper.getMethodCall().getCallLocations());
        } else {
            this.fLocationViewer.clearViewer();
        }
    }

    private void updateHistoryEntries() {
        int n = this.fMethodHistory.size() - 1;
        while (n >= 0) {
            IMethod iMethod = (IMethod)this.fMethodHistory.get(n);
            if (!iMethod.exists()) {
                this.fMethodHistory.remove(n);
            }
            --n;
        }
        this.fHistoryDropDownAction.setEnabled(!this.fMethodHistory.isEmpty());
    }

    private void updateView() {
        if (this.fShownMethod != null) {
            this.showPage(1);
            CallHierarchy.getDefault().setSearchScope(this.getSearchScope());
            String string = JavaElementLabels.getElementLabel((IJavaElement)this.fShownMethod, JavaElementLabels.ALL_DEFAULT);
            String string2 = this.fSearchScopeActions.getFullDescription();
            Object[] objectArray = new String[]{string, string2};
            this.fCallHierarchyViewer.setInput(null);
            if (this.fCurrentCallMode == 0) {
                this.setContentDescription(Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToMethod, objectArray));
                this.fCallHierarchyViewer.setComparator(new ViewerComparator());
                this.fCallHierarchyViewer.setMethodWrapper(this.getCallerRoot());
            } else {
                this.setContentDescription(Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsFromMethod, objectArray));
                this.fCallHierarchyViewer.setComparator(null);
                this.fCallHierarchyViewer.setMethodWrapper(this.getCalleeRoot());
            }
        }
    }

    static CallHierarchyViewPart findAndShowCallersView(IWorkbenchPartSite iWorkbenchPartSite) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchPartSite.getPage();
        CallHierarchyViewPart callHierarchyViewPart = null;
        try {
            callHierarchyViewPart = (CallHierarchyViewPart)iWorkbenchPage.showView(ID_CALL_HIERARCHY);
        }
        catch (PartInitException partInitException) {
            JavaPlugin.log(partInitException);
        }
        return callHierarchyViewPart;
    }

    void cancelJobs() {
        this.fCallHierarchyViewer.cancelJobs();
    }

    void setCancelEnabled(boolean bl) {
        this.fCancelSearchAction.setEnabled(bl);
    }

    private class CallHierarchySelectionProvider
    extends SelectionProviderMediator {
        public CallHierarchySelectionProvider(StructuredViewer[] structuredViewerArray) {
            super(structuredViewerArray, null);
        }

        public ISelection getSelection() {
            ISelection iSelection = super.getSelection();
            if (!iSelection.isEmpty()) {
                return CallHierarchyUI.convertSelection(iSelection);
            }
            return iSelection;
        }
    }
}

