/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.EclipsePreferencesAdapter;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.wst.jsdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class JavaMergeViewer
extends TextMergeViewer {
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;
    private boolean fUseSystemColors;
    private JavaSourceViewerConfiguration fSourceViewerConfiguration;
    private ArrayList fSourceViewer;

    public JavaMergeViewer(Composite composite, int n, CompareConfiguration compareConfiguration) {
        super(composite, n | 0x2000000, compareConfiguration);
        this.getPreferenceStore();
        this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (!this.fUseSystemColors) {
            RGB rGB = JavaMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
            this.setBackgroundColor(rGB);
            RGB rGB2 = JavaMergeViewer.createColor(this.fPreferenceStore, "java_default");
            this.setForegroundColor(rGB2);
        }
    }

    private IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.setPreferenceStore((IPreferenceStore)this.createChainedPreferenceStore(null));
        }
        return this.fPreferenceStore;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        this.setPreferenceStore(null);
        this.fSourceViewer = null;
        super.handleDispose(disposeEvent);
    }

    public IJavaProject getJavaProject(ICompareInput iCompareInput) {
        IJavaElement iJavaElement;
        IResource iResource;
        if (iCompareInput == null) {
            return null;
        }
        IResourceProvider iResourceProvider = null;
        ITypedElement iTypedElement = iCompareInput.getLeft();
        if (iTypedElement instanceof IResourceProvider) {
            iResourceProvider = (IResourceProvider)iTypedElement;
        }
        if (iResourceProvider == null && (iTypedElement = iCompareInput.getRight()) instanceof IResourceProvider) {
            iResourceProvider = (IResourceProvider)iTypedElement;
        }
        if (iResourceProvider == null && (iTypedElement = iCompareInput.getAncestor()) instanceof IResourceProvider) {
            iResourceProvider = (IResourceProvider)iTypedElement;
        }
        if (iResourceProvider != null && (iResource = iResourceProvider.getResource()) != null && (iJavaElement = JavaCore.create((IResource)iResource)) != null) {
            return iJavaElement.getJavaProject();
        }
        return null;
    }

    public void setInput(Object object) {
        IJavaProject iJavaProject;
        if (object instanceof ICompareInput && (iJavaProject = this.getJavaProject((ICompareInput)object)) != null) {
            this.setPreferenceStore((IPreferenceStore)this.createChainedPreferenceStore(iJavaProject));
            if (this.fSourceViewer != null) {
                Iterator iterator = this.fSourceViewer.iterator();
                while (iterator.hasNext()) {
                    SourceViewer sourceViewer = (SourceViewer)iterator.next();
                    sourceViewer.unconfigure();
                    sourceViewer.configure((SourceViewerConfiguration)this.getSourceViewerConfiguration());
                }
            }
        }
        super.setInput(object);
    }

    private ChainedPreferenceStore createChainedPreferenceStore(IJavaProject iJavaProject) {
        ArrayList<IPreferenceStore> arrayList = new ArrayList<IPreferenceStore>(4);
        if (iJavaProject != null) {
            arrayList.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(iJavaProject.getProject()), "org.eclipse.wst.jsdt.core"));
        }
        arrayList.add(JavaPlugin.getDefault().getPreferenceStore());
        arrayList.add(new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()));
        arrayList.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(arrayList.toArray(new IPreferenceStore[arrayList.size()]));
    }

    private void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("AbstractTextEditor.Color.Background")) {
            if (!this.fUseSystemColors) {
                RGB rGB = JavaMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(rGB);
            }
        } else if (string.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (this.fUseSystemColors) {
                this.setBackgroundColor(null);
                this.setForegroundColor(null);
            } else {
                RGB rGB = JavaMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(rGB);
                RGB rGB2 = JavaMergeViewer.createColor(this.fPreferenceStore, "java_default");
                this.setForegroundColor(rGB2);
            }
        } else if (string.equals("java_default") && !this.fUseSystemColors) {
            RGB rGB = JavaMergeViewer.createColor(this.fPreferenceStore, "java_default");
            this.setForegroundColor(rGB);
        }
        if (this.fSourceViewerConfiguration != null && this.fSourceViewerConfiguration.affectsTextPresentation(propertyChangeEvent)) {
            this.fSourceViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
            this.invalidateTextPresentation();
        }
    }

    private static RGB createColor(IPreferenceStore iPreferenceStore, String string) {
        if (!iPreferenceStore.contains(string)) {
            return null;
        }
        if (iPreferenceStore.isDefault(string)) {
            return PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string);
        }
        return PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
    }

    public String getTitle() {
        return CompareMessages.JavaMergeViewer_title;
    }

    public ITokenComparator createTokenComparator(String string) {
        return new JavaTokenComparator(string, new JavaTokenComparator.ITokenComparatorFactory(){

            public ITokenComparator createTokenComparator(String string) {
                return JavaMergeViewer.super.createTokenComparator(string);
            }
        });
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return JavaCompareUtilities.createJavaPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "___java_partitioning";
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            if (this.fSourceViewer == null) {
                this.fSourceViewer = new ArrayList();
            }
            this.fSourceViewer.add(textViewer);
            JavaTextTools javaTextTools = JavaCompareUtilities.getJavaTextTools();
            if (javaTextTools != null) {
                ((SourceViewer)textViewer).configure((SourceViewerConfiguration)this.getSourceViewerConfiguration());
            }
        }
    }

    private JavaSourceViewerConfiguration getSourceViewerConfiguration() {
        if (this.fSourceViewerConfiguration == null) {
            this.getPreferenceStore();
        }
        return this.fSourceViewerConfiguration;
    }

    protected int findInsertionPosition(char c, ICompareInput iCompareInput) {
        int n = super.findInsertionPosition(c, iCompareInput);
        if (n != 0) {
            return n;
        }
        if (iCompareInput instanceof IDiffElement) {
            ITypedElement iTypedElement;
            Object[] objectArray;
            JavaNode javaNode = null;
            ITypedElement iTypedElement2 = null;
            switch (c) {
                case 'L': {
                    iTypedElement2 = iCompareInput.getRight();
                    break;
                }
                case 'R': {
                    iTypedElement2 = iCompareInput.getLeft();
                }
            }
            if (iTypedElement2 instanceof JavaNode) {
                javaNode = (JavaNode)iTypedElement2;
            }
            JavaNode javaNode2 = null;
            IDiffElement iDiffElement = (IDiffElement)iCompareInput;
            IDiffContainer iDiffContainer = iDiffElement.getParent();
            if (iDiffContainer instanceof ICompareInput) {
                objectArray = (Object[])iDiffContainer;
                iTypedElement = null;
                switch (c) {
                    case 'L': {
                        iTypedElement = objectArray.getLeft();
                        break;
                    }
                    case 'R': {
                        iTypedElement = objectArray.getRight();
                    }
                }
                if (iTypedElement instanceof JavaNode) {
                    javaNode2 = (JavaNode)iTypedElement;
                }
            }
            if (javaNode != null && javaNode2 != null) {
                switch (javaNode.getTypeCode()) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        objectArray = javaNode2.getChildren();
                        if (objectArray.length > 0) {
                            JavaNode javaNode3 = null;
                            int n2 = 0;
                            while (n2 < objectArray.length) {
                                JavaNode javaNode4 = (JavaNode)((Object)objectArray[n2]);
                                switch (javaNode4.getTypeCode()) {
                                    case 1: {
                                        javaNode3 = javaNode4;
                                        break;
                                    }
                                    case 5: {
                                        return javaNode4.getRange().getOffset();
                                    }
                                }
                                ++n2;
                            }
                            if (javaNode3 != null) {
                                iTypedElement = javaNode3.getRange();
                                return iTypedElement.getOffset() + iTypedElement.getLength();
                            }
                        }
                        return javaNode2.getRange().getOffset();
                    }
                    case 3: {
                        iTypedElement = javaNode2.getRange();
                        return iTypedElement.getOffset() + iTypedElement.getLength();
                    }
                    case 5: {
                        objectArray = javaNode2.getChildren();
                        if (objectArray.length > 0) {
                            int n3 = objectArray.length - 1;
                            while (n3 >= 0) {
                                JavaNode javaNode5 = (JavaNode)((Object)objectArray[n3]);
                                switch (javaNode5.getTypeCode()) {
                                    case 1: 
                                    case 2: 
                                    case 5: 
                                    case 8: {
                                        iTypedElement = javaNode5.getRange();
                                        return iTypedElement.getOffset() + iTypedElement.getLength();
                                    }
                                }
                                --n3;
                            }
                        }
                        return javaNode2.getAppendPosition().getOffset();
                    }
                    case 11: {
                        objectArray = javaNode2.getChildren();
                        if (objectArray.length > 0) {
                            JavaNode javaNode6 = (JavaNode)((Object)objectArray[objectArray.length - 1]);
                            iTypedElement = javaNode6.getRange();
                            return this.findEndOfLine(javaNode2, iTypedElement.getOffset() + iTypedElement.getLength());
                        }
                        return javaNode2.getAppendPosition().getOffset();
                    }
                    case 8: {
                        objectArray = javaNode2.getChildren();
                        if (objectArray.length > 0) {
                            JavaNode javaNode7 = null;
                            int n4 = objectArray.length - 1;
                            while (n4 >= 0) {
                                JavaNode javaNode8 = (JavaNode)((Object)objectArray[n4]);
                                switch (javaNode8.getTypeCode()) {
                                    case 11: {
                                        javaNode7 = javaNode8;
                                        break;
                                    }
                                    case 8: {
                                        iTypedElement = javaNode8.getRange();
                                        return iTypedElement.getOffset() + iTypedElement.getLength();
                                    }
                                }
                                --n4;
                            }
                            if (javaNode7 != null) {
                                return javaNode7.getRange().getOffset();
                            }
                        }
                        return javaNode2.getAppendPosition().getOffset();
                    }
                }
            }
            if (javaNode2 != null) {
                objectArray = javaNode2.getRange();
                return objectArray.getOffset() + objectArray.getLength();
            }
        }
        return 0;
    }

    private int findEndOfLine(JavaNode javaNode, int n) {
        IDocument iDocument = javaNode.getDocument();
        try {
            int n2 = iDocument.getLineOfOffset(n);
            n = iDocument.getLineOffset(n2 + 1);
        }
        catch (BadLocationException badLocationException) {}
        Position position = javaNode.getRange();
        int n3 = position.getOffset();
        int n4 = position.getOffset() + position.getLength();
        if (n < n3) {
            return n3;
        }
        if (n >= n4) {
            return n4 - 1;
        }
        return n;
    }

    private void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        if (this.fPreferenceChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fPreferenceStore = iPreferenceStore;
        if (this.fPreferenceStore != null) {
            JavaTextTools javaTextTools = JavaCompareUtilities.getJavaTextTools();
            this.fSourceViewerConfiguration = new JavaSourceViewerConfiguration(javaTextTools.getColorManager(), this.fPreferenceStore, null, this.getDocumentPartitioning());
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JavaMergeViewer.this.handlePropertyChange(propertyChangeEvent);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
    }
}

