/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;

public class BuildPathDialog
extends StatusDialog {
    private IJavaProject fProject;
    private BuildPathsBlock fBlock;

    public BuildPathDialog(Shell shell, IJavaProject iJavaProject) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        Assert.isNotNull((Object)iJavaProject);
        this.fProject = iJavaProject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.format(JavaUIMessages.BuildPathDialog_title, this.fProject.getElementName()));
    }

    protected Control createDialogArea(Composite composite) {
        IStatusChangeListener iStatusChangeListener = new IStatusChangeListener(){

            public void statusChanged(IStatus iStatus) {
                BuildPathDialog.this.updateStatus(iStatus);
            }
        };
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.fBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), iStatusChangeListener, 0, false, null);
        this.fBlock.init(this.fProject, null);
        this.fBlock.createControl(composite2).setLayoutData((Object)new GridData(1808));
        BuildPathDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buttonPressed(int n) {
        try {
            if (n == 0) {
                this.configureBuildPath();
            }
            super.buttonPressed(n);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fBlock.dispose();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fBlock.dispose();
            return;
        }
    }

    private void configureBuildPath() {
        Shell shell = this.getShell();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                BuildPathDialog.this.fBlock.configureJavaProject(iProgressMonitor);
            }
        };
        WorkbenchRunnableAdapter workbenchRunnableAdapter = new WorkbenchRunnableAdapter(iWorkspaceRunnable);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)workbenchRunnableAdapter);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = PreferencesMessages.BuildPathDialog_error_title;
            String string2 = PreferencesMessages.BuildPathDialog_error_message;
            ExceptionHandler.handle(invocationTargetException, shell, string, string2);
        }
        catch (InterruptedException interruptedException) {}
    }
}

