/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class SourceActionDialog
extends CheckedTreeSelectionDialog {
    private List fInsertPositions;
    private List fLabels;
    private int fCurrentPositionIndex;
    private IDialogSettings fSettings;
    private CompilationUnitEditor fEditor;
    private ITreeContentProvider fContentProvider;
    private boolean fGenerateComment;
    private IType fType;
    private int fWidth;
    private int fHeight;
    private String fCommentString;
    private boolean fEnableInsertPosition = true;
    private int fVisibilityModifier;
    private boolean fFinal;
    private boolean fSynchronized;
    private final String SETTINGS_SECTION_METHODS = "SourceActionDialog.methods";
    private final String SETTINGS_SECTION_CONSTRUCTORS = "SourceActionDialog.constructors";
    private final String SETTINGS_INSERTPOSITION = "InsertPosition";
    private final String SETTINGS_VISIBILITY_MODIFIER = "VisibilityModifier";
    private final String SETTINGS_FINAL_MODIFIER = "FinalModifier";
    private final String SETTINGS_SYNCHRONIZED_MODIFIER = "SynchronizedModifier";
    private final String SETTINGS_COMMENTS = "Comments";
    private Composite fInsertPositionComposite;

    public SourceActionDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider, CompilationUnitEditor compilationUnitEditor, IType iType, boolean bl) throws JavaModelException {
        super(shell, iLabelProvider, iTreeContentProvider);
        this.fEditor = compilationUnitEditor;
        this.fContentProvider = iTreeContentProvider;
        this.fType = iType;
        this.fCommentString = ActionMessages.SourceActionDialog_createMethodComment;
        this.setEmptyListMessage(ActionMessages.SourceActionDialog_no_entries);
        this.fWidth = 60;
        this.fHeight = 18;
        int n = bl ? 0 : 1;
        boolean bl2 = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)iType.getJavaProject()).createComments;
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        String string = bl ? "SourceActionDialog.constructors" : "SourceActionDialog.methods";
        this.fSettings = iDialogSettings.getSection(string);
        if (this.fSettings == null) {
            this.fSettings = iDialogSettings.addNewSection(string);
        }
        this.fVisibilityModifier = this.asInt(this.fSettings.get("VisibilityModifier"), 1);
        this.fFinal = this.asBoolean(this.fSettings.get("FinalModifier"), false);
        this.fSynchronized = this.asBoolean(this.fSettings.get("SynchronizedModifier"), false);
        this.fCurrentPositionIndex = this.asInt(this.fSettings.get("InsertPosition"), n);
        this.fGenerateComment = this.asBoolean(this.fSettings.get("Comments"), bl2);
        this.fInsertPositions = new ArrayList();
        this.fLabels = new ArrayList();
        IJavaElement[] iJavaElementArray = this.fType.getChildren();
        IMethod[] iMethodArray = this.fType.getMethods();
        this.fInsertPositions.add(iMethodArray.length > 0 ? iMethodArray[0] : null);
        this.fInsertPositions.add(null);
        this.fLabels.add(ActionMessages.SourceActionDialog_first_method);
        this.fLabels.add(ActionMessages.SourceActionDialog_last_method);
        if (this.hasCursorPositionElement(this.fEditor, iJavaElementArray, this.fInsertPositions)) {
            this.fLabels.add(ActionMessages.SourceActionDialog_cursor);
            this.fCurrentPositionIndex = 2;
        } else {
            this.fCurrentPositionIndex = Math.max(this.fCurrentPositionIndex, 0);
            this.fCurrentPositionIndex = Math.min(this.fCurrentPositionIndex, 1);
        }
        int n2 = 0;
        while (n2 < iMethodArray.length) {
            IMethod iMethod = iMethodArray[n2];
            String string2 = JavaElementLabels.getElementLabel((IJavaElement)iMethod, 1L);
            this.fLabels.add(Messages.format(ActionMessages.SourceActionDialog_after, string2));
            this.fInsertPositions.add(this.findSibling(iMethod, iJavaElementArray));
            ++n2;
        }
        this.fInsertPositions.add(null);
    }

    protected IType getType() {
        return this.fType;
    }

    protected boolean asBoolean(String string, boolean bl) {
        if (string != null) {
            return StringConverter.asBoolean((String)string, (boolean)bl);
        }
        return bl;
    }

    protected int asInt(String string, int n) {
        if (string != null) {
            return StringConverter.asInt((String)string, (int)n);
        }
        return n;
    }

    private IJavaElement findSibling(IMethod iMethod, IJavaElement[] iJavaElementArray) throws JavaModelException {
        IMember iMember = null;
        int n = iMethod.getSourceRange().getOffset();
        int n2 = iJavaElementArray.length - 1;
        while (n2 >= 0) {
            IMember iMember2 = (IMember)iJavaElementArray[n2];
            if (n >= iMember2.getSourceRange().getOffset()) {
                return iMember;
            }
            iMember = iMember2;
            --n2;
        }
        return null;
    }

    private boolean hasCursorPositionElement(CompilationUnitEditor compilationUnitEditor, IJavaElement[] iJavaElementArray, List list) throws JavaModelException {
        if (compilationUnitEditor == null) {
            return false;
        }
        int n = ((ITextSelection)compilationUnitEditor.getSelectionProvider().getSelection()).getOffset();
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            IMember iMember = (IMember)iJavaElementArray[n2];
            ISourceRange iSourceRange = iMember.getSourceRange();
            if (n < iSourceRange.getOffset()) {
                list.add(iMember);
                return true;
            }
            if (n < iSourceRange.getOffset() + iSourceRange.getLength()) {
                return false;
            }
            ++n2;
        }
        list.add(null);
        return true;
    }

    public boolean close() {
        this.fSettings.put("VisibilityModifier", StringConverter.asString((int)this.fVisibilityModifier));
        this.fSettings.put("FinalModifier", StringConverter.asString((boolean)this.fFinal));
        this.fSettings.put("SynchronizedModifier", StringConverter.asString((boolean)this.fSynchronized));
        if (this.fCurrentPositionIndex == 0 || this.fCurrentPositionIndex == 1) {
            this.fSettings.put("InsertPosition", StringConverter.asString((int)this.fCurrentPositionIndex));
        }
        this.fSettings.put("Comments", this.fGenerateComment);
        return super.close();
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    private void setInsertPosition(int n) {
        this.fCurrentPositionIndex = n;
    }

    public void setCommentString(String string) {
        this.fCommentString = string;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    public boolean getGenerateComment() {
        return this.fGenerateComment;
    }

    public int getVisibilityModifier() {
        return this.fVisibilityModifier;
    }

    public void setGenerateComment(boolean bl) {
        this.fGenerateComment = bl;
    }

    protected void setVisibility(int n) {
        this.fVisibilityModifier = n;
    }

    private void setFinal(boolean bl) {
        this.fFinal = bl;
    }

    private void setSynchronized(boolean bl) {
        this.fSynchronized = bl;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite composite2 = super.createSelectionButtons(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        return composite2;
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
    }

    protected Label createMessageArea(Composite composite) {
        if (this.getMessage() != null) {
            Label label = new Label(composite, 0);
            label.setText(this.getMessage());
            label.setFont(composite.getFont());
            return label;
        }
        return null;
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = null;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Label label = this.createMessageArea(composite2);
        if (label != null) {
            gridData = new GridData(256);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
        }
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setFont(composite.getFont());
        CheckboxTreeViewer checkboxTreeViewer = this.createTreeViewer(composite3);
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        checkboxTreeViewer.getControl().setLayoutData((Object)gridData);
        Composite composite4 = this.createSelectionButtons(composite3);
        gridData = new GridData(272);
        composite4.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        composite3.setLayoutData((Object)gridData);
        this.fInsertPositionComposite = this.createInsertPositionCombo(composite2);
        this.fInsertPositionComposite.setLayoutData((Object)new GridData(768));
        Composite composite5 = this.createCommentSelection(composite2);
        composite5.setLayoutData((Object)new GridData(768));
        Control control = this.createLinkControl(composite2);
        if (control != null) {
            control.setLayoutData((Object)new GridData(768));
        }
        gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        SourceActionDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected Control createLinkControl(Composite composite) {
        return null;
    }

    protected void openCodeTempatePage(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CodeTemplatePreferencePage.select_template", string);
        PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fType.getJavaProject().getProject(), (String)"org.eclipse.wst.jsdt.ui.propertyPages.CodeTemplatePreferencePage", null, hashMap).open();
    }

    protected Composite createCommentSelection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        Button button = new Button(composite2, 32);
        button.setText(this.fCommentString);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = ((Button)selectionEvent.widget).getSelection();
                SourceActionDialog.this.setGenerateComment(bl);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        button.setSelection(this.getGenerateComment());
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        return composite2;
    }

    protected Composite addVisibilityAndModifiersChoices(Composite composite) {
        IVisibilityChangeListener iVisibilityChangeListener = new IVisibilityChangeListener(){

            public void visibilityChanged(int n) {
                SourceActionDialog.this.setVisibility(n);
            }

            public void modifierChanged(int n, boolean bl) {
                switch (n) {
                    case 16: {
                        SourceActionDialog.this.setFinal(bl);
                        return;
                    }
                    case 32: {
                        SourceActionDialog.this.setSynchronized(bl);
                        return;
                    }
                }
            }
        };
        int n = this.getVisibilityModifier();
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[2] = 2;
        int[] nArray2 = nArray;
        Composite composite2 = this.createVisibilityControlAndModifiers(composite, iVisibilityChangeListener, nArray2, n);
        return composite2;
    }

    private List convertToIntegerList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            arrayList.add(new Integer(nArray[n]));
            ++n;
        }
        return arrayList;
    }

    public void create() {
        super.create();
        CheckboxTreeViewer checkboxTreeViewer = this.getTreeViewer();
        TreeItem[] treeItemArray = checkboxTreeViewer.getTree().getItems();
        if (treeItemArray.length > 0) {
            Object object = treeItemArray[0];
            int n = 0;
            while (n < treeItemArray.length) {
                if (treeItemArray[n].getChecked()) {
                    object = treeItemArray[n].getData();
                    break;
                }
                ++n;
            }
            checkboxTreeViewer.setSelection((ISelection)new StructuredSelection(object));
            checkboxTreeViewer.reveal(object);
        }
    }

    protected Composite createVisibilityControl(Composite composite, final IVisibilityChangeListener iVisibilityChangeListener, int[] nArray, int n) {
        List list = this.convertToIntegerList(nArray);
        if (list.size() == 1) {
            return null;
        }
        Group group = new Group(composite, 0);
        group.setText(ActionMessages.SourceActionDialog_modifier_group);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 4;
        group.setLayout((Layout)gridLayout);
        String[] stringArray = new String[]{ActionMessages.SourceActionDialog_modifier_public, ActionMessages.SourceActionDialog_modifier_protected, ActionMessages.SourceActionDialog_modifier_default, ActionMessages.SourceActionDialog_modifier_private};
        Integer[] integerArray = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        Integer n2 = new Integer(n);
        int n3 = 0;
        while (n3 < stringArray.length) {
            Button button = new Button((Composite)group, 16);
            Integer n4 = integerArray[n3];
            button.setLayoutData((Object)new GridData(256));
            button.setText(stringArray[n3]);
            button.setData((Object)n4);
            button.setSelection(n4.equals(n2));
            button.setEnabled(list.contains(n4));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    iVisibilityChangeListener.visibilityChanged((Integer)selectionEvent.widget.getData());
                }
            });
            ++n3;
        }
        return group;
    }

    protected Composite createVisibilityControlAndModifiers(Composite composite, final IVisibilityChangeListener iVisibilityChangeListener, int[] nArray, int n) {
        Composite composite2 = this.createVisibilityControl(composite, iVisibilityChangeListener, nArray, n);
        Button button = new Button(composite2, 32);
        button.setText(ActionMessages.SourceActionDialog_modifier_final);
        GridData gridData = new GridData(256);
        button.setLayoutData((Object)gridData);
        button.setData((Object)new Integer(16));
        button.setEnabled(true);
        button.setSelection(this.isFinal());
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iVisibilityChangeListener.modifierChanged((Integer)selectionEvent.widget.getData(), ((Button)selectionEvent.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        Button button2 = new Button(composite2, 32);
        button2.setText(ActionMessages.SourceActionDialog_modifier_synchronized);
        gridData = new GridData(256);
        button2.setLayoutData((Object)gridData);
        button2.setData((Object)new Integer(32));
        button2.setEnabled(true);
        button2.setSelection(this.isSynchronized());
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iVisibilityChangeListener.modifierChanged((Integer)selectionEvent.widget.getData(), ((Button)selectionEvent.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        return composite2;
    }

    protected Composite createInsertPositionCombo(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.addOrderEntryChoices(composite2);
        return composite2;
    }

    private Composite addOrderEntryChoices(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(ActionMessages.SourceActionDialog_enterAt_label);
        if (!this.fEnableInsertPosition) {
            label.setEnabled(false);
        }
        GridData gridData = new GridData(256);
        label.setLayoutData((Object)gridData);
        final Combo combo = new Combo(composite, 8);
        if (!this.fEnableInsertPosition) {
            combo.setEnabled(false);
        }
        this.fillWithPossibleInsertPositions(combo);
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                SourceActionDialog.this.setInsertPosition(n);
            }
        });
        return composite;
    }

    private void fillWithPossibleInsertPositions(Combo combo) {
        combo.setItems(this.fLabels.toArray(new String[this.fLabels.size()]));
        combo.select(this.fCurrentPositionIndex);
    }

    public boolean getFinal() {
        return this.fFinal;
    }

    public boolean getSynchronized() {
        return this.fSynchronized;
    }

    public boolean isFinal() {
        return this.fFinal;
    }

    public boolean isSynchronized() {
        return this.fSynchronized;
    }

    public void setElementPositionEnabled(boolean bl) {
        this.fEnableInsertPosition = bl;
    }

    public boolean isElementPositionEnabled() {
        return this.fEnableInsertPosition;
    }

    public IJavaElement getElementPosition() {
        return (IJavaElement)this.fInsertPositions.get(this.fCurrentPositionIndex);
    }

    public int getInsertOffset() throws JavaModelException {
        IJavaElement iJavaElement = this.getElementPosition();
        if (iJavaElement instanceof ISourceReference) {
            return ((ISourceReference)iJavaElement).getSourceRange().getOffset();
        }
        return -1;
    }

    protected IDialogSettings getDialogSettings() {
        return this.fSettings;
    }
}

