/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocSpecificsWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocStandardWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class JavadocWizard
extends Wizard
implements IExportWizard {
    private JavadocTreeWizardPage fJTWPage;
    private JavadocSpecificsWizardPage fJSWPage;
    private JavadocStandardWizardPage fJSpWPage;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private final String JAVADOC_ANT_INFORMATION_DIALOG = "javadocAntInformationDialog";
    private JavadocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.wst.jsdt.ui.javadocProcess";

    public static void openJavadocWizard(JavadocWizard javadocWizard, Shell shell, IStructuredSelection iStructuredSelection) {
        javadocWizard.init(PlatformUI.getWorkbench(), iStructuredSelection);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)javadocWizard);
        PixelConverter pixelConverter = new PixelConverter(JFaceResources.getDialogFont());
        wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(100), pixelConverter.convertHeightInCharsToPixels(20));
        wizardDialog.open();
    }

    public JavadocWizard() {
        this(null);
    }

    public JavadocWizard(IFile iFile) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXPORT_JAVADOC);
        this.setWindowTitle(JavadocExportMessages.JavadocWizard_javadocwizard_title);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = iFile;
        this.fWriteCustom = false;
    }

    public boolean performFinish() {
        int n;
        IFile[] iFileArray;
        Serializable serializable;
        IJavaProject[] iJavaProjectArray = this.fJTWPage.getCheckedProjects();
        this.updateStore(iJavaProjectArray);
        this.fStore.updateDialogSettings(this.getDialogSettings(), iJavaProjectArray);
        if (!new RefactoringSaveHelper(1).saveEditors(this.getShell())) {
            return false;
        }
        this.fDestination = Path.fromOSString((String)this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                serializable = this.fDestination.toFile().toURL();
                iFileArray = new ArrayList();
                n = 0;
                while (n < iJavaProjectArray.length) {
                    IJavaProject iJavaProject = iJavaProjectArray[n];
                    URL uRL = JavaUI.getProjectJavadocLocation(iJavaProject);
                    if (!((URL)serializable).equals(uRL)) {
                        iFileArray.add(iJavaProject);
                    }
                    ++n;
                }
                if (!iFileArray.isEmpty()) {
                    this.setAllJavadocLocations(iFileArray.toArray(new IJavaProject[iFileArray.size()]), (URL)serializable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                JavaPlugin.log(malformedURLException);
            }
        }
        if (this.fJSWPage.generateAnt()) {
            OptionalMessageDialog.open("javadocAntInformationDialog", this.getShell(), JavadocExportMessages.JavadocWizard_antInformationDialog_title, null, JavadocExportMessages.JavadocWizard_antInformationDialog_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            try {
                serializable = this.fStore.createXML(iJavaProjectArray);
                if (serializable != null && (iFileArray = this.fRoot.findFilesForLocation(Path.fromOSString((String)((File)serializable).getPath()))) != null) {
                    n = 0;
                    while (n < iFileArray.length) {
                        iFileArray[n].refreshLocal(1, null);
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                ExceptionHandler.handle(coreException, this.getShell(), JavadocExportMessages.JavadocWizard_error_writeANT_title, JavadocExportMessages.JavadocWizard_error_writeANT_message);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore(IJavaProject[] iJavaProjectArray) {
        this.fJTWPage.updateStore(iJavaProjectArray);
        if (!this.fJTWPage.getCustom()) {
            this.fJSpWPage.updateStore();
        }
        this.fJSWPage.updateStore();
    }

    public boolean performCancel() {
        IJavaProject[] iJavaProjectArray = this.fJTWPage.getCheckedProjects();
        this.updateStore(iJavaProjectArray);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), iJavaProjectArray);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaProject[] iJavaProjectArray, URL uRL) {
        Shell shell = this.getShell();
        String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        int n = 0;
        while (n < iJavaProjectArray.length) {
            IJavaProject iJavaProject = iJavaProjectArray[n];
            String string = Messages.format(JavadocExportMessages.JavadocWizard_updatejavadoclocation_message, new String[]{iJavaProject.getElementName(), this.fDestination.toOSString()});
            MessageDialog messageDialog = new MessageDialog(shell, JavadocExportMessages.JavadocWizard_updatejavadocdialog_label, null, string, 3, stringArray, 1);
            switch (messageDialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation(iJavaProject, uRL);
                    break;
                }
                case 1: {
                    int n2 = n;
                    while (n2 < iJavaProjectArray.length) {
                        iJavaProject = iJavaProjectArray[n2];
                        JavaUI.setProjectJavadocLocation(iJavaProject, uRL);
                        ++n;
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    n = iJavaProjectArray.length;
                    break;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeJavadocGeneration() {
        Process process = null;
        try {
            CharSequence charSequence;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList arrayList2 = new ArrayList();
            IStatus iStatus = this.fStore.getArgumentArray(arrayList, arrayList2);
            if (!iStatus.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)JavadocExportMessages.JavadocWizard_error_title, (String)JavadocExportMessages.JavadocWizard_warning_starting_message, (IStatus)iStatus);
            }
            File file = File.createTempFile("javadoc-arguments", ".tmp");
            arrayList.add(String.valueOf('@') + file.getAbsolutePath());
            FileWriter fileWriter = new FileWriter(file);
            try {
                int n = 0;
                while (n < arrayList2.size()) {
                    charSequence = (String)arrayList2.get(n);
                    charSequence = this.checkForSpaces((String)charSequence);
                    fileWriter.write((String)charSequence);
                    fileWriter.write(32);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                fileWriter.close();
                throw throwable;
            }
            {
                Object var9_17 = null;
            }
            fileWriter.close();
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            process = Runtime.getRuntime().exec(stringArray);
            if (process == null) return false;
            charSequence = new StringBuffer();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    JavadocDebugEventListener javadocDebugEventListener = new JavadocDebugEventListener(this.getShell().getDisplay(), file);
                    DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)javadocDebugEventListener);
                    ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
                    try {
                        ILaunchConfigurationType iLaunchConfigurationType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.jsdt.core.localJavaApplication");
                        String string = JavadocExportMessages.JavadocWizard_launchconfig_name;
                        iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
                        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.debug.ui.private", true);
                        Launch launch = new Launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", null);
                        IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)JavadocExportMessages.JavadocWizard_javadocprocess_label);
                        iProcess.setAttribute(IProcess.ATTR_CMDLINE, ((StringBuffer)charSequence).toString());
                        iProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, ID_JAVADOC_PROCESS_TYPE);
                        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
                        return true;
                    }
                    catch (CoreException coreException) {
                        String string = JavadocExportMessages.JavadocWizard_error_title;
                        String string2 = JavadocExportMessages.JavadocWizard_launch_error_message;
                        ExceptionHandler.handle(coreException, this.getShell(), string, string2);
                        return true;
                    }
                }
                ((StringBuffer)charSequence).append(stringArray[n]);
                ((StringBuffer)charSequence).append(' ');
                ++n;
            }
        }
        catch (IOException iOException) {
            String string = JavadocExportMessages.JavadocWizard_error_title;
            String string3 = JavadocExportMessages.JavadocWizard_exec_error_message;
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, iOException.getMessage(), (Throwable)iOException);
            ExceptionHandler.handle(new CoreException((IStatus)status), this.getShell(), string, string3);
            return false;
        }
    }

    private String checkForSpaces(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\' || c == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public void addPages() {
        this.fJTWPage = new JavadocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fJSWPage = new JavadocSpecificsWizardPage("JavadocSpecificsPage", this.fJTWPage, this.fStore);
        this.fJSpWPage = new JavadocStandardWizardPage("JavadocStandardPage", this.fJTWPage, this.fStore);
        super.addPage((IWizardPage)this.fJTWPage);
        super.addPage((IWizardPage)this.fJSpWPage);
        super.addPage((IWizardPage)this.fJSWPage);
        this.fJTWPage.init();
        this.fJSpWPage.init();
        this.fJSWPage.init();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        ArrayList<IJavaElement> arrayList = Collections.EMPTY_LIST;
        if (iWorkbenchWindow != null) {
            ISelection iSelection = iWorkbenchWindow.getSelectionService().getSelection();
            if (iSelection instanceof IStructuredSelection) {
                arrayList = ((IStructuredSelection)iSelection).toList();
            } else {
                IJavaElement iJavaElement = EditorUtility.getActiveEditorJavaInput();
                if (iJavaElement != null) {
                    arrayList = new ArrayList<IJavaElement>();
                    arrayList.add(iJavaElement);
                }
            }
        }
        this.fStore = new JavadocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), arrayList);
    }

    private void refresh(IPath iPath) {
        if (this.fRoot.findContainersForLocation(iPath).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath iPath = this.fDestination.append("index.html");
                URL uRL = iPath.toFile().toURL();
                OpenBrowserUtil.open(uRL, display, this.getWindowTitle());
            }
            catch (MalformedURLException malformedURLException) {
                JavaPlugin.log(malformedURLException);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage instanceof JavadocTreeWizardPage) {
            if (!this.fJTWPage.getCustom()) {
                return this.fJSpWPage;
            }
            return this.fJSWPage;
        }
        if (iWizardPage instanceof JavadocSpecificsWizardPage) {
            return null;
        }
        if (iWizardPage instanceof JavadocStandardWizardPage) {
            return this.fJSWPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (iWizardPage instanceof JavadocSpecificsWizardPage) {
            if (!this.fJTWPage.getCustom()) {
                return this.fJSpWPage;
            }
            return this.fJSWPage;
        }
        if (iWizardPage instanceof JavadocTreeWizardPage) {
            return null;
        }
        if (iWizardPage instanceof JavadocStandardWizardPage) {
            return this.fJTWPage;
        }
        return null;
    }

    private class JavadocDebugEventListener
    implements IDebugEventSetListener {
        private Display fDisplay;
        private File fFile;

        public JavadocDebugEventListener(Display display, File file) {
            this.fDisplay = display;
            this.fFile = file;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleDebugEvents(DebugEvent[] debugEventArray) {
            int n = 0;
            while (n < debugEventArray.length) {
                if (debugEventArray[n].getKind() == 8) {
                    try {
                        if (!JavadocWizard.this.fWriteCustom) {
                            this.fFile.delete();
                            JavadocWizard.this.refresh(JavadocWizard.this.fDestination);
                            JavadocWizard.this.spawnInBrowser(this.fDisplay);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        return;
                    }
                }
                ++n;
            }
            return;
        }
    }
}

