/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.IResourceLocator;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileMarkerAnnotationModel;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class ClassFileDocumentProvider
extends FileDocumentProvider {
    private List fInputListeners = new ArrayList();
    static /* synthetic */ Class class$0;

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IClassFileEditorInput) {
            IClassFile iClassFile = ((IClassFileEditorInput)iEditorInput).getClassFile();
            String string2 = iClassFile.getSource();
            if (string2 == null) {
                string2 = "";
            }
            iDocument.set(string2);
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    protected IAnnotationModel createClassFileAnnotationModel(IClassFileEditorInput iClassFileEditorInput) throws CoreException {
        IResourceLocator iResourceLocator;
        IResource iResource = null;
        IClassFile iClassFile = iClassFileEditorInput.getClassFile();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.ui.IResourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResourceLocator = (IResourceLocator)iClassFile.getAdapter((Class)clazz)) != null) {
            iResource = iResourceLocator.getContainingResource(iClassFile);
        }
        if (iResource != null) {
            ClassFileMarkerAnnotationModel classFileMarkerAnnotationModel = new ClassFileMarkerAnnotationModel(iResource);
            classFileMarkerAnnotationModel.setClassFile(iClassFile);
            return classFileMarkerAnnotationModel;
        }
        return null;
    }

    protected IDocument createEmptyDocument() {
        IDocument iDocument = FileBuffers.getTextFileBufferManager().createEmptyDocument(null, LocationKind.IFILE);
        if (iDocument instanceof ISynchronizable) {
            ((ISynchronizable)iDocument).setLockObject(new Object());
        }
        return iDocument;
    }

    protected IDocument createDocument(Object object) throws CoreException {
        IDocument iDocument = super.createDocument(object);
        if (iDocument != null) {
            JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
            javaTextTools.setupJavaDocumentPartitioner(iDocument, "___java_partitioning");
        }
        return iDocument;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IClassFileEditorInput) {
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)object;
            ExternalClassFileEditorInput externalClassFileEditorInput = null;
            if (iClassFileEditorInput instanceof ExternalClassFileEditorInput) {
                externalClassFileEditorInput = (ExternalClassFileEditorInput)iClassFileEditorInput;
            }
            if (externalClassFileEditorInput != null) {
                try {
                    this.refreshFile(externalClassFileEditorInput.getFile());
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, JavaEditorMessages.ClassFileDocumentProvider_error_createElementInfo);
                }
            }
            IDocument iDocument = this.createDocument(iClassFileEditorInput);
            IAnnotationModel iAnnotationModel = this.createClassFileAnnotationModel(iClassFileEditorInput);
            if (externalClassFileEditorInput != null) {
                ClassFileInfo classFileInfo = new ClassFileInfo(iDocument, iAnnotationModel, null);
                classFileInfo.fModificationStamp = this.computeModificationStamp((IResource)externalClassFileEditorInput.getFile());
                classFileInfo.fEncoding = this.getPersistedEncoding(object);
                return classFileInfo;
            }
            if (iClassFileEditorInput instanceof InternalClassFileEditorInput) {
                ClassFileSynchronizer classFileSynchronizer = new ClassFileSynchronizer(iClassFileEditorInput);
                classFileSynchronizer.install();
                ClassFileInfo classFileInfo = new ClassFileInfo(iDocument, iAnnotationModel, classFileSynchronizer);
                classFileInfo.fEncoding = this.getPersistedEncoding(object);
                return classFileInfo;
            }
        }
        return null;
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        ClassFileInfo classFileInfo = (ClassFileInfo)elementInfo;
        if (classFileInfo.fClassFileSynchronizer != null) {
            classFileInfo.fClassFileSynchronizer.uninstall();
            classFileInfo.fClassFileSynchronizer = null;
        }
        super.disposeElementInfo(object, elementInfo);
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument) throws CoreException {
    }

    public boolean isSynchronized(Object object) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
        if (elementInfo instanceof ClassFileInfo) {
            IResource iResource;
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)object;
            try {
                iResource = iClassFileEditorInput.getClassFile().getUnderlyingResource();
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
            return iResource == null || iResource.isSynchronized(0);
        }
        return false;
    }

    protected void handleDeleted(IClassFileEditorInput iClassFileEditorInput) {
        this.fireElementDeleted(iClassFileEditorInput);
    }

    protected void fireInputChanged(IClassFileEditorInput iClassFileEditorInput) {
        ArrayList arrayList = new ArrayList(this.fInputListeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((InputChangeListener)iterator.next()).inputChanged(iClassFileEditorInput);
        }
    }

    public void addInputChangeListener(InputChangeListener inputChangeListener) {
        this.fInputListeners.add(inputChangeListener);
    }

    public void removeInputChangeListener(InputChangeListener inputChangeListener) {
        this.fInputListeners.remove(inputChangeListener);
    }

    protected class ClassFileInfo
    extends FileDocumentProvider.FileInfo {
        ClassFileSynchronizer fClassFileSynchronizer = null;

        ClassFileInfo(IDocument iDocument, IAnnotationModel iAnnotationModel, _FileSynchronizer _FileSynchronizer2) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, iDocument, iAnnotationModel, (FileDocumentProvider.FileSynchronizer)_FileSynchronizer2);
        }

        ClassFileInfo(IDocument iDocument, IAnnotationModel iAnnotationModel, ClassFileSynchronizer classFileSynchronizer) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, iDocument, iAnnotationModel, null);
            this.fClassFileSynchronizer = classFileSynchronizer;
        }
    }

    protected class ClassFileSynchronizer
    implements IElementChangedListener {
        protected IClassFileEditorInput fInput;
        protected IPackageFragmentRoot fPackageFragmentRoot;

        public ClassFileSynchronizer(IClassFileEditorInput iClassFileEditorInput) {
            this.fInput = iClassFileEditorInput;
            IJavaElement iJavaElement = this.fInput.getClassFile().getParent();
            while (iJavaElement != null && !(iJavaElement instanceof IPackageFragmentRoot)) {
                iJavaElement = iJavaElement.getParent();
            }
            this.fPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
        }

        public void install() {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }

        public void uninstall() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            this.check(this.fPackageFragmentRoot, elementChangedEvent.getDelta());
        }

        protected boolean check(IPackageFragmentRoot iPackageFragmentRoot, IJavaElementDelta iJavaElementDelta) {
            IJavaElement iJavaElement = iJavaElementDelta.getElement();
            if (((iJavaElementDelta.getKind() & 2) != 0 || (iJavaElementDelta.getFlags() & 0x400) != 0) && (iJavaElement.equals(iPackageFragmentRoot.getJavaProject()) || iJavaElement.equals(iPackageFragmentRoot))) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((iJavaElementDelta.getFlags() & 0x8000) != 0 && iPackageFragmentRoot.equals(iJavaElement)) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((iJavaElementDelta.getFlags() & 0x80) != 0 && iPackageFragmentRoot.equals(iJavaElement)) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iJavaElementDeltaArray.length) {
                if (this.check(iPackageFragmentRoot, iJavaElementDeltaArray[n])) {
                    return true;
                }
                ++n;
            }
            if ((iJavaElementDelta.getFlags() & 0x2000) != 0 || (iJavaElementDelta.getFlags() & 0x1000) != 0) {
                IClassFile iClassFile = this.fInput != null ? this.fInput.getClassFile() : null;
                IJavaProject iJavaProject = iPackageFragmentRoot != null ? iPackageFragmentRoot.getJavaProject() : null;
                boolean bl = false;
                if (iClassFile != null && iJavaProject != null) {
                    bl = iJavaProject.isOnClasspath((IJavaElement)iClassFile);
                }
                if (bl) {
                    ClassFileDocumentProvider.this.fireInputChanged(this.fInput);
                    return false;
                }
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            return false;
        }
    }

    public static interface InputChangeListener {
        public void inputChanged(IClassFileEditorInput var1);
    }

    protected class _FileSynchronizer
    extends FileDocumentProvider.FileSynchronizer {
        public _FileSynchronizer(IFileEditorInput iFileEditorInput) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, iFileEditorInput);
        }
    }
}

