/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.OverrideIndicatorManager;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.QuickAssistLightBulbUpdater;

public class JavaSelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    private Annotation fAnnotation;
    private AnnotationPreferenceLookup fAnnotationPreferenceLookup;
    private IPreferenceStore fStore;
    private boolean fHasCorrection;
    private ResourceBundle fBundle;
    static /* synthetic */ Class class$0;

    public JavaSelectAnnotationRulerAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        super(resourceBundle, string, iTextEditor, iVerticalRulerInfo);
        this.fBundle = resourceBundle;
        this.fTextEditor = iTextEditor;
        this.fAnnotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
        this.fStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.java_select_marker_ruler_action");
    }

    public void run() {
        if (this.fStore.getBoolean("editor_annotation_roll_over")) {
            return;
        }
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fAnnotation instanceof OverrideIndicatorManager.OverrideIndicator) {
            ((OverrideIndicatorManager.OverrideIndicator)this.fAnnotation).open();
            return;
        }
        if (this.fHasCorrection) {
            ITextOperationTarget iTextOperationTarget;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iTextOperationTarget = (ITextOperationTarget)this.fTextEditor.getAdapter((Class)clazz)) != null && iTextOperationTarget.canDoOperation(22)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                iTextOperationTarget.doOperation(22);
            }
            return;
        }
        super.run();
    }

    public void update() {
        this.findJavaAnnotation();
        this.setEnabled(true);
        if (this.fAnnotation instanceof OverrideIndicatorManager.OverrideIndicator) {
            this.initialize(this.fBundle, "JavaSelectAnnotationRulerAction.OpenSuperImplementation.");
            return;
        }
        if (this.fHasCorrection) {
            if (this.fAnnotation instanceof QuickAssistLightBulbUpdater.AssistAnnotation) {
                this.initialize(this.fBundle, "JavaSelectAnnotationRulerAction.QuickAssist.");
            } else {
                this.initialize(this.fBundle, "JavaSelectAnnotationRulerAction.QuickFix.");
            }
            return;
        }
        this.initialize(this.fBundle, "JavaSelectAnnotationRulerAction.GotoAnnotation.");
        super.update();
    }

    private void findJavaAnnotation() {
        this.fPosition = null;
        this.fAnnotation = null;
        this.fHasCorrection = false;
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        IAnnotationAccessExtension iAnnotationAccessExtension = this.getAnnotationAccessExtension();
        IDocument iDocument = this.getDocument();
        if (abstractMarkerAnnotationModel == null) {
            return;
        }
        boolean bl = this.fStore.getBoolean("org.eclipse.wst.jsdt.quickassist.lightbulb");
        Iterator iterator = abstractMarkerAnnotationModel.getAnnotationIterator();
        int n = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            String string;
            boolean bl2;
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.isMarkedDeleted()) continue;
            int n2 = n;
            if (iAnnotationAccessExtension != null && (n2 = iAnnotationAccessExtension.getLayer(annotation)) < n || !this.includesRulerLine(position = abstractMarkerAnnotationModel.getPosition(annotation), iDocument)) continue;
            boolean bl3 = bl2 = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (!bl2 && (bl && annotation instanceof QuickAssistLightBulbUpdater.AssistAnnotation || JavaCorrectionProcessor.hasCorrections(annotation))) {
                this.fPosition = position;
                this.fAnnotation = annotation;
                this.fHasCorrection = true;
                n = n2;
                continue;
            }
            AnnotationPreference annotationPreference = this.fAnnotationPreferenceLookup.getAnnotationPreference(annotation);
            if (annotationPreference == null || (string = annotationPreference.getVerticalRulerPreferenceKey()) == null || !this.fStore.getBoolean(string)) continue;
            this.fPosition = position;
            this.fAnnotation = annotation;
            this.fHasCorrection = false;
            n = n2;
        }
    }
}

