/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

public class JavaSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;
    private SmartBackspaceManager fBackspaceManager;
    private boolean fIsSetVisibleDocumentDelayed = false;

    public JavaSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, IPreferenceStore iPreferenceStore) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
        this.setPreferenceStore(iPreferenceStore);
    }

    public IFormattingContext createFormattingContext() {
        CommentFormattingContext commentFormattingContext = new CommentFormattingContext();
        HashMap hashMap = new HashMap(JavaCore.getOptions());
        commentFormattingContext.setProperty("formatting.context.preferences", hashMap);
        return commentFormattingContext;
    }

    public void doOperation(int n) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (n) {
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 52: {
                if (this.fStructurePresenter != null) {
                    this.fStructurePresenter.showInformation();
                }
                return;
            }
            case 53: {
                if (this.fHierarchyPresenter != null) {
                    this.fHierarchyPresenter.showInformation();
                }
                return;
            }
        }
        super.doOperation(n);
    }

    public boolean canDoOperation(int n) {
        if (n == 51) {
            return this.fOutlinePresenter != null;
        }
        if (n == 52) {
            return this.fStructurePresenter != null;
        }
        if (n == 53) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(n);
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        Object object;
        StyledText styledText = this.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            Color color;
            object = styledText.getForeground();
            if (object != null && object.isDisposed()) {
                styledText.setForeground(null);
            }
            if ((color = styledText.getBackground()) != null && color.isDisposed()) {
                styledText.setBackground(null);
            }
        }
        super.configure(sourceViewerConfiguration);
        if (sourceViewerConfiguration instanceof JavaSourceViewerConfiguration) {
            object = (JavaSourceViewerConfiguration)sourceViewerConfiguration;
            this.fOutlinePresenter = ((JavaSourceViewerConfiguration)((Object)object)).getOutlinePresenter((ISourceViewer)this, false);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fStructurePresenter = ((JavaSourceViewerConfiguration)((Object)object)).getOutlinePresenter((ISourceViewer)this, true);
            if (this.fStructurePresenter != null) {
                this.fStructurePresenter.install((ITextViewer)this);
            }
            this.fHierarchyPresenter = ((JavaSourceViewerConfiguration)((Object)object)).getHierarchyPresenter((ISourceViewer)this, true);
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.install((ITextViewer)this);
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
        this.fIsConfigured = true;
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore iPreferenceStore, String string, Display display) {
        RGB rGB = null;
        if (iPreferenceStore.contains(string) && (rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string)) != null) {
            return new Color((Device)display, rGB);
        }
        return null;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public Point rememberSelection() {
        return super.rememberSelection();
    }

    public void restoreSelection() {
        super.restoreSelection();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(string) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(string) || "AbstractTextEditor.Color.Background".equals(string) || "AbstractTextEditor.Color.Background.SystemDefault".equals(string) || "AbstractTextEditor.Color.SelectionForeground".equals(string) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(string) || "AbstractTextEditor.Color.SelectionBackground".equals(string) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(string)) {
            this.initializeViewerColors();
        }
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = iPreferenceStore;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    public void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.fPreferenceStore != null && this.fPreferenceStore.getBoolean("editor_folding_enabled") && !this.isProjectionMode()) {
            this.enableProjection();
        }
    }

    protected void createControl(Composite composite, int n) {
        if ((n & 0x4000000) == 0 && (n & 0x2000000) == 0) {
            n |= 0x2000000;
        }
        super.createControl(composite, n);
        this.fBackspaceManager = new SmartBackspaceManager();
        this.fBackspaceManager.install((ITextViewer)this);
        StyledText styledText = this.getTextWidget();
        styledText.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent bidiSegmentEvent) {
                if (JavaSourceViewer.this.redraws()) {
                    bidiSegmentEvent.segments = JavaSourceViewer.this.getBidiLineSegments(bidiSegmentEvent.lineOffset, bidiSegmentEvent.lineText);
                }
            }
        });
    }

    public SmartBackspaceManager getBackspaceManager() {
        return this.fBackspaceManager;
    }

    protected void handleDispose() {
        if (this.fBackspaceManager != null) {
            this.fBackspaceManager.uninstall();
            this.fBackspaceManager = null;
        }
        super.handleDispose();
    }

    public void prependTextPresentationListener(ITextPresentationListener iTextPresentationListener) {
        Assert.isNotNull((Object)iTextPresentationListener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(iTextPresentationListener);
        this.fTextPresentationListeners.add(0, iTextPresentationListener);
    }

    void setReconciler(IReconciler iReconciler) {
        this.fReconciler = iReconciler;
    }

    IReconciler getReconciler() {
        return this.fReconciler;
    }

    protected int[] getBidiLineSegments(int n, String string) {
        if (string != null && string.length() > 0) {
            int n2 = this.widgetOffset2ModelOffset(n);
            try {
                return JavaSourceViewer.getBidiLineSegments(this.getDocument(), n2);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    protected static int[] getBidiLineSegments(IDocument iDocument, int n) throws BadLocationException {
        if (iDocument == null) {
            return null;
        }
        IRegion iRegion = iDocument.getLineInformationOfOffset(n);
        ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)"___java_partitioning", (int)n, (int)iRegion.getLength(), (boolean)false);
        ArrayList<ITypedRegion> arrayList = new ArrayList<ITypedRegion>();
        int n2 = 0;
        while (n2 < iTypedRegionArray.length) {
            if ("__java_string".equals(iTypedRegionArray[n2].getType())) {
                arrayList.add(iTypedRegionArray[n2]);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        n2 = arrayList.size();
        int[] nArray = new int[n2 * 2 + 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            ITypedRegion iTypedRegion = (ITypedRegion)arrayList.get(n4);
            if (n4 == 0) {
                nArray[n3++] = 0;
            }
            if ((n5 = iTypedRegion.getOffset() - n) > nArray[n3 - 1]) {
                nArray[n3++] = n5;
            }
            if (n5 + iTypedRegion.getLength() >= iRegion.getLength()) break;
            nArray[n3++] = n5 + iTypedRegion.getLength();
            ++n4;
        }
        if (n3 < nArray.length) {
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            nArray = nArray2;
        }
        return nArray;
    }

    void prepareDelayedProjection() {
        Assert.isTrue((!this.fIsSetVisibleDocumentDelayed ? 1 : 0) != 0);
        this.fIsSetVisibleDocumentDelayed = true;
    }

    protected void setVisibleDocument(IDocument iDocument) {
        if (this.fIsSetVisibleDocumentDelayed) {
            this.fIsSetVisibleDocumentDelayed = false;
            IDocument iDocument2 = this.getVisibleDocument();
            this.enableProjection();
            IDocument iDocument3 = this.getVisibleDocument();
            if (iDocument3 != null && iDocument3 != iDocument2) {
                return;
            }
        }
        super.setVisibleDocument(iDocument);
    }

    protected StyleRange modelStyleRange2WidgetStyleRange(StyleRange styleRange) {
        IRegion iRegion = this.modelRange2WidgetRange((IRegion)new Region(styleRange.start, styleRange.length));
        if (iRegion != null) {
            styleRange.start = iRegion.getOffset();
            styleRange.length = iRegion.getLength();
            return styleRange;
        }
        return null;
    }
}

