/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticToken;

public class SemanticHighlightings {
    public static final String STATIC_FINAL_FIELD = "staticFinalField";
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    public static final String STATIC_METHOD_INVOCATION = "staticMethodInvocation";
    public static final String INHERITED_METHOD_INVOCATION = "inheritedMethodInvocation";
    public static final String ANNOTATION_ELEMENT_REFERENCE = "annotationElementReference";
    public static final String ABSTRACT_METHOD_INVOCATION = "abstractMethodInvocation";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String DEPRECATED_MEMBER = "deprecatedMember";
    public static final String TYPE_VARIABLE = "typeParameter";
    public static final String OBJECT_INITIALIZER = "objectInitializer";
    public static final String METHOD = "method";
    public static final String AUTOBOXING = "autoboxing";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String INTERFACE = "interface";
    public static final String ANNOTATION = "annotation";
    public static final String TYPE_ARGUMENT = "typeArgument";
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public RGB getDefaultDefaultTextColor() {
        return new RGB(13, 100, 0);
    }

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new ObjectInitializerHighlighting(), new DeprecatedMemberHighlighting(), new MethodDeclarationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new MethodHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        SemanticHighlighting[] semanticHighlightingArray = SemanticHighlightings.getSemanticHighlightings();
        int n = 0;
        int n2 = semanticHighlightingArray.length;
        while (n < n2) {
            SemanticHighlighting semanticHighlighting = semanticHighlightingArray[n];
            SemanticHighlightings.setDefaultAndFireEvent(iPreferenceStore, SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), semanticHighlighting.getDefaultTextColor());
            iPreferenceStore.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            iPreferenceStore.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            iPreferenceStore.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            iPreferenceStore.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), semanticHighlighting.isUnderlineByDefault());
            iPreferenceStore.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
            ++n;
        }
        SemanticHighlightings.convertMethodHighlightingPreferences(iPreferenceStore);
        SemanticHighlightings.convertAnnotationHighlightingPreferences(iPreferenceStore);
    }

    public static boolean affectsEnablement(IPreferenceStore iPreferenceStore, PropertyChangeEvent propertyChangeEvent) {
        String string = null;
        SemanticHighlighting[] semanticHighlightingArray = SemanticHighlightings.getSemanticHighlightings();
        int n = 0;
        while (n < semanticHighlightingArray.length) {
            if (propertyChangeEvent.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightingArray[n]))) {
                string = propertyChangeEvent.getProperty();
                break;
            }
            ++n;
        }
        if (string == null) {
            return false;
        }
        n = 0;
        while (n < semanticHighlightingArray.length) {
            String string2 = SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightingArray[n]);
            if (!string2.equals(string) && iPreferenceStore.getBoolean(string2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore iPreferenceStore) {
        SemanticHighlighting[] semanticHighlightingArray = SemanticHighlightings.getSemanticHighlightings();
        boolean bl = false;
        int n = 0;
        while (n < semanticHighlightingArray.length) {
            String string = SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightingArray[n]);
            if (iPreferenceStore.getBoolean(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static void convertMethodHighlightingPreferences(IPreferenceStore iPreferenceStore) {
        String string = "semanticHighlighting.method.color";
        String string2 = "semanticHighlighting.method.bold";
        String string3 = "semanticHighlighting.method.italic";
        String string4 = "semanticHighlighting.method.enabled";
        String string5 = "java_method_name";
        String string6 = "java_method_name_bold";
        String string7 = "java_method_name_italic";
        if (SemanticHighlightings.conditionalReset(iPreferenceStore, string5, string) || SemanticHighlightings.conditionalReset(iPreferenceStore, string6, string2) || SemanticHighlightings.conditionalReset(iPreferenceStore, string7, string3)) {
            iPreferenceStore.setValue(string4, true);
        }
    }

    private static void convertAnnotationHighlightingPreferences(IPreferenceStore iPreferenceStore) {
        String string = "semanticHighlighting.annotation.color";
        String string2 = "semanticHighlighting.annotation.bold";
        String string3 = "semanticHighlighting.annotation.italic";
        String string4 = "semanticHighlighting.annotation.strikethrough";
        String string5 = "semanticHighlighting.annotation.underline";
        String string6 = "semanticHighlighting.annotation.enabled";
        String string7 = "java_annotation";
        String string8 = "java_annotation_bold";
        String string9 = "java_annotation_italic";
        String string10 = "java_annotation_strikethrough";
        String string11 = "java_annotation_underline";
        if (SemanticHighlightings.conditionalReset(iPreferenceStore, string7, string) || SemanticHighlightings.conditionalReset(iPreferenceStore, string8, string2) || SemanticHighlightings.conditionalReset(iPreferenceStore, string9, string3) || SemanticHighlightings.conditionalReset(iPreferenceStore, string10, string4) || SemanticHighlightings.conditionalReset(iPreferenceStore, string11, string5)) {
            iPreferenceStore.setValue(string6, true);
        }
    }

    private static boolean conditionalReset(IPreferenceStore iPreferenceStore, String string, String string2) {
        if (!iPreferenceStore.isDefault(string)) {
            if (iPreferenceStore.isDefault(string2)) {
                iPreferenceStore.setValue(string2, iPreferenceStore.getString(string));
            }
            iPreferenceStore.setToDefault(string);
            return true;
        }
        return false;
    }

    private static void setDefaultAndFireEvent(IPreferenceStore iPreferenceStore, String string, RGB rGB) {
        RGB rGB2 = null;
        if (iPreferenceStore.isDefault(string)) {
            rGB2 = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string);
        }
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)string, (RGB)rGB);
        if (rGB2 != null && !rGB2.equals((Object)rGB)) {
            iPreferenceStore.firePropertyChangeEvent(string, (Object)rGB2, (Object)rGB);
        }
    }

    private SemanticHighlightings() {
    }

    private static final class DeprecatedMemberHighlighting
    extends SemanticHighlighting {
        private DeprecatedMemberHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.DEPRECATED_MEMBER;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isStrikethroughByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_deprecatedMember;
        }

        public boolean consumes(SemanticToken semanticToken) {
            IBinding iBinding = this.getMethodBinding(semanticToken);
            return iBinding != null ? iBinding.isDeprecated() : false;
        }

        private IBinding getMethodBinding(SemanticToken semanticToken) {
            Object object = null;
            SimpleName simpleName = semanticToken.getNode();
            ASTNode aSTNode = simpleName.getParent();
            while (this.isTypePath((ASTNode)simpleName, aSTNode)) {
                simpleName = aSTNode;
                aSTNode = aSTNode.getParent();
            }
            object = aSTNode != null && simpleName.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY ? ((ClassInstanceCreation)aSTNode).resolveConstructorBinding() : semanticToken.getBinding();
            return object;
        }

        private boolean isTypePath(ASTNode aSTNode, ASTNode aSTNode2) {
            if (aSTNode2 instanceof Type) {
                StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
                return structuralPropertyDescriptor == ParameterizedType.TYPE_PROPERTY || structuralPropertyDescriptor == SimpleType.NAME_PROPERTY;
            }
            if (aSTNode2 instanceof QualifiedName) {
                StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
                return structuralPropertyDescriptor == QualifiedName.NAME_PROPERTY;
            }
            return false;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE_DECLARATION;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_localVariableDeclaration;
        }

        public boolean consumes(SemanticToken semanticToken) {
            ASTNode aSTNode;
            SimpleName simpleName = semanticToken.getNode();
            StructuralPropertyDescriptor structuralPropertyDescriptor = simpleName.getLocationInParent();
            if ((structuralPropertyDescriptor == VariableDeclarationFragment.NAME_PROPERTY || structuralPropertyDescriptor == SingleVariableDeclaration.NAME_PROPERTY) && (aSTNode = simpleName.getParent()) instanceof VariableDeclaration) {
                return (aSTNode = aSTNode.getParent()) == null || !(aSTNode instanceof FieldDeclaration);
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_localVariable;
        }

        public boolean consumes(SemanticToken semanticToken) {
            IBinding iBinding = semanticToken.getBinding();
            if (iBinding != null && iBinding.getKind() == 3 && !((IVariableBinding)iBinding).isField()) {
                ASTNode aSTNode = semanticToken.getRoot().findDeclaringNode(iBinding);
                return aSTNode instanceof VariableDeclaration;
            }
            return false;
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD_DECLARATION;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_methodDeclaration;
        }

        public boolean consumes(SemanticToken semanticToken) {
            StructuralPropertyDescriptor structuralPropertyDescriptor = semanticToken.getNode().getLocationInParent();
            return structuralPropertyDescriptor == MethodDeclaration.NAME_PROPERTY || structuralPropertyDescriptor == AnnotationTypeMemberDeclaration.NAME_PROPERTY;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlighting {
        private MethodHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_method;
        }

        public boolean consumes(SemanticToken semanticToken) {
            IBinding iBinding = this.getMethodBinding(semanticToken);
            return iBinding != null && iBinding.getKind() == 4;
        }

        private IBinding getMethodBinding(SemanticToken semanticToken) {
            Object object = null;
            SimpleName simpleName = semanticToken.getNode();
            ASTNode aSTNode = simpleName.getParent();
            while (this.isTypePath((ASTNode)simpleName, aSTNode)) {
                simpleName = aSTNode;
                aSTNode = aSTNode.getParent();
            }
            object = aSTNode != null && simpleName.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY ? ((ClassInstanceCreation)aSTNode).resolveConstructorBinding() : semanticToken.getBinding();
            return object;
        }

        private boolean isTypePath(ASTNode aSTNode, ASTNode aSTNode2) {
            if (aSTNode2 instanceof Type) {
                StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
                return structuralPropertyDescriptor == ParameterizedType.TYPE_PROPERTY || structuralPropertyDescriptor == SimpleType.NAME_PROPERTY;
            }
            if (aSTNode2 instanceof QualifiedName) {
                StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
                return structuralPropertyDescriptor == QualifiedName.NAME_PROPERTY;
            }
            return false;
        }
    }

    private static final class ObjectInitializerHighlighting
    extends SemanticHighlighting {
        private ObjectInitializerHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.OBJECT_INITIALIZER;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_objectInitializer;
        }

        public boolean consumes(SemanticToken semanticToken) {
            SimpleName simpleName = semanticToken.getNode();
            StructuralPropertyDescriptor structuralPropertyDescriptor = simpleName.getLocationInParent();
            if (structuralPropertyDescriptor == ObjectLiteralField.FIELD_NAME_PROPERTY) {
                ASTNode aSTNode = simpleName.getParent();
                return aSTNode != null && aSTNode instanceof ObjectLiteral;
            }
            return false;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.PARAMETER_VARIABLE;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_parameterVariable;
        }

        public boolean consumes(SemanticToken semanticToken) {
            IBinding iBinding = semanticToken.getBinding();
            if (iBinding != null && iBinding.getKind() == 3 && !((IVariableBinding)iBinding).isField()) {
                ASTNode aSTNode = semanticToken.getRoot().findDeclaringNode(iBinding);
                return aSTNode != null && aSTNode.getLocationInParent() == MethodDeclaration.PARAMETERS_PROPERTY;
            }
            return false;
        }
    }
}

