/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPostSaveListener;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpSaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.ISaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.SaveParticipantDescriptor;

public final class SaveParticipantRegistry {
    private static final IPostSaveListener[] EMPTY_ARRAY = new IPostSaveListener[0];
    private Map fDescriptors;

    public synchronized SaveParticipantDescriptor[] getSaveParticipantDescriptors() {
        this.ensureRegistered();
        return this.fDescriptors.values().toArray(new SaveParticipantDescriptor[this.fDescriptors.size()]);
    }

    public synchronized SaveParticipantDescriptor getSaveParticipantDescriptor(String string) {
        this.ensureRegistered();
        return (SaveParticipantDescriptor)this.fDescriptors.get(string);
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadDescriptors();
        }
    }

    private void reloadDescriptors() {
        HashMap<String, 1> hashMap = new HashMap<String, 1>();
        SaveParticipantDescriptor saveParticipantDescriptor = new SaveParticipantDescriptor(new CleanUpPostSaveListener()){

            public ISaveParticipantPreferenceConfiguration createPreferenceConfiguration() {
                return new CleanUpSaveParticipantPreferenceConfiguration();
            }
        };
        hashMap.put(saveParticipantDescriptor.getId(), saveParticipantDescriptor);
        this.fDescriptors = hashMap;
    }

    public void dispose() {
    }

    public synchronized boolean hasSettingsInScope(IScopeContext iScopeContext) {
        this.ensureRegistered();
        Iterator iterator = this.fDescriptors.values().iterator();
        while (iterator.hasNext()) {
            SaveParticipantDescriptor saveParticipantDescriptor = (SaveParticipantDescriptor)iterator.next();
            if (!saveParticipantDescriptor.getPreferenceConfiguration().hasSettingsInScope(iScopeContext)) continue;
            return true;
        }
        return false;
    }

    public IPostSaveListener[] getEnabledPostSaveListeners(IProject iProject) {
        return this.getEnabledPostSaveListeners((IScopeContext)new ProjectScope(iProject));
    }

    public synchronized IPostSaveListener[] getEnabledPostSaveListeners(IScopeContext iScopeContext) {
        this.ensureRegistered();
        ArrayList<IPostSaveListener> arrayList = null;
        Iterator iterator = this.fDescriptors.values().iterator();
        while (iterator.hasNext()) {
            SaveParticipantDescriptor saveParticipantDescriptor = (SaveParticipantDescriptor)iterator.next();
            if (!saveParticipantDescriptor.getPreferenceConfiguration().isEnabled(iScopeContext)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IPostSaveListener>();
            }
            arrayList.add(saveParticipantDescriptor.getPostSaveListener());
        }
        if (arrayList == null) {
            return EMPTY_ARRAY;
        }
        return arrayList.toArray(new IPostSaveListener[arrayList.size()]);
    }
}

