/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public StructureSelectNextAction(JavaEditor javaEditor, SelectionHistory selectionHistory) {
        super(SelectionActionMessages.StructureSelectNext_label, javaEditor, selectionHistory);
        this.setToolTipText(SelectionActionMessages.StructureSelectNext_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectNext_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.structured_select_next_action");
    }

    public StructureSelectNextAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange iSourceRange, ISourceReference iSourceReference, SelectionAnalyzer selectionAnalyzer) throws JavaModelException {
        ASTNode aSTNode;
        if (iSourceRange.getLength() == 0 && selectionAnalyzer.getLastCoveringNode() != null && (aSTNode = NextNodeAnalyzer.perform(iSourceRange.getOffset(), selectionAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(iSourceReference, aSTNode);
        }
        aSTNode = selectionAnalyzer.getFirstSelectedNode();
        if (aSTNode == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(iSourceRange, iSourceReference, selectionAnalyzer);
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(iSourceRange, iSourceReference, selectionAnalyzer);
        }
        ASTNode aSTNode3 = selectionAnalyzer.getSelectedNodes()[selectionAnalyzer.getSelectedNodes().length - 1];
        ASTNode aSTNode4 = StructureSelectNextAction.getNextNode(aSTNode2, aSTNode3);
        if (aSTNode4 == aSTNode2) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(iSourceReference, aSTNode.getParent());
        }
        int n = iSourceRange.getOffset();
        int n2 = Math.min(iSourceReference.getSourceRange().getLength(), aSTNode4.getStartPosition() + aSTNode4.getLength() - 1);
        return StructureSelectionAction.createSourceRange(n, n2);
    }

    private static ASTNode getNextNode(ASTNode aSTNode, ASTNode aSTNode2) {
        Object[] objectArray = StructureSelectionAction.getSiblingNodes(aSTNode2);
        if (objectArray == null || objectArray.length == 0) {
            return aSTNode;
        }
        if (aSTNode2 == objectArray[objectArray.length - 1]) {
            return aSTNode;
        }
        return objectArray[StructureSelectionAction.findIndex(objectArray, aSTNode2) + 1];
    }

    private static class NextNodeAnalyzer
    extends GenericVisitor {
        private final int fOffset;
        private ASTNode fNextNode;

        private NextNodeAnalyzer(int n) {
            super(true);
            this.fOffset = n;
        }

        public static ASTNode perform(int n, ASTNode aSTNode) {
            NextNodeAnalyzer nextNodeAnalyzer = new NextNodeAnalyzer(n);
            aSTNode.accept((ASTVisitor)nextNodeAnalyzer);
            return nextNodeAnalyzer.fNextNode;
        }

        protected boolean visitNode(ASTNode aSTNode) {
            int n = aSTNode.getStartPosition();
            int n2 = n + aSTNode.getLength();
            if (n == this.fOffset) {
                this.fNextNode = aSTNode;
                return true;
            }
            return n < this.fOffset && this.fOffset < n2;
        }
    }
}

