/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.ltk.ui.refactoring.model.AbstractSynchronizationLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.model.JavaModelLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.model.JavaModelProvider;
import org.eclipse.wst.jsdt.internal.ui.model.JavaSynchronizationContentProvider;
import org.eclipse.wst.jsdt.internal.ui.model.ModelMessages;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public final class JavaSynchronizationLabelProvider
extends AbstractSynchronizationLabelProvider
implements ITreePathLabelProvider {
    private ILabelProvider fLabelProvider = null;
    private Object fModelRoot = null;
    private Image fPackageImage = null;

    public void dispose() {
        if (this.fPackageImage != null && !this.fPackageImage.isDisposed()) {
            this.fPackageImage.dispose();
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        super.dispose();
    }

    public Image getDelegateImage(Object object) {
        IPackageFragment iPackageFragment;
        IResource iResource;
        if (object instanceof IPackageFragment && ((iResource = (iPackageFragment = (IPackageFragment)object).getResource()) == null || !iResource.exists())) {
            if (this.fPackageImage == null) {
                this.fPackageImage = JavaPluginImages.DESC_OBJS_PACKAGE.createImage();
            }
            return this.fPackageImage;
        }
        return super.getDelegateImage(object);
    }

    protected ILabelProvider getDelegateLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaModelLabelProvider(ModelMessages.JavaModelLabelProvider_project_preferences_label, ModelMessages.JavaModelLabelProvider_refactorings_label), (ILabelDecorator)new ProblemsLabelDecorator(null));
        }
        return this.fLabelProvider;
    }

    protected IDiff getDiff(Object object) {
        ISynchronizationContext iSynchronizationContext = this.getContext();
        IResource iResource = JavaModelProvider.getResource(object);
        if (iSynchronizationContext != null && iResource != null) {
            IDiff[] iDiffArray = JavaSynchronizationContentProvider.getDiffs(iSynchronizationContext, object);
            int n = 0;
            while (n < iDiffArray.length) {
                if (iSynchronizationContext.getDiffTree().getResource(iDiffArray[n]).equals((Object)iResource)) {
                    return iDiffArray[n];
                }
                ++n;
            }
        }
        return super.getDiff(object);
    }

    protected int getMarkerSeverity(Object object) {
        return -1;
    }

    protected Object getModelRoot() {
        if (this.fModelRoot == null) {
            this.fModelRoot = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        }
        return this.fModelRoot;
    }

    protected boolean hasDecendantConflicts(Object object) {
        ISynchronizationContext iSynchronizationContext = this.getContext();
        IResource iResource = JavaModelProvider.getResource(object);
        if (iSynchronizationContext != null && iResource != null) {
            return iSynchronizationContext.getDiffTree().getProperty(iResource.getFullPath(), 2);
        }
        return super.hasDecendantConflicts(object);
    }

    protected boolean isBusy(Object object) {
        ISynchronizationContext iSynchronizationContext = this.getContext();
        IResource iResource = JavaModelProvider.getResource(object);
        if (iSynchronizationContext != null && iResource != null) {
            return iSynchronizationContext.getDiffTree().getProperty(iResource.getFullPath(), 1);
        }
        return super.isBusy(object);
    }

    protected boolean isIncludeOverlays() {
        return true;
    }

    public void updateLabel(ViewerLabel viewerLabel, TreePath treePath) {
        IProject iProject;
        Object object = treePath.getFirstSegment();
        if (object instanceof IProject && treePath.getSegmentCount() == 2) {
            IFolder iFolder;
            iProject = (IProject)object;
            Object object2 = treePath.getLastSegment();
            if (object2 instanceof IFolder && !(iFolder = (IFolder)object2).getParent().equals((Object)iProject)) {
                return;
            }
        }
        viewerLabel.setImage(this.getImage(treePath.getLastSegment()));
        viewerLabel.setText(this.getText(treePath.getLastSegment()));
        iProject = this.getFont(treePath.getLastSegment());
        if (iProject != null) {
            viewerLabel.setFont((Font)iProject);
        }
    }
}

