/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiActionGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;

public class CommonLayoutActionGroup
extends MultiActionGroup {
    public static final String LAYOUT_GROUP_NAME = "layout";
    private IExtensionStateModel fStateModel;
    private StructuredViewer fStructuredViewer;
    private boolean fHasContributedToViewMenu = false;
    private IAction fHierarchicalLayout = null;
    private IAction fFlatLayoutAction = null;
    private IAction[] fActions;
    private IMenuManager fLayoutSubMenu;

    public CommonLayoutActionGroup(StructuredViewer structuredViewer, IExtensionStateModel iExtensionStateModel) {
        this.fStateModel = iExtensionStateModel;
        this.fStructuredViewer = structuredViewer;
    }

    public void fillActionBars(IActionBars iActionBars) {
        if (!this.fHasContributedToViewMenu) {
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            if (this.fLayoutSubMenu == null) {
                this.fLayoutSubMenu = new MenuManager(PackagesMessages.LayoutActionGroup_label);
                this.addActions(this.fLayoutSubMenu);
                iMenuManager.insertAfter("additions", (IContributionItem)new Separator(LAYOUT_GROUP_NAME));
            }
            iMenuManager.appendToGroup(LAYOUT_GROUP_NAME, (IContributionItem)this.fLayoutSubMenu);
            this.fHasContributedToViewMenu = true;
        }
    }

    public void unfillActionBars(IActionBars iActionBars) {
        if (this.fHasContributedToViewMenu) {
            if (this.fLayoutSubMenu != null) {
                iActionBars.getMenuManager().remove((IContributionItem)this.fLayoutSubMenu);
                this.fLayoutSubMenu.dispose();
                this.fLayoutSubMenu = null;
            }
            this.fHasContributedToViewMenu = false;
        }
    }

    private IAction[] createActions() {
        this.fFlatLayoutAction = new CommonLayoutAction(true);
        this.fFlatLayoutAction.setText(PackagesMessages.LayoutActionGroup_flatLayoutAction_label);
        JavaPluginImages.setLocalImageDescriptors(this.fFlatLayoutAction, "flatLayout.gif");
        this.fHierarchicalLayout = new CommonLayoutAction(false);
        this.fHierarchicalLayout.setText(PackagesMessages.LayoutActionGroup_hierarchicalLayoutAction_label);
        JavaPluginImages.setLocalImageDescriptors(this.fHierarchicalLayout, "hierarchicalLayout.gif");
        return new IAction[]{this.fFlatLayoutAction, this.fHierarchicalLayout};
    }

    public void setFlatLayout(boolean bl) {
        if (this.fActions == null) {
            this.fActions = this.createActions();
            this.setActions(this.fActions, bl ? 0 : 1);
        }
        this.fHierarchicalLayout.setChecked(!bl);
        this.fFlatLayoutAction.setChecked(bl);
    }

    private class CommonLayoutAction
    extends Action
    implements IAction {
        private final boolean fIsFlatLayout;

        public CommonLayoutAction(boolean bl) {
            super("", 8);
            this.fIsFlatLayout = bl;
            if (this.fIsFlatLayout) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.layout_flat_action");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.layout_hierarchical_action");
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (CommonLayoutActionGroup.this.fStateModel.getBooleanProperty("isLayoutFlat") == this.fIsFlatLayout) return;
            CommonLayoutActionGroup.this.fStateModel.setBooleanProperty("isLayoutFlat", this.fIsFlatLayout);
            CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(false);
            try {
                CommonLayoutActionGroup.this.fStructuredViewer.refresh();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(true);
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(true);
        }
    }
}

