/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class JavaNavigatorLabelProvider
implements ICommonLabelProvider {
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private PackageExplorerLabelProvider delegeteLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private IExtensionStateModel fStateModel;
    private IPropertyChangeListener fLayoutPropertyListener;

    public void init(ICommonContentExtensionSite iCommonContentExtensionSite) {
        this.fStateModel = iCommonContentExtensionSite.getExtensionStateModel();
        this.fContentProvider = (PackageExplorerContentProvider)iCommonContentExtensionSite.getExtension().getContentProvider();
        this.delegeteLabelProvider = this.createLabelProvider();
        this.delegeteLabelProvider.setIsFlatLayout(this.fStateModel.getBooleanProperty("isLayoutFlat"));
        this.fLayoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("isLayoutFlat".equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue() != null) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue() != false;
                    JavaNavigatorLabelProvider.this.delegeteLabelProvider.setIsFlatLayout(bl);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.fLayoutPropertyListener);
    }

    public String getDescription(Object object) {
        return this.formatMessage(object);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(this.fContentProvider);
    }

    public void dispose() {
        this.delegeteLabelProvider.dispose();
        this.fStateModel.removePropertyChangeListener(this.fLayoutPropertyListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.delegeteLabelProvider.propertyChange(propertyChangeEvent);
    }

    public void addLabelDecorator(ILabelDecorator iLabelDecorator) {
        this.delegeteLabelProvider.addLabelDecorator(iLabelDecorator);
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.delegeteLabelProvider.addListener(iLabelProviderListener);
    }

    public Color getBackground(Object object) {
        return this.delegeteLabelProvider.getBackground(object);
    }

    public Color getForeground(Object object) {
        return this.delegeteLabelProvider.getForeground(object);
    }

    public Image getImage(Object object) {
        return this.delegeteLabelProvider.getImage(object);
    }

    public boolean isLabelProperty(Object object, String string) {
        return this.delegeteLabelProvider.isLabelProperty(object, string);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        this.delegeteLabelProvider.removeListener(iLabelProviderListener);
    }

    public boolean equals(Object object) {
        return this.delegeteLabelProvider.equals(object);
    }

    public int hashCode() {
        return this.delegeteLabelProvider.hashCode();
    }

    public String toString() {
        return this.delegeteLabelProvider.toString();
    }

    public String getText(Object object) {
        return this.delegeteLabelProvider.getText(object);
    }

    public void setIsFlatLayout(boolean bl) {
        this.delegeteLabelProvider.setIsFlatLayout(bl);
    }

    private String formatMessage(Object object) {
        if (object instanceof IJavaElement) {
            return this.formatJavaElementMessage((IJavaElement)object);
        }
        if (object instanceof IResource) {
            return this.formatResourceMessage((IResource)object);
        }
        return "";
    }

    private String formatJavaElementMessage(IJavaElement iJavaElement) {
        return JavaElementLabels.getElementLabel(iJavaElement, this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iContainer != null && iContainer.getType() != 8) {
            return String.valueOf(iResource.getName()) + JavaElementLabels.CONCAT_STRING + iContainer.getFullPath().makeRelative().toString();
        }
        return iResource.getName();
    }

    public void restoreState(IMemento iMemento) {
    }

    public void saveState(IMemento iMemento) {
    }
}

