/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.IMultiElementTreeContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class WorkingSetAwareContentProvider
extends PackageExplorerContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;
    static /* synthetic */ Class class$0;

    public WorkingSetAwareContentProvider(boolean bl, WorkingSetModel workingSetModel) {
        super(bl);
        this.fWorkingSetModel = workingSetModel;
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetAwareContentProvider.this.workingSetModelChanged(propertyChangeEvent);
            }
        };
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildren(object);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == object ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        Object[] objectArray = object instanceof IWorkingSet ? this.getWorkingSetChildren((IWorkingSet)object) : super.getChildren(object);
        return objectArray;
    }

    private Object[] getWorkingSetChildren(IWorkingSet iWorkingSet) {
        IAdaptable[] iAdaptableArray = this.fWorkingSetModel.getChildren(iWorkingSet);
        HashSet<Object> hashSet = new HashSet<Object>(iAdaptableArray.length);
        int n = 0;
        while (n < iAdaptableArray.length) {
            IProject iProject;
            IAdaptable iAdaptable = iAdaptableArray[n];
            if (iAdaptable instanceof IProject) {
                this.processResource((IResource)((IProject)iAdaptable), hashSet);
            } else if (iAdaptable instanceof IResource) {
                iProject = ((IResource)iAdaptable).getProject();
                if (iProject.isOpen()) {
                    this.processResource((IResource)iAdaptable, hashSet);
                }
            } else if (iAdaptable instanceof IJavaProject) {
                hashSet.add(iAdaptable);
            } else if (iAdaptable instanceof IJavaElement) {
                iProject = (IJavaElement)iAdaptable;
                IProject iProject2 = this.getProject((IJavaElement)iProject);
                if (iProject2 != null && iProject2.isOpen()) {
                    hashSet.add(iProject);
                }
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iProject = (IProject)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.processResource((IResource)iProject, hashSet);
                }
            }
            ++n;
        }
        return hashSet.toArray();
    }

    private void processResource(IResource iResource, Collection collection) {
        IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
        if (iJavaElement != null && iJavaElement.exists()) {
            collection.add(iJavaElement);
        } else {
            collection.add(iResource);
        }
    }

    private IProject getProject(IJavaElement iJavaElement) {
        IJavaProject iJavaProject = iJavaElement.getJavaProject();
        if (iJavaProject == null) {
            return null;
        }
        return iJavaProject.getProject();
    }

    public TreePath[] getTreePaths(Object object) {
        if (object instanceof IWorkingSet) {
            TreePath treePath = new TreePath(new Object[]{object});
            return new TreePath[]{treePath};
        }
        List list = this.getModelPath(object);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            arrayList.addAll(this.getTreePaths(list, n));
            ++n;
        }
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }

    private List getModelPath(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        Object object2 = super.getParent(object);
        Object object3 = this.getViewerInput();
        while (object2 != null && !object2.equals(object3) && !(object2 instanceof IJavaModel)) {
            arrayList.add(object2);
            object2 = super.getParent(object2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private List getTreePaths(List list, int n) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Object object = this.getViewerInput();
        Object e = list.get(n);
        Object[] objectArray = this.fWorkingSetModel.getAllParents(e);
        int n2 = 0;
        while (n2 < objectArray.length) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (!objectArray[n2].equals(object)) {
                arrayList2.add(objectArray[n2]);
            }
            int n3 = n;
            while (n3 < list.size()) {
                arrayList2.add(list.get(n3));
                ++n3;
            }
            arrayList.add(new TreePath(arrayList2.toArray()));
            ++n2;
        }
        return arrayList;
    }

    public Object getParent(Object object) {
        Object[] objectArray = this.fWorkingSetModel.getAllParents(object);
        if (objectArray.length == 0) {
            return super.getParent(object);
        }
        Object object2 = objectArray[0];
        return object2;
    }

    protected void augmentElementToRefresh(List list, int n, Object object) {
        Object object2;
        if (JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(object)) {
            list.remove(object);
            list.add(this.fWorkingSetModel);
        } else if (n == 2 && (object2 = this.internalGetParent(object)) != null) {
            list.addAll(Arrays.asList(this.fWorkingSetModel.getAllParents(object2)));
        }
        object2 = this.fWorkingSetModel.getNonProjectTopLevelElements();
        if (object2.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isChildOf(e, list)) continue;
            arrayList.add(e);
        }
        list.addAll(arrayList);
    }

    private void workingSetModelChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        Object object = propertyChangeEvent.getNewValue();
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(string)) {
            arrayList.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(string)) {
            arrayList.add(object);
        } else if ("workingSetNameChange".equals(string)) {
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        this.postRefresh(arrayList, true, arrayList2);
        this.executeRunnables(arrayList2);
    }

    private boolean isChildOf(Object object, List list) {
        Object object2 = super.getParent(object);
        if (object2 == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            while (object2 != null) {
                if (object2.equals(e)) {
                    return true;
                }
                object2 = super.getParent(object2);
            }
        }
        return false;
    }
}

