/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;

public class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    public static final Object DATA_ADD_ENTRY = "add_classpath_entry";
    public static final Object DATA_REVEAL_ENTRY = "select_classpath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_classpath_attribute_key";
    public static final Object DATA_BLOCK = "block_until_buildpath_applied";
    private BuildPathsBlock fBuildPathsBlock;
    private boolean fBlockOnApply = false;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        IProject iProject = this.getProject();
        Control control = iProject == null || !this.isJavaProject(iProject) ? this.createWithoutJava(composite) : (!iProject.isOpen() ? this.createForClosedProject(composite) : this.createWithJava(composite, iProject));
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.build_path_property_page_context");
    }

    private IDialogSettings getSettings() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(PAGE_SETTINGS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(PAGE_SETTINGS);
            iDialogSettings2.put(INDEX, 0);
        }
        return iDialogSettings2;
    }

    public void setVisible(boolean bl) {
        if (this.fBuildPathsBlock != null) {
            if (!bl) {
                this.fBuildPathsBlock.aboutToDispose();
                if (this.fBuildPathsBlock.hasChangesInDialog()) {
                    String string = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_title;
                    String string2 = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_message;
                    String[] stringArray = new String[]{PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_save, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_discard, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_ignore};
                    MessageDialog messageDialog = new MessageDialog(this.getShell(), string, null, string2, 3, stringArray, 0);
                    int n = messageDialog.open();
                    if (n == 0) {
                        this.performOk();
                    } else if (n == 1) {
                        this.fBuildPathsBlock.init(JavaCore.create((IProject)this.getProject()), null);
                    }
                }
            } else {
                this.fBuildPathsBlock.aboutToShow();
                if (!this.fBuildPathsBlock.hasChangesInDialog() && this.fBuildPathsBlock.hasChangesInClasspathFile()) {
                    this.fBuildPathsBlock.init(JavaCore.create((IProject)this.getProject()), null);
                }
            }
        }
        super.setVisible(bl);
    }

    private Control createWithJava(Composite composite, IProject iProject) {
        IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer = null;
        IPreferencePageContainer iPreferencePageContainer = this.getContainer();
        if (iPreferencePageContainer instanceof IWorkbenchPreferenceContainer) {
            iWorkbenchPreferenceContainer = (IWorkbenchPreferenceContainer)iPreferencePageContainer;
        }
        this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), this, this.getSettings().getInt(INDEX), false, iWorkbenchPreferenceContainer);
        this.fBuildPathsBlock.init(JavaCore.create((IProject)iProject), null);
        return this.fBuildPathsBlock.createControl(composite);
    }

    private Control createWithoutJava(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_no_java_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_closed_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null) {
            IJavaElement iJavaElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) instanceof IJavaProject) {
                return ((IJavaProject)iJavaElement).getProject();
            }
        }
        return null;
    }

    private boolean isJavaProject(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.wst.jsdt.core.jsNature");
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.fBuildPathsBlock.aboutToDispose();
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
            if (this.fBuildPathsBlock.hasChangesInDialog() || this.fBuildPathsBlock.isClassfileMissing() || this.fBuildPathsBlock.hasChangesInSuper()) {
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                        BuildPathsPropertyPage.this.fBuildPathsBlock.configureJavaProject(iProgressMonitor);
                    }
                };
                WorkbenchRunnableAdapter workbenchRunnableAdapter = new WorkbenchRunnableAdapter(iWorkspaceRunnable);
                if (this.fBlockOnApply) {
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)workbenchRunnableAdapter);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ExceptionHandler.handle(invocationTargetException, this.getShell(), PreferencesMessages.BuildPathsPropertyPage_error_title, PreferencesMessages.BuildPathsPropertyPage_error_message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                } else {
                    workbenchRunnableAdapter.runAsUserJob(PreferencesMessages.BuildPathsPropertyPage_job_title, null);
                }
            }
        }
        return true;
    }

    public void statusChanged(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    public void applyData(Object object) {
        if (object instanceof Map) {
            Object object2;
            Map map = (Map)object;
            Object v = map.get(DATA_REVEAL_ENTRY);
            if (v instanceof IClasspathEntry) {
                String string;
                object2 = (IClasspathEntry)v;
                Object v2 = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
                String string2 = string = v2 instanceof String ? (String)v2 : null;
                if (this.fBuildPathsBlock != null) {
                    this.fBuildPathsBlock.setElementToReveal((IClasspathEntry)object2, string);
                }
            }
            if ((object2 = map.get(DATA_ADD_ENTRY)) instanceof IClasspathEntry && this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.addElement((IClasspathEntry)object2);
            }
            this.fBlockOnApply = Boolean.TRUE.equals(map.get(DATA_BLOCK));
        }
    }
}

