/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.wst.jsdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.text.JavaColorManager;
import org.eclipse.wst.jsdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.wst.jsdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

class JavaEditorColoringConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private static final String COMPILER_TASK_TAGS = "org.eclipse.wst.jsdt.core.compiler.taskTags";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.JavaEditorPreferencePage_javaDocKeywords, "java_doc_keyword"}, {PreferencesMessages.JavaEditorPreferencePage_javaDocHtmlTags, "java_doc_tag"}, {PreferencesMessages.JavaEditorPreferencePage_javaDocLinks, "java_doc_link"}, {PreferencesMessages.JavaEditorPreferencePage_javaDocOthers, "java_doc_default"}, {PreferencesMessages.JavaEditorPreferencePage_multiLineComment, "java_multi_line_comment"}, {PreferencesMessages.JavaEditorPreferencePage_singleLineComment, "java_single_line_comment"}, {PreferencesMessages.JavaEditorPreferencePage_javaCommentTaskTags, "java_comment_task_tag"}, {PreferencesMessages.JavaEditorPreferencePage_keywords, "java_keyword"}, {PreferencesMessages.JavaEditorPreferencePage_returnKeyword, "java_keyword_return"}, {PreferencesMessages.JavaEditorPreferencePage_operators, "java_operator"}, {PreferencesMessages.JavaEditorPreferencePage_brackets, "java_bracket"}, {PreferencesMessages.JavaEditorPreferencePage_strings, "java_string"}, {PreferencesMessages.JavaEditorPreferencePage_others, "java_default"}};
    private final String fJavaCategory = PreferencesMessages.JavaEditorPreferencePage_coloring_category_java;
    private final String fJavadocCategory = PreferencesMessages.JavaEditorPreferencePage_coloring_category_javadoc;
    private final String fCommentsCategory = PreferencesMessages.JavaEditorPreferencePage_coloring_category_comments;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private final List fListModel = new ArrayList();
    private StructuredViewer fListViewer;
    private SemanticHighlightingManager fSemanticHighlightingManager;
    private JavaSourceViewer fPreviewViewer;
    private IColorManager fColorManager = new JavaColorManager(false);
    private FontMetrics fFontMetrics;

    public JavaEditorColoringConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        super(overlayPreferenceStore);
        int n = 0;
        int n2 = this.fSyntaxColorListModel.length;
        while (n < n2) {
            this.fListModel.add(new HighlightingColorListItem(this.fSyntaxColorListModel[n][0], this.fSyntaxColorListModel[n][1], String.valueOf(this.fSyntaxColorListModel[n][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[n][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[n][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[n][1]) + UNDERLINE));
            ++n;
        }
        SemanticHighlighting[] semanticHighlightingArray = SemanticHighlightings.getSemanticHighlightings();
        n2 = 0;
        int n3 = semanticHighlightingArray.length;
        while (n2 < n3) {
            this.fListModel.add(new SemanticHighlightingColorListItem(semanticHighlightingArray[n2].getDisplayName(), SemanticHighlightings.getColorPreferenceKey(semanticHighlightingArray[n2]), SemanticHighlightings.getBoldPreferenceKey(semanticHighlightingArray[n2]), SemanticHighlightings.getItalicPreferenceKey(semanticHighlightingArray[n2]), SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlightingArray[n2]), SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlightingArray[n2]), SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightingArray[n2])));
            ++n2;
        }
        overlayPreferenceStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int n = 0;
        int n2 = this.fListModel.size();
        while (n < n2) {
            HighlightingColorListItem highlightingColorListItem = (HighlightingColorListItem)this.fListModel.get(n);
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, highlightingColorListItem.getColorKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getBoldKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getItalicKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getStrikethroughKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getUnderlineKey()));
            if (highlightingColorListItem instanceof SemanticHighlightingColorListItem) {
                arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, ((SemanticHighlightingColorListItem)highlightingColorListItem).getEnableKey()));
            }
            ++n;
        }
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite, 768);
        scrolledPageContent.setExpandHorizontal(true);
        scrolledPageContent.setExpandVertical(true);
        Control control = this.createSyntaxPage((Composite)scrolledPageContent);
        scrolledPageContent.setContent(control);
        Point point = control.computeSize(-1, -1);
        scrolledPageContent.setMinSize(point.x, point.y);
        return scrolledPageContent;
    }

    private int convertWidthInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    private int convertHeightInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    public void initialize() {
        super.initialize();
        this.fListViewer.setInput((Object)this.fListModel);
        this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)this.fJavaCategory));
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.uninstallSemanticHighlighting();
        this.installSemanticHighlighting();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.uninstallSemanticHighlighting();
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem highlightingColorListItem = this.getHighlightingColorListItem();
        if (highlightingColorListItem == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)highlightingColorListItem.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rGB);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getUnderlineKey()));
        if (highlightingColorListItem instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean bl = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)highlightingColorListItem).getEnableKey());
            this.fEnableCheckbox.setSelection(bl);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(bl);
            this.fColorEditorLabel.setEnabled(bl);
            this.fBoldCheckBox.setEnabled(bl);
            this.fItalicCheckBox.setEnabled(bl);
            this.fStrikethroughCheckBox.setEnabled(bl);
            this.fUnderlineCheckBox.setEnabled(bl);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Control createSyntaxPage(final Composite composite) {
        HighlightingColorListItem highlightingColorListItem;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Link link = new Link(composite2, 0);
        link.setText(PreferencesMessages.JavaEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)selectionEvent.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(composite2, 1);
        Label label = new Label(composite2, 16384);
        label.setText(PreferencesMessages.JavaEditorPreferencePage_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(4, 1, true, false);
        composite3.setLayoutData((Object)gridData2);
        this.fListViewer = new TreeViewer(composite3, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fListViewer.setComparator(new ViewerComparator(){

            public int category(Object object) {
                if (JavaEditorColoringConfigurationBlock.this.fJavaCategory.equals(object)) {
                    return 0;
                }
                if (JavaEditorColoringConfigurationBlock.this.fJavadocCategory.equals(object)) {
                    return 1;
                }
                if (JavaEditorColoringConfigurationBlock.this.fCommentsCategory.equals(object)) {
                    return 2;
                }
                return 0;
            }
        });
        gridData2 = new GridData(1, 1, false, true);
        gridData2.heightHint = this.convertHeightInCharsToPixels(9);
        int n = 0;
        ScrollBar scrollBar = this.fListModel.iterator();
        while (scrollBar.hasNext()) {
            highlightingColorListItem = (HighlightingColorListItem)scrollBar.next();
            n = Math.max(n, this.convertWidthInCharsToPixels(highlightingColorListItem.getDisplayName().length()));
        }
        scrollBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (scrollBar != null) {
            n += scrollBar.getSize().x * 3;
        }
        gridData2.widthHint = n;
        this.fListViewer.getControl().setLayoutData((Object)gridData2);
        highlightingColorListItem = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        highlightingColorListItem.setLayout((Layout)gridLayout);
        highlightingColorListItem.setLayoutData(new GridData(1808));
        this.fEnableCheckbox = new Button((Composite)highlightingColorListItem, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.JavaEditorPreferencePage_enable);
        gridData2 = new GridData(768);
        gridData2.horizontalAlignment = 1;
        gridData2.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gridData2);
        this.fColorEditorLabel = new Label((Composite)highlightingColorListItem, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.JavaEditorPreferencePage_color);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gridData2);
        this.fSyntaxForegroundColorEditor = new ColorSelector((Composite)highlightingColorListItem);
        Button button = this.fSyntaxForegroundColorEditor.getButton();
        gridData2 = new GridData(32);
        button.setLayoutData((Object)gridData2);
        this.fBoldCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_bold);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gridData2);
        this.fItalicCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_italic);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gridData2);
        this.fStrikethroughCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_strikethrough);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gridData2);
        this.fUnderlineCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_underline);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gridData2);
        label = new Label(composite2, 16384);
        label.setText(PreferencesMessages.JavaEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control control = this.createPreviewer(composite2);
        gridData2 = new GridData(1808);
        gridData2.widthHint = this.convertWidthInCharsToPixels(20);
        gridData2.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData2);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                JavaEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)highlightingColorListItem.getColorKey(), (RGB)JavaEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getBoldKey(), JavaEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getItalicKey(), JavaEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getStrikethroughKey(), JavaEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getUnderlineKey(), JavaEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (highlightingColorListItem instanceof SemanticHighlightingColorListItem) {
                    boolean bl = JavaEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)highlightingColorListItem).getEnableKey(), bl);
                    JavaEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(bl);
                    JavaEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(bl);
                    JavaEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(bl);
                    JavaEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(bl);
                    JavaEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(bl);
                    JavaEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(bl);
                    JavaEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(bl);
                    JavaEditorColoringConfigurationBlock.this.uninstallSemanticHighlighting();
                    JavaEditorColoringConfigurationBlock.this.installSemanticHighlighting();
                }
            }
        });
        composite2.layout(false);
        return composite2;
    }

    private void addFiller(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    private Control createPreviewer(Composite composite) {
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore chainedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), iPreferenceStore});
        this.fPreviewViewer = new JavaSourceViewer(composite, null, null, false, 2816, (IPreferenceStore)chainedPreferenceStore);
        SimpleJavaSourceViewerConfiguration simpleJavaSourceViewerConfiguration = new SimpleJavaSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)chainedPreferenceStore, null, "___java_partitioning", false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)simpleJavaSourceViewerConfiguration);
        simpleJavaSourceViewerConfiguration.handlePropertyChangeEvent(new PropertyChangeEvent((Object)this, "org.eclipse.wst.jsdt.core.compiler.source", (Object)"1.4", (Object)"1.5"));
        Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, simpleJavaSourceViewerConfiguration, (IPreferenceStore)chainedPreferenceStore);
        this.fPreviewViewer.setEditable(false);
        String string = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(string);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        this.installSemanticHighlighting();
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences preferences = new Preferences();
        preferences.setValue(COMPILER_TASK_TAGS, "TASK,TODO");
        return preferences;
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewContentFromFile(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 112->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticHighlightingManager == null) {
            this.fSemanticHighlightingManager = new SemanticHighlightingManager();
            this.fSemanticHighlightingManager.install(this.fPreviewViewer, this.fColorManager, this.getPreferenceStore(), this.createPreviewerRanges());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticHighlightingManager != null) {
            this.fSemanticHighlightingManager.uninstall();
            this.fSemanticHighlightingManager = null;
        }
    }

    private SemanticHighlightingManager.HighlightedRange[][] createPreviewerRanges() {
        return new SemanticHighlightingManager.HighlightedRange[][]{{this.createHighlightedRange(9, 9, 3, "methodDeclarationName")}, {this.createHighlightedRange(17, 9, 3, "methodDeclarationName")}, {this.createHighlightedRange(21, 9, 4, "methodDeclarationName")}, {this.createHighlightedRange(26, 9, 7, "methodDeclarationName")}, {this.createHighlightedRange(11, 19, 6, "method")}, {this.createHighlightedRange(14, 4, 5, "method")}, {this.createHighlightedRange(11, 8, 4, "localVariableDeclaration")}, {this.createHighlightedRange(12, 8, 3, "localVariableDeclaration")}, {this.createHighlightedRange(13, 8, 1, "localVariableDeclaration")}, {this.createHighlightedRange(14, 10, 4, "localVariable")}, {this.createHighlightedRange(12, 14, 47, "objectInitializer")}, {this.createHighlightedRange(20, 16, 4, "parameterVariable")}};
    }

    private SemanticHighlightingManager.HighlightedRange createHighlightedRange(int n, int n2, int n3, String string) {
        try {
            IDocument iDocument = this.fPreviewViewer.getDocument();
            int n4 = iDocument.getLineOffset(n) + n2;
            return new SemanticHighlightingManager.HighlightedRange(n4, n3, string);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
            return null;
        }
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fListViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)object;
    }

    private void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object object) {
            return new String[]{JavaEditorColoringConfigurationBlock.this.fJavaCategory, JavaEditorColoringConfigurationBlock.this.fJavadocCategory, JavaEditorColoringConfigurationBlock.this.fCommentsCategory};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (JavaEditorColoringConfigurationBlock.this.fJavaCategory.equals(string)) {
                    return JavaEditorColoringConfigurationBlock.this.fListModel.subList(7, JavaEditorColoringConfigurationBlock.this.fListModel.size()).toArray();
                }
                if (JavaEditorColoringConfigurationBlock.this.fJavadocCategory.equals(string)) {
                    return JavaEditorColoringConfigurationBlock.this.fListModel.subList(0, 4).toArray();
                }
                if (JavaEditorColoringConfigurationBlock.this.fCommentsCategory.equals(string)) {
                    return JavaEditorColoringConfigurationBlock.this.fListModel.subList(4, 7).toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof String) {
                return null;
            }
            int n = JavaEditorColoringConfigurationBlock.this.fListModel.indexOf(object);
            if (n < 4) {
                return JavaEditorColoringConfigurationBlock.this.fJavadocCategory;
            }
            if (n >= 7) {
                return JavaEditorColoringConfigurationBlock.this.fJavaCategory;
            }
            return JavaEditorColoringConfigurationBlock.this.fCommentsCategory;
        }

        public boolean hasChildren(Object object) {
            return object instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            return ((HighlightingColorListItem)object).getDisplayName();
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;

        public HighlightingColorListItem(String string, String string2, String string3, String string4, String string5, String string6) {
            this.fDisplayName = string;
            this.fColorKey = string2;
            this.fBoldKey = string3;
            this.fItalicKey = string4;
            this.fStrikethroughKey = string5;
            this.fUnderlineKey = string6;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            super(string, string2, string3, string4, string5, string6);
            this.fEnableKey = string7;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }
}

