/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class JavadocConfigurationBlock {
    private static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private static final String ERROR_DIALOG_TITLE = "Error Dialog";
    private StringDialogField fURLField;
    private StringDialogField fArchiveField;
    private StringDialogField fArchivePathField;
    private URL fInitialURL;
    private SelectionButtonDialogField fValidateURLButton;
    private SelectionButtonDialogField fValidateArchiveButton;
    private SelectionButtonDialogField fBrowseFolder;
    private SelectionButtonDialogField fURLRadioButton;
    private SelectionButtonDialogField fArchiveRadioButton;
    private SelectionButtonDialogField fBrowseArchive;
    private SelectionButtonDialogField fExternalRadio;
    private SelectionButtonDialogField fWorkspaceRadio;
    private SelectionButtonDialogField fBrowseArchivePath;
    private Shell fShell;
    private IStatusChangeListener fContext;
    private IStatus fURLStatus;
    private IStatus fArchiveStatus;
    private IStatus fArchivePathStatus;
    private URL fURLResult;
    private URL fArchiveURLResult;
    boolean fIsForSource;
    static /* synthetic */ Class class$0;

    public JavadocConfigurationBlock(Shell shell, IStatusChangeListener iStatusChangeListener, URL uRL, boolean bl) {
        this.fShell = shell;
        this.fContext = iStatusChangeListener;
        this.fInitialURL = uRL;
        this.fIsForSource = bl;
        JDocConfigurationAdapter jDocConfigurationAdapter = new JDocConfigurationAdapter();
        if (!bl) {
            this.fURLRadioButton = new SelectionButtonDialogField(16);
            this.fURLRadioButton.setDialogFieldListener(jDocConfigurationAdapter);
            this.fURLRadioButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_type_path_label);
        }
        this.fURLField = new StringDialogField();
        this.fURLField.setDialogFieldListener(jDocConfigurationAdapter);
        this.fURLField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_path_label);
        this.fBrowseFolder = new SelectionButtonDialogField(8);
        this.fBrowseFolder.setDialogFieldListener(jDocConfigurationAdapter);
        this.fBrowseFolder.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_folder_button);
        this.fValidateURLButton = new SelectionButtonDialogField(8);
        this.fValidateURLButton.setDialogFieldListener(jDocConfigurationAdapter);
        this.fValidateURLButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_validate_button);
        if (!bl) {
            this.fArchiveRadioButton = new SelectionButtonDialogField(16);
            this.fArchiveRadioButton.setDialogFieldListener(jDocConfigurationAdapter);
            this.fArchiveRadioButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_type_jar_label);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener(jDocConfigurationAdapter);
            this.fExternalRadio.setLabelText(PreferencesMessages.JavadocConfigurationBlock_external_radio);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(jDocConfigurationAdapter);
            this.fWorkspaceRadio.setLabelText(PreferencesMessages.JavadocConfigurationBlock_workspace_radio);
            this.fArchiveField = new StringDialogField();
            this.fArchiveField.setDialogFieldListener(jDocConfigurationAdapter);
            this.fArchiveField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_jar_label);
            this.fBrowseArchive = new SelectionButtonDialogField(8);
            this.fBrowseArchive.setDialogFieldListener(jDocConfigurationAdapter);
            this.fBrowseArchive.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_archive_button);
            this.fArchivePathField = new StringDialogField();
            this.fArchivePathField.setDialogFieldListener(jDocConfigurationAdapter);
            this.fArchivePathField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_jar_path_label);
            this.fBrowseArchivePath = new SelectionButtonDialogField(8);
            this.fBrowseArchivePath.setDialogFieldListener(jDocConfigurationAdapter);
            this.fBrowseArchivePath.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_archive_path_button);
            this.fValidateArchiveButton = new SelectionButtonDialogField(8);
            this.fValidateArchiveButton.setDialogFieldListener(jDocConfigurationAdapter);
            this.fValidateArchiveButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_validate_button);
        }
        this.fURLStatus = new StatusInfo();
        this.fArchiveStatus = new StatusInfo();
        this.fArchivePathStatus = new StatusInfo();
        this.initializeSelections();
    }

    public Control createContents(Composite composite) {
        this.fShell = composite.getShell();
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        if (!this.fIsForSource) {
            this.fURLRadioButton.doFillIntoGrid(composite2, 3);
        }
        this.fURLField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setWidthHint((Control)this.fURLField.getTextControl(null), pixelConverter.convertWidthInCharsToPixels(43));
        LayoutUtil.setHorizontalGrabbing((Control)this.fURLField.getTextControl(null));
        this.fBrowseFolder.doFillIntoGrid(composite2, 1);
        DialogField.createEmptySpace(composite2, 2);
        this.fValidateURLButton.doFillIntoGrid(composite2, 1);
        if (!this.fIsForSource) {
            this.fArchiveRadioButton.doFillIntoGrid(composite2, 3);
            DialogField.createEmptySpace(composite2, 1);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(4, 4, false, false));
            GridLayout gridLayout2 = new GridLayout(2, true);
            gridLayout2.marginHeight = 0;
            gridLayout2.marginWidth = 0;
            composite3.setLayout((Layout)gridLayout2);
            this.fExternalRadio.doFillIntoGrid(composite3, 1);
            this.fWorkspaceRadio.doFillIntoGrid(composite3, 1);
            DialogField.createEmptySpace(composite2, 1);
            this.fArchiveField.doFillIntoGrid(composite2, 2);
            LayoutUtil.setWidthHint((Control)this.fArchiveField.getTextControl(null), pixelConverter.convertWidthInCharsToPixels(43));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchiveField.getTextControl(null));
            this.fBrowseArchive.doFillIntoGrid(composite2, 1);
            this.fArchivePathField.doFillIntoGrid(composite2, 2);
            LayoutUtil.setWidthHint((Control)this.fArchivePathField.getTextControl(null), pixelConverter.convertWidthInCharsToPixels(43));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchivePathField.getTextControl(null));
            this.fBrowseArchivePath.doFillIntoGrid(composite2, 1);
            DialogField.createEmptySpace(composite2, 2);
            this.fValidateArchiveButton.doFillIntoGrid(composite2, 1);
            int n = pixelConverter.convertWidthInCharsToPixels(2);
            LayoutUtil.setHorizontalIndent((Control)this.fArchiveField.getLabelControl(null), n);
            LayoutUtil.setHorizontalIndent((Control)this.fArchivePathField.getLabelControl(null), n);
            LayoutUtil.setHorizontalIndent((Control)this.fURLField.getLabelControl(null), n);
            this.fURLRadioButton.attachDialogFields(new DialogField[]{this.fURLField, this.fBrowseFolder, this.fValidateURLButton});
            this.fArchiveRadioButton.attachDialogFields(new DialogField[]{this.fArchiveField, this.fBrowseArchive, this.fExternalRadio, this.fWorkspaceRadio, this.fArchivePathField, this.fBrowseArchivePath, this.fValidateArchiveButton});
        }
        return composite2;
    }

    private void initializeSelections() {
        String string;
        String string2 = string = this.fInitialURL != null ? this.fInitialURL.toExternalForm() : "";
        if (this.fIsForSource) {
            this.fURLField.setText(string);
            return;
        }
        String string3 = "jar:";
        boolean bl = string.startsWith(string3);
        boolean bl2 = false;
        this.fURLRadioButton.setSelection(!bl);
        this.fArchiveRadioButton.setSelection(bl);
        if (bl) {
            String string4;
            String string5 = "";
            int n = string.indexOf("!/");
            if (n == -1) {
                string4 = string.substring(string3.length());
            } else {
                string4 = string.substring(string3.length(), n);
                string5 = string.substring(n + 2);
            }
            if (string4.startsWith("file:/")) {
                string4 = string4.substring("file:/".length());
            } else if (string4.startsWith("platform:/resource/")) {
                string4 = string4.substring("platform:/resource/".length());
                bl2 = true;
            } else {
                this.fURLField.setText(string);
                return;
            }
            Path path = new Path(this.decodeExclamationMarks(string4));
            this.fArchivePathField.setText(this.decodeExclamationMarks(string5));
            if (bl2) {
                this.fArchiveField.setText(path.makeRelative().toString());
            } else {
                this.fArchiveField.setText(path.makeAbsolute().toOSString());
            }
        } else {
            this.fURLField.setText(string);
        }
        this.fExternalRadio.setSelection(!bl2);
        this.fWorkspaceRadio.setSelection(bl2);
    }

    public void setFocus() {
        this.fURLField.postSetFocusOnDialogField(this.fShell.getDisplay());
    }

    public void performDefaults() {
        this.initializeSelections();
    }

    public URL getJavadocLocation() {
        if (this.fIsForSource || this.fURLRadioButton.isSelected()) {
            return this.fURLResult;
        }
        return this.fArchiveURLResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkURLConnection(URL uRL) {
        int n = 0;
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                uRLConnection.connect();
                n = ((HttpURLConnection)uRLConnection).getResponseCode();
            }
            InputStream inputStream = null;
            try {
                inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[256];
                while (inputStream.read(byArray) != -1) {
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (inputStream == null) return n < 400;
                inputStream.close();
                return n < 400;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void jdocDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fURLField) {
            this.fURLStatus = this.updateURLStatus();
            this.statusChanged();
        } else if (dialogField == this.fArchiveField) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (dialogField == this.fArchivePathField) {
            this.fArchivePathStatus = this.updateArchivePathStatus();
            this.statusChanged();
        } else if (dialogField == this.fValidateURLButton || dialogField == this.fValidateArchiveButton) {
            EntryValidator entryValidator = new EntryValidator();
            BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)entryValidator);
        } else if (dialogField == this.fBrowseFolder) {
            String string = this.chooseJavaDocFolder();
            if (string != null) {
                this.fURLField.setText(string);
            }
        } else if (dialogField == this.fBrowseArchive) {
            String string = this.chooseArchive();
            if (string != null) {
                this.fArchiveField.setText(string);
            }
        } else if (dialogField == this.fExternalRadio || dialogField == this.fWorkspaceRadio) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (dialogField == this.fBrowseArchivePath) {
            String string = this.chooseArchivePath();
            if (string != null) {
                this.fArchivePathField.setText(string);
            }
        } else if (dialogField == this.fURLRadioButton || dialogField == this.fArchiveRadioButton) {
            this.statusChanged();
        }
    }

    private void statusChanged() {
        boolean bl = this.fIsForSource || this.fURLRadioButton.isSelected();
        IStatus iStatus = bl ? this.fURLStatus : StatusUtil.getMoreSevere(this.fArchiveStatus, this.fArchivePathStatus);
        if (!this.fIsForSource) {
            boolean bl2;
            boolean bl3 = bl2 = !bl && this.fArchiveStatus.isOK() && this.fArchiveField.getText().length() > 0;
            if (bl2 && this.fWorkspaceRadio.isSelected()) {
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.fArchiveField.getText()));
                bl2 = iResource != null && iResource.getLocation() != null;
            }
            this.fBrowseArchivePath.setEnabled(bl2);
        }
        this.fContext.statusChanged(iStatus);
    }

    private String chooseArchivePath() {
        final String[] stringArray = new String[1];
        BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                stringArray[0] = JavadocConfigurationBlock.this.internalChooseArchivePath();
            }
        });
        return stringArray[0];
    }

    private String encodeExclamationMarks(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '!') {
                stringBuffer.append("%21");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String decodeExclamationMarks(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '%' && n2 < n - 2 && string.charAt(n2 + 1) == '2' && string.charAt(n2 + 2) == '1') {
                stringBuffer.append('!');
                n2 += 2;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    private String internalChooseArchivePath() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 309->312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String chooseArchive() {
        if (this.fWorkspaceRadio.isSelected()) {
            return this.chooseWorkspaceArchive();
        }
        Path path = new Path(this.fArchiveField.getText());
        if (ArchiveFileFilter.isArchivePath((IPath)path)) {
            path = path.removeLastSegments(1);
        }
        FileDialog fileDialog = new FileDialog(this.fShell, 4096);
        fileDialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        fileDialog.setText(PreferencesMessages.JavadocConfigurationBlock_zipImportSource_title);
        fileDialog.setFilterPath(path.toOSString());
        return fileDialog.open();
    }

    private String chooseWorkspaceArchive() {
        String string = this.fArchiveField.getText();
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, true);
        IResource iResource = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (string.length() > 0) {
            iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        }
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.addFilter((ViewerFilter)new ArchiveFileFilter(null, true));
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        elementTreeSelectionDialog.setTitle(PreferencesMessages.JavadocConfigurationBlock_workspace_archive_selection_dialog_title);
        elementTreeSelectionDialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_workspace_archive_selection_dialog_description);
        elementTreeSelectionDialog.setInput((Object)iWorkspaceRoot);
        elementTreeSelectionDialog.setInitialSelection((Object)iResource);
        elementTreeSelectionDialog.setHelpAvailable(false);
        if (elementTreeSelectionDialog.open() == 0) {
            IResource iResource2 = (IResource)elementTreeSelectionDialog.getFirstResult();
            return iResource2.getFullPath().makeRelative().toString();
        }
        return null;
    }

    protected void displayErrorDialog(String string) {
        MessageDialog.openError((Shell)this.fShell, (String)ERROR_DIALOG_TITLE, (String)string);
    }

    private String chooseJavaDocFolder() {
        String string = "";
        if (this.fURLResult != null && "file".equals(this.fURLResult.getProtocol())) {
            string = new File(this.fURLResult.getFile()).getPath();
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(this.fShell);
        directoryDialog.setText(PreferencesMessages.JavadocConfigurationBlock_javadocFolderDialog_label);
        directoryDialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_javadocFolderDialog_message);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 != null) {
            try {
                URL uRL = new File(string2).toURL();
                return uRL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                JavaPlugin.log(malformedURLException);
            }
        }
        return null;
    }

    private IStatus updateURLStatus() {
        StatusInfo statusInfo = new StatusInfo();
        this.fURLResult = null;
        try {
            String string = this.fURLField.getText();
            if (string.length() == 0) {
                return statusInfo;
            }
            URL uRL = new URL(string);
            if ("file".equals(uRL.getProtocol()) && uRL.getFile() == null) {
                statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_error_notafolder);
                return statusInfo;
            }
            this.fURLResult = uRL;
        }
        catch (MalformedURLException malformedURLException) {
            statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_MalformedURL_error);
            return statusInfo;
        }
        return statusInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus updateArchiveStatus() {
        try {
            this.fArchiveURLResult = null;
            StatusInfo statusInfo = new StatusInfo();
            String string = this.fArchiveField.getText();
            if (string.length() > 0) {
                if (!Path.ROOT.isValidPath(string)) {
                    statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_error_invalidarchivepath);
                    return statusInfo;
                }
                if (this.fWorkspaceRadio.isSelected()) {
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
                    if (iResource == null) {
                        statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_error_archive_not_found_in_workspace);
                        return statusInfo;
                    }
                    if (!(iResource instanceof IFile)) {
                        statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_error_archive_not_found_in_workspace);
                        return statusInfo;
                    }
                } else {
                    IPath iPath = Path.fromOSString((String)string);
                    if (!iPath.isAbsolute()) {
                        statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_error_archivepathnotabsolute);
                        return statusInfo;
                    }
                    File file = new File(string);
                    if (file.isDirectory()) {
                        statusInfo.setError(PreferencesMessages.JavadocConfigurationBlock_error_notafile);
                        return statusInfo;
                    }
                    if (!file.exists()) {
                        statusInfo.setWarning(PreferencesMessages.JavadocConfigurationBlock_error_notafile);
                    }
                }
                this.fArchiveURLResult = this.getArchiveURL();
            }
            return statusInfo;
        }
        catch (MalformedURLException malformedURLException) {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(malformedURLException.getMessage());
            return statusInfo;
        }
    }

    private IStatus updateArchivePathStatus() {
        try {
            this.fArchiveURLResult = this.getArchiveURL();
        }
        catch (MalformedURLException malformedURLException) {
            this.fArchiveURLResult = null;
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(malformedURLException.getMessage());
            return statusInfo;
        }
        return new StatusInfo();
    }

    private URL getArchiveURL() throws MalformedURLException {
        String string = this.fArchiveField.getText();
        String string2 = this.fArchivePathField.getText().trim();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jar:");
        if (this.fWorkspaceRadio.isSelected()) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
            if (iResource != null) {
                stringBuffer.append("platform:/resource").append(this.encodeExclamationMarks(iResource.getFullPath().toString()));
            }
        } else {
            stringBuffer.append(this.encodeExclamationMarks(new File(string).toURL().toExternalForm()));
        }
        stringBuffer.append('!');
        if (string2.length() > 0) {
            if (string2.charAt(0) != '/') {
                stringBuffer.append('/');
            }
            stringBuffer.append(string2);
        } else {
            stringBuffer.append('/');
        }
        return new URL(stringBuffer.toString());
    }

    private class EntryValidator
    implements Runnable {
        private String fInvalidMessage = PreferencesMessages.JavadocConfigurationBlock_InvalidLocation_message;
        private String fValidMessage = PreferencesMessages.JavadocConfigurationBlock_ValidLocation_message;
        private String fTitle = PreferencesMessages.JavadocConfigurationBlock_MessageDialog_title;
        private String fUnable = PreferencesMessages.JavadocConfigurationBlock_UnableToValidateLocation_message;

        private EntryValidator() {
        }

        public void run() {
            URL uRL = JavadocConfigurationBlock.this.getJavadocLocation();
            if (uRL == null) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
                return;
            }
            try {
                String string = uRL.getProtocol();
                if (string.startsWith("http") || string.equals("jar")) {
                    this.validateURL(uRL);
                } else if (string.equals("file")) {
                    this.validateFile(uRL);
                } else {
                    MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
            }
        }

        public void spawnInBrowser(URL uRL) {
            OpenBrowserUtil.open(uRL, JavadocConfigurationBlock.this.fShell.getDisplay(), this.fTitle);
        }

        private void validateFile(URL uRL) throws MalformedURLException {
            File file;
            File file2;
            File file3 = new File(uRL.getFile());
            if (file3.isDirectory() && (file2 = new File(file3, "index.html")).isFile() && (file = new File(file3, "package-list")).exists()) {
                if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                    this.spawnInBrowser(file2.toURL());
                }
                return;
            }
            MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
        }

        private void validateURL(URL uRL) throws MalformedURLException {
            boolean bl;
            Path path = new Path(uRL.toExternalForm());
            IPath iPath = path.append("index.html");
            IPath iPath2 = path.append("package-list");
            URL uRL2 = new URL(iPath.toString());
            URL uRL3 = new URL(iPath2.toString());
            boolean bl2 = bl = JavadocConfigurationBlock.this.checkURLConnection(uRL2) && JavadocConfigurationBlock.this.checkURLConnection(uRL3);
            if (bl) {
                if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                    this.spawnInBrowser(uRL2);
                }
            } else {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
            }
        }
    }

    private class JDocConfigurationAdapter
    implements IDialogFieldListener {
        private JDocConfigurationAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            JavadocConfigurationBlock.this.jdocDialogFieldChanged(dialogField);
        }
    }

    private static class ZipDialogContentProvider
    implements ITreeContentProvider {
        private ZipFileStructureProvider fProvider;

        public ZipDialogContentProvider(ZipFileStructureProvider zipFileStructureProvider) {
            this.fProvider = zipFileStructureProvider;
        }

        public Object findElement(IPath iPath) {
            String[] stringArray = iPath.segments();
            ZipEntry zipEntry = this.fProvider.getRoot();
            int n = 0;
            while (n < stringArray.length && zipEntry != null) {
                List list = this.fProvider.getChildren((Object)zipEntry);
                String string = stringArray[n];
                zipEntry = null;
                int n2 = 0;
                while (n2 < list.size()) {
                    Object e = list.get(n2);
                    if (this.fProvider.isFolder(e) && string.equals(this.fProvider.getLabel(e))) {
                        zipEntry = e;
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            return zipEntry;
        }

        private Object recursiveFind(Object object, String string) {
            if (string.equals(this.fProvider.getLabel(object))) {
                return object;
            }
            List list = this.fProvider.getChildren(object);
            if (list != null) {
                int n = 0;
                while (n < list.size()) {
                    Object object2 = this.recursiveFind(list.get(n), string);
                    if (object2 != null) {
                        return object2;
                    }
                    ++n;
                }
            }
            return null;
        }

        public Object findFileByName(String string) {
            return this.recursiveFind(this.fProvider.getRoot(), string);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object getParent(Object object) {
            if (object.equals(this.fProvider.getRoot())) {
                return null;
            }
            Path path = new Path(this.fProvider.getFullPath(object));
            if (path.segmentCount() > 0) {
                return this.findElement(path.removeLastSegments(1));
            }
            return this.fProvider.getRoot();
        }

        public boolean hasChildren(Object object) {
            List list = this.fProvider.getChildren(object);
            if (list != null) {
                int n = 0;
                while (n < list.size()) {
                    if (this.fProvider.isFolder(list.get(n))) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        public Object[] getChildren(Object object) {
            List list = this.fProvider.getChildren(object);
            ArrayList arrayList = new ArrayList();
            if (list != null) {
                int n = 0;
                while (n < list.size()) {
                    Object e = list.get(n);
                    if (this.fProvider.isFolder(e)) {
                        arrayList.add(e);
                    }
                    ++n;
                }
            }
            return arrayList.toArray();
        }

        public Object[] getElements(Object object) {
            return new Object[]{this.fProvider.getRoot()};
        }

        public void dispose() {
        }
    }

    private static class ZipDialogLabelProvider
    extends LabelProvider {
        private final Image IMG_JAR = JavaUI.getSharedImages().getImage("org.eclipse.wst.jsdt.ui.jar_obj.gif");
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private ZipFileStructureProvider fProvider;

        public ZipDialogLabelProvider(ZipFileStructureProvider zipFileStructureProvider) {
            this.fProvider = zipFileStructureProvider;
        }

        public Image getImage(Object object) {
            if (object == this.fProvider.getRoot()) {
                return this.IMG_JAR;
            }
            return this.IMG_FOLDER;
        }

        public String getText(Object object) {
            if (object == this.fProvider.getRoot()) {
                return this.fProvider.getZipFile().getName();
            }
            return this.fProvider.getLabel(object);
        }
    }

    private static class ZipDialogValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] objectArray) {
            String string = "";
            return new StatusInfo(1, string);
        }
    }
}

