/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

public class TypeFilterInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private List fExistingEntries;

    public TypeFilterInputDialog(Shell shell, List list) {
        super(shell);
        this.fExistingEntries = list;
        this.setTitle(PreferencesMessages.TypeFilterInputDialog_title);
        TypeFilterInputAdapter typeFilterInputAdapter = new TypeFilterInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(typeFilterInputAdapter);
        this.fNameDialogField.setLabelText(PreferencesMessages.TypeFilterInputDialog_message);
        this.fNameDialogField.setButtonLabel(PreferencesMessages.TypeFilterInputDialog_browse_button);
        this.fNameDialogField.setDialogFieldListener(typeFilterInputAdapter);
        this.fNameDialogField.setText("");
    }

    public void setInitialString(String string) {
        Assert.isNotNull((Object)string);
        this.fNameDialogField.setText(string);
    }

    public Object getResult() {
        return this.fNameDialogField.getText();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        LayoutUtil.doDefaultLayout(composite3, new DialogField[]{this.fNameDialogField}, true, 0, 0);
        int n = this.convertWidthInCharsToPixels(60);
        Text text = this.fNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, n);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        TextFieldNavigationHandler.install(text);
        this.fNameDialogField.postSetFocusOnDialogField(composite.getDisplay());
        TypeFilterInputDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void doButtonPressed() {
        IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
        BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
        int n = 7;
        PackageSelectionDialog packageSelectionDialog = new PackageSelectionDialog(this.getShell(), busyIndicatorRunnableContext, n, iJavaSearchScope);
        packageSelectionDialog.setTitle(PreferencesMessages.TypeFilterInputDialog_choosepackage_label);
        packageSelectionDialog.setMessage(PreferencesMessages.TypeFilterInputDialog_choosepackage_description);
        packageSelectionDialog.setMultipleSelection(false);
        packageSelectionDialog.setFilter(this.fNameDialogField.getText());
        if (packageSelectionDialog.open() == 0) {
            IPackageFragment iPackageFragment = (IPackageFragment)packageSelectionDialog.getFirstResult();
            this.fNameDialogField.setText(String.valueOf(iPackageFragment.getElementName()) + "*");
        }
    }

    private void doValidation() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fNameDialogField.getText();
        if (string.length() == 0) {
            statusInfo.setError(PreferencesMessages.TypeFilterInputDialog_error_enterName);
        } else {
            IStatus iStatus = JavaConventions.validatePackageName((String)(string = string.replace('*', 'X').replace('?', 'Y')), (String)"1.3", (String)"1.3");
            if (iStatus.matches(4)) {
                statusInfo.setError(Messages.format(PreferencesMessages.TypeFilterInputDialog_error_invalidName, iStatus.getMessage()));
            } else if (this.fExistingEntries.contains(string)) {
                statusInfo.setError(PreferencesMessages.TypeFilterInputDialog_error_entryExists);
            }
        }
        this.updateStatus(statusInfo);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.import_organize_input_dialog_context");
    }

    private class TypeFilterInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private TypeFilterInputAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            TypeFilterInputDialog.this.doValidation();
        }

        public void changeControlPressed(DialogField dialogField) {
            TypeFilterInputDialog.this.doButtonPressed();
        }
    }
}

