/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileVersioner;

public class FormatterProfileManager
extends ProfileManager {
    public static final String ECLIPSE21_PROFILE = "org.eclipse.wst.jsdt.ui.default_profile";
    public static final String ECLIPSE_PROFILE = "org.eclipse.wst.jsdt.ui.default.eclipse_profile";
    public static final String JAVA_PROFILE = "org.eclipse.wst.jsdt.ui.default.sun_profile";
    public static final String DEFAULT_PROFILE = "org.eclipse.wst.jsdt.ui.default.eclipse_profile";
    private static final ProfileManager.KeySet[] KEY_SETS = new ProfileManager.KeySet[]{new ProfileManager.KeySet("org.eclipse.wst.jsdt.core", new ArrayList(DefaultCodeFormatterConstants.getJavaConventionsSettings().keySet())), new ProfileManager.KeySet("org.eclipse.wst.jsdt.ui", Collections.EMPTY_LIST)};
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";

    public FormatterProfileManager(List list, IScopeContext iScopeContext, PreferencesAccess preferencesAccess, IProfileVersioner iProfileVersioner) {
        super(FormatterProfileManager.addBuiltinProfiles(list, iProfileVersioner), iScopeContext, preferencesAccess, iProfileVersioner, KEY_SETS, PROFILE_KEY, FORMATTER_SETTINGS_VERSION);
    }

    private static List addBuiltinProfiles(List list, IProfileVersioner iProfileVersioner) {
        ProfileManager.BuiltInProfile builtInProfile = new ProfileManager.BuiltInProfile(JAVA_PROFILE, FormatterMessages.ProfileManager_java_conventions_profile_name, FormatterProfileManager.getJavaSettings(), 1, iProfileVersioner.getCurrentVersion(), iProfileVersioner.getProfileKind());
        list.add(builtInProfile);
        ProfileManager.BuiltInProfile builtInProfile2 = new ProfileManager.BuiltInProfile("org.eclipse.wst.jsdt.ui.default.eclipse_profile", FormatterMessages.ProfileManager_eclipse_profile_name, FormatterProfileManager.getEclipseSettings(), 2, iProfileVersioner.getCurrentVersion(), iProfileVersioner.getProfileKind());
        list.add(builtInProfile2);
        ProfileManager.BuiltInProfile builtInProfile3 = new ProfileManager.BuiltInProfile(ECLIPSE21_PROFILE, FormatterMessages.ProfileManager_default_profile_name, FormatterProfileManager.getEclipse21Settings(), 3, iProfileVersioner.getCurrentVersion(), iProfileVersioner.getProfileKind());
        list.add(builtInProfile3);
        return list;
    }

    public static Map getEclipse21Settings() {
        Map map = DefaultCodeFormatterConstants.getEclipse21Settings();
        ProfileVersioner.setLatestCompliance(map);
        return map;
    }

    public static Map getEclipseSettings() {
        Map map = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        ProfileVersioner.setLatestCompliance(map);
        return map;
    }

    public static Map getJavaSettings() {
        Map map = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        ProfileVersioner.setLatestCompliance(map);
        return map;
    }

    public static Map getDefaultSettings() {
        return FormatterProfileManager.getEclipseSettings();
    }

    protected String getSelectedProfileId(IScopeContext iScopeContext) {
        String string;
        IEclipsePreferences iEclipsePreferences;
        String string2 = iScopeContext.getNode("org.eclipse.wst.jsdt.ui").get(PROFILE_KEY, null);
        if (string2 == null && "org.eclipse.wst.jsdt.ui.default.eclipse_profile".equals(string2 = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").get(PROFILE_KEY, null)) && (iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.core")) != null && "space".equals(string = iEclipsePreferences.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char", null))) {
            string2 = JAVA_PROFILE;
        }
        return string2;
    }

    public ProfileManager.Profile getDefaultProfile() {
        return this.getProfile("org.eclipse.wst.jsdt.ui.default.eclipse_profile");
    }
}

