/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileStore {
    public static final String ENCODING = "UTF-8";
    protected static final String VERSION_KEY_SUFFIX = ".version";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_PROFILE_KIND = "kind";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private final IProfileVersioner fProfileVersioner;
    private final String fProfilesKey;
    private final String fProfilesVersionKey;

    public ProfileStore(String string, IProfileVersioner iProfileVersioner) {
        this.fProfilesKey = string;
        this.fProfileVersioner = iProfileVersioner;
        this.fProfilesVersionKey = String.valueOf(string) + VERSION_KEY_SUFFIX;
    }

    public List readProfiles(IScopeContext iScopeContext) throws CoreException {
        return this.readProfilesFromString(iScopeContext.getNode("org.eclipse.wst.jsdt.ui").get(this.fProfilesKey, null));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProfiles(Collection collection, IScopeContext iScopeContext) throws CoreException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
        try {
            String string;
            ProfileStore.writeProfilesToStream(collection, byteArrayOutputStream, ENCODING, this.fProfileVersioner);
            try {
                string = byteArrayOutputStream.toString(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = byteArrayOutputStream.toString();
            }
            IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.eclipse.wst.jsdt.ui");
            iEclipsePreferences.put(this.fProfilesKey, string);
            iEclipsePreferences.putInt(this.fProfilesVersionKey, this.fProfileVersioner.getCurrentVersion());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        byteArrayOutputStream.close();
    }

    public List readProfilesFromString(String string) throws CoreException {
        if (string != null && string.length() > 0) {
            List list;
            byte[] byArray;
            try {
                byArray = string.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                List list2 = ProfileStore.readProfilesFromStream(new InputSource(byteArrayInputStream));
                if (list2 != null) {
                    int n = 0;
                    while (n < list2.size()) {
                        this.fProfileVersioner.update((ProfileManager.CustomProfile)list2.get(n));
                        ++n;
                    }
                }
                list = list2;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {}
            return list;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List readProfilesFromFile(File file) throws CoreException {
        try {
            List list;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                list = ProfileStore.readProfilesFromStream(new InputSource(fileInputStream));
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
            return list;
        }
        catch (IOException iOException) {
            throw ProfileStore.createException(iOException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
    }

    public static List readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler profileDefaultHandler = new ProfileDefaultHandler();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)profileDefaultHandler);
        }
        catch (SAXException sAXException) {
            throw ProfileStore.createException(sAXException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (IOException iOException) {
            throw ProfileStore.createException(iOException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ProfileStore.createException(parserConfigurationException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        return profileDefaultHandler.getProfiles();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProfilesToFile(Collection collection, File file, String string) throws CoreException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(collection, fileOutputStream, string, this.fProfileVersioner);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                ((OutputStream)fileOutputStream).close();
                return;
            }
        }
        catch (IOException iOException) {
            throw ProfileStore.createException(iOException, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    public static void writeProfilesToStream(Collection collection, OutputStream outputStream, String string, IProfileVersioner iProfileVersioner) throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(XML_NODE_ROOT);
            element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(iProfileVersioner.getCurrentVersion()));
            document.appendChild(element);
            Object object = collection.iterator();
            while (object.hasNext()) {
                ProfileManager.Profile profile = (ProfileManager.Profile)object.next();
                if (!profile.isProfileToSave()) continue;
                Element element2 = ProfileStore.createProfileElement(profile, document, iProfileVersioner);
                element.appendChild(element2);
            }
            object = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object).setOutputProperty("method", "xml");
            ((Transformer)object).setOutputProperty("encoding", string);
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw ProfileStore.createException(transformerException, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ProfileStore.createException(parserConfigurationException, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static Element createProfileElement(ProfileManager.Profile profile, Document document, IProfileVersioner iProfileVersioner) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profile.getVersion()));
        element.setAttribute(XML_ATTRIBUTE_PROFILE_KIND, iProfileVersioner.getProfileKind());
        Iterator iterator = profile.getSettings().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)profile.getSettings().get(string);
            if (string2 != null) {
                Element element2 = document.createElement(XML_NODE_SETTING);
                element2.setAttribute(XML_ATTRIBUTE_ID, string);
                element2.setAttribute(XML_ATTRIBUTE_VALUE, string2);
                element.appendChild(element2);
                continue;
            }
            JavaPlugin.logErrorMessage("ProfileStore: Profile does not contain value for key " + string);
        }
        return element;
    }

    private static JavaUIException createException(Throwable throwable, String string) {
        return new JavaUIException(JavaUIStatus.createError(4, string, throwable));
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List fProfiles;
        private int fVersion;
        private String fName;
        private Map fSettings;
        private String fKind;

        private ProfileDefaultHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(ProfileStore.XML_NODE_SETTING)) {
                String string4 = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String string5 = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(string4, string5);
            } else if (string3.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fKind = attributes.getValue(ProfileStore.XML_ATTRIBUTE_PROFILE_KIND);
                if (this.fKind == null) {
                    this.fKind = "CodeFormatterProfile";
                }
                this.fSettings = new HashMap(200);
            } else if (string3.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList();
                try {
                    this.fVersion = Integer.parseInt(attributes.getValue(ProfileStore.XML_ATTRIBUTE_VERSION));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(numberFormatException);
                }
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings, this.fVersion, this.fKind));
                this.fName = null;
                this.fSettings = null;
                this.fKind = null;
            }
        }

        public List getProfiles() {
            return this.fProfiles;
        }
    }
}

